/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.databinding.ObservableLastSelectionFromListMapValue;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.editortabs.InstructionCountersViewModel;
import com.arm.streamline.jni.apcdbgen.proto.ISampleInstructionRowDataProperties;
import com.arm.streamline.jni.apcdbgen.proto.ISampleSourceLineDataProperties;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportDataForDisasmAndSourceAnnotations;
import com.arm.streamline.jni.apcdbgen.proto.ImageFile;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.streamline.jni.apcdbgen.proto.SourceLocation;
import com.arm.streamline.jni.apcdbgen.proto.Symbol;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterModel;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import com.arm.streamline.model.icounters.InstructionCounterCodeColumnsWithMetadata;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.LRUCache;
import com.arm.utils.collections.Pair;
import com.arm.utils.function.Throwing;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.services.IDisposable;

public final class CodeTabSelectionModel
implements IDisposable {
    private final @NonNull LRUCache<@NonNull Pair<@NonNull IInstructionCounterSource, @NonNull ImageFile>, @NonNull SoftReference<ActiveDataSet>> cachedActiveData;
    private long currentDataGeneration = 0L;
    private final @NonNull Consumer<@NonNull Function<@NonNull IProgressMonitorFactory, @Nullable IComputeActiveDataSetTask>> dataSetLoaderTaskConsumer;
    private final @NonNull InstructionCountersViewModel instructionCountersViewModel;
    private final @NonNull Object lock = new Object();
    private final @NonNull BiConsumer<@Nullable InstructionCounterCodeColumnsWithMetadata, @Nullable ActiveImageProperties> notificationCallback;
    private @Nullable ActiveDataSet selectedActiveDataSet;
    private @Nullable ActiveImageProperties selectedActiveImageProperties;
    private @Nullable InstructionCounterCodeColumnsWithMetadata selectedCounter;
    private final @NonNull IValueChangeListener<@Nullable InstructionCounterCodeColumnsWithMetadata> selectedCounterListener;
    private final @NonNull ObservableLastSelectionFromListMapValue<IInstructionCounterSource, InstructionCounterCodeColumnsWithMetadata> selectedCounterProperty;
    private @Nullable ImageFile selectedImageFile;
    private final @NonNull Map<@NonNull ImageFile, @NonNull SelectionRequest> selectionRequests = new HashMap<ImageFile, SelectionRequest>();

    public CodeTabSelectionModel(final @NonNull InstructionCountersViewModel instructionCountersViewModel, @NonNull Consumer<@NonNull Function<@NonNull IProgressMonitorFactory, @Nullable IComputeActiveDataSetTask>> dataSetLoaderTaskConsumer, @NonNull BiConsumer<@Nullable InstructionCounterCodeColumnsWithMetadata, @Nullable ActiveImageProperties> notificationCallback) {
        this.instructionCountersViewModel = instructionCountersViewModel;
        this.dataSetLoaderTaskConsumer = dataSetLoaderTaskConsumer;
        this.notificationCallback = notificationCallback;
        IInstructionCounterModel instructionCounterModel = instructionCountersViewModel.getInstructionCounterModel();
        long distinctImageCount = instructionCounterModel.getInstructionCounterSources().stream().flatMap(s -> s.getSymbols().stream()).filter(r -> !r.isUnknown()).map(r -> r.getReferencedSymbol().symbol.image).distinct().count();
        this.cachedActiveData = new LRUCache(Math.toIntExact(distinctImageCount * (long)instructionCounterModel.getInstructionCounterSources().size()));
        @NonNull IObservableValue<@Nullable IInstructionCounterSource> currentSelectedSource = instructionCountersViewModel.propertyCurrentSelectedSource();
        @NonNull ComputedList<@NonNull InstructionCounterCodeColumnsWithMetadata> extractedInstructionCounters = new ComputedList<InstructionCounterCodeColumnsWithMetadata>(){

            protected List<@NonNull InstructionCounterCodeColumnsWithMetadata> calculate() {
                ArrayList<InstructionCounterCodeColumnsWithMetadata> result = new ArrayList<InstructionCounterCodeColumnsWithMetadata>();
                IInstructionCounterSource currentSource = (IInstructionCounterSource)instructionCountersViewModel.propertyCurrentSelectedSource().getValue();
                if (currentSource != null) {
                    InstructionCounterCodeColumnsWithMetadata.extractSubcolumns(result, currentSource, currentSource.getInstructionAndSourceLineColumns());
                }
                return result;
            }
        };
        this.selectedCounterProperty = new ObservableLastSelectionFromListMapValue(currentSelectedSource, (IObservableList)extractedInstructionCounters);
        this.selectedCounter = (InstructionCounterCodeColumnsWithMetadata)this.selectedCounterProperty.getValue();
        this.selectedCounterListener = event -> {
            InstructionCounterCodeColumnsWithMetadata newCounter = (InstructionCounterCodeColumnsWithMetadata)event.diff.getNewValue();
            this.doNotificationLockedUpdate(() -> {
                this.selectedCounter = newCounter;
                this.lockedRecomputeState();
                return true;
            });
        };
        this.selectedCounterProperty.addValueChangeListener(this.selectedCounterListener);
        this.doNotificationLockedUpdate(() -> this.lockedRecomputeState());
    }

    public void dispose() {
        this.clearCachedActiveData();
        this.selectedCounterProperty.removeValueChangeListener(this.selectedCounterListener);
        this.selectedCounterProperty.dispose();
    }

    public @NonNull InstructionCountersViewModel getInstructionCounterViewModel() {
        return this.instructionCountersViewModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable ActiveImageProperties getSelectedActiveImageProperties() {
        Object object = this.lock;
        synchronized (object) {
            return this.selectedActiveImageProperties;
        }
    }

    public @NonNull ObservableLastSelectionFromListMapValue<IInstructionCounterSource, InstructionCounterCodeColumnsWithMetadata> getSelectedCounterProperty() {
        return this.selectedCounterProperty;
    }

    public void recomputeFromModel() {
        this.doNotificationLockedUpdate(() -> {
            this.clearCachedActiveData();
            ++this.currentDataGeneration;
            return this.lockedRecomputeState();
        });
    }

    public void setSelectionRequest(@Nullable SelectionRequest selection) {
        this.doNotificationLockedUpdate(() -> {
            boolean changedSelection;
            boolean changedImage;
            if (selection != null) {
                SelectionRequest prevSelection = this.selectionRequests.put(selectionRequest.selectedImage, selection);
                changedImage = !NullChecking.equalsNullable((Object)this.selectedImageFile, (Object)selectionRequest.selectedImage);
                changedSelection = !NullChecking.equalsNullable((Object)prevSelection, (Object)selection);
                this.selectedImageFile = selectionRequest.selectedImage;
            } else {
                changedImage = this.selectedImageFile != null;
                changedSelection = false;
                this.selectedImageFile = null;
            }
            if (changedImage) {
                return this.lockedRecomputeState();
            }
            if (changedSelection) {
                ActiveImageProperties prevImageProperties = this.selectedActiveImageProperties;
                this.selectedActiveImageProperties = this.lockedRecomputeActiveImageProperties();
                return prevImageProperties != this.selectedActiveImageProperties;
            }
            return false;
        });
    }

    private void clearCachedActiveData() {
        for (SoftReference reference : this.cachedActiveData.values()) {
            ActiveDataSet val = (ActiveDataSet)reference.get();
            if (val != null) {
                val.cancel();
            }
            reference.clear();
        }
        this.cachedActiveData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotificationLockedUpdate(@NonNull BooleanSupplier operation) {
        ActiveImageProperties imagePropertiesValue;
        InstructionCounterCodeColumnsWithMetadata counterValue;
        boolean changed;
        Object object = this.lock;
        synchronized (object) {
            if (operation.getAsBoolean()) {
                changed = true;
                counterValue = this.selectedCounter;
                imagePropertiesValue = this.selectedActiveImageProperties;
            } else {
                changed = false;
                counterValue = null;
                imagePropertiesValue = null;
            }
        }
        if (changed) {
            this.notificationCallback.accept(counterValue, imagePropertiesValue);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable ActiveDataSet lockedRecomputeActiveDataSet() {
        ActiveDataSet cachedEntry;
        InstructionCounterCodeColumnsWithMetadata currentCounter = this.selectedCounter;
        ImageFile currentImage = this.selectedImageFile;
        long currentGeneration = this.currentDataGeneration;
        if (currentCounter == null || currentImage == null) {
            return null;
        }
        @NonNull @NonNull Pair cacheKey = new Pair((Object)currentCounter.source, (Object)currentImage);
        SoftReference cachedEntryRef = (SoftReference)this.cachedActiveData.get((Object)cacheKey);
        ActiveDataSet activeDataSet = cachedEntry = cachedEntryRef != null ? (ActiveDataSet)cachedEntryRef.get() : null;
        if (cachedEntry != null && currentGeneration == cachedEntry.currentGeneration) {
            return cachedEntry;
        }
        ActiveDataSet result = new ActiveDataSet(currentCounter.source, currentImage, currentGeneration);
        if (cachedEntry != null) {
            cachedEntry.cancel();
        }
        this.cachedActiveData.put((Object)cacheKey, new SoftReference<ActiveDataSet>(result));
        this.spawnLoaderTask(result);
        return result;
    }

    private @Nullable ActiveImageProperties lockedRecomputeActiveImageProperties() {
        ActiveDataSet activeDataSet = this.selectedActiveDataSet;
        if (activeDataSet == null) {
            return null;
        }
        ISamplesReportDataForDisasmAndSourceAnnotations loadedData = activeDataSet.loadedData;
        if (loadedData == null) {
            return null;
        }
        SelectionRequest request = (SelectionRequest)NullChecking.neverNull((Object)this.selectionRequests.get(activeDataSet.currentImage));
        return request.asActiveImageProperties(activeDataSet.currentSource, loadedData);
    }

    private boolean lockedRecomputeState() {
        ActiveDataSet prevDataSet = this.selectedActiveDataSet;
        ActiveImageProperties prevImageProperties = this.selectedActiveImageProperties;
        this.selectedActiveDataSet = this.lockedRecomputeActiveDataSet();
        if (prevDataSet != this.selectedActiveDataSet) {
            this.selectedActiveImageProperties = this.lockedRecomputeActiveImageProperties();
        }
        return prevDataSet != this.selectedActiveDataSet || prevImageProperties != this.selectedActiveImageProperties;
    }

    private void recomputeActiveImageProperties(@NonNull ActiveDataSet changedDataSet) {
        this.doNotificationLockedUpdate(() -> {
            ActiveImageProperties prevImageProperties = this.selectedActiveImageProperties;
            if (this.selectedActiveDataSet == changedDataSet) {
                this.selectedActiveImageProperties = this.lockedRecomputeActiveImageProperties();
            }
            return prevImageProperties != this.selectedActiveImageProperties;
        });
    }

    private void spawnLoaderTask(@NonNull ActiveDataSet newTask) {
        this.dataSetLoaderTaskConsumer.accept(newTask::createComputeTask);
    }

    public final class ActiveDataSet {
        private @Nullable CancellationPredicate cancellationPredicate;
        private final long currentGeneration;
        private final @NonNull ImageFile currentImage;
        private final @NonNull IInstructionCounterSource currentSource;
        private final @NonNull Object dsLock = new Object();
        private @Nullable ISamplesReportDataForDisasmAndSourceAnnotations loadedData;

        public ActiveDataSet(@NonNull IInstructionCounterSource currentSource, ImageFile currentImage, long currentGeneration) {
            this.currentSource = currentSource;
            this.currentImage = currentImage;
            this.currentGeneration = currentGeneration;
            this.cancellationPredicate = new CancellationPredicate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            boolean changed;
            Object object = this.dsLock;
            synchronized (object) {
                CancellationPredicate cancellationPredicate = this.cancellationPredicate;
                if (cancellationPredicate != null) {
                    cancellationPredicate.cancel();
                }
                changed = this.lockedReplaceLoadedData(null);
            }
            if (changed) {
                CodeTabSelectionModel.this.recomputeActiveImageProperties(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected @Nullable IComputeActiveDataSetTask createComputeTask(final @NonNull IProgressMonitorFactory progressMonitorFactory) {
            Object object = this.dsLock;
            synchronized (object) {
                CancellationPredicate cancellationPredicate;
                block4: {
                    cancellationPredicate = this.cancellationPredicate;
                    if (cancellationPredicate != null) break block4;
                    return null;
                }
                return new IComputeActiveDataSetTask(){

                    @Override
                    public void cancel() {
                        ActiveDataSet.this.cancel();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean changed;
                        ISamplesReportDataForDisasmAndSourceAnnotations result = null;
                        try {
                            ISamplesReportDataForDisasmAndSourceAnnotations r;
                            result = r = ActiveDataSet.this.currentSource.getActiveReportData().computeDisasmAndSourceData(ActiveDataSet.this.currentImage.uid, true, cancellationPredicate, progressMonitorFactory);
                        }
                        catch (Throwable t) {
                            try {
                                Throwing.closeAllIfCloseable((Iterable[])new Iterable[]{Arrays.asList(result)});
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            StdLog.error((Plugin)StreamlinePlugin.getInstance(), (String)"Failed to compute Code tab data", (Throwable)t);
                            result = null;
                        }
                        Object object = ActiveDataSet.this.dsLock;
                        synchronized (object) {
                            if (ActiveDataSet.this.cancellationPredicate != null) {
                                changed = ActiveDataSet.this.lockedReplaceLoadedData(result);
                            } else {
                                changed = ActiveDataSet.this.lockedReplaceLoadedData(null);
                                Throwing.closeIfClosableAndDiscardException((Object)result);
                            }
                        }
                        if (changed) {
                            CodeTabSelectionModel.this.recomputeActiveImageProperties(ActiveDataSet.this);
                        }
                    }
                };
            }
        }

        private boolean lockedReplaceLoadedData(@Nullable ISamplesReportDataForDisasmAndSourceAnnotations newLoadedData) {
            ISamplesReportDataForDisasmAndSourceAnnotations oldLoadedData = this.loadedData;
            boolean changed = oldLoadedData != newLoadedData;
            this.cancellationPredicate = null;
            this.loadedData = newLoadedData;
            Throwing.closeIfClosableAndDiscardException((Object)oldLoadedData);
            return changed;
        }
    }

    public static final class ActiveImageProperties {
        public final @NonNull ISamplesReportDataForDisasmAndSourceAnnotations activeDataSet;
        public @NonNull ActiveSelection selection;
        public final @NonNull IInstructionCounterSource source;

        public ActiveImageProperties(@NonNull IInstructionCounterSource source, @NonNull ISamplesReportDataForDisasmAndSourceAnnotations activeDataSet, @NonNull ActiveSelection selection) {
            this.source = source;
            this.activeDataSet = activeDataSet;
            this.selection = selection;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            Object object = obj;
            if (object instanceof ActiveImageProperties) {
                void that;
                ActiveImageProperties activeImageProperties = (ActiveImageProperties)object;
                ActiveImageProperties cfr_ignored_0 = (ActiveImageProperties)object;
                return Objects.equals(this.activeDataSet, that.activeDataSet) && Objects.equals(this.selection, that.selection) && Objects.equals(this.source, that.source);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.activeDataSet, this.selection, this.source);
        }

        public String toString() {
            return "ActiveImageProperties [source=" + String.valueOf(this.source) + ", activeDataSet=" + String.valueOf(this.activeDataSet) + ", selection=" + String.valueOf(this.selection) + "]";
        }
    }

    public record ActiveSelection(@NonNull ImageFile imageFile, @NonNull BitSet selectedInstructions, @Nullable SourceFile sourceFile, @NonNull BitSet selectedLineNos, @Nullable ReferencedSymbol lastSelectedSymbol) {
    }

    public static interface IComputeActiveDataSetTask {
        public void cancel();

        public void run();
    }

    public static final class SelectionRequest {
        private @Nullable ActiveSelection currentSelection;
        private final @NonNull ImageFile selectedImage;
        private final @Nullable BitSet selectedLineNos;
        private final @Nullable SourceFile selectedSourceFile;
        private final @Nullable ReferencedSymbol selectedSymbol;
        private final @Nullable Set<@NonNull Symbol> selectedSymbols;

        private static void populateInstructionRange(@NonNull BitSet selectedInstructions, @NonNull Symbol symbol) {
            long rangeEnd;
            ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange instructionRange = symbol.instructionRange;
            if (instructionRange == null) {
                assert (false);
                return;
            }
            long rangeStart = Math.min(instructionRange.fromIndex(), Integer.MAX_VALUE);
            if (rangeStart < (rangeEnd = Math.min(instructionRange.count() + instructionRange.fromIndex(), Integer.MAX_VALUE))) {
                selectedInstructions.set(Math.toIntExact(rangeStart), Math.toIntExact(rangeEnd));
            }
        }

        private static void populateInstructionsFromLines(@NonNull ISamplesReportDataForDisasmAndSourceAnnotations loadedData, @NonNull BitSet selectedInstructions, @NonNull SourceFile selectedSourceFile, @NonNull BitSet selectedLineNos) {
            selectedLineNos.stream().forEach(lineNo -> {
                if (lineNo < 1) {
                    return;
                }
                ISampleSourceLineDataProperties properties = loadedData.getSourceLocationDataPropertiesFor(sourceFile.uid, lineNo);
                if (properties == null) {
                    return;
                }
                long[] lArray = properties.getCorrespondingInstructionIndexes();
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    long index = lArray[n2];
                    if (index >= 0L && index <= Integer.MAX_VALUE) {
                        selectedInstructions.set((int)index);
                    }
                    ++n2;
                }
            });
        }

        private static @Nullable SourceFile populateLineNos(@NonNull ISamplesReportDataForDisasmAndSourceAnnotations loadedData, @NonNull Symbol symbol, @Nullable SourceFile selectedSourceFile, @NonNull BitSet selectedLineNos) {
            ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange instructionRange = symbol.instructionRange;
            if (instructionRange == null) {
                assert (false);
                return selectedSourceFile;
            }
            SourceFile[] result = new SourceFile[]{selectedSourceFile};
            loadedData.forEachInstruction(instructionRange.fromIndex(), instructionRange.count(), false, (index, accessor) -> {
                ISampleInstructionRowDataProperties properties = accessor.getRowProperties();
                switch (properties.getRowType()) {
                    case ARM32: 
                    case ARM64: 
                    case SYMBOL_LABEL: 
                    case THUMB: {
                        SourceFile sf;
                        SourceLocation sourceLocation = properties.getOriginalSourceLocation();
                        if (sourceLocation == null) break;
                        if (result[0] == null) {
                            sourceFileArray[0] = sourceLocation.sourceFile;
                        }
                        if (!(sf = (SourceFile)NullChecking.neverNull((Object)result[0])).equals(sourceLocation.sourceFile) || sourceLocation.lineNo <= 0) break;
                        selectedLineNos.set(sourceLocation.lineNo);
                        break;
                    }
                    case DATA: 
                    case NONE: {
                        break;
                    }
                    default: {
                        throw new AssertionError(properties.getRowType());
                    }
                }
                return true;
            });
            return result[0];
        }

        public SelectionRequest(@NonNull ImageFile selectedImage, @NonNull Set<@NonNull Symbol> selectedSymbols, @NonNull SourceFile selectedSourceFile, @NonNull BitSet selectedLineNos, @Nullable ReferencedSymbol selectedSymbol) {
            assert (!selectedSymbols.isEmpty());
            assert (!selectedLineNos.isEmpty());
            this.selectedImage = selectedImage;
            this.selectedSymbols = selectedSymbols;
            this.selectedSourceFile = selectedSourceFile;
            this.selectedLineNos = selectedLineNos;
            this.selectedSymbol = selectedSymbol;
        }

        public SelectionRequest(@NonNull ImageFile selectedImage, @NonNull Set<@NonNull Symbol> selectedSymbols, @Nullable SourceFile selectedSourceFile, @Nullable ReferencedSymbol selectedSymbol) {
            assert (!selectedSymbols.isEmpty());
            this.selectedImage = selectedImage;
            this.selectedSymbols = selectedSymbols;
            this.selectedSourceFile = selectedSourceFile;
            this.selectedLineNos = null;
            this.selectedSymbol = selectedSymbol;
        }

        public SelectionRequest(@NonNull ImageFile selectedImage, @NonNull SourceFile selectedSourceFile, @NonNull BitSet selectedLineNos, @Nullable ReferencedSymbol selectedSymbol) {
            assert (!selectedLineNos.isEmpty());
            this.selectedImage = selectedImage;
            this.selectedSourceFile = selectedSourceFile;
            this.selectedLineNos = selectedLineNos;
            this.selectedSymbols = null;
            this.selectedSymbol = selectedSymbol;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            Object object = obj;
            if (object instanceof SelectionRequest) {
                void that;
                SelectionRequest selectionRequest = (SelectionRequest)object;
                SelectionRequest cfr_ignored_0 = (SelectionRequest)object;
                return this.selectedImage.equals(that.selectedImage) && NullChecking.equalsNullable(this.selectedSymbols, that.selectedSymbols) && NullChecking.equalsNullable((Object)this.selectedSourceFile, (Object)that.selectedSourceFile) && NullChecking.equalsNullable((Object)this.selectedLineNos, (Object)that.selectedLineNos) && NullChecking.equalsNullable((Object)this.selectedSymbol, (Object)that.selectedSymbol);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.selectedImage, this.selectedLineNos, this.selectedSourceFile, this.selectedSymbols, this.selectedSymbol);
        }

        public String toString() {
            return String.format("SelectionRequest [selectedImage=%s, selectedSymbols=%s, selectedSourceFile=%s, selectedLineNos=%s, selectedSymbol=%s]", this.selectedImage, this.selectedSymbols, this.selectedSourceFile, this.selectedLineNos, this.selectedSymbol);
        }

        private @NonNull ActiveImageProperties asActiveImageProperties(@NonNull IInstructionCounterSource source, @NonNull ISamplesReportDataForDisasmAndSourceAnnotations loadedData) {
            ActiveSelection currentSelection = this.currentSelection;
            if (currentSelection == null) {
                BitSet selectedInstructions = new BitSet();
                SourceFile selectedSourceFile = this.selectedSourceFile;
                BitSet selectedLineNos = this.selectedLineNos;
                Set<Symbol> selectedSymbols = this.selectedSymbols;
                if (selectedSymbols != null) {
                    if (selectedSourceFile != null && selectedLineNos != null) {
                        for (Symbol symbol : selectedSymbols) {
                            SelectionRequest.populateInstructionRange(selectedInstructions, symbol);
                        }
                    } else {
                        selectedLineNos = new BitSet();
                        for (Symbol symbol : selectedSymbols) {
                            SelectionRequest.populateInstructionRange(selectedInstructions, symbol);
                            selectedSourceFile = SelectionRequest.populateLineNos(loadedData, symbol, selectedSourceFile, selectedLineNos);
                        }
                    }
                } else if (selectedSourceFile != null && selectedLineNos != null) {
                    SelectionRequest.populateInstructionsFromLines(loadedData, selectedInstructions, selectedSourceFile, selectedLineNos);
                } else {
                    throw new AssertionError();
                }
                this.currentSelection = currentSelection = new ActiveSelection(this.selectedImage, selectedInstructions, selectedSourceFile, selectedLineNos, this.selectedSymbol);
            }
            return new ActiveImageProperties(source, loadedData, currentSelection);
        }
    }
}

