/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.streamline.jni.apcdbgen.proto.ISourceLineReference;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.apcdbgen.proto.SymbolName;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.contextmenu.IContextMenuContributor;
import com.arm.utils.NullChecking;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractCodeContextMenuContributor
implements IContextMenuContributor {
    protected static final int THRESHOLD = 100;
    protected static final int MAX_ITEMS = 10;

    protected static @NonNull String fixAmp(@NonNull String sym) {
        return sym.replace("&", "&&");
    }

    protected static @NonNull String truncateSourceLine(@NonNull ISourceLineReference key) {
        String name = key.getSourceFile().getFileName().strip();
        return String.format("%s:%d", name, key.getStartLine());
    }

    protected static @NonNull String truncateSymbol(@NonNull ReferencedSymbol function, int threshold) {
        return AbstractCodeContextMenuContributor.truncateSymbol(function.symbol.name, threshold);
    }

    protected static @NonNull String truncateSymbol(@NonNull SymbolName name, int threshold) {
        assert (threshold > 1);
        String unmangledName = ((String)NullChecking.neverNullOr((Object)name.unmangledName, (Object)"")).strip();
        String mangledName = ((String)NullChecking.neverNullOr((Object)name.mangledName, (Object)"")).strip();
        int uN = unmangledName.length() - threshold;
        int mN = mangledName.length() - threshold;
        if (!unmangledName.isBlank() && uN <= 0) {
            return unmangledName;
        }
        if (!mangledName.isBlank() && mN <= 0) {
            return mangledName;
        }
        int half = threshold / 2;
        int otherHalf = threshold - half;
        if (!unmangledName.isBlank() && uN < mN) {
            return unmangledName.substring(0, half) + "..." + unmangledName.substring(unmangledName.length() - otherHalf);
        }
        if (!mangledName.isBlank()) {
            return mangledName.substring(0, half) + "..." + mangledName.substring(mangledName.length() - otherHalf);
        }
        return "<blank>";
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected static <T, V extends Number> @NonNull Map.Entry<@NonNull T, @NonNull V> @NonNull [] sortByRank(@NonNull Map<@NonNull T, @NonNull V> values, @NonNull Predicate<@NonNull T> filter, @NonNull Comparator<@NonNull T> comparator) {
        @NonNull @NonNull @NonNull Map.Entry @NonNull [] entries = (Map.Entry[])values.entrySet().stream().filter(e -> ((Number)e.getValue()).doubleValue() > 0.0 && filter.test(e.getKey())).toArray(Map.Entry[]::new);
        Arrays.sort(entries, (a, b) -> {
            int result = -((Comparable)a.getValue()).compareTo((Number)b.getValue());
            if (result == 0) {
                result = comparator.compare(a.getKey(), b.getKey());
            }
            return result;
        });
        return entries;
    }

    protected static <T, V extends Number> void populateMenu(@NonNull Map.Entry<@NonNull T, @NonNull V> @NonNull [] entries, @NonNull Predicate<@NonNull Map.Entry<@NonNull T, @NonNull V>> consumer) {
        int nItems = 0;
        Map.Entry<T, V>[] entryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<T, V> entry = entryArray[n2];
            if (nItems > 10) break;
            if (consumer.test(entry)) {
                ++nItems;
            }
            ++n2;
        }
    }

    @Override
    public void cleanup(ContextMenu cm) {
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

