/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.callpath;

import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.jni.reportmodel.icounters.CallPathRowValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;

public class CallPathRow
extends ReportRow<CallPathRowValue> {
    public static @NonNull List<@NonNull CallPathRow> buildRecursive(@NonNull CallPathRowValue link, @NonNull FilterMode filterMode, @NonNull Predicate<@NonNull CallPathRowValue> keepProcessOrThread, @NonNull Predicate<@NonNull CallPathRowValue> nodeFilter) {
        switch (link.getCallPathNode().type) {
            case VMUID: {
                List<CallPathRow> children = CallPathRow.buildRecursiveChildren(link, filterMode, keepProcessOrThread, nodeFilter);
                switch (filterMode) {
                    case DISCARD_PROCESSES_ONLY_FILTER_THREADS: {
                        return children;
                    }
                    case MATCH_PROCESS_OR_THREAD: 
                    case MATCH_PROCESS_AND_THREAD: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)filterMode);
                    }
                }
                if (children.isEmpty()) {
                    return Collections.emptyList();
                }
                return Arrays.asList(new CallPathRow(link, children));
            }
            case PROCESS: {
                List<CallPathRow> children;
                switch (filterMode) {
                    case DISCARD_PROCESSES_ONLY_FILTER_THREADS: {
                        return CallPathRow.buildRecursiveChildren(link, filterMode, keepProcessOrThread, nodeFilter);
                    }
                    case MATCH_PROCESS_AND_THREAD: {
                        if (!keepProcessOrThread.test(link)) {
                            return Collections.emptyList();
                        }
                        children = CallPathRow.buildRecursiveChildren(link, filterMode, keepProcessOrThread, nodeFilter);
                        break;
                    }
                    case MATCH_PROCESS_OR_THREAD: {
                        Predicate<CallPathRowValue> threadFilter = keepProcessOrThread.test(link) ? tid -> true : keepProcessOrThread;
                        children = CallPathRow.buildRecursiveChildren(link, filterMode, threadFilter, nodeFilter);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)filterMode);
                    }
                }
                if (children.isEmpty()) {
                    return Collections.emptyList();
                }
                return Arrays.asList(new CallPathRow(link, children));
            }
            case THREAD: {
                if (!keepProcessOrThread.test(link)) {
                    return Collections.emptyList();
                }
                List<CallPathRow> children = CallPathRow.buildRecursiveChildren(link, filterMode, keepProcessOrThread, nodeFilter);
                return Arrays.asList(new CallPathRow(link, children));
            }
            case SYMBOL: {
                List<CallPathRow> children = CallPathRow.buildRecursiveChildren(link, filterMode, keepProcessOrThread, nodeFilter);
                if (children.isEmpty() && !nodeFilter.test(link)) {
                    return Collections.emptyList();
                }
                return Arrays.asList(new CallPathRow(link, children));
            }
        }
        throw new AssertionError(link.getCallPathNode().type);
    }

    private static @NonNull List<@NonNull CallPathRow> buildRecursiveChildren(@NonNull CallPathRowValue link, @NonNull FilterMode filterMode, @NonNull Predicate<@NonNull CallPathRowValue> keepProcessOrThread, @NonNull Predicate<@NonNull CallPathRowValue> nodeFilter) {
        return link.getChildren().stream().map(c -> CallPathRow.buildRecursive(c, filterMode, keepProcessOrThread, nodeFilter)).flatMap(l -> l.stream()).collect(Collectors.toUnmodifiableList());
    }

    private CallPathRow(@NonNull CallPathRowValue link, @NonNull List<@NonNull CallPathRow> children) {
        super(link);
        if (!children.isEmpty()) {
            this.setCanHaveChildren(true);
            for (CallPathRow child : children) {
                this.addChild(child);
            }
            this.setOpen(true);
        }
    }

    public static enum FilterMode {
        DISCARD_PROCESSES_ONLY_FILTER_THREADS,
        MATCH_PROCESS_OR_THREAD,
        MATCH_PROCESS_AND_THREAD;

    }
}

