/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.callpath;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.FunctionColumnUtils;
import com.arm.streamline.editortabs.callpath.CallPathFunctionInstructionCounterColumn;
import com.arm.streamline.editortabs.callpath.CallPathMessages;
import com.arm.streamline.editortabs.callpath.ICallPathFunctionColumn;
import com.arm.streamline.editortabs.function.FunctionNameCell;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.jni.apcdbgen.proto.ICallPathFunctions;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportData;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.reportmodel.icounters.CallPathFunctionRowValue;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.IColumnCompareType;
import com.arm.streamline.widget.outline.TextCell;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;

public abstract class CallPathFunctionColumn
implements ICallPathFunctionColumn {
    public static final @NonNull CallPathFunctionColumn INSTANCES = new CallPathFunctionColumn(){

        @Override
        public IColumnCompareType<EnumColumn<CallPathFunctionRowValue>> getCompareType() {
            return IColumnCompareType.INTEGER();
        }

        @Override
        public Object getData(CallPathFunctionRowValue cpf) {
            return this.getDataAsLong(cpf);
        }

        @Override
        public long getDataAsLong(CallPathFunctionRowValue cpf) {
            return cpf.getInstanceCount();
        }

        @Override
        public String getDataAsText(CallPathFunctionRowValue cpf) {
            return NumberUtils.format((long)this.getDataAsLong(cpf));
        }

        @Override
        public String getHeader(Void data) {
            return CallPathMessages.INSTANCES_TITLE;
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FontInfo.get(Fonts.getNormal()).getWidth(NumberUtils.fill((int)NumberUtils.prettyFormat((int)source.getLargestFunctionCallPathCount()).length(), (char)'0'));
        }

        @Override
        public String getToolTip(CallPathFunctionRowValue cpf) {
            return cpf == null ? CallPathMessages.INSTANCES_DESCRIPTION : null;
        }
    };
    public static final @NonNull CallPathFunctionColumn LOCATION = new CallPathFunctionColumn(){

        @Override
        public int getAlignment() {
            return 16384;
        }

        @Override
        public String getDataAsText(CallPathFunctionRowValue cpf) {
            String result = cpf != null ? cpf.getLocationLabel(true) : null;
            return result != null ? result : CallPathMessages.NA;
        }

        @Override
        public String getHeader(Void data) {
            return CallPathMessages.LOCATION_TITLE;
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FunctionColumnUtils.getPreferredWidth(source);
        }

        @Override
        public String getToolTip(CallPathFunctionRowValue cpf) {
            String result = cpf != null ? cpf.getLocationLabel(true) : null;
            return result != null ? result : CallPathMessages.LOCATION_DESCRIPTION;
        }
    };
    public static final @NonNull CallPathFunctionColumn NAME = new CallPathFunctionColumn(){

        @Override
        public int getAlignment() {
            return 16384;
        }

        @Override
        public ICell<EnumColumn<CallPathFunctionRowValue>> getCell(Void data) {
            return new FunctionNameCell<CallPathFunctionRowValue>();
        }

        @Override
        public String getDataAsText(CallPathFunctionRowValue cpf) {
            return cpf.getName();
        }

        @Override
        public String getHeader(Void data) {
            return CallPathMessages.FUNCTION_NAME_TITLE;
        }

        @Override
        public @Nullable Image getImage(ReportRow<CallPathFunctionRowValue> row) {
            return CallPathFunctionColumn.getCallPathFunctionImage(row.getModelObject().getReferencedSymbol());
        }

        @Override
        public int getInitialSortSequence() {
            return 1;
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            int one = FontInfo.get(Fonts.getNormal()).getWidth("aw") / 2;
            return one * source.getLargestFunctionName().length();
        }

        @Override
        public String getToolTip(CallPathFunctionRowValue cpf) {
            return cpf == null ? CallPathMessages.FUNCTION_NAME_DESCRIPTION : null;
        }
    };

    public static @NonNull Iterable<@NonNull ICallPathFunctionColumn> aggregateColumns(@Nullable ICallPathFunctions callPathFunctions) {
        Stream<Object> counterColumns;
        if (callPathFunctions != null) {
            ISamplesReportData parentDataSet = callPathFunctions.getParent();
            counterColumns = parentDataSet.getParentReport().getCallPathFunctionColumns().stream().map(c -> CallPathFunctionInstructionCounterColumn.factory(callPathFunctions, c)).flatMap(CallPathFunctionInstructionCounterColumn::toRecursiveStream);
        } else {
            counterColumns = Stream.empty();
        }
        return Stream.concat(Stream.concat(Stream.of(NAME), counterColumns), Stream.of(INSTANCES, LOCATION)).collect(Collectors.toList());
    }

    public static Image getCallPathFunctionImage(@NonNull ReferencedSymbol function) {
        if (function.isUnknown()) {
            return StreamlinePlugin.getImage("WarningSmall.png");
        }
        return StreamlinePlugin.getImage("Function.png");
    }

    public int getAlignment() {
        return 131072;
    }

    @Override
    public ICell<EnumColumn<CallPathFunctionRowValue>> getCell(Void data) {
        return new TextCell<EnumColumn<CallPathFunctionRowValue>>(this.getAlignment());
    }

    public IColumnCompareType<EnumColumn<CallPathFunctionRowValue>> getCompareType() {
        return IColumnCompareType.TEXT();
    }

    public Object getData(CallPathFunctionRowValue cpf) {
        return this.getDataAsText(cpf);
    }

    public double getDataAsDouble(CallPathFunctionRowValue cpf) {
        return 0.0;
    }

    @Override
    public final double getDataAsDouble(ReportRow<CallPathFunctionRowValue> row) {
        return this.getDataAsDouble(row.getModelObject());
    }

    public long getDataAsLong(CallPathFunctionRowValue cpf) {
        return 0L;
    }

    @Override
    public final long getDataAsLong(ReportRow<CallPathFunctionRowValue> row) {
        return this.getDataAsLong(row.getModelObject());
    }

    public abstract @NonNull String getDataAsText(CallPathFunctionRowValue var1);

    @Override
    public final @NonNull String getDataAsText(ReportRow<CallPathFunctionRowValue> row) {
        return this.getDataAsText(row.getModelObject());
    }

    @Override
    public Image getImage(ReportRow<CallPathFunctionRowValue> row) {
        return null;
    }

    @Override
    public int getInitialSortSequence() {
        return -1;
    }

    public String getTitle() {
        return this.getHeader(null).replace('\n', ' ');
    }

    @Override
    public abstract String getToolTip(CallPathFunctionRowValue var1);

    @Override
    public final String getToolTip(ReportRow<CallPathFunctionRowValue> row) {
        return this.getToolTip(row.getModelObject());
    }

    @Override
    public final String getToolTip(Void data) {
        return this.getToolTip((CallPathFunctionRowValue)null);
    }

    @Override
    public boolean isInitialSortAscending() {
        return true;
    }

    @Override
    public boolean isPrimary() {
        return false;
    }
}

