/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.callpath;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.FunctionColumnUtils;
import com.arm.streamline.editortabs.callpath.CallPathFunctionColumn;
import com.arm.streamline.editortabs.callpath.CallPathInstructionCounterColumn;
import com.arm.streamline.editortabs.callpath.CallPathMessages;
import com.arm.streamline.editortabs.callpath.CallPathStackCell;
import com.arm.streamline.editortabs.callpath.ICallPathColumn;
import com.arm.streamline.editortabs.function.FunctionNameCell;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportData;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.reportmodel.icounters.CallPathRowValue;
import com.arm.streamline.jni.reportmodel.icounters.FunctionRowValue;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.IColumnCompareType;
import com.arm.streamline.widget.outline.TextCell;
import com.arm.utils.NullChecking;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;

public abstract class CallPathColumn
implements ICallPathColumn {
    public static final @NonNull CallPathColumn LOCATION = new CallPathColumn(CallPathMessages.LOCATION_TITLE, true){

        @Override
        public String getDataAsText(ReportRow<CallPathRowValue> row, CallPathRowValue link) {
            ReferencedSymbol function;
            ReferencedSymbol referencedSymbol = function = link != null ? link.getCallPathNode().symbol : null;
            if (link == null || function == null) {
                return CallPathMessages.NA;
            }
            String result = FunctionRowValue.getLocationLabel((IInstructionCounterSource)link.getOwnerSource(), (ReferencedSymbol)function, (row != null && row.getOwner().isExporting() ? 1 : 0) != 0);
            return result != null ? result : CallPathMessages.NA;
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FunctionColumnUtils.getPreferredWidth(source);
        }

        @Override
        public String getToolTip(CallPathRowValue link) {
            ReferencedSymbol function;
            ReferencedSymbol referencedSymbol = function = link != null ? link.getCallPathNode().symbol : null;
            if (link == null || function == null) {
                return CallPathMessages.LOCATION_DESCRIPTION;
            }
            String result = FunctionRowValue.getLocationLabel((IInstructionCounterSource)link.getOwnerSource(), (ReferencedSymbol)function, (boolean)true);
            return result != null ? result : CallPathMessages.LOCATION_DESCRIPTION;
        }
    };
    public static final @NonNull CallPathColumn NAME = new CallPathColumn(CallPathMessages.CALL_PATH_NAME_TITLE, 16384, true, 1, IColumnCompareType.TEXT()){

        @Override
        public ICell<EnumColumn<CallPathRowValue>> getCell(Void data) {
            FunctionNameCell<CallPathRowValue> cell = new FunctionNameCell<CallPathRowValue>();
            cell.setIconHAlignment(16384);
            return cell;
        }

        @Override
        public String getDataAsText(ReportRow<CallPathRowValue> row, CallPathRowValue link) {
            return link.getName();
        }

        @Override
        public Image getImage(ReportRow<CallPathRowValue> row) {
            @NonNull CallPathRowValue modelObject = row.getModelObject();
            return 2.getCallPathImage(modelObject);
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            int one = FontInfo.get(Fonts.getNormal()).getWidth("aw") / 2;
            return one * source.getLargestCallPathName().length();
        }

        @Override
        public @Nullable String getToolTip(CallPathRowValue link) {
            return link == null ? CallPathMessages.CALL_PATH_NAME_DESCRIPTION : null;
        }

        @Override
        public boolean isPrimary() {
            return true;
        }
    };
    public static final @NonNull CallPathColumn STACK_USED = new CallPathColumn(CallPathMessages.STACK_USED_TITLE){

        @Override
        public ICell<EnumColumn<CallPathRowValue>> getCell(Void data) {
            return new CallPathStackCell(this.getAlignment(), this.getCompareType());
        }

        @Override
        public Object getData(ReportRow<CallPathRowValue> row, CallPathRowValue link) {
            return this.getDataAsLong(row, link);
        }

        @Override
        public long getDataAsLong(ReportRow<CallPathRowValue> row, CallPathRowValue link) {
            return link.getStackSize();
        }

        @Override
        public String getDataAsText(ReportRow<CallPathRowValue> row, CallPathRowValue link) {
            long stackSize;
            if (!link.isStructureOnlyNode() && (stackSize = link.getStackSize()) >= 0L) {
                return NumberUtils.prettyFormat((long)stackSize);
            }
            return "";
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FontInfo.get(Fonts.getNormal()).getWidth(NumberUtils.fill((int)NumberUtils.prettyFormat((long)source.getMaxStack()).length(), (char)'0'));
        }

        @Override
        public String getToolTip(CallPathRowValue link) {
            if (link == null) {
                return CallPathMessages.STACK_USED_DESCRIPTION;
            }
            return link.hasUnknownStack() ? CallPathMessages.INDETERMINATE : CallPathMessages.STACK_USED_DESCRIPTION;
        }
    };
    protected final int alignment;
    protected final @NonNull IColumnCompareType<EnumColumn<CallPathRowValue>> compareType;
    protected final boolean initialSortAscending;
    protected final int initialSortSequence;
    protected final @NonNull String name;

    public static @NonNull Iterable<@NonNull ICallPathColumn> aggregateColumns(@Nullable IInstructionCounterSource instructionCounterSource, boolean preferTotal) {
        Stream<Object> counterColumns;
        if (instructionCounterSource != null) {
            ISamplesReportData dataSet = instructionCounterSource.getActiveReportData();
            boolean useTotals = preferTotal && instructionCounterSource.canShowCallPathTotalsColumns();
            counterColumns = instructionCounterSource.getCallPathColumns().stream().map(c -> CallPathInstructionCounterColumn.factory(dataSet, c, useTotals)).flatMap(CallPathInstructionCounterColumn::toRecursiveStream);
        } else {
            counterColumns = Stream.empty();
        }
        return Stream.concat(Stream.concat(Stream.of(NAME), counterColumns), Stream.of(STACK_USED, LOCATION)).collect(Collectors.toList());
    }

    public static Image getCallPathImage(@NonNull CallPathRowValue modelObject) {
        switch (modelObject.getCallPathNode().type) {
            case SYMBOL: {
                return CallPathFunctionColumn.getCallPathFunctionImage((ReferencedSymbol)NullChecking.neverNull((Object)modelObject.getCallPathNode().symbol));
            }
            case PROCESS: {
                return StreamlinePlugin.getImage("Process.png");
            }
            case THREAD: {
                return StreamlinePlugin.getImage("Thread.gif");
            }
            case VMUID: {
                return StreamlinePlugin.getImage("VirtualMachine.png");
            }
        }
        throw new AssertionError(modelObject.getCallPathNode().type);
    }

    protected CallPathColumn(@NonNull String name) {
        this(name, true, IColumnCompareType.INTEGER());
    }

    protected CallPathColumn(@NonNull String name, boolean alignLeft) {
        this(name, alignLeft ? 16384 : 131072, true, -1, IColumnCompareType.TEXT());
    }

    protected CallPathColumn(@NonNull String name, boolean initialSortAscending, @NonNull IColumnCompareType<EnumColumn<CallPathRowValue>> compareType) {
        this(name, initialSortAscending, -1, compareType);
    }

    protected CallPathColumn(@NonNull String name, boolean initialSortAscending, int initialSortSequence) {
        this(name, initialSortAscending, initialSortSequence, IColumnCompareType.INTEGER());
    }

    protected CallPathColumn(@NonNull String name, boolean initialSortAscending, int initialSortSequence, @NonNull IColumnCompareType<EnumColumn<CallPathRowValue>> compareType) {
        this(name, 131072, initialSortAscending, initialSortSequence, compareType);
    }

    protected CallPathColumn(@NonNull String name, int alignment, boolean initialSortAscending, int initialSortSequence, @NonNull IColumnCompareType<EnumColumn<CallPathRowValue>> compareType) {
        this.name = name;
        this.alignment = alignment;
        this.initialSortAscending = initialSortAscending;
        this.initialSortSequence = initialSortSequence;
        this.compareType = compareType;
    }

    @Override
    public ICell<EnumColumn<CallPathRowValue>> getCell(Void data) {
        return new TextCell<EnumColumn<CallPathRowValue>>(this.getAlignment(), this.getCompareType());
    }

    public Object getData(ReportRow<CallPathRowValue> row, CallPathRowValue link) {
        return this.getDataAsText(row, link);
    }

    @Override
    public final double getDataAsDouble(ReportRow<CallPathRowValue> row) {
        return this.getDataAsDouble(row, row.getModelObject());
    }

    public double getDataAsDouble(ReportRow<CallPathRowValue> row, CallPathRowValue link) {
        return 0.0;
    }

    @Override
    public final long getDataAsLong(ReportRow<CallPathRowValue> row) {
        return this.getDataAsLong(row, row.getModelObject());
    }

    public long getDataAsLong(ReportRow<CallPathRowValue> row, CallPathRowValue link) {
        return 0L;
    }

    @Override
    public final @NonNull String getDataAsText(ReportRow<CallPathRowValue> row) {
        return this.getDataAsText(row, row.getModelObject());
    }

    public abstract @NonNull String getDataAsText(ReportRow<CallPathRowValue> var1, CallPathRowValue var2);

    @Override
    public final @NonNull String getHeader(Void data) {
        return this.name;
    }

    public Image getImage(CallPathRowValue link) {
        return null;
    }

    @Override
    public Image getImage(ReportRow<CallPathRowValue> row) {
        if (row != null) {
            return this.getImage(row.getModelObject());
        }
        return null;
    }

    @Override
    public final int getInitialSortSequence() {
        return this.initialSortSequence;
    }

    @Override
    public abstract @Nullable String getToolTip(CallPathRowValue var1);

    @Override
    public final String getToolTip(ReportRow<CallPathRowValue> row) {
        return this.getToolTip(row.getModelObject());
    }

    @Override
    public final @Nullable String getToolTip(Void data) {
        return this.getToolTip((CallPathRowValue)null);
    }

    @Override
    public final boolean isInitialSortAscending() {
        return this.initialSortAscending;
    }

    @Override
    public boolean isPrimary() {
        return false;
    }

    protected final int getAlignment() {
        return this.alignment;
    }

    protected final @NonNull IColumnCompareType<EnumColumn<CallPathRowValue>> getCompareType() {
        return this.compareType;
    }
}

