/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.application.PluginMessages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.InvalidVersionException;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.DocumentsView;
import com.arm.streamline.databrowser.ICapture;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.Messages;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.utility.io.EditorInputUtils;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Fonts;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;

public final class LoaderTab
extends Composite
implements IProgressMonitor,
Runnable,
DisposeListener {
    private Thread mLoaderThread;
    private AnalysisEditor mEditor;
    private String mTaskText;
    private String mSubTaskText;
    private int mTotalWork;
    private int mFinishedWork;
    private boolean mCanceled;
    private Label mProgressLabel;
    private ProgressBar mProgressBar;
    private Label mProgressPercentage;
    private NumberFormat mFormatter;
    private boolean mUpdatePending;
    private Composite mErrorContainer;
    private StackLayout mStackLayout;
    private final @NonNull CancellationPredicate cancellationPredicate = new CancellationPredicate();

    public LoaderTab(AnalysisEditor editor) {
        super(editor.getContainer(), 0x20000000);
        ControlHacks.setBackground((Control)this, Colors.getWidgetBackground());
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "com.arm.streamline.load_progress");
        this.addDisposeListener(this);
        this.mStackLayout = new StackLayout();
        this.setLayout((Layout)this.mStackLayout);
        Composite progressContainer = new Composite((Composite)this, 0);
        progressContainer.setLayout((Layout)new GridLayout(2, false));
        progressContainer.setLayoutData((Object)new GridData(1808));
        this.mEditor = editor;
        this.mFormatter = NumberFormat.getInstance();
        this.mFormatter.setMinimumFractionDigits(1);
        this.mFormatter.setMaximumFractionDigits(1);
        this.mProgressLabel = new Label(progressContainer, 8);
        ControlHacks.setBackground((Control)this.mProgressLabel, Colors.getWidgetBackground());
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.mProgressLabel);
        this.mProgressBar = new ProgressBar(progressContainer, 65792);
        ControlHacks.setBackground((Control)this.mProgressBar, Colors.getWidgetBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mProgressBar);
        this.mProgressPercentage = new Label(progressContainer, 8);
        ControlHacks.setBackground((Control)this.mProgressPercentage, Colors.getWidgetBackground());
        this.adjustPercentageText(100.0);
        Point size = this.mProgressPercentage.computeSize(-1, -1);
        GridDataFactory.swtDefaults().hint(size.x, -1).applyTo((Control)this.mProgressPercentage);
        this.mErrorContainer = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 12;
        layout.marginHeight = 20;
        this.mErrorContainer.setLayout((Layout)layout);
        this.mErrorContainer.setLayoutData((Object)new GridData(1808));
        Label errorImage = new Label(this.mErrorContainer, 0);
        errorImage.setImage(StreamlinePlugin.getImage("Bad.png"));
        errorImage.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                LoaderTab.this.mErrorContainer.pack();
            }
        });
        this.mStackLayout.topControl = progressContainer;
        this.layout();
        this.mLoaderThread = new Thread((Runnable)this, "Load " + AnalysisEditor.getInputName(editor.getEditorInput()));
        this.mLoaderThread.start();
    }

    public void beginTask(String name, int totalWork) {
        this.mTaskText = name;
        this.mTotalWork = totalWork;
        this.mFinishedWork = 0;
        this.updateProgressFromAnyThread();
    }

    public void done() {
        this.updateProgressFromAnyThread();
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return this.mCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block35: {
            File file;
            block34: {
                ICapture capture;
                block33: {
                    block32: {
                        Task.callOnUIThread(() -> this.mEditor.showBusy(true));
                        file = new File(EditorInputUtils.getURI(this.mEditor.getEditorInput()));
                        if (file.canRead() && file.isDirectory()) break block32;
                        this.displayErrorMessage(PluginMessages.ERROR, Messages.LoaderTab_CAPTURE_MISSING, false);
                        Task.callOnUIThread(() -> this.mEditor.showBusy(false));
                        LoaderTab loaderTab = this;
                        synchronized (loaderTab) {
                            this.mLoaderThread = null;
                        }
                        return;
                    }
                    capture = ICapture.createCapture(file);
                    if (capture.isValid()) break block33;
                    this.displayErrorMessage(PluginMessages.ERROR, capture.getInvalidReason(), false);
                    Task.callOnUIThread(() -> this.mEditor.showBusy(false));
                    LoaderTab loaderTab = this;
                    synchronized (loaderTab) {
                        this.mLoaderThread = null;
                    }
                    return;
                }
                if (capture.hasReport(true)) break block34;
                this.displayErrorMessage(PluginMessages.ERROR, Messages.LoaderTab_CAPTURE_NEEDS_ANALYZING, true);
                Task.callOnUIThread(() -> this.mEditor.showBusy(false));
                LoaderTab loaderTab = this;
                synchronized (loaderTab) {
                    this.mLoaderThread = null;
                }
                return;
            }
            try {
                DocumentScanner.INSTANCE.addToWatchSet(file.getAbsoluteFile());
                Analysis analysis = new Analysis(file, this, this.cancellationPredicate);
                if (!Task.callOnUIThread(() -> this.mEditor.setAnalysis(analysis))) {
                    analysis.close();
                }
            }
            catch (InterruptedException exception) {
                this.displayErrorMessage(PluginMessages.CANCELED, PluginMessages.CANCELED_TEXT, true);
                Task.callOnUIThread(() -> this.mEditor.showBusy(false));
                LoaderTab loaderTab = this;
                synchronized (loaderTab) {
                    this.mLoaderThread = null;
                    break block35;
                }
            }
            catch (Throwable throwable) {
                block36: {
                    try {
                        if (throwable.getCause() != null && throwable.getCause().getCause() instanceof InvalidVersionException) {
                            this.handleExceptionDisplay(throwable, false);
                            break block36;
                        }
                        this.handleExceptionDisplay(throwable, true);
                    }
                    catch (Throwable throwable2) {
                        Task.callOnUIThread(() -> this.mEditor.showBusy(false));
                        LoaderTab loaderTab = this;
                        synchronized (loaderTab) {
                            this.mLoaderThread = null;
                        }
                        throw throwable2;
                    }
                }
                Task.callOnUIThread(() -> this.mEditor.showBusy(false));
                LoaderTab loaderTab = this;
                synchronized (loaderTab) {
                    this.mLoaderThread = null;
                    break block35;
                }
            }
            Task.callOnUIThread(() -> this.mEditor.showBusy(false));
            LoaderTab loaderTab = this;
            synchronized (loaderTab) {
                this.mLoaderThread = null;
            }
        }
    }

    private void handleExceptionDisplay(Throwable throwable, boolean printStackTrace) {
        if (printStackTrace) {
            throwable.printStackTrace();
        }
        if (!this.isDisposed()) {
            if (this.isCanceled()) {
                this.displayErrorMessage(PluginMessages.CANCELED, PluginMessages.CANCELED_TEXT, true);
            } else {
                String message;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getCause();
                }
                message = (message = throwable.getLocalizedMessage()) == null || message.isBlank() ? String.format("An exception of type %s occurred", throwable.getClass()) : message;
                this.displayErrorMessage(PluginMessages.ERROR, message, true);
            }
        }
    }

    public void setCanceled(boolean cancel) {
        this.mCanceled = cancel;
        this.cancellationPredicate.cancel();
    }

    public void setTaskName(String name) {
        this.mTaskText = name;
        this.updateProgressFromAnyThread();
    }

    public void subTask(String name) {
        this.mSubTaskText = name;
        this.updateProgressFromAnyThread();
    }

    public void updateProgress() {
        if (!this.isDisposed()) {
            Object text = this.mTaskText;
            if (this.mSubTaskText != null && this.mSubTaskText.trim().length() != 0 && !this.mTaskText.equals(this.mSubTaskText)) {
                text = (String)text + ": " + this.mSubTaskText;
            }
            this.mProgressLabel.setText((String)text);
            this.mProgressBar.setMaximum(this.mTotalWork);
            this.mProgressBar.setSelection(this.mFinishedWork);
            double work = 0.0;
            if (this.mTotalWork > 0 && (work = (double)this.mFinishedWork * 100.0 / (double)this.mTotalWork) > 99.9) {
                work = 99.9;
            }
            this.adjustPercentageText(work);
        }
    }

    public synchronized void updateProgressFromAnyThread() {
        if (!this.mUpdatePending) {
            this.mUpdatePending = true;
            Task.callOnUIThread(() -> {
                LoaderTab loaderTab = this;
                synchronized (loaderTab) {
                    this.mUpdatePending = false;
                }
                this.updateProgress();
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void widgetDisposed(DisposeEvent event) {
        this.setCanceled(true);
        Thread thread = null;
        LoaderTab loaderTab = this;
        synchronized (loaderTab) {
            if (this.mLoaderThread != null) {
                thread = this.mLoaderThread;
                thread.interrupt();
                this.mLoaderThread = null;
            }
        }
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void worked(int work) {
        this.mFinishedWork += work;
        this.updateProgressFromAnyThread();
    }

    private void displayErrorContents(String message, boolean isValid) {
        Label errorMessage = new Label(this.mErrorContainer, 0);
        errorMessage.setLayoutData((Object)new GridData(16384, 128, false, false));
        errorMessage.setFont(Fonts.getNormalStandout());
        errorMessage.setForeground(Colors.getDarkRed());
        errorMessage.setText(message);
        new Label(this.mErrorContainer, 0);
        if (isValid) {
            Button reAnalyzeButton = new Button(this.mErrorContainer, 8);
            reAnalyzeButton.setText(PluginMessages.ANALYZE);
            reAnalyzeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LoaderTab.this.openAnalyzeDialog();
                }
            });
        }
        this.mStackLayout.topControl = this.mErrorContainer;
        this.layout();
        this.mErrorContainer.pack();
    }

    private void adjustPercentageText(double work) {
        this.mProgressPercentage.setText(this.mFormatter.format(work) + "%");
    }

    private void displayErrorMessage(String title, String msg, boolean valid) {
        Task.callOnUIThread(() -> {
            this.mEditor.setLoadTitle(title);
            if (!this.isDisposed()) {
                this.displayErrorContents(msg, valid);
                this.redraw();
            }
        });
    }

    private void openAnalyzeDialog() {
        File file = new File(EditorInputUtils.getURI(this.mEditor.getEditorInput()));
        ICapture capture = ICapture.createCapture(file);
        DocumentsView.analyze(capture);
    }
}

