/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterModel;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class InstructionCountersViewModel {
    protected final @NonNull IObservableList<@NonNull IInstructionCounterSource> allAvailableSources;
    protected final @NonNull IObservableList<@NonNull IColumnDescriptor> currentCallPathCounters;
    protected final @NonNull IObservableList<@NonNull IColumnDescriptor> currentCallPathFunctionCounters;
    protected final @NonNull IObservableList<@NonNull IColumnDescriptor> currentCodeCounters;
    protected final @NonNull IObservableList<@NonNull IColumnDescriptor> currentFunctionCounters;
    protected final @NonNull IObservableValue<@Nullable IInstructionCounterSource> currentSelectedSource;
    protected final @NonNull IObservableValue<@NonNull Boolean> hasMultipleSources;
    protected final @NonNull IInstructionCounterModel instructionCounterModel;

    public InstructionCountersViewModel(@NonNull IInstructionCounterModel instructionCounterModel) {
        this.instructionCounterModel = instructionCounterModel;
        this.allAvailableSources = new WritableList(instructionCounterModel.getInstructionCounterSources(), IInstructionCounterSource.class);
        this.currentSelectedSource = new WritableValue(this.allAvailableSources.isEmpty() ? null : (IInstructionCounterSource)this.allAvailableSources.get(0), IInstructionCounterSource.class);
        this.hasMultipleSources = ComputedValue.create(() -> this.allAvailableSources.size() > 1);
        this.currentCallPathCounters = new ComputedList<IColumnDescriptor>(IColumnDescriptor.class){

            protected @NonNull List<@NonNull IColumnDescriptor> calculate() {
                @Nullable IInstructionCounterSource currentSource = (IInstructionCounterSource)InstructionCountersViewModel.this.currentSelectedSource.getValue();
                if (currentSource == null) {
                    return Collections.emptyList();
                }
                return currentSource.getCallPathColumns();
            }
        };
        this.currentCallPathFunctionCounters = new ComputedList<IColumnDescriptor>(IColumnDescriptor.class){

            protected @NonNull List<@NonNull IColumnDescriptor> calculate() {
                @Nullable IInstructionCounterSource currentSource = (IInstructionCounterSource)InstructionCountersViewModel.this.currentSelectedSource.getValue();
                if (currentSource == null) {
                    return Collections.emptyList();
                }
                return currentSource.getCallPathFunctionColumns();
            }
        };
        this.currentCodeCounters = new ComputedList<IColumnDescriptor>(IColumnDescriptor.class){

            protected @NonNull List<@NonNull IColumnDescriptor> calculate() {
                @Nullable IInstructionCounterSource currentSource = (IInstructionCounterSource)InstructionCountersViewModel.this.currentSelectedSource.getValue();
                if (currentSource == null) {
                    return Collections.emptyList();
                }
                return currentSource.getInstructionAndSourceLineColumns();
            }
        };
        this.currentFunctionCounters = new ComputedList<IColumnDescriptor>(IColumnDescriptor.class){

            protected @NonNull List<@NonNull IColumnDescriptor> calculate() {
                @Nullable IInstructionCounterSource currentSource = (IInstructionCounterSource)InstructionCountersViewModel.this.currentSelectedSource.getValue();
                if (currentSource == null) {
                    return Collections.emptyList();
                }
                return currentSource.getFunctionColumns();
            }
        };
    }

    public void dispose() {
        this.allAvailableSources.dispose();
        this.currentSelectedSource.dispose();
    }

    public @NonNull IInstructionCounterModel getInstructionCounterModel() {
        return this.instructionCounterModel;
    }

    public @NonNull IObservableList<@NonNull IInstructionCounterSource> propertyAllAvailableSources() {
        return this.allAvailableSources;
    }

    public @NonNull IObservableList<@NonNull IColumnDescriptor> propertyCurrentCallPathCounters() {
        return this.currentCallPathCounters;
    }

    public @NonNull IObservableList<@NonNull IColumnDescriptor> propertyCurrentCallPathFunctionCounters() {
        return this.currentCallPathFunctionCounters;
    }

    public @NonNull IObservableList<@NonNull IColumnDescriptor> propertyCurrentCodeCounters() {
        return this.currentCodeCounters;
    }

    public @NonNull IObservableList<@NonNull IColumnDescriptor> propertyCurrentFunctionCounters() {
        return this.currentFunctionCounters;
    }

    public @NonNull IObservableValue<@Nullable IInstructionCounterSource> propertyCurrentSelectedSource() {
        return this.currentSelectedSource;
    }

    public @NonNull IObservableValue<@NonNull Boolean> propertyHasMultipleSources() {
        return this.hasMultipleSources;
    }
}

