/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.utility.io.EditorInputUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class AnalysisInput
extends FileStoreEditorInput {
    private static final String KEY_INPUT = "input";
    private static final String SLASH = "/";
    private URI mURI;

    private static URI fixup(URI uri) {
        Object s = uri.toString();
        if (!((String)s).endsWith(SLASH)) {
            s = (String)s + SLASH;
        }
        return URI.create((String)s);
    }

    public AnalysisInput(File file) throws CoreException {
        this(file.toURI());
    }

    public AnalysisInput(IEditorInput input) throws CoreException {
        this(EditorInputUtils.getURI(input));
    }

    public AnalysisInput(IMemento memento) throws CoreException, URISyntaxException {
        this(new URI(memento.getString(KEY_INPUT)));
    }

    public AnalysisInput(URI uri) throws CoreException {
        super(EFS.getStore((URI)AnalysisInput.fixup(uri)));
        this.mURI = AnalysisInput.fixup(uri.normalize());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AnalysisInput) {
            return super.equals(obj);
        }
        return false;
    }

    public final boolean exists() {
        try {
            return new File(this.mURI).exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPersistableElement.class) {
            return (T)((Object)this);
        }
        return null;
    }

    public String getFactoryId() {
        return "com.arm.streamline.input.apd";
    }

    public ImageDescriptor getImageDescriptor() {
        return StreamlinePlugin.getImageDescriptor("AnalysisFile.gif");
    }

    public String getName() {
        try {
            return new File(this.mURI).getName();
        }
        catch (Exception exception) {
            CommonPlugin.error((Throwable)exception);
            return "";
        }
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return EditorInputUtils.getReadableString((IEditorInput)this);
    }

    public URI getURI() {
        return this.mURI;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void saveState(IMemento memento) {
        memento.putString(KEY_INPUT, this.mURI.toString());
    }
}

