/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.application.IVetoablePageChangeListener;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.editortabs.AnalysisInput;
import com.arm.streamline.editortabs.EditorTab;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.IUpdateOnDisplayTab;
import com.arm.streamline.editortabs.InstructionCountersViewModel;
import com.arm.streamline.editortabs.LoaderTab;
import com.arm.streamline.editortabs.timeline.TimelineTab;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.utility.Timing;
import com.arm.streamline.utility.io.EditorInputUtils;
import com.arm.streamline.widget.BusyTabHelper;
import com.arm.streamline.widget.ISettableTitleImage;
import com.arm.utils.NullChecking;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;

public class AnalysisEditor
extends MultiPageEditorPart
implements ISettableTitleImage {
    public static final String ID = "com.arm.streamline.editor.apd";
    private @Nullable Analysis mAnalysis;
    private @Nullable InstructionCountersViewModel instructionCountersViewModel;
    private ArrayList<IVetoablePageChangeListener> mVetoablePageChangeListeners = new ArrayList();
    private boolean mAllowPageChangeUnconditionally = false;
    private int mLastPage = -1;
    private BusyTabHelper mBusyHelper;
    private boolean mDisposed;
    private ArrayList<EditorTabID> mPageOrder = new ArrayList();

    public static final String getInputName(IEditorInput input) {
        IFileStore fileStore = EditorInputUtils.getFileStore(input);
        String name = fileStore.getName();
        if (name.equalsIgnoreCase("report")) {
            name = fileStore.getParent().getName();
        }
        if (name.endsWith(".apc")) {
            name = name.substring(0, name.length() - ".apc".length());
        }
        return name;
    }

    public static final @NonNull File getReportDirFromEditorInput(IEditorInput input) {
        File dir = new File(EditorInputUtils.getURI(input));
        if (dir.getName().toLowerCase().endsWith(".apc")) {
            dir = new File(dir, "report");
        }
        return dir;
    }

    public static final AnalysisEditor locate(Analysis analysis) {
        if (analysis != null) {
            String analysisPath = FilePath.getFullPath((File)analysis.getReportDirectory());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path;
                AnalysisEditor editor;
                IEditorReference ref = iEditorReferenceArray[n2];
                if (ID.equals(ref.getId()) && (editor = (AnalysisEditor)ref.getEditor(false)) != null && analysisPath.equals(path = FilePath.getFullPath((File)AnalysisEditor.getReportDirFromEditorInput(editor.getEditorInput())))) {
                    return editor;
                }
                ++n2;
            }
        }
        return null;
    }

    public AnalysisEditor() {
        this.mBusyHelper = new BusyTabHelper(this, StreamlinePlugin.getImage("AnalysisFile.gif"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoablePageChangeListener(IVetoablePageChangeListener listener) {
        ArrayList<IVetoablePageChangeListener> arrayList = this.mVetoablePageChangeListeners;
        synchronized (arrayList) {
            this.mVetoablePageChangeListeners.add(listener);
        }
    }

    public void dispose() {
        if (!this.mDisposed) {
            Analysis mAnalysis = this.mAnalysis;
            if (mAnalysis != null) {
                try {
                    mAnalysis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.instructionCountersViewModel != null) {
                this.instructionCountersViewModel.dispose();
                this.instructionCountersViewModel = null;
            }
            this.mBusyHelper.dispose();
            this.mDisposed = true;
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public @Nullable Analysis getAnalysis() {
        return this.mAnalysis;
    }

    public @Nullable InstructionCountersViewModel getInstructionCountersViewModel() {
        return this.instructionCountersViewModel;
    }

    public @NonNull InstructionCountersViewModel requireInstructionCountersViewModel() {
        return (InstructionCountersViewModel)NullChecking.neverNull((Object)this.instructionCountersViewModel);
    }

    public Composite getContainer() {
        return super.getContainer();
    }

    public Control getControl(int pageIndex) {
        return super.getControl(pageIndex);
    }

    public ISelectionProvider getCurrentSelectionProvider() {
        int page = this.getActivePage();
        return page > -1 ? this.getSelectionProvider(page) : null;
    }

    public int getPageIndex(EditorTabID editorPageID) {
        int count = this.mPageOrder.size();
        int i = 0;
        while (i < count) {
            if (this.mPageOrder.get(i) == editorPageID) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Timing.startOpenReport(input);
        try {
            AnalysisInput analysisInput = new AnalysisInput(input);
            super.init(site, (IEditorInput)analysisInput);
            this.setPartName(AnalysisEditor.getInputName(this.getEditorInput()));
            this.setTitleToolTip(this.getTitleToolTip());
            this.firePropertyChange(1);
        }
        catch (Throwable throwable) {
            throw new PartInitException(null, throwable);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVetoablePageChangeListener(IVetoablePageChangeListener listener) {
        ArrayList<IVetoablePageChangeListener> arrayList = this.mVetoablePageChangeListeners;
        synchronized (arrayList) {
            this.mVetoablePageChangeListeners.remove(listener);
        }
    }

    public void select(EditorTabID editorPageID, ISelection selection) {
        this.setActivePage(editorPageID);
        ISelectionProvider selectionProvider = this.getCurrentSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.setSelection(selection);
        }
    }

    public void setActivePage(EditorTabID editorPageID) {
        int index;
        if (this.mPageOrder.get(this.getActivePage()) != editorPageID && (index = this.getPageIndex(editorPageID)) != -1) {
            this.setActivePage(index);
        }
    }

    public void setAnalysis(@NonNull Analysis analysis) {
        if (!this.mDisposed) {
            this.mAnalysis = analysis;
            this.instructionCountersViewModel = new InstructionCountersViewModel(analysis.getInstructionCounterModel());
            EditorTabID[] editorTabIDArray = EditorTabID.values();
            int n = editorTabIDArray.length;
            int n2 = 0;
            while (n2 < n) {
                EditorTabID pageID = editorTabIDArray[n2];
                if (pageID.okToAdd(this)) {
                    this.addPage(pageID);
                }
                ++n2;
            }
            this.mPageOrder.remove(0);
            this.removePage(0);
            this.getContainer().layout(true, true);
            Timing.endOpenReport(this.getEditorInput());
        } else {
            try {
                analysis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setFocus() {
        super.setFocus();
        int activePage = this.getActivePage();
        Control control = this.getControl(activePage);
        if (control != null) {
            this.adjustActionsAndSelectionProvider(control, this.getSelectionProvider(activePage));
        }
    }

    public void setLoadTitle(String title) {
        if (this.getPageCount() == 1 && this.getControl(0) instanceof LoaderTab) {
            this.setPageText(0, title);
        }
    }

    @Override
    public void setTitleImage(Image titleImage) {
        if (!this.mDisposed) {
            super.setTitleImage(titleImage);
        }
    }

    public void showBusy(boolean busy) {
        this.mBusyHelper.showBusy(busy);
    }

    protected void createPages() {
        Composite container = this.getContainer();
        if (container instanceof CTabFolder) {
            ((CTabFolder)container).setTabPosition(128);
        }
        this.addPage(EditorTabID.LOADER);
    }

    protected void pageChange(int newPageIndex) {
        if (newPageIndex >= 0 && newPageIndex < this.mPageOrder.size()) {
            if (this.mLastPage == -1 || this.isPageChangeAllowed(this.mPageOrder.get(this.mLastPage), this.mPageOrder.get(newPageIndex))) {
                Control control = this.getControl(newPageIndex);
                if (control == null) {
                    EditorTabID eID = this.mPageOrder.get(newPageIndex);
                    control = eID.createControl(this, this.getBaseTimelineContent());
                    this.setControl(newPageIndex, control);
                } else if (control instanceof IUpdateOnDisplayTab) {
                    ((IUpdateOnDisplayTab)control).onTabDisplayed();
                }
                super.pageChange(newPageIndex);
                this.adjustActionsAndSelectionProvider(control, this.getSelectionProvider(newPageIndex));
                this.mLastPage = newPageIndex;
            } else {
                this.mAllowPageChangeUnconditionally = true;
                this.setActivePage(this.mPageOrder.get(this.mLastPage));
                this.mAllowPageChangeUnconditionally = false;
            }
        }
    }

    private void addPage(EditorTabID id) {
        this.mPageOrder.add(id);
        int index = this.addPage(id == EditorTabID.LOADER ? id.createControl(this, this.getBaseTimelineContent()) : null);
        this.setPageText(index, id.toString());
        this.setPageImage(index, id.getImage());
    }

    private void adjustActionsAndSelectionProvider(Control control, ISelectionProvider provider) {
        if (this.getEditorSite().getWorkbenchWindow().isClosing()) {
            return;
        }
        IActionBars actionBars = this.getEditorSite().getActionBars();
        if (actionBars != null) {
            actionBars.clearGlobalActionHandlers();
            if (control instanceof EditorTab) {
                for (Map.Entry<String, IAction> entry : ((EditorTab)control).getActionMap().entrySet()) {
                    actionBars.setGlobalActionHandler(entry.getKey(), entry.getValue());
                }
            }
            actionBars.updateActionBars();
        }
        this.getSite().setSelectionProvider(provider);
    }

    private @Nullable BaseTimelineContent getBaseTimelineContent() {
        int index = this.getPageIndex(EditorTabID.TIMELINE);
        if (index == -1 || this.getControl(index) == null) {
            return null;
        }
        return ((TimelineTab)this.getControl(index)).getContent();
    }

    private ISelectionProvider getSelectionProvider(int index) {
        Control control = this.getControl(index);
        if (control instanceof ISelectionProvider) {
            return (ISelectionProvider)control;
        }
        if (control instanceof EditorTab) {
            return ((EditorTab)control).getSelectionProvider();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPageChangeAllowed(EditorTabID from, EditorTabID to) {
        if (!this.mAllowPageChangeUnconditionally) {
            IVetoablePageChangeListener[] listeners;
            ArrayList<IVetoablePageChangeListener> arrayList = this.mVetoablePageChangeListeners;
            synchronized (arrayList) {
                listeners = this.mVetoablePageChangeListeners.toArray(new IVetoablePageChangeListener[this.mVetoablePageChangeListeners.size()]);
            }
            IVetoablePageChangeListener[] iVetoablePageChangeListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IVetoablePageChangeListener listener = iVetoablePageChangeListenerArray[n2];
                if (!listener.allowPageChange(from, to)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public @Nullable EditorTabID getCurrentActiveEditorTab() {
        return this.mLastPage > -1 ? this.mPageOrder.get(this.mLastPage) : null;
    }
}

