/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.callpath.Utilities;
import com.arm.streamline.editortabs.histogram.HistogramCellDataProvider;
import com.arm.streamline.editortabs.report.IColumnEnum;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.jni.apcdbgen.proto.HistogramDataPoint;
import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.jni.apcdbgen.proto.IExtractable;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnAccessorFactory;
import com.arm.streamline.jni.reportmodel.icounters.RatioValue;
import com.arm.streamline.widget.outline.ColumnStructureProperties;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.HistogramCell;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.IColumnCompareType;
import com.arm.streamline.widget.outline.MpkiCell;
import com.arm.streamline.widget.outline.PercentageCell;
import com.arm.streamline.widget.outline.RatioCell;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.TextCell;
import com.arm.utils.ArrayUtils;
import com.arm.utils.StreamUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractInstructionCounterColumn<T extends IExtractable, X>
implements IColumnEnum<T, X> {
    protected final @NonNull IColumnDescriptor counterColumn;
    private final @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> cellSupplier;
    private final boolean hiddenFromExport;
    private final boolean hiddenFromUi;
    private @Nullable AbstractInstructionCounterColumn<T, X> parent;
    private final @NonNull IntSupplier prefWidthSupplier;
    private final @NonNull IRowValueMapper<T> rowValueMapper;
    private final @NonNull Function<@Nullable T, @Nullable String> valueTooltipFunction;
    private final boolean visibleByDefault;
    private final @NonNull ColumnStructureProperties columnStructureProperties;

    public static @Nullable Integer @NonNull [] makeColourSpread(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userPreference, int numberOfBins) {
        if (numberOfBins == 0) {
            return new Integer[0];
        }
        int biasPointH = numberOfBins * 3 / 4;
        double divH = (double)(18 * numberOfBins) / 4.0;
        double divL = (double)(6 * numberOfBins) / 4.0;
        double halfWay = 0.16666666666666666;
        double h = Math.min((double)numberOfBins, 6.0);
        double v = Math.ceil((double)numberOfBins / 6.0);
        switch (colourPreference) {
            case higher_is_better: {
                return (Integer[])ArrayUtils.create(Integer[]::new, (int)numberOfBins, i -> {
                    float hue = (float)(i < biasPointH ? (double)i / divH : (double)(i - biasPointH) / divL + 0.16666666666666666);
                    return Color.HSBtoRGB(hue, 1.0f, 1.0f);
                });
            }
            case lower_is_better: {
                return (Integer[])ArrayUtils.create(Integer[]::new, (int)numberOfBins, i -> {
                    int k = numberOfBins - i - 1;
                    float hue = (float)(k < biasPointH ? (double)k / divH : (double)(k - biasPointH) / divL + 0.16666666666666666);
                    return Color.HSBtoRGB(hue, 1.0f, 1.0f);
                });
            }
            case neutral: {
                return (Integer[])ArrayUtils.create(Integer[]::new, (int)numberOfBins, i -> {
                    int l = i / 6;
                    float val = (float)(1.0 - (double)l / v);
                    float hue = (float)(1.0 - (double)i / h);
                    return Color.HSBtoRGB(hue + 0.1f, 1.0f, val);
                });
            }
            case user_defined: {
                return (Integer[])ArrayUtils.create(Integer[]::new, (int)numberOfBins, i -> userPreference);
            }
        }
        throw new AssertionError(colourPreference);
    }

    public static @Nullable Integer @NonNull [] makeColourSpread(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IColumnDescriptor.ColourPreference colourPreference, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IColumnDescriptor.IRatioColumnDescriptor.RatioItem @NonNull [] ratioItems) {
        double div = 3 * Math.max(ratioItems.length - 1, 1);
        double h = Math.min((double)ratioItems.length, 6.0);
        double v = Math.ceil((double)ratioItems.length / 6.0);
        switch (colourPreference) {
            case higher_is_better: {
                return (Integer[])ArrayUtils.create(Integer[]::new, (int)ratioItems.length, i -> {
                    float hue = (float)((double)i / div);
                    return Color.HSBtoRGB(hue, 1.0f, 1.0f);
                });
            }
            case lower_is_better: {
                return (Integer[])ArrayUtils.create(Integer[]::new, (int)ratioItems.length, i -> {
                    float hue = (float)((double)(ratioItems.length - i) / div);
                    return Color.HSBtoRGB(hue, 1.0f, 1.0f);
                });
            }
            case neutral: {
                return (Integer[])ArrayUtils.create(Integer[]::new, (int)ratioItems.length, i -> {
                    int l = i / 6;
                    float val = (float)(1.0 - (double)l / v);
                    float hue = (float)(1.0 - (double)i / h);
                    return Color.HSBtoRGB(hue + 0.1f, 1.0f, val);
                });
            }
            case user_defined: {
                return (Integer[])ArrayUtils.create(Integer[]::new, (int)ratioItems.length, i -> ratioItems[i].userDefinedRGB());
            }
        }
        throw new AssertionError(colourPreference);
    }

    protected static <T extends IExtractable, X, C extends AbstractInstructionCounterColumn<T, X>> @NonNull C bindColumnsAndChildren(@NonNull IConstructor<T, X, C> constructor, @NonNull IColumnDescriptor counterColumn, boolean hiddenFromUi, boolean hiddenFromExport, boolean visibleByDefault, @NonNull List<@NonNull C> children, @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> cellSupplier, @NonNull IRowValueMapper<T> rowValueMapper, @NonNull Function<@Nullable T, @Nullable String> valueTooltipFunction, @NonNull IntSupplier prefWidthSupplier) {
        C result = constructor.create(counterColumn, hiddenFromUi, hiddenFromExport, visibleByDefault, children, cellSupplier, rowValueMapper, valueTooltipFunction, prefWidthSupplier);
        for (AbstractInstructionCounterColumn c : children) {
            c.setParent((AbstractInstructionCounterColumn<T, X>)result);
        }
        return result;
    }

    protected static <T extends IExtractable, X, C extends AbstractInstructionCounterColumn<T, X>> @NonNull C factory(@NonNull IConstructor<T, X, C> constructor, @NonNull IAccessorFactory accessorFactory, @NonNull IColumnDescriptor columnDescriptor, @NonNull ToLongFunction<@NonNull T> uidMapper) {
        return AbstractInstructionCounterColumn.factory(constructor, accessorFactory, columnDescriptor, uidMapper, false, false, true);
    }

    protected static <T extends IExtractable> @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> histogramCellSupplier(@NonNull HistogramDataPoint @NonNull [] datapoints, boolean scaleRelativeToLimit, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer colour, int typicalBinCount, @NonNull String units, @NonNull Function<@NonNull T, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ISampleCounterColumnAccessorFactory.HistogramValue> mapper) {
        return () -> new HistogramCell(new HistogramCellDataProvider(datapoints, scaleRelativeToLimit, colourPreference, colour, typicalBinCount, units, mapper));
    }

    protected static @NonNull RatioValue @Nullable [] mapRatioValues(long @Nullable [] values, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IColumnDescriptor.IRatioColumnDescriptor.RatioItem @NonNull [] ratioItems, @Nullable Integer @NonNull [] colourSpread) {
        if (values == null) {
            return null;
        }
        assert (values.length == ratioItems.length);
        assert (values.length == colourSpread.length);
        return (RatioValue[])ArrayUtils.createNonNull(RatioValue[]::new, (int)ratioItems.length, i -> new RatioValue(ratioItems[i].name(), values[i], colourSpread[i]));
    }

    protected static <T extends IExtractable, V extends Number> @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> mpkiCellSupplier(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userRGB, final @NonNull Function<@NonNull T, @Nullable V> mapper) {
        return () -> new MpkiCell<EnumColumn<T>>(50, false, false, colourPreference, userRGB){

            @Override
            public double getMPKI(Row<EnumColumn<T>> row, EnumColumn<T> column) {
                @NonNull T value = ((ReportRow)row).getModelObject();
                @Nullable Number mpki = (Number)mapper.apply(value);
                return mpki != null ? mpki.doubleValue() : -1.0;
            }
        };
    }

    protected static <T extends IExtractable> @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> numberCellSupplier(final @NonNull Function<@NonNull T, @Nullable Number> mapper) {
        return () -> new TextCell<EnumColumn<T>>(131072, IColumnCompareType.INTEGER()){

            @Override
            protected String getData(@Nullable Row<EnumColumn<T>> row, @NonNull EnumColumn<T> column, boolean nullOK) {
                Object value;
                Number number;
                if (row != null && (number = (Number)mapper.apply(value = ((ReportRow)row).getModelObject())) != null) {
                    if (number instanceof Float || number instanceof Double) {
                        return NumberUtils.prettyFormat((double)number.doubleValue());
                    }
                    return NumberUtils.prettyFormat((long)number.longValue());
                }
                if (!nullOK) {
                    return "";
                }
                return null;
            }
        };
    }

    protected static <T extends IExtractable, V extends Number> @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> percentCellSupplierFromPercent(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userRGB, final @NonNull Function<@NonNull T, @Nullable V> mapper) {
        return () -> new PercentageCell<EnumColumn<T>>(50, false, true, colourPreference, userRGB){

            @Override
            public double getPercentage(Row<EnumColumn<T>> row, EnumColumn<T> column) {
                @NonNull T value = ((ReportRow)row).getModelObject();
                @Nullable Number percent = (Number)mapper.apply(value);
                return percent != null ? percent.doubleValue() : -1.0;
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong getPercentAndValue(@NonNull Row<EnumColumn<T>> row, @NonNull EnumColumn<T> column) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }

            @Override
            public long getValue(Row<EnumColumn<T>> row, EnumColumn<T> column) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return 0L;
            }
        };
    }

    protected static <T extends IExtractable> @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> percentCellSupplierFromPercentAndValue(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userRGB, final @NonNull Function<@NonNull T, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong> mapper) {
        return () -> new PercentageCell<EnumColumn<T>>(50, false, false, colourPreference, userRGB){

            @Override
            public double getPercentage(Row<EnumColumn<T>> row, EnumColumn<T> column) {
                // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong result = this.getPercentAndValue(row, column);
                return result != null ? result.percent() : -1.0;
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong getPercentAndValue(@NonNull Row<EnumColumn<T>> row, @NonNull EnumColumn<T> column) {
                @NonNull T value = ((ReportRow)row).getModelObject();
                return (ISampleCounterColumnAccessorFactory.PercentAndLong)mapper.apply(value);
            }

            @Override
            public long getValue(Row<EnumColumn<T>> row, EnumColumn<T> column) {
                // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong result = this.getPercentAndValue(row, column);
                return result != null ? result.value() : 0L;
            }
        };
    }

    protected static <T extends IExtractable> @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> ratioCellSupplier(@NonNull Function<@NonNull T, @NonNull RatioValue @Nullable []> mapper) {
        return () -> new RatioCell(row -> {
            @NonNull T value = ((ReportRow)row).getModelObject();
            return (RatioValue[])mapper.apply(value);
        });
    }

    protected static <T> @NonNull IRowValueMapper<T> rowMapperFromHistogram(@NonNull HistogramDataPoint @NonNull [] datapoints, final @NonNull Function<@NonNull T, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ISampleCounterColumnAccessorFactory.HistogramValue> mapper) {
        return new IRowValueMapper<T>(){

            @Override
            public double getDouble(@NonNull T data) {
                return 0.0;
            }

            @Override
            public long getLong(@NonNull T data) {
                return 0L;
            }

            @Override
            public @NonNull String getText(@NonNull T data) {
                ISampleCounterColumnAccessorFactory.HistogramValue valueSet = (ISampleCounterColumnAccessorFactory.HistogramValue)mapper.apply(data);
                if (valueSet == null) {
                    return "";
                }
                return Arrays.stream(valueSet.values()).mapToObj(x -> Long.toUnsignedString(x)).collect(Collectors.joining(":"));
            }
        };
    }

    protected static <T, V extends Number> @NonNull IRowValueMapper<T> rowMapperFromMpki(final @NonNull Function<@NonNull T, @Nullable V> mapper) {
        return new IRowValueMapper<T>(){

            @Override
            public double getDouble(@NonNull T data) {
                @Nullable Number mpki = (Number)mapper.apply(data);
                return mpki != null ? mpki.doubleValue() : -1.0;
            }

            @Override
            public long getLong(@NonNull T data) {
                @Nullable Number mpki = (Number)mapper.apply(data);
                return mpki != null ? mpki.longValue() : 0L;
            }

            @Override
            public @NonNull String getText(@NonNull T data) {
                @Nullable Number mpki = (Number)mapper.apply(data);
                return mpki != null ? NumberUtils.prettyFormat((double)mpki.doubleValue()) : "";
            }
        };
    }

    protected static <T> @NonNull IRowValueMapper<T> rowMapperFromNumber(final @NonNull Function<@NonNull T, @Nullable Number> mapper) {
        return new IRowValueMapper<T>(){

            @Override
            public double getDouble(@NonNull T data) {
                @Nullable Number number = (Number)mapper.apply(data);
                return number != null ? number.doubleValue() : 0.0;
            }

            @Override
            public long getLong(@NonNull T data) {
                @Nullable Number number = (Number)mapper.apply(data);
                return number != null ? number.longValue() : 0L;
            }

            @Override
            public @NonNull String getText(@NonNull T data) {
                @Nullable Number number = (Number)mapper.apply(data);
                if (number == null) {
                    return "";
                }
                if (number instanceof Float || number instanceof Double) {
                    return NumberUtils.prettyFormat((double)number.doubleValue());
                }
                return NumberUtils.prettyFormat((long)number.longValue());
            }
        };
    }

    protected static <T, V extends Number> @NonNull IRowValueMapper<T> rowMapperFromPercent(final @NonNull Function<@NonNull T, @Nullable V> mapper) {
        return new IRowValueMapper<T>(){

            @Override
            public double getDouble(@NonNull T data) {
                @Nullable Number percent = (Number)mapper.apply(data);
                return percent != null ? percent.doubleValue() : -1.0;
            }

            @Override
            public long getLong(@NonNull T data) {
                @Nullable Number percent = (Number)mapper.apply(data);
                return percent != null ? percent.longValue() : 0L;
            }

            @Override
            public @NonNull String getText(@NonNull T data) {
                @Nullable Number percent = (Number)mapper.apply(data);
                return percent != null ? NumberUtils.formatPercentage((double)percent.doubleValue(), (boolean)false) : "";
            }
        };
    }

    protected static <T> @NonNull IRowValueMapper<T> rowMapperFromPercentAndValue(final @NonNull Function<@NonNull T, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong> mapper) {
        return new IRowValueMapper<T>(){

            @Override
            public double getDouble(@NonNull T data) {
                // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong percentAndValue = (ISampleCounterColumnAccessorFactory.PercentAndLong)mapper.apply(data);
                return percentAndValue != null ? percentAndValue.percent() : -1.0;
            }

            @Override
            public long getLong(@NonNull T data) {
                // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong percentAndValue = (ISampleCounterColumnAccessorFactory.PercentAndLong)mapper.apply(data);
                return percentAndValue != null ? percentAndValue.value() : 0L;
            }

            @Override
            public @NonNull String getText(@NonNull T data) {
                // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong percentAndValue = (ISampleCounterColumnAccessorFactory.PercentAndLong)mapper.apply(data);
                return percentAndValue != null ? String.format("%s\t%s", percentAndValue.value(), percentAndValue.percent()) : "";
            }
        };
    }

    protected static <T> @NonNull IRowValueMapper<T> rowMapperFromRatio(final @NonNull Function<@NonNull T, @NonNull RatioValue @Nullable []> mapper) {
        return new IRowValueMapper<T>(){

            @Override
            public double getDouble(@NonNull T data) {
                return this.getLong(data);
            }

            @Override
            public long getLong(@NonNull T data) {
                @NonNull Object @Nullable [] ratioValues = (RatioValue[])mapper.apply(data);
                return StreamUtils.emptyIfNullOfArray((Object[])ratioValues).mapToLong(v -> v.value).sum();
            }

            @Override
            public @NonNull String getText(@NonNull T data) {
                @NonNull Object @Nullable [] ratioValues = (RatioValue[])mapper.apply(data);
                return StreamUtils.emptyIfNullOfArray((Object[])ratioValues).map(x -> Long.toUnsignedString(x.value)).collect(Collectors.joining(":"));
            }
        };
    }

    private static <T extends IExtractable, X, C extends AbstractInstructionCounterColumn<T, X>> @NonNull C factory(final @NonNull IConstructor<T, X, C> constructor, final @NonNull IAccessorFactory accessorFactory, final @NonNull IColumnDescriptor columnDescriptor, final @NonNull ToLongFunction<@NonNull T> uidMapper, final boolean childOfRatio, final boolean hideFromUi, final boolean visibleByDefault) {
        return (C)((AbstractInstructionCounterColumn)accessorFactory.apply(columnDescriptor, new ISampleCounterColumnAccessorFactory<ToLongFunction<T>, C, RuntimeException>(){

            public @NonNull C histogram(@NonNull ToLongFunction<@NonNull T> data, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull ISampleCounterColumnAccessorFactory.ISampleCounterHistogramValueAccessor accessor) throws RuntimeException {
                @NonNull List<@NonNull T> children = AbstractInstructionCounterColumn.streamOfChildren(columnDescriptor).map(c -> AbstractInstructionCounterColumn.factory(constructor, accessorFactory, c, uidMapper, true, hideFromUi, visibleByDefault && !columnDescriptor.isVisibleByDefault())).collect(Collectors.toUnmodifiableList());
                IColumnDescriptor.IHistogramColumnDescriptor histoDescriptor = accessor.getColumnDescriptor();
                IColumnDescriptor descriptor = histoDescriptor.getDescriptor();
                HistogramDataPoint[] dataPoints = histoDescriptor.getDatapoints();
                boolean shouldScaleRelativeToLimit = histoDescriptor.shouldScaleRelativeToLimit();
                @NonNull Function<@NonNull IExtractable, // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable ISampleCounterColumnAccessorFactory.HistogramValue> mapper = t -> accessor.getValueFor(uidMapper.applyAsLong(t));
                return AbstractInstructionCounterColumn.bindColumnsAndChildren(constructor, descriptor, false, !descriptor.isExportable(), visibleByDefault && descriptor.isVisibleByDefault(), children, AbstractInstructionCounterColumn.histogramCellSupplier(dataPoints, shouldScaleRelativeToLimit, descriptor.getColourPreference(), histoDescriptor.getUserDefinedRGB(), histoDescriptor.getTypicalBinCount(), descriptor.getUnits(), mapper), AbstractInstructionCounterColumn.rowMapperFromHistogram(dataPoints, mapper), AbstractInstructionCounterColumn.valueTooltipHistogram(descriptor, mapper), () -> Utilities.getHistogramPreferredWidth(dataPoints));
            }

            public @NonNull C number(@NonNull ToLongFunction<@NonNull T> data, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull ISampleCounterColumnAccessorFactory.ISampleCounterNumberValueAccessor accessor) throws RuntimeException {
                @NonNull List<@NonNull T> children = AbstractInstructionCounterColumn.streamOfChildren(columnDescriptor).map(c -> AbstractInstructionCounterColumn.factory(constructor, accessorFactory, c, uidMapper, childOfRatio, hideFromUi, visibleByDefault && !columnDescriptor.isVisibleByDefault())).collect(Collectors.toUnmodifiableList());
                IColumnDescriptor descriptor = accessor.getColumnDescriptor().getDescriptor();
                switch (accessor.getColumnDescriptor().getFormat()) {
                    case number: {
                        @NonNull Function<@NonNull IExtractable, @Nullable Number> mapper = t -> accessor.getValueFor(uidMapper.applyAsLong(t));
                        return AbstractInstructionCounterColumn.bindColumnsAndChildren(constructor, descriptor, childOfRatio && hideFromUi, !descriptor.isExportable(), visibleByDefault && descriptor.isVisibleByDefault(), children, AbstractInstructionCounterColumn.numberCellSupplier(mapper), AbstractInstructionCounterColumn.rowMapperFromNumber(mapper), AbstractInstructionCounterColumn.valueTooltipNumber(descriptor, mapper), () -> Utilities.getValuePreferredWidth(accessor.getMaxValue()));
                    }
                    case percent: {
                        @NonNull Function<@NonNull IExtractable, @Nullable Number> mapper = t -> accessor.getValueFor(uidMapper.applyAsLong(t));
                        return AbstractInstructionCounterColumn.bindColumnsAndChildren(constructor, descriptor, childOfRatio && hideFromUi, !descriptor.isExportable(), visibleByDefault && descriptor.isVisibleByDefault(), children, AbstractInstructionCounterColumn.percentCellSupplierFromPercent(descriptor.getColourPreference(), accessor.getColumnDescriptor().getUserDefinedRGB(), mapper), AbstractInstructionCounterColumn.rowMapperFromPercent(mapper), AbstractInstructionCounterColumn.valueTooltipPercent(descriptor, mapper), () -> Utilities.getPercentPreferredWidth());
                    }
                    case mpki: {
                        @NonNull Function<@NonNull IExtractable, @Nullable Number> mapper = t -> accessor.getValueFor(uidMapper.applyAsLong(t));
                        return AbstractInstructionCounterColumn.bindColumnsAndChildren(constructor, descriptor, childOfRatio && hideFromUi, !descriptor.isExportable(), visibleByDefault && descriptor.isVisibleByDefault(), children, AbstractInstructionCounterColumn.mpkiCellSupplier(descriptor.getColourPreference(), accessor.getColumnDescriptor().getUserDefinedRGB(), mapper), AbstractInstructionCounterColumn.rowMapperFromMpki(mapper), AbstractInstructionCounterColumn.valueTooltipMpki(descriptor, mapper), () -> Utilities.getPercentPreferredWidth());
                    }
                }
                throw new AssertionError(accessor.getColumnDescriptor().getFormat());
            }

            public @NonNull C percentAndNumber(@NonNull ToLongFunction<@NonNull T> data, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull ISampleCounterColumnAccessorFactory.ISampleCounterPercentAndLongValueAccessor accessor) throws RuntimeException {
                @NonNull List<@NonNull T> children = AbstractInstructionCounterColumn.streamOfChildren(columnDescriptor).map(c -> AbstractInstructionCounterColumn.factory(constructor, accessorFactory, c, uidMapper, childOfRatio, childOfRatio, visibleByDefault && !columnDescriptor.isVisibleByDefault())).collect(Collectors.toUnmodifiableList());
                IColumnDescriptor descriptor = accessor.getColumnDescriptor().getDescriptor();
                @NonNull Function<@NonNull IExtractable, // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong> mapper = t -> accessor.getValueFor(uidMapper.applyAsLong(t));
                return AbstractInstructionCounterColumn.bindColumnsAndChildren(constructor, descriptor, false, !descriptor.isExportable(), visibleByDefault && descriptor.isVisibleByDefault(), children, AbstractInstructionCounterColumn.percentCellSupplierFromPercentAndValue(descriptor.getColourPreference(), accessor.getColumnDescriptor().getUserDefinedRGB(), mapper), AbstractInstructionCounterColumn.rowMapperFromPercentAndValue(mapper), AbstractInstructionCounterColumn.valueTooltipPercentAndNumber(descriptor, mapper), () -> Utilities.getValueAndPercentagePreferredWidth(accessor.getMaxValue()));
            }

            public @NonNull C ratio(@NonNull ToLongFunction<@NonNull T> data, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull ISampleCounterColumnAccessorFactory.ISampleCounterRatioValueAccessor accessor) throws RuntimeException {
                @NonNull List<@NonNull T> children = AbstractInstructionCounterColumn.streamOfChildren(columnDescriptor).map(c -> AbstractInstructionCounterColumn.factory(constructor, accessorFactory, c, uidMapper, true, hideFromUi, visibleByDefault && !columnDescriptor.isVisibleByDefault())).collect(Collectors.toUnmodifiableList());
                IColumnDescriptor.IRatioColumnDescriptor ratioDescriptor = accessor.getColumnDescriptor();
                IColumnDescriptor descriptor = ratioDescriptor.getDescriptor();
                IColumnDescriptor.IRatioColumnDescriptor.RatioItem[] ratioItems = ratioDescriptor.getItems();
                Integer[] colourSpread = AbstractInstructionCounterColumn.makeColourSpread(descriptor.getColourPreference(), ratioItems);
                @NonNull Function<@NonNull IExtractable, @NonNull RatioValue @Nullable []> mapper = t -> AbstractInstructionCounterColumn.mapRatioValues(accessor.getValuesFor(uidMapper.applyAsLong(t)), ratioItems, colourSpread);
                return AbstractInstructionCounterColumn.bindColumnsAndChildren(constructor, descriptor, false, !descriptor.isExportable(), visibleByDefault && descriptor.isVisibleByDefault(), children, AbstractInstructionCounterColumn.ratioCellSupplier(mapper), AbstractInstructionCounterColumn.rowMapperFromRatio(mapper), AbstractInstructionCounterColumn.valueTooltipRatio(descriptor, mapper), () -> Utilities.getRatioPreferredWidth(ratioItems.length));
            }
        }, uidMapper));
    }

    private static final @NonNull Stream<@NonNull IColumnDescriptor> streamOfChildren(@NonNull IColumnDescriptor columnDescriptor) {
        IColumnDescriptor[] children = columnDescriptor.getChildren();
        if (children == null) {
            return Stream.empty();
        }
        return Arrays.stream(children);
    }

    private static <T extends IExtractable> @NonNull Function<@Nullable T, @Nullable String> valueTooltipHistogram(@NonNull IColumnDescriptor descriptor, @NonNull Function<@NonNull T, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ISampleCounterColumnAccessorFactory.HistogramValue> mapper) {
        return v -> null;
    }

    private static <T extends IExtractable, V extends Number> @NonNull Function<@Nullable T, @Nullable String> valueTooltipMpki(@NonNull IColumnDescriptor descriptor, @NonNull Function<@NonNull T, @Nullable V> mapper) {
        String units = descriptor.getUnits().trim();
        return v -> {
            if (v == null) {
                return null;
            }
            Number m = (Number)mapper.apply(v);
            if (m == null) {
                return null;
            }
            if (units.isBlank() || units.equalsIgnoreCase("misses") || units.equalsIgnoreCase("mpki")) {
                return String.format("%s misses per 1000 instructions", m);
            }
            return String.format("%s %s per 1000 instructions", m, units);
        };
    }

    private static <T extends IExtractable, V extends Number> @NonNull Function<@Nullable T, @Nullable String> valueTooltipNumber(@NonNull IColumnDescriptor descriptor, @NonNull Function<@NonNull T, @Nullable V> mapper) {
        String units = descriptor.getUnits().trim();
        return v -> {
            if (v == null) {
                return null;
            }
            Number m = (Number)mapper.apply(v);
            if (m == null) {
                return null;
            }
            if (units.isBlank()) {
                return m.toString();
            }
            return String.format("%s %s", m, units);
        };
    }

    private static <T extends IExtractable, V extends Number> @NonNull Function<@Nullable T, @Nullable String> valueTooltipPercent(@NonNull IColumnDescriptor descriptor, @NonNull Function<@NonNull T, @Nullable V> mapper) {
        String units = descriptor.getUnits().trim();
        return v -> {
            if (v == null) {
                return null;
            }
            Number m = (Number)mapper.apply(v);
            if (m == null) {
                return null;
            }
            if (units.isBlank() || units.equalsIgnoreCase("percent")) {
                return String.format("%s%%", m);
            }
            return String.format("%s%% %s", m, units);
        };
    }

    private static <T extends IExtractable> @NonNull Function<@Nullable T, @Nullable String> valueTooltipPercentAndNumber(@NonNull IColumnDescriptor descriptor, @NonNull Function<@NonNull T, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong> mapper) {
        String units = descriptor.getUnits().trim();
        return v -> {
            if (v == null) {
                return null;
            }
            ISampleCounterColumnAccessorFactory.PercentAndLong m = (ISampleCounterColumnAccessorFactory.PercentAndLong)mapper.apply(v);
            if (m == null) {
                return null;
            }
            if (units.isBlank() || units.equalsIgnoreCase("percent")) {
                return String.format("%s (%s%%)", m.value(), m.percent());
            }
            return String.format("%s %s (%s%%)", m.value(), units, m.percent());
        };
    }

    private static <T extends IExtractable> @NonNull Function<@Nullable T, @Nullable String> valueTooltipRatio(@NonNull IColumnDescriptor descriptor, @NonNull Function<@NonNull T, @NonNull RatioValue @Nullable []> mapper) {
        String units = descriptor.getUnits().trim();
        return v -> {
            if (v == null) {
                return null;
            }
            @NonNull RatioValue @Nullable [] ratioValue = (RatioValue[])mapper.apply(v);
            if (ratioValue == null) {
                return null;
            }
            @NonNull String valuesText = Arrays.stream(ratioValue).map(x -> Long.toUnsignedString(x.value)).collect(Collectors.joining(":"));
            if (units.isBlank()) {
                return valuesText;
            }
            return String.format("%s %s", valuesText, units);
        };
    }

    protected AbstractInstructionCounterColumn(@NonNull IColumnDescriptor counterColumn, boolean hiddenFromUi, boolean hiddenFromExport, boolean visibleByDefault, @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> cellSupplier, @NonNull IRowValueMapper<T> rowValueMapper, @NonNull Function<@Nullable T, @Nullable String> valueTooltipFunction, @NonNull IntSupplier prefWidthSupplier) {
        this.counterColumn = counterColumn;
        this.hiddenFromUi = hiddenFromUi;
        this.hiddenFromExport = hiddenFromExport;
        this.visibleByDefault = visibleByDefault;
        this.cellSupplier = cellSupplier;
        this.rowValueMapper = rowValueMapper;
        this.valueTooltipFunction = valueTooltipFunction;
        this.prefWidthSupplier = prefWidthSupplier;
        this.columnStructureProperties = new ColumnStructureProperties(counterColumn.getClusterName(), counterColumn.getHierarchyGroupLabel(), counterColumn.getFilterGroupLabel(), counterColumn.isInternalDebug());
    }

    @Override
    public @NonNull ICell<EnumColumn<T>> getCell(X data) {
        return this.cellSupplier.get();
    }

    @Override
    public double getDataAsDouble(ReportRow<T> row) {
        return this.rowValueMapper.getDouble(row.getModelObject());
    }

    @Override
    public long getDataAsLong(ReportRow<T> row) {
        return this.rowValueMapper.getLong(row.getModelObject());
    }

    @Override
    public @NonNull String getDataAsText(ReportRow<T> row) {
        return this.rowValueMapper.getText(row.getModelObject());
    }

    @Override
    public @NonNull String getHeader(X data) {
        return this.counterColumn.getTitle();
    }

    @Override
    public final @Nullable AbstractInstructionCounterColumn<T, X> getHeirarchicalParentColumn() {
        return this.parent;
    }

    @Override
    public @Nullable Image getImage(ReportRow<T> row) {
        return null;
    }

    @Override
    public int getInitialSortSequence() {
        return this.counterColumn.getDefaultSortIndex();
    }

    @Override
    public @Nullable ColumnStructureProperties getColumnStructureProperties() {
        return this.columnStructureProperties;
    }

    @Override
    public final @Nullable String getToolTip(ReportRow<T> row) {
        return this.valueTooltipFunction.apply(row.getModelObject());
    }

    @Override
    public final @NonNull String getToolTip(X data) {
        return this.counterColumn.getDescription();
    }

    @Override
    public boolean isComponentOfParent() {
        return this.counterColumn.isComponentOfParent();
    }

    @Override
    public boolean isHiddenFromExport() {
        return this.hiddenFromExport;
    }

    @Override
    public boolean isHiddenFromUi() {
        return this.hiddenFromUi;
    }

    @Override
    public boolean isInitialSortAscending() {
        return this.counterColumn.getDefaultSortAscending();
    }

    @Override
    public boolean isPrimary() {
        return false;
    }

    @Override
    public boolean isVisibleByDefault() {
        return this.visibleByDefault;
    }

    protected int getPreferredWidth() {
        return this.prefWidthSupplier.getAsInt();
    }

    protected final void setParent(@NonNull AbstractInstructionCounterColumn<T, X> parent) {
        this.parent = parent;
    }

    static /* synthetic */ AbstractInstructionCounterColumn access$1(IConstructor iConstructor, IAccessorFactory iAccessorFactory, IColumnDescriptor iColumnDescriptor, ToLongFunction toLongFunction, boolean bl, boolean bl2, boolean bl3) {
        return AbstractInstructionCounterColumn.factory(iConstructor, iAccessorFactory, iColumnDescriptor, toLongFunction, bl, bl2, bl3);
    }

    @FunctionalInterface
    public static interface IAccessorFactory {
        public <D, R, E extends Throwable> R apply(@NonNull IColumnDescriptor var1, @NonNull ISampleCounterColumnAccessorFactory<D, R, E> var2, D var3) throws E;
    }

    @FunctionalInterface
    protected static interface IConstructor<T extends IExtractable, X, C extends AbstractInstructionCounterColumn<T, X>> {
        public @NonNull C create(@NonNull IColumnDescriptor var1, boolean var2, boolean var3, boolean var4, @NonNull List<@NonNull C> var5, @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> var6, @NonNull IRowValueMapper<T> var7, @NonNull Function<@Nullable T, @Nullable String> var8, @NonNull IntSupplier var9);
    }

    protected static interface IRowValueMapper<T> {
        public double getDouble(@NonNull T var1);

        public long getLong(@NonNull T var1);

        public @NonNull String getText(@NonNull T var1);
    }
}

