/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.dataimport;

import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.BarmanTypeAndVersion;
import com.arm.streamline.barman.IBarmanHeader;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.xml.pmus.EventsAndPmusXml;
import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.DocumentsView;
import com.arm.streamline.dataimport.ImportJob;
import com.arm.streamline.dataimport.ImportingApcFile;
import com.arm.utils.NullChecking;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;

public class ImportBarmanCaptureJob
extends ImportJob {
    private final @NonNull List<@NonNull File> barmanFiles;

    public static boolean isBarmanFile(@NonNull File file) throws FileNotFoundException, IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream inputStream = new FileInputStream(file);){
                BarmanTypeAndVersion typeAndVersion = BarmanTypeAndVersion.detectTypeAndVersion(inputStream);
                boolean bl = typeAndVersion != null;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException e) {
            return false;
        }
    }

    public ImportBarmanCaptureJob(@NonNull List<@NonNull File> barmanFiles, @NonNull File apcOutputPath) {
        super(DocumentsMessages.IMPORTING_TITLE, apcOutputPath);
        this.barmanFiles = barmanFiles;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(DocumentsMessages.IMPORTING_TITLE, this.barmanFiles.size());
        for (File inputFile : this.barmanFiles) {
            IStatus status = this.convertOne(monitor, inputFile);
            if (status != Status.OK_STATUS) {
                return status;
            }
            monitor.worked(1);
        }
        return Status.OK_STATUS;
    }

    /*
     * Loose catch block
     */
    private IStatus convertOne(IProgressMonitor monitor, File inputFile) {
        IStatus iStatus;
        block40: {
            boolean completedSuccessfully;
            block38: {
                completedSuccessfully = false;
                File apcDirectory = null;
                try {
                    String name;
                    if (!inputFile.exists() || !inputFile.isFile()) {
                        throw new AssertionError(inputFile);
                    }
                    if (!this.outputPath.exists() || !this.outputPath.isDirectory()) {
                        throw new AssertionError(this.outputPath);
                    }
                    Throwable throwable = null;
                    Object var7_8 = null;
                    try (FileInputStream inputStream = new FileInputStream(inputFile);){
                        BarmanTypeAndVersion typeAndVersion = BarmanTypeAndVersion.detectTypeAndVersion(inputStream);
                        if (typeAndVersion == null) {
                            throw new AssertionError((Object)"Invalid file");
                        }
                        IBarmanHeader header = typeAndVersion.getHeader(EventsAndPmusXml.getPmus((File)inputFile), EventsAndPmusXml.getEvents((File)inputFile), inputStream);
                        name = header.getTargetDescription();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    name = name.replaceAll("[^0-9A-Za-z_ ]+", " ").trim().replace(' ', '_');
                    if (name.isEmpty()) {
                        name = inputFile.getName();
                    }
                    throwable = null;
                    var7_8 = null;
                    try (@NonNull ImportingApcFile apcFile = ImportBarmanCaptureJob.getApcFile(this.outputPath, (String)NullChecking.neverNull((Object)name));){
                        apcDirectory = apcFile.getFile();
                        CommonFileUtils.copyFile((File)inputFile, (File)new File(apcDirectory, "barman.raw"));
                        File pmusXml = new File(inputFile.getParentFile(), "pmus.xml");
                        File eventsXml = new File(inputFile.getParentFile(), "events.xml");
                        if (pmusXml.exists()) {
                            CommonFileUtils.copyFile((File)pmusXml, (File)new File(apcDirectory, "pmus.xml"));
                        }
                        if (eventsXml.exists()) {
                            CommonFileUtils.copyFile((File)eventsXml, (File)new File(apcDirectory, "events.xml"));
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    DocumentScanner.INSTANCE.updateAndSelect(Arrays.asList(apcDirectory));
                    completedSuccessfully = true;
                    iStatus = Status.OK_STATUS;
                    if (completedSuccessfully || apcDirectory == null) break block38;
                }
                catch (InterruptedException e) {
                    block39: {
                        if (!monitor.isCanceled()) break block39;
                        IStatus iStatus2 = Status.CANCEL_STATUS;
                        return iStatus2;
                    }
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.IMPORT_ERROR_EXCEPTION, (Throwable)e);
                    return status;
                }
                catch (BarmanDataError | IOException e2) {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.IMPORT_ERROR_EXCEPTION, e2);
                    return status;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (!completedSuccessfully && apcDirectory != null) {
                        ImportBarmanCaptureJob.deleteRecursive(apcDirectory);
                    } else if (completedSuccessfully) {
                        DocumentsView.makeVisible();
                    }
                }
                ImportBarmanCaptureJob.deleteRecursive(apcDirectory);
                break block40;
            }
            if (completedSuccessfully) {
                DocumentsView.makeVisible();
            }
        }
        return iStatus;
    }
}

