/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.authentication.TargetAuthentication;
import com.arm.utils.NullChecking;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TargetAddressString
implements Comparable<TargetAddressString> {
    private static final @NonNull String ADB_TCP_PREFIX = "adb+tcp:";
    private static final @NonNull String ADB_UDS_PREFIX = "adb:";
    private static final @NonNull Pattern TCP_PORT_PATTERN = Pattern.compile("(.+):(\\d+)");
    private static final @NonNull Pattern IPV6_PATTERN = Pattern.compile("^(?!.*:::.*)(?!.*::.*::)(?=.*::.*|.*:.*:.*:.*:.*:.*:.*:.*)(?<![:.\\w])(?:[a-fA-F0-9]{0,4}:){1,7}[a-fA-F0-9]{1,4}(?![:.\\w])$");
    private final @Nullable String deviceSerial;
    private final @Nullable String hostname;
    private final @NonNull String originalAddress;
    private final @Nullable Integer port;
    private final @NonNull Type type;
    private @Nullable String label;

    public static boolean isIPv6(@NonNull String address) {
        Matcher matcher;
        return !address.isEmpty() && (matcher = IPV6_PATTERN.matcher(address)).matches();
    }

    public static @NonNull TargetAddressString makeAndroid(@NonNull String deviceSerial, boolean tcp) {
        return new TargetAddressString((tcp ? ADB_TCP_PREFIX : ADB_UDS_PREFIX) + deviceSerial);
    }

    public static @NonNull TargetAddressString makeTcp(@NonNull String address) {
        return new TargetAddressString(address);
    }

    public TargetAddressString() {
        this(null);
    }

    public TargetAddressString(@Nullable String address) {
        if (address == null) {
            this.type = Type.NONE;
            this.originalAddress = "";
            this.hostname = null;
            this.port = null;
            this.deviceSerial = null;
        } else {
            this.originalAddress = address = address.trim();
            if (address.startsWith(ADB_UDS_PREFIX)) {
                String serial = address.substring(ADB_UDS_PREFIX.length()).trim();
                if (serial.isEmpty()) {
                    this.deviceSerial = null;
                    this.type = Type.NONE;
                } else {
                    this.type = Type.ANDROID_UDS;
                    this.deviceSerial = serial;
                }
                this.hostname = null;
                this.port = null;
            } else if (address.startsWith(ADB_TCP_PREFIX)) {
                String serial = address.substring(ADB_TCP_PREFIX.length()).trim();
                if (serial.isEmpty()) {
                    this.deviceSerial = null;
                    this.type = Type.NONE;
                } else {
                    this.type = Type.ANDROID_TCP;
                    this.deviceSerial = serial;
                }
                this.hostname = null;
                this.port = null;
            } else {
                if (address.toLowerCase().startsWith("tcp:")) {
                    address = address.substring(4).trim();
                }
                Matcher matcher = TCP_PORT_PATTERN.matcher(address);
                if (TargetAddressString.isIPv6(address)) {
                    this.type = Type.TCP;
                    this.hostname = address;
                    this.port = null;
                } else if (matcher.matches()) {
                    this.type = Type.TCP;
                    this.hostname = matcher.group(1);
                    this.port = Integer.valueOf(matcher.group(2));
                } else if (address.isEmpty()) {
                    this.type = Type.NONE;
                    this.hostname = null;
                    this.port = null;
                } else {
                    this.type = Type.TCP;
                    this.hostname = address;
                    this.port = null;
                }
                this.deviceSerial = null;
            }
        }
    }

    @Override
    public int compareTo(TargetAddressString o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof TargetAddressString) {
            TargetAddressString that = (TargetAddressString)obj;
            if (this.type == that.type) {
                if (this.type == Type.NONE) {
                    return this.originalAddress.contentEquals(that.originalAddress);
                }
                return NullChecking.equalsNullable((Object)this.hostname, (Object)that.hostname) && NullChecking.equalsNullable((Object)this.port, (Object)that.port) && NullChecking.equalsNullable((Object)this.deviceSerial, (Object)that.deviceSerial);
            }
        }
        return false;
    }

    public @NonNull String getAndroidSerialNumber() {
        switch (this.type) {
            case ANDROID_TCP: 
            case ANDROID_UDS: {
                return (String)NullChecking.neverNull((Object)this.deviceSerial);
            }
        }
        throw new AssertionError((Object)this.originalAddress);
    }

    public @NonNull String getHostname() {
        switch (this.type) {
            case TCP: {
                return (String)NullChecking.neverNull((Object)this.hostname);
            }
        }
        throw new AssertionError((Object)this.originalAddress);
    }

    public @Nullable TargetAuthentication.Address getTcpAddressOrDefault(@NonNull String defaultHostname, int defaultPort) {
        switch (this.type) {
            case NONE: 
            case TCP: {
                String hostname = (String)NullChecking.neverNullOr((Object)this.hostname, (Object)defaultHostname);
                Integer port = (Integer)NullChecking.neverNullOr((Object)this.port, (Object)defaultPort);
                if (hostname.isEmpty()) {
                    return null;
                }
                return new TargetAuthentication.Address(hostname, port);
            }
        }
        throw new AssertionError((Object)this.originalAddress);
    }

    public int hashCode() {
        if (this.type == Type.NONE) {
            return this.originalAddress.hashCode();
        }
        return ((this.type.hashCode() * 31 + NullChecking.hashNullable((Object)this.hostname)) * 31 + NullChecking.hashNullable((Object)this.port)) * 31 + NullChecking.hashNullable((Object)this.deviceSerial);
    }

    public boolean isAndroid() {
        return this.isAndroidOverTcp() || this.isAndroidOverUds();
    }

    public boolean isAndroidOverTcp() {
        return this.type == Type.ANDROID_TCP;
    }

    public boolean isAndroidOverUds() {
        return this.type == Type.ANDROID_UDS;
    }

    public boolean isDefinitelyLoopback() {
        switch (this.type) {
            case ANDROID_TCP: 
            case ANDROID_UDS: 
            case NONE: {
                return false;
            }
            case TCP: {
                assert (this.hostname != null);
                try {
                    return InetAddress.getByName(this.hostname).isLoopbackAddress();
                }
                catch (UnknownHostException exception) {
                    return false;
                }
            }
        }
        throw new AssertionError((Object)this.originalAddress);
    }

    public boolean isTcp() {
        return this.type == Type.TCP;
    }

    public boolean isValid() {
        return this.type != Type.NONE;
    }

    public void setLabel(@NonNull String label) {
        this.label = label;
    }

    public @NonNull String toString() {
        String label = this.label;
        if (label != null && !label.isBlank()) {
            return label;
        }
        switch (this.type) {
            case ANDROID_UDS: {
                String deviceSerial = (String)NullChecking.neverNull((Object)this.deviceSerial);
                return ADB_UDS_PREFIX + deviceSerial;
            }
            case ANDROID_TCP: {
                String deviceSerial = (String)NullChecking.neverNull((Object)this.deviceSerial);
                return ADB_TCP_PREFIX + deviceSerial;
            }
            case NONE: {
                return "";
            }
            case TCP: {
                String hostname = (String)NullChecking.neverNull((Object)this.hostname);
                Integer port = this.port;
                return port != null ? hostname + ":" + String.valueOf(port) : hostname;
            }
        }
        throw new AssertionError((Object)this.type);
    }

    private static enum Type {
        ANDROID_TCP,
        ANDROID_UDS,
        NONE,
        TCP;

    }
}

