/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.GatorBinaryId;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.databrowser.DeviceABIDetector;
import com.arm.streamline.databrowser.IConfigurer;
import com.arm.streamline.databrowser.IGatordInstallUninstall;
import com.arm.streamline.databrowser.SshException;
import com.arm.streamline.deviceconn.IInteractiveCommand;
import com.arm.streamline.deviceconn.lib.AbstractAsyncByteReaderLineReaderAndLogger;
import com.arm.streamline.deviceconn.lib.ISelfCleaningSession;
import com.arm.streamline.deviceconn.ssh.ISshCommandRunner;
import com.arm.streamline.deviceconn.ssh.SshSelfCleaningSession;
import com.arm.streamline.model.session.GpuTimelineLayerDriver;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class SshGatordManager {
    private final @NonNull ISshCommandRunner commandRunner;
    private final @NonNull GpuTimelineLayerDriver gpuTimelineLayerDriverStatus;

    public SshGatordManager(@NonNull ISshCommandRunner commandRunner, @NonNull GpuTimelineLayerDriver gpuTimelineLayerDriverStatus) {
        this.commandRunner = commandRunner;
        this.gpuTimelineLayerDriverStatus = gpuTimelineLayerDriverStatus;
    }

    private static @NonNull File getGatord(@NonNull DeviceABIDetector.DeviceABI deviceABI) throws IOException {
        switch (deviceABI) {
            case ARM64: {
                return StreamlinePlugin.getGatord(GatorBinaryId.LINUX_ARM64);
            }
            case ARM32: {
                return StreamlinePlugin.getGatord(GatorBinaryId.LINUX_ARM32);
            }
            case X86_64: {
                try {
                    return StreamlinePlugin.getGatord(GatorBinaryId.LINUX_X64_64);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        throw new IOException("Device must support either arm64 arm32 or x86_64 abi.");
    }

    public @NonNull IGatordInstallUninstall getGatordInstallUninstall(final @NonNull IConfigurer configurer, String ... gatordArgs) {
        boolean logDebug;
        final SshSelfCleaningSession session = new SshSelfCleaningSession(this.commandRunner, StreamlinePlugin::warning);
        String envDebug = System.getenv("DEVTEST_LOG_DEBUG");
        boolean bl = logDebug = AbstractAsyncByteReaderLineReaderAndLogger.LOG_OUTPUT_TO_SCREEN && envDebug != null && envDebug.toLowerCase().matches("^(true)|([1-9][0-9]*)$");
        if (logDebug) {
            String[] newArgs = new String[gatordArgs.length + 1];
            newArgs[0] = "-d";
            System.arraycopy(gatordArgs, 0, newArgs, 1, gatordArgs.length);
            gatordArgs = newArgs;
        }
        final String[] argsToUse = gatordArgs;
        return new IGatordInstallUninstall(){

            @Override
            public @NonNull IRunnableWithProgress getInstaller() {
                return monitor -> {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
                    try {
                        subMonitor.subTask("Getting ABI version");
                        DeviceABIDetector.DeviceABI deviceABI = DeviceABIDetector.getLinuxDeviceABI(SshGatordManager.this.commandRunner);
                        subMonitor.split(1);
                        if (SshGatordManager.this.gpuTimelineLayerDriverStatus != GpuTimelineLayerDriver.DISABLE) {
                            throw new UnsupportedOperationException("GPU Timeline Layer Driver status " + String.valueOf((Object)SshGatordManager.this.gpuTimelineLayerDriverStatus) + " support is unimplemented for SSH-based captures");
                        }
                        subMonitor.subTask("Detecting device gatord executable");
                        File gatord = SshGatordManager.getGatord(deviceABI);
                        subMonitor.split(1);
                        subMonitor.subTask("Transferring gatord to device");
                        ISelfCleaningSession.IRemoteExecutable remoteGatord = session.pushExecutable(gatord, "gatord");
                        subMonitor.split(1);
                        subMonitor.subTask("Starting gatord");
                        IInteractiveCommand gatordCommand = remoteGatord.runExe(argsToUse);
                        subMonitor.split(1);
                        try {
                            gatordCommand.waitForLineMatching(false, Pattern.compile("Gator ready"), true);
                        }
                        catch (EOFException e) {
                            throw new SshException("Error starting gatord", gatordCommand);
                        }
                        subMonitor.subTask("Gatord ready");
                        subMonitor.split(1);
                        configurer.configureTarget(subMonitor);
                        subMonitor.split(1);
                    }
                    catch (SshException | ISelfCleaningSession.CommandFailedException | IOException e) {
                        throw new InvocationTargetException(e);
                    }
                };
            }

            @Override
            public @NonNull IRunnableWithProgress getUninstaller() {
                return monitor -> {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(session.getNumberOfCleanUpActions() + 1));
                    subMonitor.subTask("Removing gatord from device");
                    try {
                        SshGatordManager.this.commandRunner.runCommandAndGetOutput("killall", new String[]{"gatord-main"});
                        subMonitor.worked(1);
                    }
                    catch (IOException e) {
                        StreamlinePlugin.warning("Failed to stop gatord", e);
                    }
                    session.cleanUp(() -> {
                        SubMonitor split = subMonitor.split(1);
                        split.worked(1);
                    });
                };
            }
        };
    }
}

