/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.deviceconn.Log;
import com.arm.streamline.deviceconn.ssh.BasicSshDeviceConnection;
import com.arm.streamline.deviceconn.ssh.SshDeviceConfiguration;
import com.arm.streamline.ui.part.lpv.SshTargetLauncher;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.utility.SWTUtils;
import com.arm.streamline.utility.io.Images;
import com.arm.streamline.widget.BorderedComposite;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.TextField;
import java.io.File;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SshConfigurationDialog
extends TitleAreaDialog {
    private TextField mGatorPath;
    private TextField mGatorPort;
    private TextField mSessionName;
    private TextField mSSHAddress;
    private TextField mSSHPort;
    private TextField mSSHUsername;
    private TextField mSSHPrivateKey;
    private TextField mSSHPassword;
    private Button mBtnPass;
    private Button mBtnKey;
    private ToolItem mBtnOpenDialog;
    ObservableList<@NonNull ISshTargetLauncher> mDetectedDevices;
    private ISshTargetLauncher mSshTarget;
    private Button mTestConnectionBtn;
    private Button mSaveBtn;
    private Label mConnectionStatusLabel;

    private static boolean isValidPort(String s) {
        try {
            int p = Integer.parseInt(s.trim());
            return p >= 1 && p <= 65535;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean validateSSHConfigurationInput() {
        block16: {
            boolean hasPassword;
            boolean hasGatorPath;
            boolean hasSessionName = this.mSessionName != null && !this.mSessionName.getText().trim().isEmpty();
            boolean hasAddress = this.mSSHAddress != null && !this.mSSHAddress.getText().trim().isEmpty();
            String portText = this.mSSHPort != null ? this.mSSHPort.getText() : "";
            boolean hasPort = this.mSSHPort != null && !portText.trim().isEmpty();
            boolean validSSHPort = hasPort && SshConfigurationDialog.isValidPort(portText);
            boolean hasUser = this.mSSHUsername != null && !this.mSSHUsername.getText().trim().isEmpty();
            portText = this.mGatorPort != null ? this.mGatorPort.getText() : "";
            hasPort = this.mGatorPort != null && !portText.trim().isEmpty();
            boolean validGatorPort = hasPort && SshConfigurationDialog.isValidPort(portText);
            boolean bl = hasGatorPath = this.mGatorPath != null && !this.mGatorPath.getText().trim().isEmpty();
            if (!hasSessionName) {
                SshConfigurationDialog.showErroToUserAndWait("Session name can not be empty");
                return false;
            }
            if (!hasAddress) {
                SshConfigurationDialog.showErroToUserAndWait("Address name can not be empty");
                return false;
            }
            if (!validSSHPort) {
                SshConfigurationDialog.showErroToUserAndWait("SSH Port must be between 1 and 65535");
                return false;
            }
            if (!validGatorPort) {
                SshConfigurationDialog.showErroToUserAndWait("Gator Port must be between 1 and 65535");
                return false;
            }
            if (!hasUser) {
                SshConfigurationDialog.showErroToUserAndWait("User name can not be empty");
                return false;
            }
            if (!hasGatorPath) {
                SshConfigurationDialog.showErroToUserAndWait("Gator path can not be empty");
                return false;
            }
            if (this.mSSHPrivateKey.getEnabled() && this.mBtnKey.getSelection()) {
                File key;
                block15: {
                    block14: {
                        boolean hasKey;
                        boolean bl2 = hasKey = !this.mSSHPrivateKey.getText().trim().isEmpty();
                        if (!hasKey) {
                            SshConfigurationDialog.showErroToUserAndWait("Private key can not be empty");
                            return false;
                        }
                        try {
                            key = new File(this.mSSHPrivateKey.getText().trim());
                            if (key.exists()) break block14;
                            SshConfigurationDialog.showErroToUserAndWait("SSH private key file " + key.getAbsolutePath() + " does not exist.");
                            return false;
                        }
                        catch (Exception e) {
                            SshConfigurationDialog.showErroToUserAndWait("Reading SSH private key file failed. Error: " + e.getMessage());
                            return false;
                        }
                    }
                    if (key.isFile()) break block15;
                    SshConfigurationDialog.showErroToUserAndWait("SSH private key file " + key.getAbsolutePath() + " is not a file.");
                    return false;
                }
                if (!key.canRead()) {
                    SshConfigurationDialog.showErroToUserAndWait("SSH private key file " + key.getAbsolutePath() + " can not be read.");
                    return false;
                }
                break block16;
            }
            boolean bl3 = hasPassword = !this.mSSHPassword.getText().trim().isEmpty();
            if (!hasPassword) {
                SshConfigurationDialog.showErroToUserAndWait("Password can not be empty");
                return false;
            }
        }
        return true;
    }

    private SshDeviceConfiguration buildSshConfig() throws Exception {
        @NonNull String host = this.mSSHAddress.getText().trim();
        int port = Integer.parseInt(this.mSSHPort.getText().trim());
        @NonNull String user = this.mSSHUsername.getText().trim();
        if (this.mBtnPass.getSelection()) {
            String pw = this.mSSHPassword.getText();
            if (pw == null) {
                return null;
            }
            return new SshDeviceConfiguration(host, port, user, pw);
        }
        File key = new File(this.mSSHPrivateKey.getText().trim());
        return new SshDeviceConfiguration(host, port, user, key, null);
    }

    public SshConfigurationDialog(Shell parentShell, ObservableList<@NonNull ISshTargetLauncher> detectedDevices, ISshTargetLauncher sshTarget) {
        super(parentShell);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.mDetectedDevices = detectedDevices;
        this.mSshTarget = sshTarget;
    }

    protected void configureShell(Shell parentShell) {
        super.configureShell(parentShell);
        parentShell.setText(DocumentsMessages.SSH_CONFIGURATION_TITLE);
        Display display = parentShell.getDisplay();
        int width = display.getClientArea().width;
        int height = display.getClientArea().height;
        parentShell.setLocation((width - parentShell.getSize().x) / 2, (height - parentShell.getSize().y) / 2);
        parentShell.setSize(605, 530);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(DocumentsMessages.SSH_CONFIGURATION_TITLE);
        this.setMessage(DocumentsMessages.SSH_CONFIGURATION_MESSAGE, 1);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridLayout mChildLayout = new GridLayout();
        mChildLayout.verticalSpacing = 10;
        mChildLayout.numColumns = 1;
        parent.setLayout((Layout)mChildLayout);
        BorderedComposite mSshName = new BorderedComposite(parent, "Name");
        GridLayoutFactory.fillDefaults().applyTo((Composite)mSshName);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(2, 2).applyTo((Composite)mSshName);
        this.mSessionName = SshConfigurationDialog.createTextField(mSshName, "Session name", "sessionname", 2048, false);
        FontInfo mFontInfo = FontInfo.get(this.mSessionName.getFont());
        this.mSessionName.setDesiredMinimumTextWidth(mFontInfo.getWidth("0") * 64);
        BorderedComposite mSshAddress = new BorderedComposite(parent, "Address");
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(2, 2).applyTo((Composite)mSshAddress);
        SWTUtils.createLabel(mSshAddress, DocumentsMessages.SSH_CONFIGURATION_ADDRESS, DocumentsMessages.SSH_CONFIGURATION_ADDRESS_TOOLTIP, 0);
        SWTUtils.createLabel(mSshAddress, DocumentsMessages.SSH_CONFIGURATION_PORT, DocumentsMessages.SSH_CONFIGURATION_PORT_TOOLTIP, 0);
        this.mSSHAddress = SshConfigurationDialog.createTextField(mSshAddress, DocumentsMessages.SSH_CONFIGURATION_ADDRESS_TOOLTIP, "192.168.1.1", 2048, true);
        this.mSSHPort = SshConfigurationDialog.createTextField(mSshAddress, DocumentsMessages.SSH_CONFIGURATION_PORT_TOOLTIP, "22", 2048, false);
        BorderedComposite mSshGroup = new BorderedComposite(parent, "Credentials");
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(2, 2).applyTo((Composite)mSshGroup);
        SWTUtils.createLabel(mSshGroup, DocumentsMessages.SSH_CONFIGURATION_USERNAME, DocumentsMessages.SSH_CONFIGURATION_USERNAME_TOOLTIP, 0);
        this.mSSHUsername = SshConfigurationDialog.createTextField(mSshGroup, DocumentsMessages.SSH_CONFIGURATION_USERNAME_TOOLTIP, "root", 2048, true);
        Composite mSshGroupComp = new Composite((Composite)mSshGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(2, 2).applyTo(mSshGroupComp);
        this.mBtnKey = new Button(mSshGroupComp, 16);
        this.mBtnKey.setText(DocumentsMessages.SSH_CONFIGURATION_PRIVATE_KEY);
        this.mBtnKey.setToolTipText(DocumentsMessages.SSH_CONFIGURATION_PRIVATE_KEY_TOOLTIP);
        this.mBtnPass = new Button(mSshGroupComp, 16);
        this.mBtnPass.setText(DocumentsMessages.SSH_CONFIGURATION_PASSWORD);
        this.mBtnPass.setToolTipText(DocumentsMessages.SSH_CONFIGURATION_PASSWORD_TOOLTIP);
        Composite mSshGroupPrivateKetComp = new Composite(mSshGroupComp, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(2, 2).applyTo(mSshGroupPrivateKetComp);
        this.mSSHPrivateKey = SshConfigurationDialog.createTextField(mSshGroupPrivateKetComp, DocumentsMessages.SSH_CONFIGURATION_PRIVATE_KEY_TOOLTIP, "~/.ssh", 2048, false);
        ToolBar toolBar = new ToolBar(mSshGroupPrivateKetComp, 0x800000);
        this.mBtnOpenDialog = new ToolItem(toolBar, 8);
        this.mBtnOpenDialog.setImage(Images.getEclipseSharedImage("IMG_OBJ_FOLDER"));
        final FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        this.mBtnOpenDialog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                fileDialog.setFilterPath(SshConfigurationDialog.this.mSSHPrivateKey.getText());
                String path = fileDialog.open();
                if (path != null && !path.isEmpty()) {
                    SshConfigurationDialog.this.mSSHPrivateKey.setText(path);
                }
            }
        });
        this.mSSHPassword = SshConfigurationDialog.createTextField(mSshGroupComp, DocumentsMessages.SSH_CONFIGURATION_PASSWORD_TOOLTIP, "", 0x400800, false);
        this.mSSHPrivateKey.setDesiredMinimumTextWidth(mFontInfo.getWidth("0") * 28);
        this.mSSHPassword.setDesiredMinimumTextWidth(mFontInfo.getWidth("0") * 32);
        this.selectPasswordOption(true);
        this.mBtnPass.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SshConfigurationDialog.this.mSSHPrivateKey.setEnabled(false);
                SshConfigurationDialog.this.mSSHPassword.setEnabled(true);
                SshConfigurationDialog.this.mBtnOpenDialog.setEnabled(false);
            }
        });
        this.mBtnKey.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SshConfigurationDialog.this.mSSHPrivateKey.setEnabled(true);
                SshConfigurationDialog.this.mSSHPassword.setEnabled(false);
                SshConfigurationDialog.this.mBtnOpenDialog.setEnabled(true);
            }
        });
        BorderedComposite mGatorGroup = new BorderedComposite(parent, "Gator Configuration");
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(2, 2).applyTo((Composite)mGatorGroup);
        SWTUtils.createLabel(mGatorGroup, DocumentsMessages.SSH_CONFIGURATION_GATOR_PATH, DocumentsMessages.SSH_CONFIGURATION_GATOR_PATH_TOOLTIP, 0);
        SWTUtils.createLabel(mGatorGroup, DocumentsMessages.SSH_CONFIGURATION_GATOR_PORT, DocumentsMessages.SSH_CONFIGURATION_GATOR_PORT_TOOLTIP, 0);
        this.mGatorPath = SshConfigurationDialog.createTextField(mGatorGroup, DocumentsMessages.SSH_CONFIGURATION_GATOR_PATH_TOOLTIP, "/tmp", 2048, true);
        this.mGatorPort = SshConfigurationDialog.createTextField(mGatorGroup, DocumentsMessages.SSH_CONFIGURATION_GATOR_PORT_TOOLTIP, "8080", 2048, false);
        if (this.mSshTarget != null) {
            this.mSessionName.setText(this.mSshTarget.getProfileName());
            this.mSSHUsername.setText(this.mSshTarget.getUserName());
            this.mSSHAddress.setText(this.mSshTarget.getTargetAddress());
            this.mSSHPort.setText(Integer.toString(this.mSshTarget.getSshPort()));
            this.mGatorPort.setText(Integer.toString(this.mSshTarget.getGatorPort()));
            this.mGatorPath.setText(this.mSshTarget.getGatorPath());
            if (!this.mSshTarget.getPassKey().isEmpty()) {
                this.mSSHPrivateKey.setText(this.mSshTarget.getPassKey());
                this.selectPasswordOption(false);
            } else {
                this.selectPasswordOption(true);
            }
        }
        this.mSSHPort.addVerifyListener(SshConfigurationDialog::ensureTextContainsOnlyDigits);
        this.mGatorPort.addVerifyListener(SshConfigurationDialog::ensureTextContainsOnlyDigits);
        return parent;
    }

    private static void ensureTextContainsOnlyDigits(VerifyEvent e) {
        String string = e.text;
        e.doit = string.matches("\\d*");
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.mSaveBtn = this.getButton(0);
        this.mSaveBtn.setText(DocumentsMessages.SAVE);
        return control;
    }

    public void okPressed() {
        int sPort;
        int gPort;
        String sshaddress = this.mSSHAddress.getText().trim();
        String sshSessionName = this.mSessionName.getText().trim();
        String sshUsername = this.mSSHUsername.getText().trim();
        String sshPort = this.mSSHPort.getText().trim();
        String sshGatorPort = this.mGatorPort.getText().trim();
        String sshGatorPath = this.mGatorPath.getText().trim();
        for (ISshTargetLauncher sshTargetLauncher : this.mDetectedDevices) {
            if (this.mSshTarget == null || this.mSshTarget == sshTargetLauncher || !sshTargetLauncher.getProfileName().equals(sshSessionName)) continue;
            SshConfigurationDialog.showErroToUserAndWait("Target with name " + sshSessionName + " already exist");
            return;
        }
        try {
            gPort = Integer.parseUnsignedInt(sshGatorPort);
            sPort = Integer.parseUnsignedInt(sshPort);
        }
        catch (NumberFormatException e) {
            SshConfigurationDialog.showErroToUserAndWait(e.getMessage());
            return;
        }
        if (!this.validateSSHConfigurationInput()) {
            return;
        }
        SshTargetLauncher targetDevice = SshTargetLauncher.create(sshaddress, "", "", "", sshSessionName, sshUsername, this.mBtnPass.getSelection() ? this.mSSHPassword.getText() : "", this.mBtnKey.getSelection() ? this.mSSHPrivateKey.getText() : "", sPort, gPort, sshGatorPath, false);
        if (targetDevice != null) {
            if (this.mSshTarget != null) {
                int pos = this.mDetectedDevices.indexOf((Object)this.mSshTarget);
                if (pos == -1) {
                    SshConfigurationDialog.showErroToUserAndWait("Could not modify existing target");
                    return;
                }
                this.mDetectedDevices.set(pos, (Object)targetDevice);
            } else {
                this.mDetectedDevices.add((Object)targetDevice);
            }
        }
        this.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(4).spacing(32, 2).applyTo(parent);
        this.mTestConnectionBtn = this.createButton(parent, 10, "Test connection", false);
        this.mTestConnectionBtn.setToolTipText("Test connection");
        this.mConnectionStatusLabel = SWTUtils.createLabel(parent, ": disconnected", "Connection status", 0);
        this.mTestConnectionBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SshDeviceConfiguration cfg;
                if (!SshConfigurationDialog.this.validateSSHConfigurationInput()) {
                    return;
                }
                Display ui = SshConfigurationDialog.this.mConnectionStatusLabel.getDisplay();
                Cursor cursorWait = new Cursor((Device)ui, 1);
                final Cursor oldCursor = SshConfigurationDialog.this.getShell().getCursor();
                SshConfigurationDialog.this.getShell().setCursor(cursorWait);
                SshConfigurationDialog.this.mConnectionStatusLabel.setText(": testing...");
                try {
                    cfg = SshConfigurationDialog.this.buildSshConfig();
                    if (cfg == null) {
                        SshConfigurationDialog.this.mConnectionStatusLabel.setText(": failed");
                        Log.warn((String)String.format("SSH: Failed to build SSH configuration", new Object[0]));
                        SshConfigurationDialog.this.getShell().setCursor(oldCursor);
                        return;
                    }
                }
                catch (Exception e) {
                    SshConfigurationDialog.this.mConnectionStatusLabel.setText(": failed");
                    Log.warn((String)String.format("SSH: Could not build SSH configuration %s", e.getMessage()));
                    SshConfigurationDialog.this.getShell().setCursor(oldCursor);
                    return;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String resultMessage;
                        if (BasicSshDeviceConnection.test((SshDeviceConfiguration)cfg)) {
                            resultMessage = ": connected";
                        } else {
                            Log.warn((String)String.format("SSH: Could not establish connection", new Object[0]));
                            resultMessage = ": failed";
                        }
                        (this).SshConfigurationDialog.this.mConnectionStatusLabel.setText(resultMessage);
                        SshConfigurationDialog.this.getShell().setCursor(oldCursor);
                    }
                });
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    private static TextField createTextField(Composite parent, String tooltip, String defaultValue, int style, boolean isLongFiled) {
        TextField field = new TextField(parent, style);
        field.setWatermark(defaultValue);
        field.setToolTipText(tooltip);
        FontInfo fontInfo = FontInfo.get(field.getFont());
        field.setDesiredMinimumTextWidth(fontInfo.getWidth("0") * (isLongFiled ? 48 : 16));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)field);
        return field;
    }

    private void selectPasswordOption(boolean enablePassword) {
        this.mBtnKey.setSelection(!enablePassword);
        this.mBtnPass.setSelection(enablePassword);
        this.mBtnOpenDialog.setEnabled(!enablePassword);
        this.mSSHPrivateKey.setEnabled(!enablePassword);
        this.mSSHPassword.setEnabled(enablePassword);
    }

    private static void showErroToUserAndWait(String errorMessage) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setHeaderText(errorMessage);
        alert.showAndWait();
    }
}

