/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.utility.UtilityMessages;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.databrowser.AnalysisOptionsPanel;
import com.arm.streamline.databrowser.CaptureOptionsPanel;
import com.arm.streamline.databrowser.DefaultImages;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.ISessionOwner;
import com.arm.streamline.databrowser.ImagesOptionsPanel;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.databrowser.model.ImageSearchPathsDirectoryListPanelModel;
import com.arm.streamline.databrowser.view.FileOrDirectoryListPanel;
import com.arm.streamline.model.session.PathWithEnabledFlag;
import com.arm.streamline.model.session.Session;
import com.arm.streamline.utility.SWTUtils;
import com.arm.streamline.widget.BorderedComposite;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Error;
import com.arm.utils.text.SWTLabelFilter;
import java.io.File;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.SWTResourceManager;

public class OptionsDialog
extends TitleAreaDialog
implements ISessionOwner {
    private static final String[] EXTENSIONS = new String[]{"*.xml", "*.*"};
    private static final String[] DESCRIPTIONS = new String[]{DocumentsMessages.SESSION_DESCRIPTION, UtilityMessages.ALL_FILES};
    private static final int IMPORT_ID = 1000;
    private static final int EXPORT_ID = 1001;
    private static String DEFAULT_PATH = null;
    private Composite mContent;
    private CaptureOptionsPanel mCaptureOptionsPanel;
    private AnalysisOptionsPanel mAnalysisOptionsPanel;
    private @NonNull Session mSession;
    private Button mRetrieveImagesCheckbox;
    private boolean mRetrieveImages;
    private ImagesOptionsPanel mImagesPanel = null;
    private final @NonNull DefaultImages imagesStore = new DefaultImages();
    private final @NonNull ImageSearchPathsDirectoryListPanelModel mImageSearchPathsPanelModel;

    private static String getDefaultPath() {
        if (DEFAULT_PATH == null) {
            DEFAULT_PATH = new File(System.getProperty("user.home", ".")).getAbsolutePath();
        }
        return DEFAULT_PATH;
    }

    private static void setDefaultPath(String path) {
        DEFAULT_PATH = FilePath.getParent((String)FilePath.getFullPath(null, (String)path));
    }

    public OptionsDialog(Shell shell, @NonNull Session session) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.mSession = session;
        this.mImageSearchPathsPanelModel = new ImageSearchPathsDirectoryListPanelModel(this.mSession);
    }

    @Override
    public @NonNull Session getSession() {
        return this.mSession;
    }

    @Override
    public void markDirty() {
        this.adjustAcceptance();
    }

    protected void buttonPressed(int id) {
        if (id == 1000) {
            this.importSession();
        } else if (id == 1001) {
            this.exportSession();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DocumentsMessages.OPTIONS_TITLE);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setText(DocumentsMessages.SAVE);
        this.adjustAcceptance();
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1000, DocumentsMessages.IMPORT_OPTIONS, false).setToolTipText(DocumentsMessages.IMPORT_OPTIONS_TOOLTIP);
        this.createButton(parent, 1001, DocumentsMessages.EXPORT_OPTIONS, false).setToolTipText(DocumentsMessages.EXPORT_OPTIONS_TOOLTIP);
        ++((GridLayout)parent.getLayout()).numColumns;
        GridDataFactory.swtDefaults().grab(true, false).hint(1, 1).applyTo((Control)new Composite(parent, 0));
        super.createButtonsForButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(SWTLabelFilter.filterForMenuOrLabel((String)DocumentsMessages.OPTIONS_TITLE));
        this.setMessage(DocumentsMessages.OPTIONS_MSG);
        this.mContent = new Composite((Composite)super.createDialogArea(parent), 0);
        GridLayoutFactory.swtDefaults().applyTo(this.mContent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mContent);
        this.mCaptureOptionsPanel = new CaptureOptionsPanel(this.mContent, this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mCaptureOptionsPanel);
        this.mAnalysisOptionsPanel = new AnalysisOptionsPanel(this.mContent, this.getSession(), this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mAnalysisOptionsPanel);
        BorderedComposite mImages = new BorderedComposite(this.mContent, DocumentsMessages.IMAGES);
        GridLayoutFactory.fillDefaults().spacing(2, 2).applyTo((Composite)mImages);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mImages);
        this.mRetrieveImages = StreamlinePreferences.getRetrieveImages();
        SelectionAdapter imagesSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsDialog.this.mRetrieveImages = OptionsDialog.this.mRetrieveImagesCheckbox.getSelection();
            }
        };
        this.mRetrieveImagesCheckbox = SWTUtils.createCheckbox(mImages, DocumentsMessages.RETRIEVE_IMAGES_LABEL, DocumentsMessages.RETRIEVE_IMAGES_TOOLTIP, (SelectionListener)imagesSelectionAdapter);
        ((GridData)this.mRetrieveImagesCheckbox.getLayoutData()).verticalIndent = 5;
        this.mRetrieveImagesCheckbox.setEnabled(this.isRetrieveImagesSupported());
        this.mRetrieveImagesCheckbox.setSelection(this.mRetrieveImages);
        final CTabFolder mTabsPanel = new CTabFolder((Composite)mImages, 0);
        mTabsPanel.setSelectionBackground(SWTResourceManager.getColor(22));
        mTabsPanel.setBackground(SWTResourceManager.getColor(22));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mTabsPanel);
        mTabsPanel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Color borderColor = Colors.getGray();
                e.gc.setForeground(borderColor);
                e.gc.drawLine(0, 0, 0, mTabsPanel.getBounds().height - 3);
            }
        });
        ((GridData)mTabsPanel.getLayoutData()).verticalIndent = 5;
        this.mImagesPanel = ImagesOptionsPanel.create((Composite)mTabsPanel, this.imagesStore, this.mSession, this, false);
        CTabItem mTabsPanel_TabImages = new CTabItem(mTabsPanel, 0);
        mTabsPanel_TabImages.setText(DocumentsMessages.IMAGES_TAB_HEADER);
        mTabsPanel_TabImages.setControl((Control)this.mImagesPanel);
        mTabsPanel.setSelection(mTabsPanel_TabImages);
        FileOrDirectoryListPanel mSearchPathsPanel = new FileOrDirectoryListPanel((Composite)mTabsPanel, this.mImageSearchPathsPanelModel);
        CTabItem mTabsPanel_TabSearchPaths = new CTabItem(mTabsPanel, 0);
        mTabsPanel_TabSearchPaths.setText(DocumentsMessages.IMAGE_SEARCH_PATHS);
        mTabsPanel_TabSearchPaths.setControl((Control)mSearchPathsPanel);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mContent, "com.arm.streamline.launch_options");
        return this.mContent;
    }

    private boolean isRetrieveImagesSupported() {
        TargetAddressString targetAddress = this.mSession.getTargetAddress();
        return !targetAddress.isAndroid() || !targetAddress.isDefinitelyLoopback();
    }

    protected void initializeBounds() {
        Shell shell = this.getShell();
        Point size = shell.computeSize(-1, -1);
        shell.setMinimumSize(size);
        this.mCaptureOptionsPanel.initializeContent();
        this.mAnalysisOptionsPanel.initializeContent();
        this.mImagesPanel.initializeContent();
        this.adjustAcceptance();
        shell.setSize(size);
        shell.setLocation(this.getInitialLocation(size));
        super.initializeBounds();
    }

    private void adjustAcceptance() {
        String msg = this.mCaptureOptionsPanel.checkValidity();
        if (msg == null && (msg = this.mAnalysisOptionsPanel.checkValidity()) == null) {
            msg = this.mImagesPanel.checkValidity();
        }
        boolean valid = msg == null;
        this.setErrorMessage(msg);
        this.getButton(0).setEnabled(valid);
        this.getButton(1001).setEnabled(valid);
    }

    private void exportSession() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setFilterExtensions(EXTENSIONS);
        dialog.setOverwrite(true);
        dialog.setFilterPath(OptionsDialog.getDefaultPath());
        dialog.setFileName("session.xml");
        dialog.setFilterNames(DESCRIPTIONS);
        String fileName = dialog.open();
        if (fileName != null) {
            OptionsDialog.setDefaultPath(fileName);
            try {
                this.mSession.setImageSearchPathsWithEnabledFlags(new TreeSet<PathWithEnabledFlag>(this.mImageSearchPathsPanelModel.getPathsWithEnabledFlag()));
                this.mSession.save(new File(fileName));
            }
            catch (Exception exception) {
                Error.show(exception);
            }
        }
    }

    private void importSession() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(EXTENSIONS);
        dialog.setFilterNames(DESCRIPTIONS);
        dialog.setFilterPath(OptionsDialog.getDefaultPath());
        String fileName = dialog.open();
        if (fileName != null) {
            OptionsDialog.setDefaultPath(fileName);
            try {
                Session session;
                this.mSession = session = new Session(new File(fileName), false);
                this.mImageSearchPathsPanelModel.replaceContents(session.getImageSearchPathsWithEnabledFlags());
                this.mCaptureOptionsPanel.initializeContent();
                this.mAnalysisOptionsPanel.initializeContent();
                this.adjustAcceptance();
            }
            catch (Exception exception) {
                Error.show(exception);
            }
        }
    }

    public void saveChanges() {
        this.mSession.setImageSearchPathsWithEnabledFlags(new TreeSet<PathWithEnabledFlag>(this.mImageSearchPathsPanelModel.getPathsWithEnabledFlag()));
        StreamlinePreferences.setDefaultImages(this.imagesStore.getAvailableImages());
        StreamlinePreferences.setRetrieveImages(this.mRetrieveImages);
    }
}

