/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.databrowser.DeviceABIDetector;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.deviceconn.adb.AdbSelfCleaningSession;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.lib.ISelfCleaningSession;
import com.arm.streamline.utility.AdbRunnerFactory;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class GpuTimelineLayerManager {
    private final @Nullable IAdbCommandRunner commandRunner;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAdbCommandRunner.WrapMode wrapMode = IAdbCommandRunner.WrapMode.DEFAULT;
    private @Nullable AdbSelfCleaningSession session;
    private static final @NonNull File INSTALL_DIR = CommonPlugin.getInstallDir();
    private static final @NonNull String ANDROID_BIN_DIR = "bin/android";
    private static final @NonNull String ARM64_DIR = "arm64";
    private static final @NonNull String LIB_GPUTIMELINE_LAYER_FILE = "libVkLayerGPUTimeline.so";
    private static final @NonNull String LIB_GPUTIMELINE_LAYER_ENV_VAR_ARM64 = "STREAMLINE_LIBGPULAYER_ARM64";
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ISelfCleaningSession.IRemoteExecutable remoteLibFilePath = null;
    private boolean isInstalled = false;

    private static @Nullable File getLibGpuTimelineLayerExecutablePath(@NonNull DeviceABIDetector.DeviceABI deviceABI) {
        File file = null;
        String envPath = null;
        String propPath = null;
        switch (deviceABI) {
            case ARM64: {
                file = Paths.get(INSTALL_DIR.getAbsolutePath(), ANDROID_BIN_DIR, ARM64_DIR, LIB_GPUTIMELINE_LAYER_FILE).toFile();
                envPath = System.getenv(LIB_GPUTIMELINE_LAYER_ENV_VAR_ARM64);
                propPath = System.getProperty("streamline.layer");
                break;
            }
        }
        if (envPath != null) {
            file = new File(envPath);
        }
        if (!(file != null && file.exists() || propPath == null)) {
            file = new File(propPath);
        }
        return file != null && file.exists() ? file : null;
    }

    public GpuTimelineLayerManager(@NonNull IAdbCommandRunner commandRunner, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAdbCommandRunner.WrapMode wrapMode) {
        this.commandRunner = commandRunner;
        this.wrapMode = wrapMode;
        this.session = new AdbSelfCleaningSession(commandRunner, wrapMode, StreamlinePlugin::warning);
    }

    public GpuTimelineLayerManager(@NonNull IAdbProcessRunner adbProcessRunner, @NonNull TargetAddressString targetAddressString) throws IOException {
        if (targetAddressString.isAndroid()) {
            this.commandRunner = AdbRunnerFactory.SINGLETON.create(adbProcessRunner, targetAddressString.getAndroidSerialNumber());
            this.wrapMode = IAdbCommandRunner.rootWrapModeOrDefault((AdbDeviceRootMode)this.commandRunner.detectRootMode());
            this.session = new AdbSelfCleaningSession((IAdbCommandRunner)NullChecking.neverNull((Object)this.commandRunner), this.wrapMode, StreamlinePlugin::warning);
        } else {
            this.commandRunner = null;
        }
    }

    public void pushLibGpuTimelineLayerExecutableToTarget(@NonNull DeviceABIDetector.DeviceABI deviceABI) throws IOException, ISelfCleaningSession.CommandFailedException {
        File libFile = GpuTimelineLayerManager.getLibGpuTimelineLayerExecutablePath(deviceABI);
        if (libFile != null && this.session != null) {
            this.remoteLibFilePath = this.session.pushExecutable(libFile);
            this.isInstalled = true;
        } else {
            StreamlinePlugin.warning(String.format("Failed to find suitable %s file.", LIB_GPUTIMELINE_LAYER_FILE));
        }
    }

    public @NonNull IRunnableWithProgress getInstaller(@NonNull DeviceABIDetector.DeviceABI deviceABI) {
        return monitor -> {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            subMonitor.subTask("Transferring GPU Timeline Layer to device");
            try {
                this.pushLibGpuTimelineLayerExecutableToTarget(deviceABI);
            }
            catch (ISelfCleaningSession.CommandFailedException | IOException e) {
                throw new InvocationTargetException(e);
            }
        };
    }

    public void uninstall() {
        if (this.remoteLibFilePath != null && this.commandRunner != null) {
            try {
                IBasicInteractiveShell.InteractiveCommandResult result = this.commandRunner.runCommandAndGetOutput(this.wrapMode, "rm", new String[]{"-f", this.remoteLibFilePath.getPath()});
                if (result.status.isSuccessful()) {
                    this.isInstalled = false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void tryUninstall() {
        if (this.isInstalled) {
            this.uninstall();
        }
    }
}

