/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.elfdwarf.ElfDwarfParser;
import com.arm.streamline.jni.elfdwarf.SectionRecord;
import com.arm.streamline.jni.elfdwarf.SeparateDwarfInfo;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.zip.ZipFile;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ElfImage {
    private @NonNull Availability debugFrame = Availability.UNSET;
    private @NonNull Availability debugInfo = Availability.UNSET;
    private final @NonNull File file;
    private @Nullable File separateDebugDir = null;
    private @Nullable File separateDebugFile = null;
    private @NonNull Availability symbols = Availability.UNSET;
    private @NonNull Availability dynsymbols = Availability.UNSET;
    private @NonNull Availability execSections = Availability.UNSET;

    public ElfImage(@NonNull File filePath) {
        this.file = filePath;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile zf = new ZipFile(filePath);){
                this.symbols = Availability.UNKNOWN;
                this.dynsymbols = Availability.UNKNOWN;
                this.debugFrame = Availability.UNKNOWN;
                this.debugInfo = Availability.UNKNOWN;
                this.execSections = Availability.UNKNOWN;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElfImage) {
            ElfImage that = (ElfImage)obj;
            return this.file.equals(that.file) && NullChecking.equalsNullable((Object)this.separateDebugDir, (Object)that.separateDebugDir) && NullChecking.equalsNullable((Object)this.separateDebugFile, (Object)that.separateDebugFile) && this.symbols.equals((Object)that.symbols) && this.dynsymbols.equals((Object)that.dynsymbols) && this.debugInfo.equals((Object)that.debugInfo) && this.debugFrame.equals((Object)that.debugFrame) && this.execSections.equals((Object)that.execSections);
        }
        return false;
    }

    public @NonNull Availability getDebugFrameStatus() {
        return this.debugFrame;
    }

    public @NonNull Availability getDebugInfoStatus() {
        return this.debugInfo;
    }

    public @NonNull File getFile() {
        return this.file;
    }

    public @NonNull String getName() {
        return (String)NullChecking.neverNull((Object)this.file.getName());
    }

    public @Nullable File getSeparateDebugDir() {
        return this.separateDebugDir;
    }

    public @Nullable File getSeparateDebugFile() {
        return this.separateDebugFile;
    }

    public @NonNull Availability getSymbolsStatus() {
        return this.symbols;
    }

    public @NonNull Availability getDynSymbolsStatus() {
        return this.dynsymbols;
    }

    public @NonNull Availability getExecSectionStatus() {
        return this.execSections;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public void processFile() throws CodecException, IOException {
        SectionRecord[] sections;
        if (this.symbols == Availability.UNKNOWN) {
            return;
        }
        this.debugFrame = Availability.NOT_AVAILABLE;
        this.debugInfo = Availability.NOT_AVAILABLE;
        this.symbols = Availability.NOT_AVAILABLE;
        this.dynsymbols = Availability.NOT_AVAILABLE;
        this.execSections = Availability.NOT_AVAILABLE;
        if (!this.file.exists() || !this.file.isFile() || this.file.length() == 0L) {
            return;
        }
        SectionRecord[] sectionRecordArray = sections = ElfDwarfParser.getSections((File)this.file, (boolean)false);
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull SectionRecord section = sectionRecordArray[n2];
            switch (section.getName()) {
                case ".symtab": {
                    this.symbols = Availability.AVAILABLE;
                    break;
                }
                case ".dynsym": {
                    this.dynsymbols = Availability.AVAILABLE;
                    break;
                }
                case ".eh_frame": 
                case ".debug_frame": {
                    this.debugFrame = Availability.AVAILABLE;
                    break;
                }
                case ".debug_info": {
                    this.debugInfo = Availability.AVAILABLE;
                    break;
                }
                case ".gnu_debuglink": {
                    this.debugInfo = Availability.SEPARATE_FILE_REQUIRED;
                    this.debugFrame = Availability.SEPARATE_FILE_REQUIRED;
                    this.symbols = Availability.SEPARATE_FILE_REQUIRED;
                    @NonNull SeparateDwarfInfo separateDwarfInfo = ElfDwarfParser.getSeparatedDwarfInfo((File)this.file);
                    @NonNull String fileName = (String)NullChecking.neverNull((Object)separateDwarfInfo.getGnuDebugLinkInfo());
                    this.separateDebugFile = new File(this.separateDebugDir, fileName);
                    if (this.separateDebugFile.exists()) {
                        this.processDebugFile(this.separateDebugFile);
                        break;
                    }
                    @NonNull File altSeparateDebugFile = new File(this.separateDebugDir, this.getName());
                    if (!altSeparateDebugFile.exists()) break;
                    this.processDebugFile(altSeparateDebugFile);
                    break;
                }
                default: {
                    if (!section.isExec() || !section.isProgbits()) break;
                    this.execSections = Availability.AVAILABLE;
                }
            }
            ++n2;
        }
        if (this.execSections == Availability.NOT_AVAILABLE) {
            CommonPlugin.warning((String)MessageFormat.format(DocumentsMessages.IMAGES_NO_EXEC_SECTION_WARNING, this.getName()));
        }
    }

    private void processDebugFile(File debugFile) throws CodecException, IOException {
        SectionRecord[] separateSections;
        this.debugInfo = Availability.NOT_AVAILABLE;
        this.debugFrame = Availability.NOT_AVAILABLE;
        this.symbols = Availability.NOT_AVAILABLE;
        SectionRecord[] sectionRecordArray = separateSections = ElfDwarfParser.getSections((File)((File)NullChecking.neverNull((Object)debugFile)), (boolean)false);
        int n = separateSections.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull SectionRecord separateSection = sectionRecordArray[n2];
            switch (separateSection.getName()) {
                case ".eh_frame": 
                case ".debug_frame": {
                    this.debugFrame = Availability.AVAILABLE;
                    break;
                }
                case ".debug_info": {
                    this.debugInfo = Availability.AVAILABLE;
                    break;
                }
                case ".symtab": {
                    this.symbols = Availability.AVAILABLE;
                    break;
                }
            }
            ++n2;
        }
    }

    public void setSeparateDebugDir(File separateDebugDir) {
        this.separateDebugDir = separateDebugDir;
    }

    public String toString() {
        return String.format("ElfImage [file=%s, separateDebugDir=%s, separateDebugFile=%s, symbols=%s, dynsymbols=%s, debugInfo=%s, debugFrame=%s, execSections=%s]", new Object[]{this.file, this.separateDebugDir, this.separateDebugFile, this.symbols, this.debugInfo, this.debugFrame, this.execSections});
    }

    public static enum Availability {
        AVAILABLE,
        BROKEN,
        NOT_AVAILABLE,
        SEPARATE_FILE_REQUIRED,
        UNKNOWN,
        UNSET;

    }
}

