/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.preferences.AndroidDevicePreference;
import com.arm.streamline.common.preferences.CommonPreferences;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.PathChoice;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.counterconfig.CountersDialog;
import com.arm.streamline.databrowser.AndroidDeviceException;
import com.arm.streamline.databrowser.AndroidDeviceGatordManager;
import com.arm.streamline.databrowser.CaptureControlView;
import com.arm.streamline.databrowser.CaptureStateProxy;
import com.arm.streamline.databrowser.ConfigureTargetHandler;
import com.arm.streamline.databrowser.DeviceABIDetector;
import com.arm.streamline.databrowser.GpuTimelineLayerManager;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.databrowser.IConfigurer;
import com.arm.streamline.databrowser.IDeviceConnectionModel;
import com.arm.streamline.databrowser.IGatordInstallUninstall;
import com.arm.streamline.databrowser.ILiveCapture;
import com.arm.streamline.databrowser.NullConfigurer;
import com.arm.streamline.databrowser.OptionsDialog;
import com.arm.streamline.databrowser.SshConfigurationDialog;
import com.arm.streamline.databrowser.SshGatordManager;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.databrowser.TargetLauncher;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.ssh.ISshCommandRunner;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.live.LiveEditor;
import com.arm.streamline.model.live.CaptureInput;
import com.arm.streamline.model.live.LiveCaptureDataProvider;
import com.arm.streamline.model.session.ExcludeKernel;
import com.arm.streamline.model.session.GpuTimelineLayerDriver;
import com.arm.streamline.model.session.Session;
import com.arm.streamline.ui.vm.IAndroidPackage;
import com.arm.streamline.ui.vm.IAndroidTargetDevice;
import com.arm.streamline.ui.vm.IAndroidTargetLauncher;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.ui.vm.ITargetLauncher;
import com.arm.streamline.ui.vm.ITcpTargetLauncher;
import com.arm.streamline.utility.AdbRunnerFactory;
import com.arm.streamline.utility.IAdbRunnerFactory;
import com.arm.streamline.utility.ISshRunnerFactory;
import com.arm.streamline.utility.SshRunnerFactory;
import com.arm.streamline.widget.Error;
import com.arm.streamline.widget.WidgetUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.function.Throwing;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class DeviceConnectionModel
implements IDeviceConnectionModel,
ICaptureProxy {
    private static final @NonNull Runnable EMPTY_RUNNABLE = () -> {};
    private static final @NonNull DeviceConnectionModel INSTANCE = new DeviceConnectionModel(StreamlinePreferences.getApplicationPreferences(), AdbRunnerFactory.SINGLETON, SshRunnerFactory.SINGLETON);
    private final @NonNull AtomicReference<@NonNull Runnable> cleanUpTask = new AtomicReference<Runnable>(EMPTY_RUNNABLE);
    private final @NonNull SimpleObjectProperty<@Nullable TargetAddressString> activeCaptureAddress = new SimpleObjectProperty(null);
    private final @NonNull IPreferences appSettings;
    private final @NonNull CaptureStateProxy capStateProxies = new CaptureStateProxy();
    private final @NonNull IAdbRunnerFactory adbRunnerFactory;
    private final @NonNull ISshRunnerFactory sshRunnerFactory;
    private List<@NonNull String> argHistory;
    private @NonNull Runnable refreshCallback = EMPTY_RUNNABLE;

    public static @NonNull IDeviceConnectionModel get() {
        return INSTANCE;
    }

    private static @Nullable Shell getShell() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return null;
        }
        IWorkbenchWindow aww = wb.getActiveWorkbenchWindow();
        if (aww == null) {
            return null;
        }
        return aww.getShell();
    }

    private DeviceConnectionModel(@NonNull IPreferences appSettings, @NonNull IAdbRunnerFactory adbRunnerFactory, @NonNull ISshRunnerFactory sshRunnerFactory) {
        this.appSettings = appSettings;
        this.adbRunnerFactory = adbRunnerFactory;
        this.sshRunnerFactory = sshRunnerFactory;
        this.capStateProxies.addCaptureStateListener(this);
    }

    @Override
    public @NonNull ObservableBooleanValue hasActiveConnectionProperty() {
        return this.activeCaptureAddress.isNotNull();
    }

    @Override
    public void addCaptureStateProxy(@NonNull ICaptureProxy captureProxy) {
        this.capStateProxies.addCaptureStateListener(captureProxy);
    }

    @Override
    public void captureError(String msg) {
        this.clearActiveCapture();
    }

    @Override
    public void captureError(@NonNull Throwable t) {
        this.clearActiveCapture();
    }

    @Override
    public void captureFinished(boolean isDiscarded) {
        this.clearActiveCapture();
    }

    @Override
    public void captureStarted(@NonNull ILiveCapture doc, @Nullable LiveCaptureDataProvider live, @NonNull IPreferences settings, boolean discard) {
        if (live != null) {
            TargetAddressString targetAddress = live.getCaptureSettings().getTargetAddress();
            this.setActiveCapture(targetAddress);
        }
    }

    @Override
    public void captureStopped(@NonNull ILiveCapture doc, boolean discard) {
    }

    @Override
    public void liveError(String msg) {
    }

    @Override
    public void liveWarning(@NonNull WarningItem msg) {
    }

    @Override
    public void removeCaptureStateProxy(@NonNull ICaptureProxy captureProxy) {
        this.capStateProxies.removeCaptureStateListener(captureProxy);
    }

    @Override
    public void showAdvancedSettings() {
        if (!WidgetUtils.isModalDialogShowing()) {
            Session defaultSessionForAdvancedSettings = StreamlinePreferences.getSessionObject();
            OptionsDialog dialog = new OptionsDialog(DeviceConnectionModel.getShell(), new Session(defaultSessionForAdvancedSettings));
            if (dialog.open() != 1) {
                dialog.saveChanges();
                defaultSessionForAdvancedSettings.copyFrom(dialog.getSession());
                StreamlinePreferences.setSession(defaultSessionForAdvancedSettings.toString());
            }
        }
    }

    @Override
    public boolean isAdvancedConfigModePreferred() {
        return CommonPreferences.isAdvancedConfigModePreferred();
    }

    @Override
    public void setAdvancedConfigModePreference(boolean useAdvanced) {
        CommonPreferences.setAdvancedConfigModePreference((boolean)useAdvanced);
    }

    @Override
    public void showCounterConfiguration(@NonNull ITargetLauncher activeTarget) {
        if (!WidgetUtils.isModalDialogShowing()) {
            activeTarget.accept(new ITargetLauncher.IVisitor(){

                public void visitAndroidTargetLauncher(@NonNull IAndroidTargetLauncher targetLauncher) {
                    DeviceConnectionModel.this.androidCounterConfiguration(targetLauncher);
                }

                public void visitTcpTargetLauncher(@NonNull ITcpTargetLauncher targetLauncher) {
                    DeviceConnectionModel.this.tcpCounterConfiguration(targetLauncher);
                }

                public void visitSshTargetLauncher(@NonNull ISshTargetLauncher targetLauncher) {
                    DeviceConnectionModel.this.sshCounterConfiguration(targetLauncher);
                }
            });
        }
    }

    private void androidCounterConfiguration(@NonNull IAndroidTargetLauncher targetLauncher) {
        try {
            this.prepareAdbCommandThen(targetLauncher, (target, cmdRunner) -> {
                IGatordInstallUninstall installUninstall;
                TargetAddressString targetAddress = new TargetAddressString(target.getTargetAddress());
                this.setActiveCapture(targetAddress);
                this.cleanUpTask.set(EMPTY_RUNNABLE);
                IAdbCommandRunner.WrapMode wrapmode = IAdbCommandRunner.rootWrapModeOrDefault((AdbDeviceRootMode)target.getDeviceRootMode());
                try {
                    installUninstall = DeviceConnectionModel.prepareAndroidCopyGatorTask(target.getDebuggablePackage().getPackageName(), null, null, cmdRunner, GpuTimelineLayerDriver.DISABLE, false, wrapmode, new NullConfigurer());
                }
                catch (AndroidDeviceException | IOException e) {
                    Error.show(e);
                    return;
                }
                this.cleanUpTask.set(() -> DeviceConnectionModel.cleanUpAfterCapture(installUninstall, new Closeable[0]));
                if (DeviceConnectionModel.installThenStartGator(installUninstall.getInstaller())) {
                    CountersDialog.configureCounters(DeviceConnectionModel.getShell(), targetAddress);
                }
            });
        }
        finally {
            this.clearActiveCapture();
        }
    }

    private void tcpCounterConfiguration(@NonNull ITcpTargetLauncher activeTarget) {
        try {
            TargetAddressString targetAddress = new TargetAddressString(activeTarget.getTargetAddress());
            this.setActiveCapture(targetAddress);
            this.cleanUpTask.set(EMPTY_RUNNABLE);
            CountersDialog.configureCounters(DeviceConnectionModel.getShell(), targetAddress);
        }
        finally {
            this.clearActiveCapture();
        }
    }

    private void sshCounterConfiguration(@NonNull ISshTargetLauncher targetLauncher) {
        try {
            this.prepareSshCommandThen(targetLauncher, (target, cmdRunner) -> {
                int localPort;
                int portSpecified = targetLauncher.getGatorPort();
                int portToUse = portSpecified > 0 ? portSpecified : 8080;
                try {
                    localPort = cmdRunner.forwardLocalPort(0, portToUse);
                }
                catch (IOException e) {
                    StreamlinePlugin.warning("Failed to setup port forwarding for SSH connection", e);
                    return;
                }
                TargetAddressString targetAddress = new TargetAddressString("tcp:127.0.0.1:" + localPort);
                targetAddress.setLabel(targetLauncher.getTargetAddress());
                this.setActiveCapture(targetAddress);
                this.cleanUpTask.set(EMPTY_RUNNABLE);
                IGatordInstallUninstall installUninstall = DeviceConnectionModel.prepareSshCopyGatorTask(cmdRunner, GpuTimelineLayerDriver.DISABLE, portToUse);
                this.cleanUpTask.set(() -> DeviceConnectionModel.cleanUpAfterCapture(installUninstall, new Closeable[]{cmdRunner}));
                if (DeviceConnectionModel.installThenStartGator(installUninstall.getInstaller())) {
                    CountersDialog.configureCounters(DeviceConnectionModel.getShell(), targetAddress);
                }
            });
        }
        finally {
            this.clearActiveCapture();
        }
    }

    @Override
    public void showStartCapture(@NonNull ITargetLauncher activeTarget) {
        if (!WidgetUtils.isModalDialogShowing()) {
            activeTarget.accept(new ITargetLauncher.IVisitor(){

                public void visitTcpTargetLauncher(@NonNull ITcpTargetLauncher tcpTargetLauncher) {
                    TargetLauncher targetLauncher = DeviceConnectionModel.this.doStartTcpCapture(tcpTargetLauncher);
                    if (targetLauncher == null) {
                        DeviceConnectionModel.this.clearActiveCapture();
                    }
                }

                public void visitAndroidTargetLauncher(@NonNull IAndroidTargetLauncher activeTarget) {
                    AtomicReference<@Nullable Object> wrapper = new AtomicReference<Object>(null);
                    DeviceConnectionModel.this.prepareAdbCommandThen(activeTarget, (target, cmdRunner) -> wrapper.set(DeviceConnectionModel.this.androidCaptureWithAdb((IAndroidTargetLauncher)target, (IAdbCommandRunner)cmdRunner, IAdbCommandRunner.rootWrapModeOrDefault((AdbDeviceRootMode)activeTarget.getDeviceRootMode()))));
                    if (wrapper.get() == null) {
                        DeviceConnectionModel.this.clearActiveCapture();
                    }
                }

                public void visitSshTargetLauncher(@NonNull ISshTargetLauncher sshTargetLauncher) {
                    if (!DeviceConnectionModel.this.doStartSshCapture(sshTargetLauncher)) {
                        DeviceConnectionModel.this.clearActiveCapture();
                    }
                }
            });
        }
    }

    private @Nullable IAdbCommandRunner getAdbCommand(@NonNull String deviceSerialNumber) {
        IAdbCommandRunner adbCommandRunner;
        File maybeAdb = StreamlinePreferences.getApplicationPreferences().getAdbPathOrDefault();
        if (maybeAdb == null) {
            Error.show("adb path is not configured");
            return null;
        }
        try {
            adbCommandRunner = this.adbRunnerFactory.create(this.adbRunnerFactory.create(maybeAdb), deviceSerialNumber);
        }
        catch (IOException ex) {
            Error.show(ex);
            return null;
        }
        return adbCommandRunner;
    }

    private @Nullable ISshCommandRunner getSshCommand(@NonNull ISshTargetLauncher sshTargetLauncher) {
        try {
            ISshCommandRunner sshCommandRunner = this.sshRunnerFactory.create(sshTargetLauncher);
            return sshCommandRunner;
        }
        catch (IOException ex) {
            Error.show(ex);
            return null;
        }
    }

    private void prepareAdbCommandThen(@NonNull IAndroidTargetLauncher targetLauncher, @NonNull BiConsumer<@NonNull IAndroidTargetLauncher, @NonNull IAdbCommandRunner> next) {
        IAdbCommandRunner adbCommandRunner = this.getAdbCommand(targetLauncher.getDeviceSerialNumber());
        if (adbCommandRunner != null) {
            next.accept(targetLauncher, adbCommandRunner);
        }
    }

    private void prepareSshCommandThen(@NonNull ISshTargetLauncher targetLauncher, @NonNull BiConsumer<@NonNull ISshTargetLauncher, @NonNull ISshCommandRunner> next) {
        ISshCommandRunner sshCommandRunner = this.getSshCommand(targetLauncher);
        if (sshCommandRunner != null) {
            next.accept(targetLauncher, sshCommandRunner);
        }
    }

    private static @NonNull IGatordInstallUninstall prepareAndroidCopyGatorTask(@NonNull String packageName, @Nullable String activityName, @Nullable String activityArguments, @NonNull IAdbCommandRunner adbCommandRunner, @NonNull GpuTimelineLayerDriver gpuTimelineLayerDriverStatus, boolean captureLog, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAdbCommandRunner.WrapMode wrapMode, @NonNull IConfigurer configurer) throws IOException, AndroidDeviceException {
        AndroidDeviceGatordManager gatorManager = new AndroidDeviceGatordManager(adbCommandRunner, wrapMode, gpuTimelineLayerDriverStatus);
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(List.of("--android-pkg", packageName, "-p", "uds"));
        if (activityName != null) {
            args.add("--android-activity");
            args.add(activityName);
        }
        if (activityArguments != null && !activityArguments.isBlank()) {
            args.add("--activity-args");
            args.add(activityArguments);
        }
        if (captureLog) {
            args.add("--capture-log");
        }
        return gatorManager.getGatordInstallUninstall(configurer, (String[])args.toArray(String[]::new));
    }

    private static @NonNull IGatordInstallUninstall prepareSshCopyGatorTask(@NonNull ISshCommandRunner sshCommandRunner, @NonNull GpuTimelineLayerDriver gpuTimelineLayerDriverStatus, int port) {
        SshGatordManager gatorManager = new SshGatordManager(sshCommandRunner, gpuTimelineLayerDriverStatus);
        return gatorManager.getGatordInstallUninstall(new NullConfigurer(), "-p", Integer.toString(port), "-a");
    }

    private TargetLauncher androidCaptureWithAdb(IAndroidTargetLauncher activeAndroidTarget, @NonNull IAdbCommandRunner adbCommandRunner, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAdbCommandRunner.WrapMode wrapMode) {
        IGatordInstallUninstall installUninstall;
        String path;
        Session defaultSessionForAdvancedSettings = StreamlinePreferences.getSessionObject();
        TargetAddressString targetAddress = new TargetAddressString(activeAndroidTarget.getTargetAddress());
        Session session = CommonPreferences.isAdvancedConfigModePreferred() ? new Session(defaultSessionForAdvancedSettings) : DeviceConnectionModel.createSessionForBasicMode(targetAddress);
        session.setTargetAddress(targetAddress);
        session.setStopGator(true);
        if (!session.getTargetAddress().isValid()) {
            return null;
        }
        this.setActiveCapture(targetAddress);
        CaptureControlView.makeVisible();
        if (session.isDiscardEnabled()) {
            File parent = new File(CommonPreferences.getLastSavePath());
            path = new File(parent, CommonPreferences.chooseUniqueName((File)parent, (String)(CommonPreferences.getLastCaptureName() + ".apc"))).getAbsolutePath();
        } else {
            path = PathChoice.chooseCaptureSavePath();
        }
        if (path == null) {
            return null;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IAndroidPackage pkg = activeAndroidTarget.getDebuggablePackage();
            @NonNull IConfigurer configurer = !CommonPreferences.isAdvancedConfigModePreferred() ? new ConfigureTargetHandler(targetAddress) : new NullConfigurer();
            String selectedActivityName = pkg.shouldOverrideActivityName() ? pkg.getOverrideActivityName() : pkg.getActivityName();
            installUninstall = DeviceConnectionModel.prepareAndroidCopyGatorTask(pkg.getPackageName(), selectedActivityName, pkg.getActivityArguments(), adbCommandRunner, session.getGpuTimelineLayerDriver(), session.isCaptureLogFileEnabled(), wrapMode, configurer);
        }
        catch (AndroidDeviceException | IOException e) {
            Error.show(e);
            return null;
        }
        this.cleanUpTask.set(() -> DeviceConnectionModel.cleanUpAfterCapture(installUninstall, new Closeable[0]));
        if (DeviceConnectionModel.installThenStartGator(installUninstall.getInstaller())) {
            Runnable onActivityStartedCallback = () -> {
                this.saveApplicationArgumentsHistory();
                this.refreshCallback.run();
            };
            TargetLauncher returnVal = this.connectToGatorThenCapture(session, path, page, onActivityStartedCallback);
            return returnVal;
        }
        return null;
    }

    private static @NonNull Session createSessionForBasicMode(@NonNull TargetAddressString targetAddress) {
        @NonNull Session session = new Session();
        session.setResolutionMode(DeviceConnectionModel.getResolutionMode(targetAddress.getAndroidSerialNumber()));
        session.setGpuTimelineLayerDriver(AndroidDevicePreference.isProfileWithMaliCountersAddedForDevice((String)targetAddress.getAndroidSerialNumber()) ? GpuTimelineLayerDriver.AUTO : GpuTimelineLayerDriver.DISABLE);
        session.setExcludeKernelEvents(ExcludeKernel.AUTO);
        Session defaultSession = StreamlinePreferences.getSessionObject();
        session.setImageSearchEnabled(true);
        session.setImageSearchPathsWithEnabledFlags(defaultSession.getImageSearchPathsWithEnabledFlags());
        return session;
    }

    private static boolean installThenStartGator(IRunnableWithProgress installer) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(installer);
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
        catch (InvocationTargetException ex) {
            Error.show(ex.getCause());
            return false;
        }
    }

    private static void installGpuTimelineLayer(IRunnableWithProgress installer) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(installer);
        }
        catch (InterruptedException | InvocationTargetException ex) {
            Error.show(ex.getCause());
        }
    }

    private @Nullable TargetLauncher connectToGatorThenCapture(@NonNull Session session, @NonNull String captureSavePath, IWorkbenchPage page, @NonNull Runnable callback) {
        try {
            @NonNull TargetLauncher currentCapture = new TargetLauncher(session, captureSavePath, this.appSettings, callback);
            IEditorPart editor = (IEditorPart)NullChecking.neverNull((Object)page.openEditor((IEditorInput)new CaptureInput(currentCapture), "com.arm.streamline.live"));
            if (editor instanceof LiveEditor) {
                Task.callOnAnotherThread((Runnable)currentCapture.getRunnableWith(this.capStateProxies));
                return currentCapture;
            }
        }
        catch (Exception exception) {
            this.capStateProxies.captureError(exception);
            Error.show(exception);
        }
        return null;
    }

    @Override
    public void stopLiveRequestSend() {
    }

    private void clearActiveCapture() {
        this.runCleanUpTask();
        this.activeCaptureAddress.set(null);
    }

    private void runCleanUpTask() {
        Runnable runnable = this.cleanUpTask.getAndSet(EMPTY_RUNNABLE);
        runnable.run();
    }

    private @Nullable TargetLauncher doStartTcpCapture(@NonNull ITcpTargetLauncher activeTcpTarget) {
        String path;
        Session defaultSessionForAdvancedSettings = StreamlinePreferences.getSessionObject();
        TargetAddressString targetAddress = new TargetAddressString(activeTcpTarget.getTargetAddress());
        Session session = new Session(defaultSessionForAdvancedSettings);
        session.setTargetAddress(targetAddress);
        session.setCaptureCommand(activeTcpTarget.getCommandPath());
        session.setCaptureWorkingDir(activeTcpTarget.getCommandWorkingDir());
        session.setCaptureUser(activeTcpTarget.getCommandUsername());
        session.setStopGator(activeTcpTarget.isCommandStopOnExit());
        if (!session.getTargetAddress().isValid()) {
            return null;
        }
        this.setActiveCapture(targetAddress);
        this.cleanUpTask.set(EMPTY_RUNNABLE);
        CaptureControlView.makeVisible();
        if (session.isDiscardEnabled()) {
            File parent = new File(CommonPreferences.getLastSavePath());
            path = new File(parent, CommonPreferences.chooseUniqueName((File)parent, (String)(CommonPreferences.getLastCaptureName() + ".apc"))).getAbsolutePath();
        } else {
            path = PathChoice.chooseCaptureSavePath();
        }
        if (path == null) {
            return null;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (targetAddress.isAndroid() && session.getGpuTimelineLayerDriver().equals((Object)GpuTimelineLayerDriver.FORCE)) {
            try {
                IAdbCommandRunner adbCommandRunner = this.getAdbCommand(targetAddress.getAndroidSerialNumber());
                if (adbCommandRunner != null) {
                    AdbDeviceRootMode rootMode = IAdbCommandRunner.detectRootMode((IAdbCommandRunner)adbCommandRunner);
                    IAdbCommandRunner.WrapMode wrapMode = IAdbCommandRunner.rootWrapModeOrDefault((AdbDeviceRootMode)rootMode);
                    DeviceABIDetector.DeviceABI deviceABI = DeviceABIDetector.getAndroidDeviceABI(adbCommandRunner);
                    GpuTimelineLayerManager gpuTimelineLayerManager = new GpuTimelineLayerManager(adbCommandRunner, wrapMode);
                    this.cleanUpTask.set(() -> gpuTimelineLayerManager.tryUninstall());
                    DeviceConnectionModel.installGpuTimelineLayer(gpuTimelineLayerManager.getInstaller(deviceABI));
                }
            }
            catch (AndroidDeviceException | IOException exception) {
                Error.show(exception);
            }
        }
        return this.connectToGatorThenCapture(session, path, page, EMPTY_RUNNABLE);
    }

    private boolean doStartSshCapture(@NonNull ISshTargetLauncher activeSshTarget) {
        AtomicBoolean isSuccessful = new AtomicBoolean(false);
        this.prepareSshCommandThen(activeSshTarget, (target, cmdRunner) -> {
            String path;
            int localPort;
            int portSpecified = activeSshTarget.getGatorPort();
            int portToUse = portSpecified > 0 ? portSpecified : 8080;
            try {
                localPort = cmdRunner.forwardLocalPort(0, portToUse);
            }
            catch (IOException e) {
                StreamlinePlugin.warning("Failed to setup port forwarding for SSH connection", e);
                isSuccessful.set(false);
                return;
            }
            TargetAddressString targetAddress = new TargetAddressString("tcp:127.0.0.1:" + localPort);
            targetAddress.setLabel(activeSshTarget.getTargetAddress());
            Session defaultSessionForAdvancedSettings = StreamlinePreferences.getSessionObject();
            Session session = new Session(defaultSessionForAdvancedSettings);
            session.setTargetAddress(targetAddress);
            session.setCaptureCommand(activeSshTarget.getCommandPath());
            session.setCaptureWorkingDir(activeSshTarget.getCommandWorkingDir());
            session.setCaptureUser(activeSshTarget.getCommandUsername());
            session.setStopGator(activeSshTarget.isCommandStopOnExit());
            if (!session.getTargetAddress().isValid()) {
                isSuccessful.set(false);
                return;
            }
            this.setActiveCapture(targetAddress);
            this.cleanUpTask.set(EMPTY_RUNNABLE);
            CaptureControlView.makeVisible();
            if (session.isDiscardEnabled()) {
                File parent = new File(CommonPreferences.getLastSavePath());
                path = new File(parent, CommonPreferences.chooseUniqueName((File)parent, (String)(CommonPreferences.getLastCaptureName() + ".apc"))).getAbsolutePath();
            } else {
                path = PathChoice.chooseCaptureSavePath();
            }
            if (path == null) {
                isSuccessful.set(false);
                return;
            }
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IGatordInstallUninstall installUninstall = DeviceConnectionModel.prepareSshCopyGatorTask(cmdRunner, GpuTimelineLayerDriver.DISABLE, portToUse);
            this.cleanUpTask.set(() -> DeviceConnectionModel.cleanUpAfterCapture(installUninstall, new Closeable[]{cmdRunner}));
            if (DeviceConnectionModel.installThenStartGator(installUninstall.getInstaller())) {
                isSuccessful.set(this.connectToGatorThenCapture(session, path, page, EMPTY_RUNNABLE) != null);
            }
        });
        return isSuccessful.get();
    }

    private void setActiveCapture(@NonNull TargetAddressString targetAddress) {
        this.activeCaptureAddress.set((Object)targetAddress);
    }

    private static void cleanUpAfterCapture(final @NonNull IGatordInstallUninstall installUninstallTask, final Closeable ... cs) {
        Job uninstallJob = new Job("Remove gatord from device"){

            protected IStatus run(@NonNull IProgressMonitor monitor) {
                try {
                    installUninstallTask.getUninstaller().run(monitor);
                    Throwing.closeAll((Closeable[])cs);
                }
                catch (IOException e) {
                    Error.show(e);
                    return Status.CANCEL_STATUS;
                }
                catch (InterruptedException ex) {
                    return Status.CANCEL_STATUS;
                }
                catch (InvocationTargetException e) {
                    Error.show(e.getCause());
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        uninstallJob.schedule();
    }

    @Override
    public void setProfileWithMaliCounters(@NonNull IAndroidTargetDevice selectedDevice, boolean checkedState) {
        AndroidDevicePreference.setProfileWithMaliCounters((String)selectedDevice.getSerialNumber(), (boolean)checkedState);
    }

    @Override
    public boolean getProfileWithMaliCounters(@NonNull IAndroidTargetDevice selectedDevice) {
        return AndroidDevicePreference.getProfileWithMaliCounters((String)selectedDevice.getSerialNumber());
    }

    @Override
    public boolean isProfileWithMaliCountersAddedForDevice(@NonNull IAndroidTargetDevice selectedDevice) {
        return AndroidDevicePreference.isProfileWithMaliCountersAddedForDevice((String)selectedDevice.getSerialNumber());
    }

    @Override
    public void setResolutionMode(@NonNull IAndroidTargetDevice selectedDevice, @NonNull ResolutionMode resolutionMode) {
        AndroidDevicePreference.setResolutionMode((String)selectedDevice.getSerialNumber(), (String)resolutionMode.getStringValue());
    }

    @Override
    public @NonNull ResolutionMode getResolutionMode(@NonNull IAndroidTargetDevice selectedDevice) {
        return DeviceConnectionModel.getResolutionMode(selectedDevice.getSerialNumber());
    }

    private static @NonNull ResolutionMode getResolutionMode(@NonNull String androidSerialNumber) {
        ResolutionMode resolutionMode;
        try {
            String resolutionModePersisted = AndroidDevicePreference.getResolutionMode((String)androidSerialNumber);
            resolutionMode = resolutionModePersisted.trim().isEmpty() ? ResolutionMode.NORMAL : ResolutionMode.fromStringValue((String)resolutionModePersisted);
        }
        catch (IllegalArgumentException e) {
            resolutionMode = ResolutionMode.NORMAL;
            AndroidDevicePreference.setResolutionMode((String)androidSerialNumber, (String)resolutionMode.getStringValue());
        }
        return resolutionMode;
    }

    @Override
    public void setApplicationArgumentsHistory(@NonNull List<@NonNull String> history) {
        this.argHistory = history;
    }

    @Override
    public void setApplicationArgumentsHistoryRefreshCallback(@NonNull Runnable refreshCallback) {
        this.refreshCallback = refreshCallback;
    }

    private void saveApplicationArgumentsHistory() {
        if (this.argHistory != null) {
            CommonPreferences.setApplicationArgumentsHistory(this.argHistory);
        }
    }

    @Override
    public @NonNull List<@NonNull String> getApplicationArgumentsHistory() {
        return CommonPreferences.getApplicationArgumentsHistory();
    }

    @Override
    public void showSSHConfiguration(ObservableList<@NonNull ISshTargetLauncher> detectedDevices, ISshTargetLauncher sshTarget) {
        SshConfigurationDialog dialog = new SshConfigurationDialog(DeviceConnectionModel.getShell(), detectedDevices, sshTarget);
        dialog.open();
    }
}

