/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.analysis.IDirtyFlag;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.databrowser.AnalysisOptionsPanel;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.IElfImageStore;
import com.arm.streamline.databrowser.ImagesOptionsPanel;
import com.arm.streamline.databrowser.model.ImageSearchPathsDirectoryListPanelModel;
import com.arm.streamline.databrowser.model.JitDumpsPathsFileOrDirectoryListPanelModel;
import com.arm.streamline.databrowser.view.FileOrDirectoryListPanel;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.SWTResourceManager;

public class AnalyzeDialog
extends TitleAreaDialog
implements IDirtyFlag {
    private Composite mContent;
    private AnalysisOptionsPanel mProfilingPanel;
    private ImagesOptionsPanel mImagesPanel;
    private final @NonNull IAnalysisInputSettings mSettings;
    private String mTitle;
    private final @NonNull IElfImageStore mImageStore;
    private final @NonNull JitDumpsPathsFileOrDirectoryListPanelModel mJitDumpsPathsPanelModel;
    private final @NonNull ImageSearchPathsDirectoryListPanelModel mImageSearchPathsPanelModel;
    private final boolean showJitDumpsPanel;
    private final boolean showImageSearchPathsPanel;

    public AnalyzeDialog(@NonNull IElfImageStore imageStore, @NonNull IAnalysisInputSettings settings, @NonNull JitDumpsPathsFileOrDirectoryListPanelModel jitDumpsPathsPanelModel, @NonNull ImageSearchPathsDirectoryListPanelModel imageSearchPathsPanelModel, @NonNull String title, boolean captureIsPerfProtocol) {
        super(WorkspaceUtils.getShell());
        this.setShellStyle(0x10 | this.getShellStyle());
        this.mJitDumpsPathsPanelModel = jitDumpsPathsPanelModel;
        this.mImageSearchPathsPanelModel = imageSearchPathsPanelModel;
        this.mSettings = settings;
        this.mTitle = title;
        this.mImageStore = imageStore;
        this.showJitDumpsPanel = this.mSettings.isJitDumpProfilingSupported() && captureIsPerfProtocol;
        this.showImageSearchPathsPanel = this.mSettings.isImageSearchingSupported();
        this.mSettings.setImageSearchEnabled(false);
    }

    @Override
    public void markDirty() {
        this.adjustAcceptance();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.mTitle);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setText(DocumentsMessages.ANALYZE);
        this.adjustAcceptance();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(DocumentsMessages.ANALYZE);
        this.setMessage(DocumentsMessages.MESSAGE);
        this.mContent = new Composite((Composite)super.createDialogArea(parent), 0);
        GridLayoutFactory.swtDefaults().applyTo(this.mContent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mContent);
        this.mProfilingPanel = new AnalysisOptionsPanel(this.mContent, this.mSettings, this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mProfilingPanel);
        if (this.showJitDumpsPanel || this.showImageSearchPathsPanel) {
            CTabFolder mTabsPanel = new CTabFolder(this.mContent, 2048);
            mTabsPanel.setSelectionBackground(SWTResourceManager.getColor(22));
            mTabsPanel.setBackground(SWTResourceManager.getColor(22));
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mTabsPanel);
            this.mImagesPanel = ImagesOptionsPanel.create((Composite)mTabsPanel, this.mImageStore, this.mSettings, this, false);
            CTabItem mTabsPanel_TabImages = new CTabItem(mTabsPanel, 0);
            mTabsPanel_TabImages.setText(DocumentsMessages.IMAGES);
            mTabsPanel_TabImages.setControl((Control)this.mImagesPanel);
            mTabsPanel.setSelection(mTabsPanel_TabImages);
            FileOrDirectoryListPanel mSearchPathsPanel = new FileOrDirectoryListPanel((Composite)mTabsPanel, this.mImageSearchPathsPanelModel);
            CTabItem mTabsPanel_TabSearchPaths = new CTabItem(mTabsPanel, 0);
            mTabsPanel_TabSearchPaths.setText(DocumentsMessages.IMAGE_SEARCH_PATHS);
            mTabsPanel_TabSearchPaths.setControl((Control)mSearchPathsPanel);
            if (this.showJitDumpsPanel) {
                FileOrDirectoryListPanel mJITDumpsPanel = new FileOrDirectoryListPanel((Composite)mTabsPanel, this.mJitDumpsPathsPanelModel);
                CTabItem mTabsPanel_TabJITDumps = new CTabItem(mTabsPanel, 0);
                mTabsPanel_TabJITDumps.setText(DocumentsMessages.JITDUMP_FILES);
                mTabsPanel_TabJITDumps.setControl((Control)mJITDumpsPanel);
            }
        } else {
            this.mImagesPanel = ImagesOptionsPanel.create(this.mContent, this.mImageStore, this.mSettings, this, true);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mImagesPanel);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mContent, "com.arm.streamline.analyze");
        return this.mContent;
    }

    protected void initializeBounds() {
        Shell shell = this.getShell();
        shell.setMinimumSize(shell.computeSize(-1, -1));
        this.mProfilingPanel.initializeContent();
        this.mImagesPanel.initializeContent();
        this.adjustAcceptance();
        super.initializeBounds();
    }

    private void adjustAcceptance() {
        String msg = this.mProfilingPanel.checkValidity();
        if (msg == null) {
            msg = this.mImagesPanel.checkValidity();
        }
        boolean valid = msg == null;
        this.setErrorMessage(msg);
        this.getButton(0).setEnabled(valid);
    }
}

