/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig.viewmodel;

import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.counters.TargetCounter;
import com.arm.streamline.counterconfig.model.Configurations;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffect;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffectFactory;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CountersEbsSharedViewModel {
    private final @NonNull IObservableValue<@NonNull Boolean> computedCountValueIsValid;
    private final @NonNull IObservableValue<@NonNull String> computedEventName;
    private final @NonNull IObservableValue<@NonNull Boolean> computedHasTargetCounter;
    private final @NonNull IObservableValue<@Nullable Integer> observableCountValue;
    private final @NonNull IObservableValue<@Nullable TargetCounter> observableTargetCounter;
    private final @NonNull IObservableValue<@NonNull String> observableThresholdText;
    private final @NonNull Set<@NonNull ISideEffect> sideEffects = new HashSet<ISideEffect>();

    public static @NonNull CountersEbsSharedViewModel create(@NonNull Configurations configurations, @NonNull Events events) {
        return new CountersEbsSharedViewModel(t -> t.getDisplayTitle(), configurations::getLastSetEbsValueOrDefault, configurations::setEbsValueForAllMatching);
    }

    public CountersEbsSharedViewModel(@NonNull Function<@NonNull TargetCounter, @NonNull String> nameMapper, @NonNull ToIntFunction<@NonNull TargetCounter> ebsCountMapper, @NonNull ObjIntConsumer<@NonNull TargetCounter> ebsCountConsumer) {
        this.observableTargetCounter = new WritableValue(null, TargetCounter.class);
        this.observableCountValue = new WritableValue((Object)0, Integer.class);
        this.observableThresholdText = new WritableValue((Object)"", String.class);
        ISideEffectFactory sef = ISideEffectFactory.createFactory(this.sideEffects::add);
        sef.create(() -> this.observableCountValue.getValue(), (T count) -> {
            String oldText;
            @NonNull String newText = count != null ? count.toString() : "";
            if (!newText.contentEquals(oldText = (String)this.observableThresholdText.getValue())) {
                this.observableThresholdText.setValue((Object)newText);
            }
        });
        sef.create(() -> this.observableThresholdText.getValue(), (T t) -> {
            try {
                int parsedCount = Integer.parseInt(t);
                if (parsedCount > 0) {
                    @Nullable Integer currentCount = (Integer)this.observableCountValue.getValue();
                    if (currentCount == null || currentCount != parsedCount) {
                        this.observableCountValue.setValue((Object)parsedCount);
                    }
                } else {
                    this.observableCountValue.setValue(null);
                }
            }
            catch (NumberFormatException e) {
                this.observableCountValue.setValue(null);
            }
        });
        this.computedCountValueIsValid = ComputedValue.create(() -> {
            @Nullable TargetCounter tc = (TargetCounter)this.observableTargetCounter.getValue();
            @Nullable Integer count = (Integer)this.observableCountValue.getValue();
            return tc == null || count != null && count > 0;
        });
        sef.create(() -> this.observableCountValue.getValue(), (T count) -> {
            int c;
            @Nullable TargetCounter value = (TargetCounter)this.observableTargetCounter.getValue();
            if (value != null && count != null && (c = count.intValue()) > 0) {
                ebsCountConsumer.accept(value, c);
            }
        });
        sef.create(() -> this.observableTargetCounter.getValue(), (T value) -> {
            if (value != null) {
                this.observableCountValue.setValue((Object)ebsCountMapper.applyAsInt((TargetCounter)value));
            } else {
                this.observableThresholdText.setValue((Object)"");
            }
        });
        this.computedHasTargetCounter = ComputedValue.create(() -> {
            @Nullable TargetCounter value = (TargetCounter)this.observableTargetCounter.getValue();
            return value != null;
        });
        this.computedEventName = ComputedValue.create(() -> {
            @Nullable TargetCounter value = (TargetCounter)this.observableTargetCounter.getValue();
            if (value == null) {
                return "";
            }
            return (String)nameMapper.apply(value);
        });
    }

    public void dispose() {
        this.sideEffects.forEach(ISideEffect::dispose);
        this.observableTargetCounter.dispose();
        this.observableTargetCounter.dispose();
    }

    public @NonNull IObservableValue<@NonNull String> propertyCountText() {
        return this.observableThresholdText;
    }

    public @NonNull IObservableValue<@Nullable Integer> propertyCountValue() {
        return this.observableCountValue;
    }

    public @NonNull IObservableValue<@NonNull Boolean> propertyCountValueIsValid() {
        return this.computedCountValueIsValid;
    }

    public @NonNull IObservableValue<@NonNull String> propertyEventName() {
        return this.computedEventName;
    }

    public @NonNull IObservableValue<@NonNull Boolean> propertyHasTargetCounter() {
        return this.computedHasTargetCounter;
    }

    public @NonNull IObservableValue<@Nullable TargetCounter> propertyTargetCounter() {
        return this.observableTargetCounter;
    }
}

