/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig.outline;

import com.arm.streamline.common.xml.counters.IAvailableEvent;
import com.arm.streamline.common.xml.counters.IConfiguredEvent;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.counterconfig.BaseCountersOutline;
import com.arm.streamline.counterconfig.outline.IAvailableEventsRow;
import com.arm.streamline.counterconfig.outline.SpeTargetDescriptionRow;
import com.arm.streamline.counterconfig.outline.StockCounterRow;
import com.arm.streamline.utility.io.LocalObjectTransfer;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CountersOutline
extends BaseCountersOutline {
    private @NonNull Set<@NonNull IAvailableEventsRow> mHighlighted = new HashSet<IAvailableEventsRow>();
    private @NonNull List<@NonNull Consumer<@Nullable IAvailableEvent>> mouseListeners = new ArrayList<Consumer<IAvailableEvent>>();

    public CountersOutline(Composite parent, @NonNull OutlineModel<SimpleColumn> model) {
        super(parent, model, true);
        final DragSource dragSource = new DragSource((Control)this, 1);
        dragSource.setTransfer(new Transfer[]{LocalObjectTransfer.get(Row.class)});
        dragSource.addDragListener(new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                CountersOutline.this.dragFinished(event);
            }

            public void dragSetData(DragSourceEvent event) {
                try {
                    @NonNull LocalObjectTransfer<Row<SimpleColumn>> transfer = this.getDragSourceTransfer();
                    if (transfer.isSupportedType(event.dataType)) {
                        event.data = transfer.getTransferObjects();
                        event.doit = true;
                    } else {
                        event.doit = false;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public void dragStart(DragSourceEvent event) {
                try {
                    @NonNull LocalObjectTransfer<Row<SimpleColumn>> transfer = this.getDragSourceTransfer();
                    CountersOutline.this.setDragStart(event, transfer);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            private @NonNull LocalObjectTransfer<Row<SimpleColumn>> getDragSourceTransfer() throws Exception {
                Transfer @NonNull [] transfers = (Transfer[])NullChecking.neverNull((Object[])dragSource.getTransfer());
                if (transfers.length > 0) {
                    Transfer transfer = transfers[0];
                    return (LocalObjectTransfer)((Object)NullChecking.neverNull((Object)((Object)((LocalObjectTransfer)transfer))));
                }
                throw new Exception("No Transfers item found in collection.");
            }
        });
        this.addDisposeListener(e -> dragSource.dispose());
        MouseListener mouseListener = new MouseListener();
        this.addMouseMoveListener(mouseListener);
        this.addMouseTrackListener(mouseListener);
        this.addMouseWheelListener(mouseListener);
    }

    public void addMouseCounterListener(@NonNull Consumer<@Nullable IAvailableEvent> listener) {
        this.mouseListeners.add(listener);
    }

    public @NonNull Collection<@NonNull StockCounter> getSelectedStockCounters() {
        ArrayList<@NonNull StockCounter> counters = new ArrayList<StockCounter>();
        for (Row row : this.getModel().getSelectionAsList()) {
            if (!(row instanceof StockCounterRow)) continue;
            counters.add(((StockCounterRow)row).getCounter());
        }
        return counters;
    }

    public @NonNull Collection<@NonNull SpeTargetDescription> getSelectedSpeEvents() {
        ArrayList<@NonNull SpeTargetDescription> speEvents = new ArrayList<SpeTargetDescription>();
        for (Row row : this.getModel().getSelectionAsList()) {
            if (!(row instanceof SpeTargetDescriptionRow)) continue;
            speEvents.add(((SpeTargetDescriptionRow)row).getTargetDescription());
        }
        return speEvents;
    }

    public void removeMouseCounterListener(@NonNull Consumer<@Nullable StockCounter> listener) {
        this.mouseListeners.remove(listener);
    }

    public void setHighlighted(@Nullable IConfiguredEvent counter) {
        @Nullable IAvailableEvent derivedFrom = (IAvailableEvent)NullChecking.applyIfNonNull((Object)counter, IConfiguredEvent::getDerivedFrom);
        this.mHighlighted.forEach(row -> {
            if (derivedFrom != row.getData()) {
                row.getBaseRow().setHighlighted(false);
                this.redrawRow(row.getBaseRow());
            }
        });
        this.mHighlighted.clear();
        OutlineModel model = this.getModel();
        for (Row row2 : model.getRows()) {
            IAvailableEventsRow cwrow;
            if (!(row2 instanceof IAvailableEventsRow) || (cwrow = (IAvailableEventsRow)((Object)row2)).getData() != derivedFrom) continue;
            this.mHighlighted.add(cwrow);
            cwrow.getBaseRow().setHighlighted(true);
            this.redrawRow(cwrow.getBaseRow());
            break;
        }
    }

    public void setHighlightedSources(@NonNull Collection<@NonNull String> sources) {
        this.mHighlighted.forEach(row -> {
            if (row.getSources().stream().noneMatch(sources::contains)) {
                row.getBaseRow().setHighlighted(false);
                this.redrawRow(row.getBaseRow());
            }
        });
        this.mHighlighted.clear();
        OutlineModel model = this.getModel();
        for (Row row2 : model.getRows()) {
            if (!(row2 instanceof IAvailableEventsRow)) continue;
            IAvailableEventsRow cwrow = (IAvailableEventsRow)((Object)row2);
            if (cwrow.getSources().stream().noneMatch(sources::contains)) continue;
            this.mHighlighted.add(cwrow);
            cwrow.getBaseRow().setHighlighted(true);
            this.redrawRow(cwrow.getBaseRow());
        }
    }

    @Override
    protected boolean isRowDraggable(Row<SimpleColumn> row) {
        return row instanceof IAvailableEventsRow && ((IAvailableEventsRow)((Object)row)).getBaseRow().isEnabled();
    }

    @Override
    public void setSelection(ISelection selection) {
        super.setSelection(selection);
    }

    private class MouseListener
    implements MouseTrackListener,
    MouseMoveListener,
    MouseWheelListener {
        private @Nullable IAvailableEvent stockCounter = null;

        public void mouseEnter(MouseEvent event) {
            this.mouseMove(event);
        }

        public void mouseExit(MouseEvent event) {
            this.fireChange(null);
        }

        public void mouseHover(MouseEvent event) {
            this.mouseMove(event);
        }

        public void mouseMove(MouseEvent event) {
            Row row = CountersOutline.this.overRow(event);
            if (row instanceof IAvailableEventsRow) {
                IAvailableEventsRow iAvaiableEventsRow = (IAvailableEventsRow)((Object)row);
                @NonNull IAvailableEvent data = iAvaiableEventsRow.getData();
                this.fireChange(data);
            } else {
                this.fireChange(null);
            }
        }

        public void mouseScrolled(MouseEvent event) {
            this.mouseMove(event);
        }

        private void fireChange(@Nullable IAvailableEvent availableEvent) {
            if (this.stockCounter != availableEvent) {
                CountersOutline.this.mouseListeners.forEach(l -> l.accept(availableEvent));
                this.stockCounter = availableEvent;
            }
        }
    }
}

