/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig.outline;

import com.arm.streamline.common.xml.counters.Category;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.counters.IAvailableEvent;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.counters.TargetCounter;
import com.arm.streamline.common.xml.spe.SpeFilterConfiguration;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.counterconfig.CountersMessages;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.counterconfig.outline.BaseRow;
import com.arm.streamline.counterconfig.outline.CounterGroupRow;
import com.arm.streamline.counterconfig.outline.IEventConfigurationRow;
import com.arm.streamline.counterconfig.outline.IStickyHeader;
import com.arm.streamline.counterconfig.outline.SpeFilterConfigurationRow;
import com.arm.streamline.counterconfig.outline.SpeTargetDescriptionRow;
import com.arm.streamline.counterconfig.outline.StockCounterRow;
import com.arm.streamline.counterconfig.outline.TargetCounterRow;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.utility.io.LocalObjectTransfer;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.outline.IOutlineListener;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class ConfigurationsOutline
extends Outline<SimpleColumn>
implements DropTargetListener {
    private final @NonNull Configurations mConfigurations;
    private final @NonNull Events mEvents;
    private final @NonNull DropTarget mDropTarget;

    public ConfigurationsOutline(@NonNull Composite parent, @NonNull OutlineModel<SimpleColumn> model, @NonNull Configurations configurations, @NonNull Events events) {
        super(parent, model, true, true);
        model.setShowOutline(false);
        this.setPermitDragSelect(false);
        this.setAllowColumnResize(false);
        this.setShowColumnLines(false);
        this.setColumnFill(true);
        this.mConfigurations = configurations;
        this.mEvents = events;
        this.mDropTarget = new DropTarget((Control)this, 1);
        this.mDropTarget.setTransfer(new Transfer[]{LocalObjectTransfer.get(Row.class)});
        this.mDropTarget.addDropListener((DropTargetListener)this);
        ConfigurationsListener listener = new ConfigurationsListener();
        configurations.addListener(listener);
        this.addDisposeListener(x -> configurations.removeListener(listener));
        this.addOutlineListener(new IOutlineListener<SimpleColumn>(){

            @Override
            public void selectionChanged(Outline<SimpleColumn> outline) {
            }

            @Override
            public void openSelectionRequested(Outline<SimpleColumn> outline) {
            }

            @Override
            public void editorChanged(Outline<SimpleColumn> outline) {
            }

            @Override
            public void deleteSelectionRequested(Outline<SimpleColumn> outline) {
                ConfigurationsOutline.this.deleteSelection();
            }
        });
        this.rebuild();
    }

    public @NonNull Collection<@NonNull TargetCounter> getSelectedTargetCounters() {
        ArrayList<@NonNull TargetCounter> counters = new ArrayList<TargetCounter>();
        for (Row row : this.getModel().getSelectionAsList()) {
            if (!(row instanceof TargetCounterRow)) continue;
            counters.add(((TargetCounterRow)row).getCounter());
        }
        return counters;
    }

    protected void rebuild() {
        OutlineModel<SimpleColumn> model = this.getModel();
        model.removeAllRows();
        Map<@NonNull String, List<@NonNull TargetCounter>> countersByGroupName = this.mConfigurations.getAllCounters().collect(Collectors.groupingBy(tc -> tc.getDerivedFrom().getCategory().getName()));
        countersByGroupName.forEach((groupName, counters) -> {
            CounterGroupRow groupRow = new CounterGroupRow((String)groupName);
            counters.forEach(counter -> groupRow.addChild(new TargetCounterRow((TargetCounter)counter, this.mEvents)));
            model.addRow(groupRow, true);
        });
        @NonNull Set<@NonNull SpeFilterConfiguration> speFilterConfigurations = this.mConfigurations.getSpeFilterConfigurations();
        if (speFilterConfigurations.size() > 0) {
            CounterGroupRow counterGroupRow = new CounterGroupRow(CountersMessages.STAT_PROF_EXTN);
            speFilterConfigurations.forEach(speFilterConfs -> counterGroupRow.addChild(new SpeFilterConfigurationRow((SpeFilterConfiguration)speFilterConfs)));
            model.addRow(counterGroupRow, true);
        }
        ((SimpleColumn)NullChecking.neverNull((Object)((SimpleColumn)model.getColumnWithID(0)))).setSortCriteria(0, true);
        model.sort();
    }

    public void deleteSelection() {
        OutlineModel model = this.getModel();
        ArrayList<@NonNull TargetCounter> counterToRemove = new ArrayList<TargetCounter>();
        ArrayList<@NonNull SpeFilterConfiguration> speFilterToRemove = new ArrayList<SpeFilterConfiguration>();
        for (Row row : model.getSelectionAsList(false)) {
            if (row.canHaveChildren()) continue;
            if (row instanceof TargetCounterRow) {
                counterToRemove.add(((TargetCounterRow)row).getCounter());
                continue;
            }
            if (!(row instanceof SpeFilterConfigurationRow)) continue;
            @NonNull SpeFilterConfiguration speFilterConfiguration = ((SpeFilterConfigurationRow)row).getSpeFilterConfiguration();
            speFilterToRemove.add(speFilterConfiguration);
        }
        this.mConfigurations.removeEvents(speFilterToRemove, counterToRemove);
    }

    public void dragEnter(DropTargetEvent event) {
        if (this.isValidDrag(event)) {
            this.setDropHighlight(true);
            event.detail = 1;
        } else {
            this.setDropHighlight(false);
            event.detail = 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
        this.setDropHighlight(false);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (this.isValidDrag(event)) {
            this.setDropHighlight(true);
            event.detail = 1;
        } else {
            this.setDropHighlight(false);
            event.detail = 0;
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = 1;
    }

    public void drop(DropTargetEvent event) {
        @NonNull ArrayList<@NonNull StockCounter> selectedStockCounters = new ArrayList<StockCounter>();
        @NonNull ArrayList<@NonNull SpeTargetDescription> selectedSpeTargets = new ArrayList<SpeTargetDescription>();
        Row<SimpleColumn>[] rowArray = this.getDropTargetTransfer().getTransferObjects();
        int n = rowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Row<SimpleColumn> row = rowArray[n2];
            if (row instanceof StockCounterRow) {
                selectedStockCounters.add(((StockCounterRow)row).getCounter());
            } else if (row instanceof SpeTargetDescriptionRow) {
                selectedSpeTargets.add(((SpeTargetDescriptionRow)row).getTargetDescription());
            }
            ++n2;
        }
        this.mConfigurations.addEvents(selectedSpeTargets, selectedStockCounters);
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void forceColumnToFill() {
        SimpleColumn column = (SimpleColumn)this.getModel().getColumnAtIndex(0);
        int width = Math.max(column.getPreferredWidth(this), this.getSize().x);
        column.setWidth(width);
        this.adjustScrollBarsForContent();
        this.redrawAll();
    }

    @Override
    public int overRowIndex(int y) {
        Point panelZeroPt = this.toVirtual(new Point(0, 0));
        int index = super.overRowIndex(panelZeroPt.y);
        OutlineModel model = this.getModel();
        if (index >= 0) {
            Row row = model.getRowAtIndex(index);
            int upcomingRowIndex = index + 1;
            if (!(row instanceof IStickyHeader) && (row = row.getParent()) instanceof IStickyHeader) {
                index = model.getIndexOfRow(row);
            }
            if (row instanceof IStickyHeader) {
                Row upcomingRow;
                SimpleColumn column = (SimpleColumn)model.getColumnAtIndex(0);
                if (upcomingRowIndex < model.getRowCount() && (upcomingRow = model.getRowAtIndex(upcomingRowIndex)) instanceof IStickyHeader) {
                    Rectangle cellBounds = this.getCellBounds(upcomingRow, column);
                    panelZeroPt.y = cellBounds.y - (cellBounds.height + 1);
                }
                Rectangle cellBounds = this.getCellBounds(row, column);
                if (y >= panelZeroPt.y && y < panelZeroPt.y + cellBounds.height) {
                    return index;
                }
            }
        }
        return super.overRowIndex(y);
    }

    public void setHighlighted(@Nullable IAvailableEvent counter) {
        for (Row row : this.getModel().getRows()) {
            if (!(row instanceof IEventConfigurationRow)) continue;
            IEventConfigurationRow evRow = (IEventConfigurationRow)((Object)row);
            BaseRow baserow = (BaseRow)row;
            if (evRow.getData().getDerivedFrom().equals(counter)) {
                if (baserow.isHighlighted()) continue;
                baserow.setHighlighted(true);
                this.redrawRow(baserow);
                continue;
            }
            if (!baserow.isHighlighted()) continue;
            baserow.setHighlighted(false);
            this.redrawRow(baserow);
        }
    }

    public void sizeToFit() {
        this.sizeColumnsToFit();
        this.adjustScrollBarsForContent();
    }

    @Override
    protected void drawMore(GC gc, boolean up, int amt) {
    }

    @Override
    protected void drawRowBackground(GC gc, Rectangle bounds, Row<SimpleColumn> row, boolean selected, boolean active) {
        if (row instanceof IStickyHeader) {
            Pattern pattern = new Pattern(gc.getDevice(), 0.0f, (float)bounds.y, 0.0f, (float)(bounds.y + bounds.height), Colors.getDarkGray(), Colors.getBlack());
            gc.setBackgroundPattern(pattern);
            gc.fillRectangle(bounds);
            pattern.dispose();
        } else {
            super.drawRowBackground(gc, bounds, row, selected, active);
        }
    }

    @Override
    protected void handleKeyDown(Event event) {
        super.handleKeyDown(event);
        if (event.doit && event.keyCode == 27) {
            this.getShell().traverse(2);
        }
    }

    @Override
    protected void paintCanvas(GC gc) {
        super.paintCanvas(gc);
        Point panelZeroPt = this.toVirtual(new Point(0, 0));
        int index = super.overRowIndex(panelZeroPt.y);
        OutlineModel<SimpleColumn> model = this.getModel();
        if (index >= 0) {
            Row<SimpleColumn> row = model.getRowAtIndex(index);
            int upcomingRowIndex = index + 1;
            if (!(row instanceof IStickyHeader) && (row = row.getParent()) instanceof IStickyHeader) {
                index = model.getIndexOfRow(row);
            }
            if (row instanceof IStickyHeader) {
                Row upcomingRow;
                if (upcomingRowIndex < model.getRowCount() && (upcomingRow = model.getRowAtIndex(upcomingRowIndex)) instanceof IStickyHeader) {
                    Rectangle cellBounds = this.getCellBounds(upcomingRow, (SimpleColumn)model.getColumnAtIndex(0));
                    panelZeroPt.y = cellBounds.y - (cellBounds.height + 1);
                }
                this.overdraw(gc, row, index, panelZeroPt);
            }
        }
    }

    @Override
    protected Rectangle repaintSelectionInternal() {
        Rectangle bounds = this.getClientArea();
        this.redraw(bounds.x, bounds.y, bounds.width, this.getModel().getRowHeight() + 1, false);
        return super.repaintSelectionInternal();
    }

    private LocalObjectTransfer<Row<SimpleColumn>> getDropTargetTransfer() {
        return (LocalObjectTransfer)this.mDropTarget.getTransfer()[0];
    }

    private boolean isValidDrag(DropTargetEvent event) {
        if ((event.operations & 1) == 1) {
            return this.getDropTargetTransfer().isSupportedType(event.currentDataType);
        }
        return false;
    }

    private void overdraw(GC gc, @NonNull Row<SimpleColumn> row, int index, Point panelZeroPt) {
        OutlineModel<SimpleColumn> model = this.getModel();
        boolean rowSelected = model.isRowSelected(row);
        boolean active = this.isFocusControl();
        SimpleColumn column = (SimpleColumn)model.getColumnAtIndex(0);
        Rectangle bounds = this.getCellBounds(row, column);
        int indent = model.getIndentWidth(row, column);
        bounds.x = panelZeroPt.x;
        bounds.y = panelZeroPt.y;
        this.drawRowBackground(gc, bounds, row, rowSelected, active);
        bounds.x += indent;
        bounds.width -= indent;
        column.drawRowCell(gc, bounds, row, rowSelected, active);
        bounds.x -= indent;
        bounds.width += indent;
        gc.setForeground(this.getRowDividerColor(index));
        gc.drawLine(bounds.x, bounds.y - 1, bounds.width, bounds.y - 1);
        gc.drawLine(bounds.x, bounds.y + bounds.height, bounds.width, bounds.y + bounds.height);
    }

    private class ConfigurationsListener
    implements Configurations.IListener {
        @Override
        public void handleEventsAdded(@NonNull Collection<@NonNull SpeFilterConfiguration> filterConfig, @NonNull Collection<@NonNull TargetCounter> targetCounters) {
            if (!filterConfig.isEmpty() || !targetCounters.isEmpty()) {
                OutlineModel<SimpleColumn> model = ConfigurationsOutline.this.getModel();
                int selection = model.getSelection().getSize();
                ArrayList<@NonNull BaseRow> rows = new ArrayList<BaseRow>();
                model.deselect();
                for (SpeFilterConfiguration speFilter : filterConfig) {
                    int rowIndex = 0;
                    boolean added = false;
                    for (Row one : model.getRows()) {
                        CounterGroupRow cgRow;
                        if (one instanceof CounterGroupRow && (cgRow = (CounterGroupRow)one).getName().equals(CountersMessages.STAT_PROF_EXTN)) {
                            SpeFilterConfigurationRow newRow = new SpeFilterConfigurationRow(speFilter);
                            cgRow.addChild(newRow);
                            model.addRow(rowIndex + cgRow.getChildCount(), newRow);
                            rows.add(newRow);
                            added = true;
                            break;
                        }
                        ++rowIndex;
                    }
                    if (!added) {
                        CounterGroupRow cgRow = new CounterGroupRow(CountersMessages.STAT_PROF_EXTN);
                        SpeFilterConfigurationRow newRow = new SpeFilterConfigurationRow(speFilter);
                        cgRow.addChild(newRow);
                        model.addRow(cgRow, true);
                        rows.add(newRow);
                    }
                    if (rows.size() == 1 && selection == 1) {
                        model.select((Row)rows.get(0), false);
                        continue;
                    }
                    model.select(rows, true);
                }
                rows = new ArrayList();
                for (TargetCounter targetCounter : targetCounters) {
                    @NonNull StockCounter derivedFrom = targetCounter.getDerivedFrom();
                    Category category = derivedFrom.getCategory();
                    int rowIndex = 0;
                    boolean added = false;
                    String categoryName = category.getName();
                    for (Row one : model.getRows()) {
                        CounterGroupRow cgRow;
                        if (one instanceof CounterGroupRow && (cgRow = (CounterGroupRow)one).getName().equals(categoryName)) {
                            TargetCounterRow newRow = new TargetCounterRow(targetCounter, ConfigurationsOutline.this.mEvents);
                            cgRow.addChild(newRow);
                            model.addRow(rowIndex + cgRow.getChildCount(), newRow);
                            rows.add(newRow);
                            added = true;
                            break;
                        }
                        ++rowIndex;
                    }
                    if (!added) {
                        CounterGroupRow cgRow = new CounterGroupRow(categoryName);
                        TargetCounterRow newRow = new TargetCounterRow(targetCounter, ConfigurationsOutline.this.mEvents);
                        cgRow.addChild(newRow);
                        model.addRow(cgRow, true);
                        rows.add(newRow);
                    }
                    model.select(rows, true);
                }
                ((SimpleColumn)NullChecking.neverNull((Object)((SimpleColumn)model.getColumnWithID(0)))).setSortCriteria(0, true);
                model.sort();
                ConfigurationsOutline.this.redraw();
            }
        }

        @Override
        public void handleEventsRemoved(@NonNull Collection<@NonNull SpeFilterConfiguration> filterConfig, @NonNull Collection<@NonNull TargetCounter> targetCounters) {
            OutlineModel model = ConfigurationsOutline.this.getModel();
            ArrayList<@NonNull Row<C>> rows = new ArrayList();
            @NonNull Collection allEvents = Stream.concat(filterConfig.stream(), targetCounters.stream()).collect(Collectors.toList());
            for (Row row : model.getRows()) {
                if (!(row instanceof IEventConfigurationRow) || !allEvents.contains(((IEventConfigurationRow)((Object)row)).getData())) continue;
                rows.add(row);
                row.removeFromParent();
            }
            model.removeRows(rows);
            model.deselect();
            for (Row row : model.getTopLevelRows()) {
                if (row.getChildCount() != 0) continue;
                model.select(row, true);
            }
            model.removeSelection();
            ConfigurationsOutline.this.redraw();
        }

        @Override
        public void handleReload() {
            ConfigurationsOutline.this.rebuild();
            ConfigurationsOutline.this.sizeColumnsToFit();
            ConfigurationsOutline.this.adjustScrollBarsForContent();
            ConfigurationsOutline.this.redraw();
        }

        @Override
        public void handleEbsChanged(@Nullable TargetCounter counter) {
            ConfigurationsOutline.this.redraw();
        }

        @Override
        public void handleListenersChanged() {
        }
    }
}

