/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.counterconfig.CountersDialog;
import com.arm.streamline.counterconfig.CountersMessages;
import com.arm.streamline.counterconfig.model.CounterConfiguration;
import com.arm.streamline.counterconfig.model.CounterNames;
import com.arm.streamline.databrowser.TargetUtils;
import com.arm.streamline.editortabs.timeline.common.templates.TemplateAction;
import com.arm.streamline.editortabs.timeline.common.templates.TemplatesMessages;
import com.arm.streamline.model.templates.ITemplatePath;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.streamline.model.templates.TemplateUtils;
import com.arm.streamline.utility.GpuTimelineEventsUtil;
import com.arm.streamline.widget.Error;
import com.arm.streamline.widget.IProvidesStateMaskAtMouseDown;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.utils.NullChecking;
import com.arm.utils.StreamUtils;
import com.arm.utils.collections.Pair;
import gnu.trove.set.TIntSet;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ImportTemplateAction
extends Action
implements IMenuCreator,
SelectionListener {
    private CountersDialog mDialog;
    private Menu mMenu;
    private boolean mAdd;

    public ImportTemplateAction(CountersDialog dialog) {
        this.mDialog = dialog;
        this.setImageDescriptor(StreamlinePlugin.getImageDescriptor("Templates.png"));
        this.setToolTipText(String.format(CountersMessages.TEMPLATE_IMPORT_TOOLTIP, KeyStroke.getInstance((int)SWT.MOD2).format()));
        this.setMenuCreator(this);
    }

    public final void dispose() {
        if (this.mMenu != null) {
            this.mMenu.dispose();
            this.mMenu = null;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public final Menu getMenu(Control parent) {
        this.mAdd = false;
        if (parent instanceof IProvidesStateMaskAtMouseDown) {
            this.mAdd = (((IProvidesStateMaskAtMouseDown)parent).getStateMaskAtMouseDown() & SWT.MOD2) == SWT.MOD2;
        }
        this.mMenu = new Menu(parent);
        if (this.mAdd) {
            MenuItem notice = new MenuItem(this.mMenu, 8);
            notice.setText(CountersMessages.ADD_NOTICE);
            notice.setEnabled(false);
            ContextMenu.createSeparator(this.mMenu);
        }
        CounterConfiguration config = this.mDialog.getConfig();
        final @NonNull @NonNull Map sourceToClusterIdMap = config.getEvents().getSourceToClusterIdMap();
        List<TemplateFile> builtInTemplates = TemplateAction.getAvailableTemplates(sourceToClusterIdMap);
        if (!config.getConfigurations().getTemplates().isEmpty()) {
            MenuItem notice = new MenuItem(this.mMenu, 8);
            notice.setText(TemplatesMessages.SELECTED_TEMPLATES);
            notice.setEnabled(false);
        }
        @NonNull Set<@NonNull String> counterAlias = config.getEvents().getSourceToComboMap().keySet();
        @NonNull CounterNames counterNames = config.getCounterNames();
        @Nullable String gpuPublicName = config.getConfigurations().getGpuPublicName();
        @NonNull Optional<@Nullable String> deviceGpu = TargetUtils.findSupportedGpuFromCounterNamesAndPublicName(counterNames, gpuPublicName);
        @NonNull List<@NonNull String> listOfCounterAlias = List.copyOf(counterAlias);
        for (TemplateFile template : config.getConfigurations().getTemplates()) {
            MenuItem item = new MenuItem(this.mMenu, 8);
            @NonNull String availableChartsSeriesCount = TemplateUtils.getValidSeriesMessage(template.getCharts(), null, listOfCounterAlias, ImportTemplateAction.isValid(counterAlias), TemplateUtils.TemplateSelectedFrom.CounterDialog);
            item.setText(template.getName() + availableChartsSeriesCount);
            String tooltip = MessageFormat.format(TemplatesMessages.SERIES_SUPPORTED, availableChartsSeriesCount, TemplatesMessages.TARGET);
            item.setToolTipText(tooltip);
            item.setData((Object)template);
            item.addSelectionListener((SelectionListener)this);
        }
        if (!config.getConfigurations().getTemplates().isEmpty()) {
            ContextMenu.createSeparator(this.mMenu);
        }
        if (builtInTemplates.isEmpty()) {
            MenuItem notice = new MenuItem(this.mMenu, 8);
            notice.setText(CountersMessages.NO_TEMPLATES);
            notice.setEnabled(false);
        } else {
            boolean seenStock = false;
            boolean seenUserDefined = false;
            for (TemplateFile template : builtInTemplates) {
                ITemplatePath path = template.getPath();
                if (path != null && path.isStock()) {
                    if (!seenStock) {
                        if (seenUserDefined) {
                            ContextMenu.createSeparator(this.mMenu);
                        }
                        MenuItem notice = new MenuItem(this.mMenu, 8);
                        notice.setText(TemplatesMessages.BUILT_IN_TEMPLATES);
                        notice.setEnabled(false);
                    }
                    seenStock = true;
                } else {
                    if (!seenUserDefined) {
                        MenuItem notice = new MenuItem(this.mMenu, 8);
                        notice.setText(TemplatesMessages.USER_TEMPLATES);
                        notice.setEnabled(false);
                    }
                    seenUserDefined = true;
                }
                boolean hasValidSeries = TemplateUtils.getValidSeries(template.getCharts(), null, listOfCounterAlias, ImportTemplateAction.isValid(counterAlias), TemplateUtils.TemplateSelectedFrom.CounterDialog) != 0;
                Set<String> availableSpe = config.getEvents().getAvailableSpeTargetDescriptions().stream().map(s -> s.getId()).collect(Collectors.toSet());
                if (!TemplateUtils.templateShouldBeAdded(template, deviceGpu, availableSpe, hasValidSeries)) continue;
                MenuItem item = new MenuItem(this.mMenu, 8);
                @NonNull String availableChartsSeriesCount = TemplateUtils.getValidSeriesMessage(template.getCharts(), null, listOfCounterAlias, ImportTemplateAction.isValid(counterAlias), TemplateUtils.TemplateSelectedFrom.CounterDialog);
                item.setText(template.getName() + availableChartsSeriesCount);
                String tooltip = MessageFormat.format(TemplatesMessages.SERIES_SUPPORTED, availableChartsSeriesCount, TemplatesMessages.TARGET);
                item.setToolTipText(tooltip);
                item.setData((Object)template);
                item.addSelectionListener((SelectionListener)this);
                GpuTimelineEventsUtil.pruneFromTemplateIfUnsupported(config.getEvents(), template);
            }
        }
        ContextMenu.createConditionalSeparator(this.mMenu);
        MenuItem installItem = new MenuItem(this.mMenu, 8);
        installItem.setText(CountersMessages.INSTALL_AND_LOAD);
        installItem.setEnabled(true);
        installItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                ImportTemplateAction.this.installAndLoad(sourceToClusterIdMap);
            }
        });
        return this.mMenu;
    }

    public static @NonNull Predicate<@NonNull String> isValid(@NonNull Set<@NonNull String> counterAlias) {
        return variableFromExpression -> {
            if (variableFromExpression.startsWith("MaliConstants")) {
                return true;
            }
            return counterAlias.contains(variableFromExpression);
        };
    }

    public static @Nullable Pair<@NonNull String, @NonNull String> addTemplate(@NonNull CounterConfiguration config, @NonNull TemplateFile template) {
        config.getConfigurations().removeTemplateIfPresent(template);
        config.getConfigurations().addTemplate(template);
        Set<@NonNull String> notAddedAliases = TemplateUtils.addTemplate(config.getConfigurations()::addCombinationsByAlias, template.getCharts(), List.copyOf(config.getEvents().getSourceToComboMap().keySet()));
        ITemplatePath templatePath = template.getPath();
        if (templatePath != null && templatePath.isStock() && templatePath.getName().contentEquals("SPE")) {
            Collection speConfigs = config.getEvents().getAvailableSpeTargetDescriptions();
            config.getConfigurations().addEvents(speConfigs, Collections.emptyList());
        }
        if (!notAddedAliases.isEmpty()) {
            return new Pair((Object)CountersMessages.UNABLE_TO_ADD_COUNTERS, (Object)StreamUtils.addFirst((Object)CountersMessages.LIST_OF_COUNTERS_NOT_ADDED, notAddedAliases.stream().sorted()).collect(Collectors.joining("\n    ")));
        }
        return null;
    }

    public final Menu getMenu(Menu parent) {
        return null;
    }

    public final void widgetDefaultSelected(SelectionEvent event) {
    }

    public final void widgetSelected(SelectionEvent event) {
        this.selectTemplate((TemplateFile)NullChecking.neverNull((Object)event.widget.getData()));
    }

    private void selectTemplate(@NonNull TemplateFile template) {
        try {
            Pair<String, String> error;
            CounterConfiguration config = this.mDialog.getConfig();
            if (!this.mAdd) {
                config.getConfigurations().clear();
            }
            if ((error = ImportTemplateAction.addTemplate(config, template)) != null) {
                Error.show(String.format((String)error.first, CountersMessages.CLICK_FOR_DETAIL_INFO), new Throwable((String)error.second), false);
            }
        }
        catch (Exception exception) {
            Error.show(exception);
        }
    }

    private final void installAndLoad(@NonNull Map<@NonNull String, @NonNull TIntSet> sourcesToClusterId) {
        Optional<File> maybeFile = TemplateUtils.installAndLoad();
        if (maybeFile.isPresent()) {
            File file = maybeFile.get();
            String fileNameWithoutExtension = file.getName();
            int idx = fileNameWithoutExtension.lastIndexOf(46);
            if (idx > 0) {
                fileNameWithoutExtension = fileNameWithoutExtension.substring(0, idx);
            }
            try {
                this.selectTemplate(new TemplateFile(file, sourcesToClusterId));
            }
            catch (Exception exception) {
                Error.show(String.format(CountersMessages.UNABLE_TO_LOAD, fileNameWithoutExtension), exception, true);
                return;
            }
        }
    }
}

