/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.xml.counters.IAvailableEvent;
import com.arm.streamline.common.xml.counters.IConfiguredEvent;
import com.arm.streamline.counterconfig.CountersMessages;
import com.arm.streamline.counterconfig.CountersUiShared;
import com.arm.streamline.counterconfig.EventsEditorComposite;
import com.arm.streamline.counterconfig.ImportTemplateAction;
import com.arm.streamline.counterconfig.model.CounterConfiguration;
import com.arm.streamline.counterconfig.outline.ConfigurationsOutline;
import com.arm.streamline.counterconfig.outline.CounterCell;
import com.arm.streamline.counterconfig.outline.CounterRow;
import com.arm.streamline.counterconfig.outline.CountersOutline;
import com.arm.streamline.counterconfig.outline.IEventConfigurationRow;
import com.arm.streamline.counterconfig.outline.SpeFilterConfigurationRow;
import com.arm.streamline.counterconfig.outline.TargetCounterRow;
import com.arm.streamline.databrowser.IdleTargetXml;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.ICommandTarget;
import com.arm.streamline.utility.io.Images;
import com.arm.streamline.utility.io.LocalObjectTransfer;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.Error;
import com.arm.streamline.widget.outline.IOutlineModelListener;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CountersDialog
extends TitleAreaDialog
implements ICommandTarget,
IOutlineModelListener<SimpleColumn>,
ControlListener,
MouseWheelListener,
MouseMoveListener,
MouseTrackListener,
KeyListener {
    private static final String CMD_DELETE = "delete";
    private static final String CMD_IMPORT = "import";
    private static final String CMD_EXPORT = "export";
    private static final String CMD_RESTORE_DEFAULTS = "restore_defaults";
    private static final String[] EXTENSIONS = new String[]{"*.xml", "*.*"};
    private static final String[] DESCRIPTIONS;
    private static String DEFAULT_PATH;
    private final @NonNull CounterConfiguration mConfig;
    private ConfigurationsOutline mChosenOutline;
    private CommandAction mDeleteAction;
    private CountersOutline mAvailableOutline;
    private CountersUiShared sharedControls;
    private EventsEditorComposite eventsEditorHandler;
    private boolean isValid;
    private @NonNull TargetAddressString targetAddress;

    static {
        DEFAULT_PATH = null;
        DESCRIPTIONS = new String[]{CountersMessages.XML_FILES, CountersMessages.ALL_FILES};
    }

    public static void configureCounters(Shell shell, @NonNull TargetAddressString targetAddress) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (IdleTargetXml targetXml = new IdleTargetXml(targetAddress);){
                CountersDialog dialog = new CountersDialog(shell, new CounterConfiguration(targetXml), targetAddress);
                dialog.open();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            CountersDialog.handleError(exception);
        }
    }

    public static Label createEventsToCollectLabel(Composite parent) {
        return CountersUiShared.makeBold(CountersUiShared.createLabel(parent, CountersMessages.EVENTS_TO_COLLECT));
    }

    private static String getDefaultPath() {
        if (DEFAULT_PATH == null) {
            DEFAULT_PATH = new File(System.getProperty("user.home", ".")).getAbsolutePath();
        }
        return DEFAULT_PATH;
    }

    public static void handleError(Exception exception) {
        if (exception.getMessage() == null) {
            Error.show(CountersMessages.GENERAL_COMM_ERROR);
        } else {
            Error.show(exception);
        }
    }

    private static void setDefaultPath(String path) {
        DEFAULT_PATH = FilePath.getParent((String)FilePath.getFullPath(null, (String)path));
    }

    public CountersDialog(Shell parentShell, @NonNull CounterConfiguration config, @NonNull TargetAddressString targetAddress) {
        super(parentShell);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.setHelpAvailable(true);
        this.mConfig = config;
        this.targetAddress = targetAddress;
    }

    public void controlMoved(ControlEvent event) {
    }

    public void controlResized(ControlEvent event) {
        this.mChosenOutline.sizeColumnsToFit();
        this.mChosenOutline.adjustScrollBarsForContent();
    }

    public void keyPressed(KeyEvent event) {
        Object source;
        KeyStroke keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)event));
        if (keyStroke.isComplete() && keyStroke.getModifierKeys() == WorkspaceUtils.getCommandKey() && keyStroke.getNaturalKey() == 65 && (source = event.getSource()) instanceof Outline) {
            Outline typedSource = (Outline)source;
            typedSource.getModel().select();
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseEnter(MouseEvent event) {
        this.mouseMove(event);
    }

    public void mouseExit(MouseEvent event) {
        this.sharedControls.setCounter(null);
        this.sharedControls.availableOutline.setHighlighted(null);
        this.mChosenOutline.setHighlighted(null);
    }

    public void mouseHover(MouseEvent event) {
    }

    public void mouseMove(MouseEvent event) {
        if (event.widget instanceof ConfigurationsOutline) {
            Outline outline = (Outline)event.widget;
            Row row = outline.overRow(event);
            IAvailableEvent stockCounter = null;
            if (row instanceof IEventConfigurationRow) {
                IConfiguredEvent counter = ((IEventConfigurationRow)((Object)row)).getData();
                stockCounter = counter.getDerivedFrom();
                this.sharedControls.availableOutline.setHighlighted(counter);
            }
            this.sharedControls.setCounter(stockCounter);
        }
    }

    public void mouseScrolled(MouseEvent event) {
        this.mouseMove(event);
    }

    @Override
    public void obeyCommand(CommandAction commandAction) {
        String command = commandAction.getCommand();
        if (CMD_DELETE.equals(command)) {
            this.mChosenOutline.deleteSelection();
        } else if (CMD_IMPORT.equals(command)) {
            this.importConfiguration();
        } else if (CMD_EXPORT.equals(command)) {
            this.exportConfiguration();
        } else if (CMD_RESTORE_DEFAULTS.equals(command)) {
            this.loadDefaults();
        }
    }

    @Override
    public void rowsAdded(OutlineModel<SimpleColumn> model, Row<SimpleColumn>[] rows) {
        if (model == this.mChosenOutline.getModel()) {
            this.selectionDidChange(model);
        }
    }

    @Override
    public void rowsWereRemoved(OutlineModel<SimpleColumn> model, Row<SimpleColumn>[] rows) {
        if (model == this.mChosenOutline.getModel()) {
            this.selectionDidChange(model);
        }
    }

    @Override
    public void rowsWillBeRemoved(OutlineModel<SimpleColumn> model, Row<SimpleColumn>[] rows) {
    }

    @Override
    public void selectionDidChange(OutlineModel<SimpleColumn> model) {
        boolean enabled = false;
        List<Row<SimpleColumn>> selection = this.handleSelection(model);
        for (Row<SimpleColumn> row : selection) {
            if (!(row instanceof IEventConfigurationRow)) continue;
            enabled = true;
            break;
        }
        this.mDeleteAction.setEnabled(enabled);
    }

    List<Row<SimpleColumn>> handleSelection(OutlineModel<SimpleColumn> model) {
        List<Row<SimpleColumn>> selection = model.getSelectionAsList();
        if (selection.size() != 1 && this.eventsEditorHandler != null) {
            this.eventsEditorHandler.handleClearRequest();
        } else if (selection.size() == 1) {
            Row<SimpleColumn> row = selection.get(0);
            if (row instanceof SpeFilterConfigurationRow) {
                this.eventsEditorHandler.handleRequest(((SpeFilterConfigurationRow)row).getSpeFilterConfiguration());
                this.mChosenOutline.scrollRowsIntoView(Arrays.asList(row), true);
            } else if (row instanceof TargetCounterRow) {
                TargetCounterRow tcRow = (TargetCounterRow)row;
                if (this.eventsEditorHandler != null) {
                    boolean ebsTarget = ((CounterRow)tcRow).isEbsTarget(this.mConfig.getConfigurations());
                    if (ebsTarget) {
                        this.eventsEditorHandler.handleRequest(tcRow.getCounter());
                        this.mChosenOutline.scrollRowsIntoView(Arrays.asList(row), true);
                    } else {
                        this.eventsEditorHandler.handleClearRequest();
                    }
                }
            }
        }
        return selection;
    }

    @Override
    public void selectionWillChange(OutlineModel<SimpleColumn> model) {
    }

    @Override
    public void sortCleared(OutlineModel<SimpleColumn> model) {
    }

    @Override
    public void sorted(OutlineModel<SimpleColumn> model, boolean restoring) {
    }

    protected void buttonPressed(int buttonID) {
        block5: {
            if (buttonID == 0) {
                try {
                    @Nullable IOException exception = this.mConfig.save(true);
                    if (exception == null) {
                        super.buttonPressed(buttonID);
                        break block5;
                    }
                    CountersDialog.handleError(exception);
                }
                catch (Exception ioe) {
                    CountersDialog.handleError(ioe);
                    super.buttonPressed(1);
                }
            } else {
                super.buttonPressed(buttonID);
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CountersMessages.DIALOG_TITLE);
        newShell.setImage(StreamlinePlugin.getImage("CpuIcon.png"));
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        Button okButton = this.getButton(0);
        assert (okButton != null);
        okButton.setText(CountersMessages.SAVE);
        okButton.setEnabled(this.isValid);
        return control;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.sharedControls.setCounter(null);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(CountersMessages.SELECT_COUNTERS_TITLE);
        this.setMessage(String.format(CountersMessages.CHOOSE_TARGET_COUNTERS, this.targetAddress));
        Composite dialogContent = new Composite(parent, 0x20000000);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(dialogContent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)dialogContent);
        Composite content = new Composite(dialogContent, 0x20000000);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(content);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)content);
        Composite outer = new Composite(content, 0x20000000);
        GridLayoutFactory.fillDefaults().spacing(0, 5).applyTo(outer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)outer);
        this.eventsEditorHandler = new EventsEditorComposite(outer, this.mConfig);
        OutlineModel<SimpleColumn> model = new OutlineModel<SimpleColumn>();
        SimpleColumn column = new SimpleColumn(0, CountersMessages.EVENTS_TO_COLLECT, "");
        column.setPrimary(true);
        if (this.eventsEditorHandler != null) {
            column.setRowCell(new CounterCell(this.mConfig.getConfigurations()));
        }
        column.setNoMaxWidth();
        model.addColumn(column);
        this.mChosenOutline = new ConfigurationsOutline(outer, model, this.mConfig.getConfigurations(), this.mConfig.getEvents());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mChosenOutline);
        this.mChosenOutline.addMouseTrackListener(this);
        this.mChosenOutline.addMouseMoveListener(this);
        this.mChosenOutline.addMouseWheelListener(this);
        this.mChosenOutline.addControlListener(this);
        this.mChosenOutline.getModel().addListener(this);
        this.mChosenOutline.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CountersDialog.this.handleSelection(CountersDialog.this.mChosenOutline.getModel());
            }
        });
        this.mChosenOutline.addKeyListener(this);
        this.eventsEditorHandler.createComposite();
        this.eventsEditorHandler.addValidityListener(isValid -> {
            this.isValid = isValid;
            this.updateDialogButtons();
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)outer);
        this.sharedControls = new CountersUiShared(content, this.mConfig, this.eventsEditorHandler, true);
        Label availableEventsLabel = this.sharedControls.label;
        GridDataFactory.fillDefaults().align(16384, 0x1000008).applyTo((Control)this.sharedControls.label);
        availableEventsLabel.moveAbove(null);
        Label eventsToCollectLabel = CountersDialog.createEventsToCollectLabel(content);
        eventsToCollectLabel.moveBelow((Control)availableEventsLabel);
        CountersUiShared.AvailableEventsToolbar availableEventsToolbar = this.sharedControls.toolbar;
        availableEventsToolbar.moveBelow((Control)eventsToCollectLabel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)availableEventsToolbar);
        @NonNull CustomToolbar eventsToCollectToolbar = new CustomToolbar(content, false);
        this.createEventsToCollectToolbarContent(eventsToCollectToolbar);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)eventsToCollectToolbar);
        eventsToCollectToolbar.moveBelow((Control)availableEventsToolbar);
        this.mAvailableOutline = this.sharedControls.availableOutline;
        this.mAvailableOutline.addKeyListener(this);
        this.mAvailableOutline.addMouseCounterListener(this.mChosenOutline::setHighlighted);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mAvailableOutline);
        this.mAvailableOutline.moveBelow((Control)eventsToCollectToolbar);
        outer.moveBelow((Control)this.mAvailableOutline);
        Composite description = this.sharedControls.description;
        description.moveBelow((Control)outer);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)description);
        DragSource dragSource = new DragSource((Control)this.mChosenOutline, 2);
        dragSource.setTransfer(new Transfer[]{LocalObjectTransfer.get(Row.class)});
        DropTarget dropTarget = new DropTarget((Control)this.mAvailableOutline, 2);
        dropTarget.setTransfer(new Transfer[]{LocalObjectTransfer.get(Row.class)});
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 2;
                CountersDialog.this.mAvailableOutline.setDropHighlight(true);
            }

            public void dragLeave(DropTargetEvent event) {
                CountersDialog.this.mAvailableOutline.setDropHighlight(false);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                event.detail = 2;
                CountersDialog.this.mAvailableOutline.setDropHighlight(true);
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 2;
            }

            public void drop(DropTargetEvent event) {
                CountersDialog.this.mChosenOutline.deleteSelection();
                CountersDialog.this.mAvailableOutline.setDropHighlight(false);
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogContent, "com.arm.streamline.counters");
        return dialogContent;
    }

    private void updateDialogButtons() {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(this.isValid);
        }
    }

    protected Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
        Rectangle bounds = super.getConstrainedShellBounds(preferredSize);
        Rectangle available = this.getShell().getDisplay().getClientArea();
        int max = available.height * 2 / 3;
        if (bounds.height > max) {
            bounds.y += (bounds.height - max) / 2;
            bounds.height = max;
        }
        return bounds;
    }

    protected void initializeBounds() {
        Shell shell = this.getShell();
        Rectangle available = shell.getDisplay().getClientArea();
        Point size = shell.computeSize(-1, -1);
        size.x = 1000;
        int max = available.width - 100;
        if (size.x > max) {
            size.x = max;
        }
        size.y = 750;
        shell.setMinimumSize(size);
        super.initializeBounds();
    }

    private void createEventsToCollectToolbarContent(CustomToolbar eventsToCollectToolbar) {
        this.mDeleteAction = new CommandAction(CMD_DELETE, CountersMessages.REMOVE_SELECTED, Images.getEclipseSharedImageDescriptor("IMG_TOOL_DELETE"), this);
        this.mDeleteAction.setEnabled(false);
        eventsToCollectToolbar.addAction(this.mDeleteAction);
        eventsToCollectToolbar.addAction(new CommandAction(CMD_RESTORE_DEFAULTS, CountersMessages.DEFAULTS, StreamlinePlugin.getImageDescriptor(StreamlineImages.RESET), this));
        eventsToCollectToolbar.addFlexibleSpace();
        eventsToCollectToolbar.addAction(new ImportTemplateAction(this));
        eventsToCollectToolbar.addAction(new CommandAction(CMD_IMPORT, CountersMessages.IMPORT, StreamlinePlugin.getImageDescriptor("Import.gif"), this));
        eventsToCollectToolbar.addAction(new CommandAction(CMD_EXPORT, CountersMessages.EXPORT, StreamlinePlugin.getImageDescriptor("Export.gif"), this));
        eventsToCollectToolbar.setLeftMargin(0);
    }

    private void exportConfiguration() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setFilterExtensions(EXTENSIONS);
        dialog.setOverwrite(true);
        dialog.setFilterPath(CountersDialog.getDefaultPath());
        dialog.setFileName("configuration.xml");
        dialog.setFilterNames(DESCRIPTIONS);
        String fileName = dialog.open();
        if (fileName != null) {
            CountersDialog.setDefaultPath(fileName);
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileOutputStream out = new FileOutputStream(fileName);){
                    this.mConfig.getConfigurations().save(out);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                CountersDialog.handleError(exception);
            }
        }
    }

    private void importConfiguration() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(EXTENSIONS);
        dialog.setFilterNames(DESCRIPTIONS);
        dialog.setFilterPath(CountersDialog.getDefaultPath());
        String fileName = dialog.open();
        if (fileName != null) {
            CountersDialog.setDefaultPath(fileName);
            try {
                this.mConfig.importConfig(fileName);
            }
            catch (Exception exception) {
                CountersDialog.handleError(exception);
            }
        }
    }

    private void loadDefaults() {
        try {
            this.mConfig.loadDefaults();
        }
        catch (Exception exception) {
            CountersDialog.handleError(exception);
        }
    }

    public @NonNull CounterConfiguration getConfig() {
        return this.mConfig;
    }
}

