/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.cmdline;

import com.arm.streamline.cmdline.CmdLineMessages;
import com.arm.streamline.cmdline.ReportProcessor;
import com.arm.streamline.cmdline.ValueReporting;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.dataimport.ImportFileType;
import com.arm.utils.NullChecking;
import com.arm.utils.Platform;
import com.arm.utils.collections.Pair;
import com.arm.utils.text.BasicNumberUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CmdLineParser {
    public static final @NonNull ZoomLevel DEFAULT_ZOOM_LEVEL = Scales.ONE_MILLISECOND_ZOOM_LEVEL;
    public static final String OPTION_SCALE = "scale";

    public static @Nullable Integer parse(@NonNull String @NonNull [] args, @NonNull String @NonNull [] additionalArgs, @NonNull ICommandLineHandler handler) {
        int exitCode;
        String errorMessage;
        String nextArg;
        String optionArg;
        String originalArg;
        AbstractCommandLineModeParser modeParser;
        ArrayList<String> invalidArguments;
        ArrayList<String> files;
        block15: {
            files = new ArrayList<String>();
            invalidArguments = new ArrayList<String>();
            if (args.length == 0) {
                return null;
            }
            String originalArg2 = args[0];
            @Nullable String optionArg2 = CmdLineParser.extractOption(originalArg2);
            if (optionArg2 != null) {
                modeParser = CmdLineParser.isHelpMode(optionArg2) ? new HelpCommandLineModeParser(invalidArguments) : CmdLineParser.processOption(invalidArguments, optionArg2, originalArg2);
            } else {
                invalidArguments.add(originalArg2);
                modeParser = null;
            }
            if (modeParser == null) break block15;
            int i = 1;
            while (i < args.length && !modeParser.hasError()) {
                block18: {
                    block16: {
                        String subsequentArg;
                        block17: {
                            originalArg = args[i];
                            optionArg = CmdLineParser.extractOption(originalArg);
                            nextArg = i + 1 < args.length ? args[i + 1] : null;
                            String string = subsequentArg = i + 2 < args.length ? args[i + 2] : null;
                            if (optionArg == null || modeParser instanceof PACommandLineModeParser) break block16;
                            if (!CmdLineParser.isHelpMode(optionArg)) break block17;
                            modeParser = new HelpCommandLineModeParser(invalidArguments);
                            break block18;
                        }
                        switch (modeParser.nextOption(optionArg, originalArg, nextArg, subsequentArg)) {
                            case BOTH: {
                                i += 2;
                                break block18;
                            }
                            case NEXT: {
                                ++i;
                                break block18;
                            }
                            case NONE: {
                                break block18;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                    }
                    files.add(originalArg);
                }
                ++i;
            }
        }
        int i = 0;
        while (!(i >= additionalArgs.length || modeParser != null && modeParser.hasError())) {
            originalArg = additionalArgs[i];
            optionArg = CmdLineParser.extractOption(originalArg);
            String string = nextArg = i + 1 < additionalArgs.length ? additionalArgs[i + 1] : null;
            if (optionArg != null && "password".equals(optionArg)) {
                if (modeParser == null) break;
                modeParser.nextOption(optionArg, originalArg, nextArg, null);
                break;
            }
            ++i;
        }
        String string = errorMessage = modeParser != null ? modeParser.errorMessage : null;
        if (errorMessage != null) {
            exitCode = handler.error(errorMessage);
        } else if (!invalidArguments.isEmpty()) {
            exitCode = handler.invalidArguments(invalidArguments);
        } else {
            @NonNull AbstractCommandLineModeParser mp = (AbstractCommandLineModeParser)NullChecking.neverNull((Object)modeParser);
            exitCode = mp.accept(handler, files);
        }
        return exitCode;
    }

    protected static @Nullable String extractOption(@NonNull String arg) {
        return CmdLineParser.extractOption(arg, Platform.isWindows());
    }

    protected static @Nullable String extractOption(@NonNull String arg, boolean allowSlash) {
        if (arg.startsWith("/")) {
            if (arg.length() > 1 && allowSlash) {
                return arg.substring(1);
            }
        } else if (arg.startsWith("--")) {
            if (arg.length() > 2) {
                return arg.substring(2);
            }
        } else if (arg.startsWith("-") && arg.length() > 1) {
            return arg.substring(1);
        }
        return null;
    }

    private static boolean isHelpMode(@NonNull String arg) {
        switch (arg) {
            case "?": 
            case "h": 
            case "help": {
                return true;
            }
        }
        return false;
    }

    private static @Nullable AbstractCommandLineModeParser processOption(@NonNull List<@NonNull String> invalidArguments, @NonNull String arg, @NonNull String originalArg) {
        switch (arg) {
            case "v": 
            case "version": {
                return new VersionCommandLineModeParser(invalidArguments);
            }
            case "analyze": {
                return new AnalyseCommandLineModeParser(invalidArguments);
            }
            case "capture": {
                return new CaptureCommandLineModeParser(invalidArguments);
            }
            case "generate-config": {
                return new GenerateConfigCommandLineModeParser(invalidArguments);
            }
            case "report": {
                return new ReportCommandLineModeParser(invalidArguments);
            }
            case "pa": {
                return new PACommandLineModeParser(invalidArguments);
            }
            case "generate-bare-metal-agent": {
                return new GenerateBarmanCommandLineModeParser(invalidArguments);
            }
            case "import-itm": {
                return new ImportCommandLineModeParser(ImportFileType.ITM_DUMP, invalidArguments);
            }
            case "import-stm": {
                return new ImportCommandLineModeParser(ImportFileType.STPv2_DUMP, invalidArguments);
            }
            case "import-perf": {
                return new ImportCommandLineModeParser(ImportFileType.PERF_DATA, invalidArguments);
            }
            case "import-barman-raw": {
                return new ImportCommandLineModeParser(ImportFileType.BARMAN_RAW, invalidArguments);
            }
            case "import-apc-zip": {
                return new ImportCommandLineModeParser(ImportFileType.ZIP_APC, invalidArguments);
            }
            case "list-devices": {
                return new ListDevicesCommandLineModeParser(invalidArguments);
            }
            case "list-packages": {
                return new ListPackagesCommandLineModeParser(invalidArguments);
            }
        }
        invalidArguments.add(originalArg);
        return null;
    }

    protected static abstract class AbstractCommandLineModeParser {
        protected @Nullable String errorMessage;
        protected final @NonNull List<@NonNull String> invalidArguments;

        protected AbstractCommandLineModeParser(@NonNull List<@NonNull String> invalidArguments) {
            this.invalidArguments = invalidArguments;
        }

        public abstract int accept(@NonNull ICommandLineHandler var1, @NonNull List<@NonNull String> var2);

        public final boolean hasError() {
            return this.errorMessage != null;
        }

        public abstract @NonNull ConsumedArgs nextOption(@NonNull String var1, @NonNull String var2, @Nullable String var3, @Nullable String var4);

        protected final void error(@NonNull String message) {
            this.errorMessage = message;
        }

        protected final void invalid(@NonNull String originalArg) {
            this.invalidArguments.add(originalArg);
        }

        protected abstract boolean isLicensingRequired();

        protected boolean isLicensingError() {
            return false;
        }

        public static enum ConsumedArgs {
            BOTH,
            NEXT,
            NONE;

        }
    }

    protected static final class AnalyseCommandLineModeParser
    extends AbstractCommandLineModeParser {
        protected @NonNull ResolutionMode resolutionMode = ResolutionMode.NORMAL;

        public AnalyseCommandLineModeParser(@NonNull List<@NonNull String> invalidArguments) {
            super(invalidArguments);
        }

        @Override
        public int accept(@NonNull ICommandLineHandler handler, @NonNull List<@NonNull String> files) {
            return handler.analyze(this.resolutionMode, files);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public @NonNull AbstractCommandLineModeParser.ConsumedArgs nextOption(@NonNull String arg, @NonNull String originalArg, @Nullable String nextArg, String subsequentArg) {
            switch (arg) {
                case "resolution": {
                    String resolution;
                    if (nextArg == null) {
                        this.error(CmdLineMessages.MISSING_RESOLUTION);
                        return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                    }
                    switch (resolution = nextArg.toLowerCase()) {
                        case "summary": {
                            this.resolutionMode = ResolutionMode.SUMMARY;
                            return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                        }
                        case "normal": {
                            this.resolutionMode = ResolutionMode.NORMAL;
                            return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                        }
                        case "high": {
                            this.resolutionMode = ResolutionMode.HIGH;
                            return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                        }
                        case "ultra": {
                            this.resolutionMode = ResolutionMode.ULTRAHIGH;
                            return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                        }
                    }
                    this.error(CmdLineMessages.MISSING_RESOLUTION);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
            }
            this.invalid(originalArg);
            return AbstractCommandLineModeParser.ConsumedArgs.NONE;
        }

        @Override
        protected boolean isLicensingRequired() {
            return true;
        }
    }

    protected static final class CaptureCommandLineModeParser
    extends AbstractCommandLineModeParser {
        protected @Nullable String configPath;
        protected @Nullable Integer durationSeconds;
        protected @Nullable String outputPath;
        protected @Nullable String password;
        protected @Nullable String retrieveImagesRegex;
        protected boolean retrieveLibraries;
        protected @Nullable List<@NonNull String> templatePaths;
        protected @Nullable String username;
        protected @Nullable String androidPackageName;
        protected @Nullable String androidActivityName;
        protected @Nullable String androidPackageFlags;
        protected boolean cleanGatord;

        public CaptureCommandLineModeParser(@NonNull List<@NonNull String> invalidArguments) {
            super(invalidArguments);
        }

        @Override
        public int accept(@NonNull ICommandLineHandler handler, @NonNull List<@NonNull String> files) {
            return handler.capture(this.configPath, this.durationSeconds, this.retrieveLibraries, this.retrieveImagesRegex, this.username, this.password, this.templatePaths, this.outputPath, this.androidPackageName, this.androidActivityName, this.androidPackageFlags, files, this.cleanGatord);
        }

        @Override
        public @NonNull AbstractCommandLineModeParser.ConsumedArgs nextOption(@NonNull String arg, @NonNull String originalArg, @Nullable String nextArg, String subsequentArg) {
            switch (arg) {
                case "duration": {
                    if (nextArg != null) {
                        @NonNull String duration = nextArg.toLowerCase();
                        try {
                            int durationSeconds = Integer.parseInt(duration);
                            if (durationSeconds > 0) {
                                this.durationSeconds = durationSeconds;
                            } else {
                                this.error(CmdLineMessages.MISSING_DURATION_ARG);
                            }
                        }
                        catch (NumberFormatException a) {
                            this.error(CmdLineMessages.MISSING_DURATION_ARG);
                        }
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_DURATION_ARG);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "config": {
                    if (nextArg != null) {
                        this.configPath = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_CONFIG_PATH);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "template": {
                    if (nextArg != null) {
                        if (this.templatePaths == null) {
                            this.templatePaths = new ArrayList<String>();
                        }
                        if (this.templatePaths != null) {
                            this.templatePaths.add(nextArg);
                            return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                        }
                    } else {
                        this.error(CmdLineMessages.MISSING_TEMPLATE_PATH);
                        return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                    }
                }
                case "output": 
                case "o": {
                    if (nextArg != null) {
                        this.outputPath = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_OUTPUT_FILE);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "retrieve-image": {
                    if (nextArg != null) {
                        this.retrieveImagesRegex = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_REGEX);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "username": {
                    if (nextArg != null) {
                        this.username = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_STRING);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "password": {
                    if (nextArg != null) {
                        this.password = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_STRING);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "package": {
                    if (nextArg != null) {
                        this.androidPackageName = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_STRING);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "activity": {
                    if (nextArg != null) {
                        this.androidActivityName = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_STRING);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "activity-args": {
                    if (nextArg != null) {
                        this.androidPackageFlags = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_STRING);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "include-libs": {
                    this.retrieveLibraries = true;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "clean-gatord": {
                    this.cleanGatord = true;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
            }
            this.invalid(originalArg);
            return AbstractCommandLineModeParser.ConsumedArgs.NONE;
        }

        @Override
        protected boolean isLicensingRequired() {
            return true;
        }
    }

    protected static final class GenerateBarmanCommandLineModeParser
    extends AbstractCommandLineModeParser {
        protected @Nullable String configPath;
        protected @Nullable String eventsXmlPath;
        protected @Nullable String outputPath;
        protected @Nullable String pmusXmlPath;

        public GenerateBarmanCommandLineModeParser(@NonNull List<@NonNull String> invalidArguments) {
            super(invalidArguments);
        }

        @Override
        public int accept(@NonNull ICommandLineHandler handler, @NonNull List<@NonNull String> files) {
            return handler.generateBareMetalAgent(this.configPath, this.eventsXmlPath, this.pmusXmlPath, this.outputPath, files);
        }

        @Override
        public @NonNull AbstractCommandLineModeParser.ConsumedArgs nextOption(@NonNull String arg, @NonNull String originalArg, @Nullable String nextArg, String subsequentArg) {
            switch (arg) {
                case "config": 
                case "c": {
                    if (nextArg != null) {
                        this.configPath = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_BARMAN_CONFIG_PATH);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "events": 
                case "e": {
                    if (nextArg != null) {
                        this.eventsXmlPath = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_BARMAN_EVENTS_XML_PATH);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "output": 
                case "o": {
                    if (nextArg != null) {
                        this.outputPath = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_BARMAN_OUTPUT_PATH);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "p": 
                case "pmus": {
                    if (nextArg != null) {
                        this.pmusXmlPath = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_BARMAN_PMUS_XML_PATH);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
            }
            this.invalid(originalArg);
            return AbstractCommandLineModeParser.ConsumedArgs.NONE;
        }

        @Override
        protected boolean isLicensingRequired() {
            return true;
        }
    }

    protected static final class GenerateConfigCommandLineModeParser
    extends AbstractCommandLineModeParser {
        protected @Nullable String outputPath;
        protected @NonNull List<@NonNull String> templates = new ArrayList<String>();
        protected boolean includeDefault = false;

        public GenerateConfigCommandLineModeParser(@NonNull List<@NonNull String> invalidArguments) {
            super(invalidArguments);
        }

        @Override
        public int accept(@NonNull ICommandLineHandler handler, @NonNull List<@NonNull String> files) {
            if (this.templates.isEmpty()) {
                return handler.error(CmdLineMessages.CmdLineParser_GENERATE_CONFIG_MISSING_TEMPLATE);
            }
            if (files.size() < 1) {
                return handler.error(CmdLineMessages.CmdLineParser_GENERATE_CONFIG_MISSING_TARGET_ADDRESS);
            }
            if (files.size() > 1) {
                return handler.error(MessageFormat.format(CmdLineMessages.CmdLineParser_GENERATE_CONFIG_TOO_MANY_ARGUMENTS, files.subList(1, files.size()).stream().collect(Collectors.joining(" "))));
            }
            return handler.generateConfig(this.templates, new TargetAddressString(files.get(0)), this.outputPath, this.includeDefault);
        }

        @Override
        public @NonNull AbstractCommandLineModeParser.ConsumedArgs nextOption(@NonNull String arg, @NonNull String originalArg, @Nullable String nextArg, String subsequentArg) {
            switch (arg) {
                case "output": 
                case "o": {
                    if (nextArg != null) {
                        this.outputPath = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_OUTPUT_FILE);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "template": {
                    if (nextArg != null) {
                        this.templates.add(nextArg);
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_TEMPLATE_PATH);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "include-default": {
                    this.includeDefault = true;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
            }
            this.invalid(originalArg);
            return AbstractCommandLineModeParser.ConsumedArgs.NONE;
        }

        @Override
        protected boolean isLicensingRequired() {
            return true;
        }
    }

    protected static final class HelpCommandLineModeParser
    extends AbstractCommandLineModeParser {
        public HelpCommandLineModeParser(@NonNull List<@NonNull String> invalidArguments) {
            super(invalidArguments);
        }

        @Override
        public int accept(@NonNull ICommandLineHandler handler, @NonNull List<@NonNull String> files) {
            return handler.help(files);
        }

        @Override
        public @NonNull AbstractCommandLineModeParser.ConsumedArgs nextOption(@NonNull String arg, @NonNull String originalArg, @Nullable String nextArg, String subsequentArg) {
            return AbstractCommandLineModeParser.ConsumedArgs.NONE;
        }

        @Override
        protected boolean isLicensingRequired() {
            return false;
        }
    }

    public static interface ICommandLineHandler {
        public int analyze(@NonNull ResolutionMode var1, @NonNull List<@NonNull String> var2);

        public int capture(@Nullable String var1, @Nullable Integer var2, boolean var3, @Nullable String var4, @Nullable String var5, @Nullable String var6, @Nullable List<@NonNull String> var7, @Nullable String var8, @Nullable String var9, @Nullable String var10, String var11, @NonNull List<@NonNull String> var12, boolean var13);

        public int error(@NonNull String var1);

        public int generateBareMetalAgent(@Nullable String var1, @Nullable String var2, @Nullable String var3, @Nullable String var4, @NonNull List<@NonNull String> var5);

        public int generateConfig(@NonNull List<@NonNull String> var1, @NonNull TargetAddressString var2, @Nullable String var3, boolean var4);

        public int help(@NonNull List<@NonNull String> var1);

        public int importCapture(@NonNull ImportFileType var1, @Nullable String var2, @Nullable String var3, boolean var4, @Nullable String var5, @NonNull List<@NonNull String> var6);

        public int launchPA(@NonNull List<@NonNull String> var1);

        public int invalidArguments(@NonNull List<@NonNull String> var1);

        public int listDevices(@Nullable Integer var1);

        public int listPackages(@Nullable String var1, boolean var2, boolean var3);

        public int report(@Nullable String var1, @Nullable String var2, double var3, double var5, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11, boolean var12, boolean var13, boolean var14, boolean var15, boolean var16, @Nullable String var17, @NonNull Map<@NonNull String, @Nullable String> var18, @Nullable String var19, @NonNull Map<@NonNull String, @Nullable String> var20, @Nullable String var21, @Nullable String var22, @Nullable String var23, @Nullable String var24, @NonNull Map<@NonNull String, @Nullable String> var25, @NonNull Map<@NonNull String, @NonNull Pair<@Nullable String, @Nullable Set<@NonNull String>>> var26,  @NonNull ReportProcessor.Format var27, @Nullable String var28, @Nullable String var29, boolean var30, @Nullable List<@NonNull String> var31, @NonNull ValueReporting var32, @NonNull ZoomLevel var33, @Nullable String var34, @NonNull List<@NonNull String> var35, boolean var36);

        public int version(boolean var1);
    }

    protected static final class ImportCommandLineModeParser
    extends AbstractCommandLineModeParser {
        protected @Nullable String agentImagePath;
        protected @Nullable String barmanXmlInputPath;
        protected boolean importAsSynchronized;
        protected @Nullable String outputPath;
        protected final @NonNull ImportFileType type;

        public ImportCommandLineModeParser(@NonNull ImportFileType type, @NonNull List<@NonNull String> invalidArguments) {
            super(invalidArguments);
            this.type = type;
        }

        @Override
        public int accept(@NonNull ICommandLineHandler handler, @NonNull List<@NonNull String> files) {
            return handler.importCapture(this.type, this.agentImagePath, this.barmanXmlInputPath, this.importAsSynchronized, this.outputPath, files);
        }

        @Override
        public @NonNull AbstractCommandLineModeParser.ConsumedArgs nextOption(@NonNull String arg, @NonNull String originalArg, @Nullable String nextArg, String subsequentArg) {
            switch (arg) {
                case "barman-xml": {
                    if (nextArg != null) {
                        this.barmanXmlInputPath = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_BARMAN_XML_PATH);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "agent-image": {
                    if (nextArg != null) {
                        this.agentImagePath = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_AGENT_IMAGE_PATH);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "assume-sync": {
                    this.importAsSynchronized = true;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "output": 
                case "o": {
                    if (nextArg != null) {
                        this.outputPath = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_OUTPUT_DIRECTORY);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
            }
            this.invalid(originalArg);
            return AbstractCommandLineModeParser.ConsumedArgs.NONE;
        }

        @Override
        protected boolean isLicensingRequired() {
            return true;
        }
    }

    protected static final class ListDevicesCommandLineModeParser
    extends AbstractCommandLineModeParser {
        protected @Nullable Integer networkWaitSeconds;

        public ListDevicesCommandLineModeParser(@NonNull List<@NonNull String> invalidArguments) {
            super(invalidArguments);
        }

        @Override
        public int accept(@NonNull ICommandLineHandler handler, @NonNull List<@NonNull String> files) {
            return handler.listDevices(this.networkWaitSeconds);
        }

        @Override
        public @NonNull AbstractCommandLineModeParser.ConsumedArgs nextOption(@NonNull String arg, @NonNull String originalArg, @Nullable String nextArg, String subsequentArg) {
            switch (arg) {
                case "w": 
                case "wait": {
                    if (nextArg != null) {
                        @NonNull String networkWait = nextArg.toLowerCase();
                        try {
                            int networkWaitSeconds = Integer.parseInt(networkWait);
                            if (networkWaitSeconds > 0) {
                                this.networkWaitSeconds = networkWaitSeconds;
                            } else {
                                this.error(CmdLineMessages.CmdLine_POSITIVE_WAIT_ARG_REQUIRED);
                            }
                        }
                        catch (NumberFormatException a) {
                            this.error(CmdLineMessages.CmdLine_POSITIVE_WAIT_ARG_REQUIRED);
                        }
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.CmdLine_POSITIVE_WAIT_ARG_REQUIRED);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
            }
            this.invalid(originalArg);
            return AbstractCommandLineModeParser.ConsumedArgs.NONE;
        }

        @Override
        protected boolean isLicensingRequired() {
            return true;
        }
    }

    protected static final class ListPackagesCommandLineModeParser
    extends AbstractCommandLineModeParser {
        protected @Nullable String device;
        protected boolean showAllPackages = false;
        protected boolean showActivities = false;

        public ListPackagesCommandLineModeParser(@NonNull List<@NonNull String> invalidArguments) {
            super(invalidArguments);
        }

        @Override
        public int accept(@NonNull ICommandLineHandler handler, @NonNull List<@NonNull String> files) {
            return handler.listPackages(this.device, this.showAllPackages, this.showActivities);
        }

        @Override
        public @NonNull AbstractCommandLineModeParser.ConsumedArgs nextOption(@NonNull String arg, @NonNull String originalArg, @Nullable String nextArg, String subsequentArg) {
            switch (arg) {
                case "device": 
                case "d": {
                    if (nextArg != null) {
                        this.device = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.CmdLine_DEVICE_ARG_REQUIRED);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "a": 
                case "all": {
                    this.showAllPackages = true;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "activity": 
                case "t": {
                    this.showActivities = true;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
            }
            this.invalid(originalArg);
            return AbstractCommandLineModeParser.ConsumedArgs.NONE;
        }

        @Override
        protected boolean isLicensingRequired() {
            return true;
        }
    }

    protected static final class MissingLicensePermision
    extends AbstractCommandLineModeParser {
        protected MissingLicensePermision(@NonNull List<@NonNull String> invalidArguments, @NonNull String mode) {
            super(invalidArguments);
            this.error(MessageFormat.format(CmdLineMessages.NOT_SUPPORTED_WITH_LICENSE, "-" + mode));
        }

        @Override
        public int accept(@NonNull ICommandLineHandler handler, @NonNull List<@NonNull String> files) {
            throw new UnsupportedOperationException("This parser does nothing");
        }

        @Override
        public @NonNull AbstractCommandLineModeParser.ConsumedArgs nextOption(@NonNull String arg, @NonNull String originalArg, @Nullable String nextArg, String subsequentArg) {
            return AbstractCommandLineModeParser.ConsumedArgs.NONE;
        }

        @Override
        protected boolean isLicensingRequired() {
            return false;
        }

        @Override
        protected boolean isLicensingError() {
            return true;
        }
    }

    protected static final class PACommandLineModeParser
    extends AbstractCommandLineModeParser {
        public PACommandLineModeParser(@NonNull List<@NonNull String> invalidArguments) {
            super(invalidArguments);
        }

        @Override
        public int accept(@NonNull ICommandLineHandler handler, @NonNull List<@NonNull String> files) {
            return handler.launchPA(files);
        }

        @Override
        public @NonNull AbstractCommandLineModeParser.ConsumedArgs nextOption(@NonNull String arg, @NonNull String originalArg, @Nullable String nextArg, @Nullable String subsequentArg) {
            return AbstractCommandLineModeParser.ConsumedArgs.NONE;
        }

        @Override
        protected boolean isLicensingRequired() {
            return true;
        }
    }

    protected static final class ReportCommandLineModeParser
    extends AbstractCommandLineModeParser {
        static final String THREAD_SPECIFIER_OPTION = "thread";
        static final String PROCESS_SPECIFIER_OPTION = "process";
        protected @Nullable String bookmarkStart;
        protected @Nullable String bookmarkStop;
        protected final @NonNull Map<@NonNull String, @Nullable String> callPathSourcesAndNames = new HashMap<String, String>();
        protected final @NonNull Map<@NonNull String, @NonNull Pair<@Nullable String, @Nullable Set<@NonNull String>>> disasmSourcesAndImageNames = new HashMap<String, Pair<String, Set<String>>>();
        protected boolean averageHeatmapPerCore = true;
        protected boolean dumpAll;
        protected boolean dumpBookmarks;
        protected boolean dumpCallPaths;
        protected boolean dumpCams;
        protected boolean dumpFunctions;
        protected boolean dumpIndividualThreads;
        protected boolean dumpLog;
        protected boolean dumpOpenCL;
        protected boolean dumpTimeline;
        protected boolean dumpWarnings;
        protected @Nullable String filenameBookmarks;
        protected @Nullable String filenameCams;
        protected @Nullable String filenameLog;
        protected @Nullable String filenameOpenCL;
        protected @Nullable String filenameTimeline;
        protected @Nullable String filenameWarnings;
        protected  @NonNull ReportProcessor.Format format = ReportProcessor.Format.COMMAS;
        protected final @NonNull Map<@NonNull String, @Nullable String> functionSourcesAndNames = new HashMap<String, String>();
        protected final @NonNull Map<@NonNull String, @Nullable String> heatmapSourcesAndNames = new HashMap<String, String>();
        protected @Nullable String outputPath;
        protected @Nullable String processSpecifier;
        protected @Nullable String threadSpecifier;
        protected double start = -1.0;
        protected double stop = -1.0;
        protected @Nullable List<@NonNull String> templatePaths;
        protected @NonNull ValueReporting valueReporting = ValueReporting.AGGREGATE;
        protected @NonNull ZoomLevel zoomLevel = DEFAULT_ZOOM_LEVEL;
        protected boolean defaultTemplate = false;

        protected static @NonNull Pair<@NonNull String, @Nullable String> splitOptionalAssignmentArgument(@NonNull String arg) {
            int index = arg.indexOf(61);
            if (index < 0) {
                return new Pair((Object)arg, null);
            }
            @NonNull String option = arg.substring(0, index);
            @NonNull String value = arg.substring(index + 1);
            if (value.isEmpty()) {
                return new Pair((Object)option, null);
            }
            return new Pair((Object)option, (Object)value);
        }

        public ReportCommandLineModeParser(@NonNull List<@NonNull String> invalidArguments) {
            super(invalidArguments);
        }

        @Override
        public int accept(@NonNull ICommandLineHandler handler, @NonNull List<@NonNull String> files) {
            if (this.dumpIndividualThreads && this.processSpecifier == null) {
                return handler.error(CmdLineMessages.CmdLineParser_REPORT_INDIVIDUAL_THREADS_WITHOUT_PROCESS);
            }
            if (this.dumpIndividualThreads && !this.dumpAll && !this.dumpTimeline && !this.dumpCallPaths) {
                return handler.error(CmdLineMessages.CmdLineParser_REPORT_INDIVIDUAL_THREADS_WITHOUT_DUMP_TIMELINE_OR_CALLPATH);
            }
            return handler.report(this.bookmarkStart, this.bookmarkStop, this.start, this.stop, this.dumpAll, this.dumpBookmarks, this.dumpCallPaths, this.dumpCams, this.dumpFunctions, this.dumpIndividualThreads, this.dumpLog, this.dumpOpenCL, this.dumpTimeline, this.dumpWarnings, this.filenameBookmarks, this.callPathSourcesAndNames, this.filenameCams, this.functionSourcesAndNames, this.filenameLog, this.filenameOpenCL, this.filenameTimeline, this.filenameWarnings, this.heatmapSourcesAndNames, this.disasmSourcesAndImageNames, this.format, this.processSpecifier, this.threadSpecifier, this.defaultTemplate, this.templatePaths, this.valueReporting, this.zoomLevel, this.outputPath, files, this.averageHeatmapPerCore);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public @NonNull AbstractCommandLineModeParser.ConsumedArgs nextOption(@NonNull String arg, @NonNull String originalArg, @Nullable String nextArg, @Nullable String subsequentArg) {
            switch (arg) {
                case "all": {
                    this.dumpAll = true;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "start": {
                    if (nextArg != null) {
                        this.start = BasicNumberUtils.getNonLocalizedDouble((String)nextArg, (double)-1.0);
                        if (!(this.start < 0.0)) return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                        this.error(MessageFormat.format(CmdLineMessages.MISSING_TIME, originalArg));
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(MessageFormat.format(CmdLineMessages.MISSING_TIME, originalArg));
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "stop": {
                    if (nextArg != null) {
                        this.stop = BasicNumberUtils.getNonLocalizedDouble((String)nextArg, (double)-1.0);
                        if (!(this.stop < 0.0)) return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                        this.error(MessageFormat.format(CmdLineMessages.MISSING_TIME, originalArg));
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(MessageFormat.format(CmdLineMessages.MISSING_TIME, originalArg));
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "bstart": {
                    if (nextArg != null) {
                        this.bookmarkStart = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(MessageFormat.format(CmdLineMessages.MISSING_NAME, originalArg));
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "bstop": {
                    if (nextArg != null) {
                        this.bookmarkStop = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(MessageFormat.format(CmdLineMessages.MISSING_NAME, originalArg));
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "output": 
                case "o": {
                    if (nextArg != null) {
                        this.outputPath = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_OUTPUT_FILE);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "per-core": 
                case "per_core": {
                    this.valueReporting = ValueReporting.PER_CORE;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "heatmap-mode": {
                    if (nextArg != null) {
                        if ("average".contentEquals(nextArg)) {
                            this.averageHeatmapPerCore = true;
                            return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                        }
                        if ("total".contentEquals(nextArg)) {
                            this.averageHeatmapPerCore = false;
                            return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                        }
                    }
                    this.error(CmdLineMessages.MISSING_HEATMAP_MODE);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "template": {
                    if (nextArg != null) {
                        if (this.templatePaths == null) {
                            this.templatePaths = new ArrayList<String>();
                        }
                        if (this.templatePaths != null) {
                            this.templatePaths.add(nextArg);
                            return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                        }
                    }
                    this.error(CmdLineMessages.MISSING_TEMPLATE_PATH);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "default-template": {
                    this.defaultTemplate = true;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "scale": {
                    if (nextArg == null) {
                        this.error(MessageFormat.format(CmdLineMessages.INVALID_SCALE, originalArg));
                        return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                    }
                    int bps = BasicNumberUtils.getNonLocalizedInteger((String)nextArg, (int)-1);
                    if (bps < 0) {
                        this.error(MessageFormat.format(CmdLineMessages.INVALID_SCALE, originalArg));
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.zoomLevel = new ZoomLevel(bps);
                    return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                }
                case "format": {
                    if (nextArg == null) {
                        this.error(CmdLineMessages.MISSING_FORMAT);
                        return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                    }
                    switch (nextArg.toLowerCase()) {
                        case "csv": {
                            this.format = ReportProcessor.Format.COMMAS;
                            return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                        }
                        case "space": {
                            this.format = ReportProcessor.Format.SPACES;
                            return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                        }
                        case "tab": {
                            this.format = ReportProcessor.Format.TABS;
                            return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                        }
                    }
                    this.error(CmdLineMessages.MISSING_FORMAT);
                    return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                }
                case "process": {
                    if (nextArg != null) {
                        this.processSpecifier = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_PROCESS);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "thread": {
                    if (nextArg != null) {
                        this.threadSpecifier = nextArg;
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.error(CmdLineMessages.MISSING_THREAD);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
            }
            @NonNull Pair<@NonNull String, @Nullable String> optionAndValue = ReportCommandLineModeParser.splitOptionalAssignmentArgument(arg);
            switch ((String)optionAndValue.first) {
                case "function": {
                    this.dumpFunctions = true;
                    if (nextArg != null && CmdLineParser.extractOption(nextArg) == null) {
                        this.functionSourcesAndNames.put(nextArg, (String)optionAndValue.second);
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.functionSourcesAndNames.put("", (String)optionAndValue.second);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "callpath": {
                    this.dumpCallPaths = true;
                    if (nextArg != null && CmdLineParser.extractOption(nextArg) == null) {
                        this.callPathSourcesAndNames.put(nextArg, (String)optionAndValue.second);
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    this.callPathSourcesAndNames.put("", (String)optionAndValue.second);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "log": {
                    this.dumpLog = true;
                    this.filenameLog = (String)optionAndValue.second;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "individual-threads": {
                    this.dumpIndividualThreads = true;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "timeline": {
                    this.dumpTimeline = true;
                    this.filenameTimeline = (String)optionAndValue.second;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "cam": {
                    this.dumpCams = true;
                    this.filenameCams = (String)optionAndValue.second;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "opencl": {
                    this.dumpOpenCL = true;
                    this.filenameOpenCL = (String)optionAndValue.second;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "bookmarks": {
                    this.dumpBookmarks = true;
                    this.filenameBookmarks = (String)optionAndValue.second;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "heatmap": {
                    if (nextArg != null && CmdLineParser.extractOption(nextArg) == null) {
                        String heatmapSource = nextArg;
                        this.heatmapSourcesAndNames.put(heatmapSource, (String)optionAndValue.second);
                        return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                    }
                    @NonNull String heatmapSource = "CPU Activity";
                    this.heatmapSourcesAndNames.put(heatmapSource, (String)optionAndValue.second);
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
                case "disasm": {
                    @NonNull String filename = (String)NullChecking.neverNullOr((Object)((String)optionAndValue.second), (Object)"");
                    if (nextArg == null || nextArg.isEmpty() || CmdLineParser.extractOption(nextArg) != null) {
                        this.error(CmdLineMessages.MISSING_DISASM_IMAGES_SOURCE);
                        return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                    }
                    HashSet<String> imageNames = !"*".contentEquals(nextArg) ? new HashSet<String>(Arrays.asList(nextArg.split(","))) : null;
                    if (subsequentArg != null && CmdLineParser.extractOption(subsequentArg) == null) {
                        this.disasmSourcesAndImageNames.put(filename, (Pair<String, Set<String>>)new Pair((Object)subsequentArg, imageNames));
                        return AbstractCommandLineModeParser.ConsumedArgs.BOTH;
                    }
                    this.disasmSourcesAndImageNames.put(filename, (Pair<String, Set<String>>)new Pair(null, imageNames));
                    return AbstractCommandLineModeParser.ConsumedArgs.NEXT;
                }
                case "warnings": {
                    this.dumpWarnings = true;
                    this.filenameWarnings = (String)optionAndValue.second;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
            }
            this.invalid(originalArg);
            return AbstractCommandLineModeParser.ConsumedArgs.NONE;
        }

        @Override
        protected boolean isLicensingRequired() {
            return true;
        }
    }

    protected static final class VersionCommandLineModeParser
    extends AbstractCommandLineModeParser {
        private boolean detailed = false;

        public VersionCommandLineModeParser(@NonNull List<@NonNull String> invalidArguments) {
            super(invalidArguments);
        }

        @Override
        public int accept(@NonNull ICommandLineHandler handler, @NonNull List<@NonNull String> files) {
            if (!files.isEmpty()) {
                return handler.invalidArguments(files);
            }
            return handler.version(this.detailed);
        }

        @Override
        public @NonNull AbstractCommandLineModeParser.ConsumedArgs nextOption(@NonNull String arg, @NonNull String originalArg, @Nullable String nextArg, String subsequentArg) {
            switch (arg) {
                case "detailed": {
                    this.detailed = true;
                    return AbstractCommandLineModeParser.ConsumedArgs.NONE;
                }
            }
            this.invalid(originalArg);
            return AbstractCommandLineModeParser.ConsumedArgs.NONE;
        }

        @Override
        protected boolean isLicensingRequired() {
            return false;
        }
    }
}

