/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.cmdline;

import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.cmdline.CmdLineMessages;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.counterconfig.ImportTemplateAction;
import com.arm.streamline.counterconfig.model.CounterConfiguration;
import com.arm.streamline.databrowser.AndroidDeviceGatordManager;
import com.arm.streamline.databrowser.GatorSendCommandUtility;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.databrowser.IGatordInstallUninstall;
import com.arm.streamline.databrowser.ILiveCapture;
import com.arm.streamline.databrowser.IdleTargetXml;
import com.arm.streamline.databrowser.NullConfigurer;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.databrowser.TargetLauncher;
import com.arm.streamline.databrowser.browser.AdbTargetBrowser;
import com.arm.streamline.databrowser.browser.BrowseResult;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.adb.utils.AdbInstalledPackage;
import com.arm.streamline.deviceconn.adb.utils.AdbPackageEnumeration;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.model.live.LiveCaptureDataProvider;
import com.arm.streamline.model.session.GpuTimelineLayerDriver;
import com.arm.streamline.model.session.Session;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.streamline.model.templates.TemplatePath;
import com.arm.streamline.utility.AdbRunnerFactory;
import com.arm.streamline.utility.target.CredentialsAddress;
import com.arm.streamline.utility.target.SimpleCredentials;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import gnu.trove.set.TIntSet;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.BooleanSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CaptureProcessor
implements ICaptureProxy {
    protected final @NonNull CountDownLatch mDone = new CountDownLatch(1);
    private int mDuration = -1;
    private StringBuilder mErrorMsg = new StringBuilder();
    private static final @NonNull Runnable EMPTY_RUNNABLE = () -> {};

    @Override
    public void captureError(String msg) {
        if (this.mErrorMsg.length() > 0) {
            this.mErrorMsg.append('\n');
        }
        this.mErrorMsg.append(msg);
        this.mDone.countDown();
    }

    @Override
    public void captureError(Throwable t) {
        String message = t.getMessage();
        if (message == null || message.isEmpty()) {
            message = CmdLineMessages.UNKNOWN_ERROR;
        }
        this.captureError(message);
    }

    @Override
    public void captureFinished(boolean isDiscarded) {
        this.mDone.countDown();
    }

    @Override
    public void captureStarted(ILiveCapture doc, LiveCaptureDataProvider live, IPreferences settings, boolean discard) {
    }

    @Override
    public void captureStopped(@NonNull ILiveCapture doc, boolean discard) {
        if (!discard) {
            System.err.println(MessageFormat.format(CmdLineMessages.FINISHED, doc.getApcDirectory()));
        }
    }

    public int getDuration() {
        return this.mDuration;
    }

    @Override
    public void liveError(String msg) {
    }

    @Override
    public void liveWarning(WarningItem warning) {
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public static void generateConfiguration(@NonNull List<@NonNull String> templates, @NonNull TargetAddressString targetAddress, @Nullable String outputPath, boolean includeDefault) throws IOException {
        block20: {
            Throwable throwable = null;
            Object var5_6 = null;
            try (IdleTargetXml targetXml = new IdleTargetXml(targetAddress);){
                CounterConfiguration config = new CounterConfiguration(targetXml, includeDefault);
                for (String template : templates) {
                    CaptureProcessor.addTemplate(config, template);
                }
                if (outputPath != null) {
                    Throwable throwable2 = null;
                    Iterator<String> iterator = null;
                    try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(new File(outputPath)));){
                        config.getConfigurations().save(output);
                        break block20;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                config.save(false);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    private static @NonNull String getMainActivity(@NonNull IAdbCommandRunner adbCommandRunner, @NonNull String packageName) throws Exception {
        BooleanSupplier notCancelled = () -> true;
        AdbInstalledPackage packageDetails = new AdbPackageEnumeration(adbCommandRunner, notCancelled).discoverSinglePackage(packageName);
        Set mainActivities = packageDetails.getMainActivities();
        if (mainActivities.size() == 0) {
            throw new Exception(CmdLineMessages.ANDROID_PACKAGE_NO_MAIN);
        }
        if (mainActivities.size() > 2) {
            throw new Exception(CmdLineMessages.ANDROID_PACKAGE_MULTIPLE_MAIN);
        }
        return (String)mainActivities.iterator().next();
    }

    private static boolean isGatorAlreadyRunning(@NonNull IAdbProcessRunner adbProcessRunner, @NonNull TargetAddressString targetAddressString) throws Exception {
        AdbTargetBrowser targetBrowser = new AdbTargetBrowser(adbProcessRunner);
        BrowseResult browseResult = targetBrowser.browseOne(targetAddressString);
        return browseResult != null && browseResult.isGatorRunning();
    }

    private static @NonNull IAndroidDeviceManager pushGatordToTargetIfNecessary(@NonNull IAdbProcessRunner adbProcessRunner, @NonNull TargetAddressString targetAddressString, @Nullable String packageName, @Nullable String activityName, @Nullable String activityArgs, boolean cleanGatord, boolean captureLog, @NonNull GpuTimelineLayerDriver gpuTimelineLayerDriverStatus) throws Exception {
        IAndroidDeviceManager doNothing = new IAndroidDeviceManager(){

            @Override
            public void installGatord() {
            }

            @Override
            public void cleanUp() {
            }
        };
        if (!targetAddressString.isAndroid()) {
            if (packageName != null) {
                throw new Exception(CmdLineMessages.PACKAGE_NOT_APPLICABLE);
            }
            return doNothing;
        }
        IAdbCommandRunner adbCommandRunner = AdbRunnerFactory.SINGLETON.create(adbProcessRunner, targetAddressString.getAndroidSerialNumber());
        AdbDeviceRootMode deviceRootMode = adbCommandRunner.detectRootMode();
        IAdbCommandRunner.WrapMode wrapMode = IAdbCommandRunner.rootWrapModeOrDefault((AdbDeviceRootMode)deviceRootMode);
        if (CaptureProcessor.isGatorAlreadyRunning(adbProcessRunner, targetAddressString)) {
            if (packageName == null) {
                return doNothing;
            }
            if (!cleanGatord) {
                throw new Exception(CmdLineMessages.GATORD_ALREADY_RUNNING);
            }
        } else {
            if (packageName == null) {
                throw new Exception(CmdLineMessages.NO_ANDROID_PACKAGE);
            }
            if (cleanGatord) {
                System.err.println("Gatord is not currently running on target, Ignoring -clean-gatord.");
            }
        }
        AndroidDeviceGatordManager gatordManager = new AndroidDeviceGatordManager(adbCommandRunner, wrapMode, gpuTimelineLayerDriverStatus);
        String activityNameToUse = activityName == null ? CaptureProcessor.getMainActivity(adbCommandRunner, packageName) : activityName;
        ArrayList<String> gatorArgs = new ArrayList<String>(Arrays.asList("--android-pkg", packageName, "--android-activity", activityNameToUse, "-p", "uds"));
        if (activityArgs != null) {
            gatorArgs.add("--activity-args");
            gatorArgs.add(activityArgs);
        }
        if (captureLog) {
            gatorArgs.add("--capture-log");
        }
        final IGatordInstallUninstall installUninstall = gatordManager.getGatordInstallUninstall(new NullConfigurer(), (String[])gatorArgs.toArray(String[]::new));
        NullProgressMonitor monitor = new NullProgressMonitor(){

            public void subTask(String task) {
                System.out.println(task);
            }
        };
        return new IAndroidDeviceManager(monitor){
            private final /* synthetic */ 2 val$monitor;
            {
                this.val$monitor = var2_2;
            }

            @Override
            public void installGatord() {
                try {
                    installUninstall.getInstaller().run((IProgressMonitor)this.val$monitor);
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
            }

            @Override
            public void cleanUp() throws IOException {
                try {
                    installUninstall.getUninstaller().run((IProgressMonitor)this.val$monitor);
                }
                catch (InvocationTargetException e) {
                    e.getCause().printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    public void start(@NonNull List<@NonNull String> files, String configPath, @Nullable List<@NonNull String> templatePaths, String outputPath, String retrieveImagesRegex, boolean retrieveLibraries, String username, String password, @Nullable String androidPackageName, @Nullable String androidActivityName, @Nullable String androidActivityArgs, boolean cleanGatord) throws Exception {
        @NonNull AdbRunnerFactory adbRunnerFactory = AdbRunnerFactory.SINGLETON;
        if (files.isEmpty()) {
            throw new Exception(CmdLineMessages.NO_FILES_ERROR);
        }
        if (files.size() > 1) {
            throw new Exception(CmdLineMessages.TOO_MANY_FILES_ERROR);
        }
        try {
            File sessionFile = new File(files.get(0));
            Session session = null;
            try {
                if (!sessionFile.canRead()) {
                    throw new Exception(CmdLineMessages.CANNOT_READ_SESSION_XML);
                }
                session = new Session(sessionFile, false);
            }
            catch (IOException e) {
                throw new Exception(CmdLineMessages.INVALID_SESSION_XML);
            }
            if (!session.getTargetAddress().isValid()) {
                throw new Exception(CmdLineMessages.INVALID_SESSION_XML);
            }
            File adb = StreamlinePreferences.getApplicationPreferences().getAdbPathOrDefault();
            if (adb == null) {
                throw new Exception(CmdLineMessages.ADB_NOT_FOUND);
            }
            IAdbProcessRunner adbProcessRunner = AdbRunnerFactory.SINGLETON.create(adb);
            if (androidActivityArgs != null && (androidPackageName == null || androidActivityName == null)) {
                throw new Exception(CmdLineMessages.ACTIVITY_FLAGS_SPECIFIED_WITHOUT_PACKAGE_OR_ACTIVITY);
            }
            final IAndroidDeviceManager deviceManager = CaptureProcessor.pushGatordToTargetIfNecessary(adbProcessRunner, session.getTargetAddress(), androidPackageName, androidActivityName, androidActivityArgs, cleanGatord, session.isCaptureLogFileEnabled(), session.getGpuTimelineLayerDriver());
            @NonNull IPreferences appSettings = StreamlinePreferences.getApplicationPreferences();
            if (androidPackageName != null && cleanGatord && CaptureProcessor.isGatorAlreadyRunning(adbProcessRunner, session.getTargetAddress())) {
                GatorSendCommandUtility.useGatorTarget(session.getTargetAddress(), adbRunnerFactory.tryCreate(appSettings.getAdbPathOrDefault(), session.getTargetAddress().isAndroid()), true, gatorTarget -> {
                    gatorTarget.sendExitOk();
                    return null;
                }, 1000, 500L);
            }
            deviceManager.installGatord();
            if (templatePaths != null || configPath != null) {
                Throwable ioe = null;
                Object var21_26 = null;
                try (IdleTargetXml targetXml = new IdleTargetXml(session.getTargetAddress());){
                    CounterConfiguration config = new CounterConfiguration(targetXml, false);
                    if (configPath != null) {
                        config.importConfig(configPath);
                    }
                    if (templatePaths != null) {
                        for (String templatePath : templatePaths) {
                            CaptureProcessor.addTemplate(config, templatePath);
                        }
                    }
                    config.save(true);
                }
                catch (Throwable throwable) {
                    if (ioe == null) {
                        ioe = throwable;
                    } else if (ioe != throwable) {
                        ioe.addSuppressed(throwable);
                    }
                    throw ioe;
                }
            }
            if (this.mDuration > -1) {
                session.setDurationLimit(this.mDuration);
            }
            if (session.getDurationLimitInSecs() > 0) {
                System.err.println(MessageFormat.format(CmdLineMessages.TIMED_STARTING, NumberUtils.formatTime((double)session.getDurationLimitInSecs())));
            } else {
                System.err.println(CmdLineMessages.STARTING);
            }
            System.err.println(CmdLineMessages.CaptureProcessor_HOW_TO_STOP_OR_DISCARD);
            if (retrieveImagesRegex != null && !retrieveImagesRegex.isEmpty()) {
                session.setRetrieveImageRegex(retrieveImagesRegex);
                session.setRetrieveLibraries(retrieveLibraries);
                session.setCommandlineCredentials(new SimpleCredentials(new CredentialsAddress(session.getTargetAddress()), username, password, null));
            }
            if (outputPath == null) {
                outputPath = (String)NullChecking.neverNull((Object)new File(sessionFile.getParent(), FilePath.getLeafName((String)sessionFile.getName(), (boolean)false) + ".apc").getAbsolutePath());
            }
            final TargetLauncher launcher = new TargetLauncher(session, outputPath, appSettings, EMPTY_RUNNABLE);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (CaptureProcessor.this.mDone.getCount() > 0L) {
                        System.err.println(CmdLineMessages.STOPPING);
                        launcher.stopAndWait();
                        try {
                            CaptureProcessor.this.mDone.await();
                        }
                        catch (InterruptedException exception) {
                            return;
                        }
                    }
                    try {
                        deviceManager.cleanUp();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            Task.executeAsynchronously((String)"target launcher", (Runnable)launcher.getRunnableWith(this));
            Task.executeAsynchronously((String)"stdin handler", () -> {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(System.in));){
                        String line;
                        while ((line = in.readLine()) != null) {
                            if (line.equals("stop")) {
                                launcher.stop(false);
                                continue;
                            }
                            if (!line.equals("discard")) continue;
                            launcher.stop(true);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            });
            this.mDone.await();
        }
        catch (InterruptedException sessionFile) {
        }
        catch (Exception exception) {
            this.captureError(exception);
        }
        if (this.mErrorMsg.length() > 0) {
            throw new Exception(this.mErrorMsg.toString());
        }
    }

    private static void addTemplate(@NonNull CounterConfiguration config, @NonNull String template) throws IOException {
        TemplatePath path = TemplatePath.resolveTemplatePath(template);
        TemplateFile templateFile = new TemplateFile(path, (Map<String, TIntSet>)config.getEvents().getSourceToClusterIdMap());
        Pair<String, String> warning = ImportTemplateAction.addTemplate(config, templateFile);
        if (warning != null) {
            System.err.println(String.format((String)warning.first, warning.second));
        }
    }

    @Override
    public void stopLiveRequestSend() {
    }

    private static interface IAndroidDeviceManager {
        public void installGatord();

        public void cleanUp() throws IOException;
    }
}

