/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.capture.apc;

import com.arm.streamline.analysis.session.IFrameAddress;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class APCFrameAddress
implements IFrameAddress<APCFrameAddress> {
    public static final @NonNull APCFrameAddress DUMMY = new APCFrameAddress("", -1L, -1);
    private static final String ATTR_PATH = "path";
    private static final String ATTR_POS = "pos";
    private static final String ATTR_SIZE = "size";
    private final long mBufPos;
    private final int mFrameSize;
    private final @NonNull String mPath;

    public static @NonNull APCFrameAddress read(@NonNull XMLParser in) {
        return new APCFrameAddress((String)NullChecking.neverNull((Object)in.getAttribute(ATTR_PATH)), in.getLongAttribute(ATTR_POS), in.getIntegerAttribute(ATTR_SIZE));
    }

    public APCFrameAddress(@NonNull String path, long bufPos, int frameSize) {
        this.mPath = path;
        this.mBufPos = bufPos;
        this.mFrameSize = frameSize;
    }

    public int compareTo(APCFrameAddress rhs) {
        int result = this.mPath.compareTo(rhs.getPath());
        if (result != 0) {
            return result;
        }
        return Long.compare(this.mBufPos, rhs.getFrameOffset());
    }

    public boolean equals(Object obj) {
        if (obj instanceof APCFrameAddress) {
            APCFrameAddress that = (APCFrameAddress)obj;
            return this.mPath.equals(that.getPath()) && this.mBufPos == that.getFrameOffset() && this.mFrameSize == that.getFrameSize();
        }
        return false;
    }

    public long getFrameOffset() {
        return this.mBufPos;
    }

    public int getFrameSize() {
        return this.mFrameSize;
    }

    public @NonNull String getPath() {
        return this.mPath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.mBufPos ^ this.mBufPos >>> 32);
        result = 31 * result + this.mFrameSize;
        result = 31 * result + this.mPath.hashCode();
        return result;
    }

    public boolean isDummy() {
        return this.equals(DUMMY);
    }

    public boolean isSetupFrame() {
        return false;
    }

    public String toString() {
        return this.mPath + " " + this.mBufPos + " " + this.mFrameSize;
    }

    public void write(XMLGenerator xml) throws IOException {
        xml.addAttribute(ATTR_PATH, new File(this.getPath()).getName());
        xml.addAttribute(ATTR_POS, this.getFrameOffset());
        xml.addAttribute(ATTR_SIZE, this.getFrameSize());
    }
}

