/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.CustomChart;
import com.arm.streamline.barmancfg.wizard.BarmanWizardMessages;
import com.arm.streamline.barmancfg.wizard.custcounters.CustomChartWidget;
import com.arm.streamline.common.utility.io.StdLog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BarmanAddCustomCountersPage
extends WizardPage {
    public static final String PAGE_NAME = "PAGE_4";
    public static final String PAGE_TITLE = BarmanWizardMessages.PAGE_4_TITLE;
    private final @NonNull List<@NonNull CustomChartWidget> customChartWidgets = new ArrayList<CustomChartWidget>();
    private final @NonNull BarmanConfiguration defaults;

    public BarmanAddCustomCountersPage(@NonNull BarmanConfiguration defaults) {
        super(PAGE_NAME, PAGE_TITLE, null);
        this.defaults = defaults;
        if (defaults.getCustomCharts().size() > 1) {
            StdLog.warning((Plugin)StreamlinePlugin.getInstance(), (String)BarmanWizardMessages.PAGE_4_ERROR_IGNORING_ADDITIONAL_CHARTS, null);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(0, 0).applyTo(composite);
        Button button = new Button(composite, 32);
        button.setText(BarmanWizardMessages.PAGE_4_LABEL_ENABLE_CUSTOM_COUNTERS);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)button);
        CustomChart customChart = this.defaults.getCustomCharts().isEmpty() ? null : this.defaults.getCustomCharts().get(0);
        CustomChartWidget widget = new CustomChartWidget(composite, customChart, (c, v) -> this.setPageComplete(v));
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).grab(true, true).applyTo((Control)widget);
        button.setSelection(!this.defaults.getCustomCharts().isEmpty());
        button.addListener(13, e -> {
            if (button.getSelection()) {
                widget.setVisible(true);
                this.setPageComplete(widget.isValid());
            } else {
                widget.setVisible(false);
                this.setPageComplete(true);
            }
        });
        widget.setVisible(button.getSelection());
        this.setControl((Control)composite);
        this.setPageComplete(!button.getSelection() || button.getSelection() && widget.isValid());
        this.customChartWidgets.add(widget);
    }

    public @Nullable List<@NonNull CustomChart> getCustomCharts() {
        ArrayList<@NonNull CustomChart> result = new ArrayList<CustomChart>();
        for (CustomChartWidget widget : this.customChartWidgets) {
            CustomChart chart = widget.getCustomChart();
            if (chart == null) {
                return null;
            }
            result.add(chart);
        }
        return result;
    }
}

