/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.gen.header;

import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.BarmanProcessorConfiguration;
import com.arm.streamline.barmancfg.gen.header.IBarmanHeaderGenerator;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.utils.NullChecking;
import java.util.HashSet;
import org.eclipse.jdt.annotation.NonNull;

public class PmuConstantsGenerator
implements IBarmanHeaderGenerator {
    public static final String TOKEN = "PMU_CONSTANTS";

    @Override
    public @NonNull String generate(@NonNull String token, @NonNull BarmanConfiguration configuration) {
        HashSet<String> seenPmuNames = new HashSet<String>();
        HashSet<String> duplicatedPmuNames = new HashSet<String>();
        for (BarmanProcessorConfiguration processor : configuration.getProcessors()) {
            ProcessorPmu pmu = processor.getProcessorPmu();
            int[] nArray = pmu.getCpuids();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int cpuId = nArray[n2];
                if (!seenPmuNames.add(pmu.getConstantName(false, cpuId))) {
                    duplicatedPmuNames.add(pmu.getConstantName(false, cpuId));
                }
                ++n2;
            }
        }
        StringBuilder result = new StringBuilder();
        result.append("/**\n");
        result.append(" * @brief Enumerates all the supported processor CPUID values.\n");
        result.append(" */\n");
        result.append("enum barman_processor_cpuids {\n");
        boolean firstEnum = true;
        for (BarmanProcessorConfiguration processor : configuration.getProcessors()) {
            ProcessorPmu pmu = processor.getProcessorPmu();
            if (!firstEnum) {
                result.append(",\n");
            }
            int[] nArray = pmu.getCpuids();
            int n = nArray.length;
            int n3 = 0;
            while (n3 < n) {
                int cpuId = nArray[n3];
                firstEnum = false;
                boolean isDuplicated = duplicatedPmuNames.contains(pmu.getConstantName(false, cpuId));
                result.append(String.format("    /** %s */\n", pmu.getCoreName()));
                result.append(String.format("    %s = 0x%x", pmu.getConstantName(isDuplicated, cpuId), cpuId));
                ++n3;
            }
        }
        if (!firstEnum) {
            result.append("\n");
        }
        result.append("};\n");
        return (String)NullChecking.neverNull((Object)result.toString());
    }
}

