/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.gen.header;

import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.DWTConfiguration;
import com.arm.streamline.barmancfg.configuration.ITMBackendConfiguration;
import com.arm.streamline.barmancfg.configuration.STMBackendConfiguration;
import com.arm.streamline.barmancfg.configuration.StreamingConfiguration;
import com.arm.utils.NullChecking;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CompileTimeConstantsGenerator {
    private static void appendDefine(@NonNull Map<@NonNull String, String> map, @NonNull String name, boolean value) {
        CompileTimeConstantsGenerator.appendDefine(map, name, value ? "1" : "0");
    }

    private static void appendDefine(@NonNull Map<@NonNull String, String> map, @NonNull String name, int value) {
        CompileTimeConstantsGenerator.appendDefine(map, name, (String)NullChecking.neverNull((Object)String.valueOf(value)));
    }

    private static void appendDefine(@NonNull Map<@NonNull String, String> map, @NonNull String name, long value) {
        CompileTimeConstantsGenerator.appendDefine(map, name, (String)NullChecking.neverNull((Object)String.valueOf(value)));
    }

    private static void appendDefine(@NonNull Map<@NonNull String, String> map, @NonNull String name, @NonNull String value) {
        map.put(name, value);
    }

    public static @NonNull Map<@NonNull String, String> generate(@NonNull BarmanConfiguration configuration) {
        DWTConfiguration dwtConfig;
        ITMBackendConfiguration itmConfig;
        StreamingConfiguration streamingConfig;
        HashMap<@NonNull String, String> result = new HashMap<String, String>();
        CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_ENABLE_LOGGING", configuration.getConfigSettings().isEnableLogging());
        CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_ENABLE_DEBUG_LOGGING", configuration.getConfigSettings().isEnableDebugLogging());
        CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_ENABLE_BUILTIN_MEMFUNCS", configuration.getConfigSettings().isEnableBuiltinMemFuncs());
        CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_MAX_CORES", configuration.getConfigSettings().getMaxCores());
        CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_MAX_MMAP_LAYOUTS", configuration.getConfigSettings().getMaxMmapLayoutEntries());
        CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_MAX_TASK_INFOS", configuration.getConfigSettings().getMaxTaskEntries());
        CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_MIN_SAMPLE_PERIOD", configuration.getConfigSettings().getMinimumSamplePeriod());
        CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_USE_DATASTORE", configuration.getDataStorageBackend().getConstant());
        CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_NUM_PMU_TYPES", configuration.getProcessors().size());
        @Nullable STMBackendConfiguration stmConfig = configuration.getStmConfiguration();
        if (stmConfig != null) {
            CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_STM_MIN_CHANNEL_NUMBER", stmConfig.getMinChannelNumber());
            CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_STM_NUMBER_OF_CHANNELS", stmConfig.getNumberOfChannels());
        }
        if ((streamingConfig = configuration.getStreamingConfiguration()) != null) {
            CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_RECORDS_PER_HEADER_SENT", streamingConfig.getHeaderEveryNRecords());
        }
        if ((itmConfig = configuration.getITMConfiguration()) != null) {
            CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_ITM_MIN_PORT_NUMBER", itmConfig.getPortNumber());
            CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_ITM_NUMBER_OF_PORTS", itmConfig.getNumPortsUsed());
        }
        if ((dwtConfig = configuration.getDWTConfiguration()) != null) {
            CompileTimeConstantsGenerator.appendDefine(result, "BM_CONFIG_DWT_SAMPLE_PERIOD", dwtConfig.getPCSamplingPeriod());
        }
        return result;
    }
}

