/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg;

import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.gen.HeaderGenerator;
import com.arm.streamline.barmancfg.gen.SourceGenerator;
import com.arm.streamline.barmancfg.preprocessor.AbstractCFileResource;
import com.arm.streamline.barmancfg.preprocessor.javaresources.CFileResourceLocator;
import com.arm.streamline.barmancfg.xml.BarmanConfigurationXML;
import com.arm.streamline.common.utility.CommonResources;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.common.xml.pmus.ProcessorPmuEventDescription;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BarmanGenerator {
    public static final @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    ProcessorPmu.ArchitectureProfile> BARE_METAL_ALL_VALID_CLASSIFICATIONS = BarmanGenerator.makeClassificationSet(ProcessorPmu.ArchitectureProfile::isValidForBareMetal);
    public static final @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    ProcessorPmu.ArchitectureProfile> BARE_METAL_IN_MEMORY_CLASSIFICATIONS = BarmanGenerator.makeClassificationSet(ProcessorPmu.ArchitectureProfile::isValidForBareMetalInMemoryBuffer);
    public static final @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    ProcessorPmu.ArchitectureProfile> BARE_METAL_ITM_CLASSIFICATIONS = BarmanGenerator.makeClassificationSet(ProcessorPmu.ArchitectureProfile::isValidForBareMetalITMStream);
    public static final @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    ProcessorPmu.ArchitectureProfile> BARE_METAL_STM_CLASSIFICATIONS = BarmanGenerator.makeClassificationSet(ProcessorPmu.ArchitectureProfile::isValidForBareMetalSTMStream);
    public static final @NonNull String BARMAN_C = "barman.c";
    public static final @NonNull String BARMAN_H = "barman.h";
    public static final @NonNull String BARMAN_IN_MEMORY_HELPERS_PY = "barman_in_memory_helpers.py";
    public static final @NonNull String BARMAN_XML = "barman.xml";
    private static final @NonNull String BARMAN_SCRIPT_RESOURCE_PATH = "/resources/";
    private static final @NonNull List<@NonNull String> RESOURCE_SEARCH_PATH = (List)NullChecking.neverNull(Arrays.asList("/resources/", "/resources/sources/"));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void generateBarmanFiles(boolean generateSources, boolean saveConfig, @NonNull BarmanConfiguration configuration, @NonNull File outputPath) throws IOException {
        File barmanHFile = new File(outputPath, BARMAN_H);
        File barmanCFile = new File(outputPath, BARMAN_C);
        try {
            if (saveConfig) {
                BarmanConfigurationXML.writeXmlFile(configuration, new File(outputPath, BARMAN_XML));
            }
            if (!generateSources) return;
            HeaderGenerator headerGenerator = new HeaderGenerator();
            SourceGenerator sourceGenerator = new SourceGenerator();
            CFileResourceLocator locator = new CFileResourceLocator(BarmanGenerator.class, RESOURCE_SEARCH_PATH);
            HashSet<@NonNull AbstractCFileResource> hIncludes = new HashSet<AbstractCFileResource>();
            String hSource = headerGenerator.doProcessing(configuration, locator, hIncludes);
            String cSource = sourceGenerator.doProcessing(configuration, locator, hIncludes);
            BarmanGenerator.writeFile(barmanHFile, hSource);
            BarmanGenerator.writeFile(barmanCFile, cSource);
            String barmanHelperScriptName = configuration.getDataStorageBackend().getHelperScriptName();
            if (barmanHelperScriptName == null) return;
            File barmanETMScriptFile = new File(outputPath, barmanHelperScriptName);
            Throwable throwable = null;
            Object var15_17 = null;
            try {
                InputStream inputStream = BarmanGenerator.class.getResourceAsStream(BARMAN_SCRIPT_RESOURCE_PATH + barmanHelperScriptName);
                try {
                    try (FileOutputStream outputStream = new FileOutputStream(barmanETMScriptFile);){
                        int length;
                        if (inputStream == null) {
                            throw new IOException("Barman script resource not found");
                        }
                        byte[] buffer = new byte[65536];
                        while ((length = inputStream.read(buffer)) >= 0) {
                            if (length <= 0) continue;
                            ((OutputStream)outputStream).write(buffer, 0, length);
                        }
                    }
                    if (inputStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            barmanHFile.delete();
            barmanCFile.delete();
            throw e;
        }
    }

    public static @NonNull Map<@NonNull Integer, @NonNull ProcessorPmu> getProcessorPmuConfigurations(@Nullable String pmusXmlPath, @Nullable String eventsXmlPath, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    ProcessorPmu.ArchitectureProfile> allowedClassifications) throws IOException {
        FileInputStream pmusInputStream = null;
        FileInputStream eventsInputStream = null;
        try {
            pmusInputStream = pmusXmlPath != null ? new FileInputStream(pmusXmlPath) : null;
            eventsInputStream = eventsXmlPath != null ? new FileInputStream(eventsXmlPath) : null;
            Map<Integer, ProcessorPmu> map = BarmanGenerator.getProcessorPmuConfigurations(pmusInputStream, eventsInputStream, allowedClassifications);
            return map;
        }
        finally {
            if (pmusInputStream != null) {
                try {
                    ((InputStream)pmusInputStream).close();
                }
                catch (Throwable throwable) {}
            }
            if (eventsInputStream != null) {
                try {
                    ((InputStream)eventsInputStream).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static @NonNull Map<Integer, ProcessorPmu> getProcessorPmuConfigurations(@NonNull String barmanConfigPath, @Nullable String barmanPmusXmlPath, @Nullable String barmanEventsXmlPath, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    ProcessorPmu.ArchitectureProfile> allowedClassifications) throws IOException {
        if (barmanPmusXmlPath == null || barmanEventsXmlPath == null) {
            BarmanConfigurationXML.EventsAndPmusXmlPaths eventsAndPmusXmlPaths = BarmanConfigurationXML.getEventsAndPmusXmlPaths(barmanConfigPath);
            if (barmanPmusXmlPath == null) {
                barmanPmusXmlPath = eventsAndPmusXmlPaths.pmusXmlPath;
            }
            if (barmanEventsXmlPath == null) {
                barmanEventsXmlPath = eventsAndPmusXmlPaths.eventsXmlPath;
            }
        }
        return BarmanGenerator.getProcessorPmuConfigurations(barmanPmusXmlPath, barmanEventsXmlPath, allowedClassifications);
    }

    private static @NonNull Map<@NonNull Integer, @NonNull ProcessorPmu> filterInvalidProcessors(@NonNull Map<@NonNull Integer, @NonNull ProcessorPmu> pmusMap, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    ProcessorPmu.ArchitectureProfile> allowedClassifications) {
        Iterator<Map.Entry<Integer, ProcessorPmu>> iterator = pmusMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, ProcessorPmu> entry = iterator.next();
            if (allowedClassifications.contains(entry.getValue().getProfile())) continue;
            iterator.remove();
        }
        return pmusMap;
    }

    private static @NonNull Map<@NonNull Integer, @NonNull ProcessorPmu> getProcessorPmuConfigurations(@Nullable InputStream userPmusXml, @Nullable InputStream userEventsXml, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    ProcessorPmu.ArchitectureProfile> allowedClassifications) throws IOException {
        InputStream pmusXml = userPmusXml != null ? userPmusXml : (InputStream)NullChecking.neverNull((Object)CommonResources.RESOURCES_PMUS_XML.open());
        InputStream eventsXml = userEventsXml != null ? userEventsXml : (InputStream)NullChecking.neverNull((Object)CommonResources.RESOURCES_EVENTS_XML.open());
        return BarmanGenerator.filterInvalidProcessors(ProcessorPmu.loadPMUXml((InputStream)pmusXml, (Map)ProcessorPmuEventDescription.loadEventsXml((InputStream)eventsXml)), allowedClassifications);
    }

    private static @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    ProcessorPmu.ArchitectureProfile> makeClassificationSet(@NonNull Predicate<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ProcessorPmu.ArchitectureProfile> filter) {
        return Arrays.stream(ProcessorPmu.ArchitectureProfile.values()).filter(filter).collect(Collectors.toSet());
    }

    private static void writeFile(@NonNull File outputFile, @NonNull String contents) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter writer = new FileWriter(outputFile);){
            writer.write(contents);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

