/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.v1;

import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.BarmanDataInput;
import com.arm.streamline.barman.BarmanTypeAndVersion;
import com.arm.streamline.barman.IBarmanProcessorInformation;
import com.arm.streamline.barman.recordstream.BarmanDataStoreParameters;
import com.arm.streamline.barmancfg.configuration.CustomChart;
import com.arm.streamline.barmancfg.configuration.CustomChartSeries;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.utils.ArrayUtils;
import com.arm.utils.StreamUtils;
import com.arm.utils.io.GrowableTargetByteBuffer;
import gnu.trove.TCollections;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BarmanHeaderDataV1 {
    private final @NonNull ClockInfo clockInfo;
    private final @NonNull ConfigConstants configConstants;
    private final @NonNull List<@NonNull CustomChart> customCharts;
    private final @NonNull BarmanDataStoreParameters dataStoreParameters;
    private final @NonNull DataStoreType dataStoreType;
    private final long lastTimestamp;
    private final @NonNull MmapLayout @NonNull [] mmapLayout;
    private final @NonNull PmuSettings @NonNull [] perCorePmuSettings;
    private final @NonNull String targetName;
    private final @NonNull TaskInfo @NonNull [] taskInfo;
    private final int timerSampleRate;
    private final @NonNull BarmanTypeAndVersion typeAndVersion;

    protected static @Nullable Boolean mapBoolean(int i) {
        return i != 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    private static @NonNull List<@NonNull CustomChart> parseCustomCounters(@NonNull BarmanDataInput<?> dataInput, int numCustomSeries, @NonNull StringTable stringTable) throws BarmanDataError, IOException {
        int numCustomCharts = dataInput.readInt();
        CustomChartDescriptor[] chartDescriptors = new CustomChartDescriptor[numCustomCharts];
        int i = 0;
        while (i < numCustomCharts) {
            chartDescriptors[i] = new CustomChartDescriptor(dataInput, stringTable);
            ++i;
        }
        i = 0;
        while (i < numCustomSeries) {
            CustomChartSeriesDescriptor seriesDescriptor = new CustomChartSeriesDescriptor(dataInput, stringTable);
            if (seriesDescriptor.getChartIndex() < 0 || seriesDescriptor.getChartIndex() >= numCustomCharts) {
                throw new BarmanDataError();
            }
            chartDescriptors[seriesDescriptor.getChartIndex()].addSeries(seriesDescriptor);
            ++i;
        }
        ArrayList<@NonNull CustomChart> result = new ArrayList<CustomChart>(numCustomCharts);
        CustomChartDescriptor[] customChartDescriptorArray = chartDescriptors;
        int n = chartDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            CustomChartDescriptor chartDescriptor = customChartDescriptorArray[n2];
            result.add(chartDescriptor.toCustomChart());
            ++n2;
        }
        return result;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull ToIntFunction<@NonNull String> writeStringTable(@NonNull GrowableTargetByteBuffer buffer, int maxLength, @NonNull Set<@NonNull String> strings) {
        if (maxLength < 1) {
            return s -> 0;
        }
        int beginPos = buffer.skip(4).position();
        int maxEndPos = beginPos + maxLength;
        buffer.put8((byte)0);
        @NonNull TObjectIntHashMap map = new TObjectIntHashMap(strings.size(), 1.0f, 0);
        strings.forEach(string -> {
            if (maxEndPos - buffer.position() >= string.length() + 1) {
                map.put(string, buffer.position() - beginPos);
                string.chars().forEachOrdered(c -> {
                    GrowableTargetByteBuffer growableTargetByteBuffer2 = buffer.put8((byte)c);
                });
                buffer.put8((byte)0);
            }
        });
        buffer.put32(beginPos - 4, buffer.position() - beginPos);
        return arg_0 -> ((TObjectIntHashMap)map).get(arg_0);
    }

    public BarmanHeaderDataV1(@NonNull BarmanTypeAndVersion typeAndVersion, @NonNull BarmanDataInput<?> dataInput) throws IOException, BarmanDataError {
        Object record;
        this.typeAndVersion = typeAndVersion;
        int headerLength = dataInput.readInt();
        this.dataStoreType = DataStoreType.fromInt(dataInput.readInt());
        int targetNamePtr = dataInput.readInt();
        this.lastTimestamp = dataInput.readLong();
        this.timerSampleRate = dataInput.readInt();
        this.configConstants = new ConfigConstants(dataInput);
        this.clockInfo = new ClockInfo(dataInput);
        @NonNull StringTable stringTable = new StringTable(dataInput, this.configConstants);
        this.targetName = stringTable.getString(targetNamePtr);
        ClusterMap clusterMap = new ClusterMap();
        this.perCorePmuSettings = new PmuSettings[this.configConstants.getMaxCores()];
        int i = 0;
        while (i < this.configConstants.getMaxCores()) {
            this.perCorePmuSettings[i] = new PmuSettings(clusterMap, i, dataInput, this.configConstants);
            ++i;
        }
        int numTaskEntries = this.configConstants.getMaxTaskInfos() > 0 ? dataInput.readInt() : 0;
        this.taskInfo = new TaskInfo[numTaskEntries];
        i = 0;
        while (i < this.configConstants.getMaxTaskInfos()) {
            record = new TaskInfo(stringTable, dataInput, this.configConstants);
            if (i < this.taskInfo.length) {
                this.taskInfo[i] = record;
            }
            ++i;
        }
        int numMmapEntries = this.configConstants.getMaxMmapLayouts() > 0 ? dataInput.readInt() : 0;
        this.mmapLayout = new MmapLayout[numMmapEntries];
        i = 0;
        while (i < this.configConstants.getMaxMmapLayouts()) {
            record = new MmapLayout(stringTable, dataInput, this.configConstants, this.clockInfo);
            if (i < this.mmapLayout.length) {
                this.mmapLayout[i] = record;
            }
            ++i;
        }
        this.customCharts = this.configConstants.getNumCustomCounters() > 0 ? BarmanHeaderDataV1.parseCustomCounters(dataInput, this.configConstants.getNumCustomCounters(), stringTable) : new ArrayList<CustomChart>();
        this.dataStoreParameters = new BarmanDataStoreParameters(dataInput);
        long skipBytes = (long)headerLength - dataInput.getOffset();
        if (skipBytes != 0L && skipBytes != 4L) {
            throw new AssertionError((Object)("Offset should be same as header length in V1 when aligned to 8 byte boundary: " + skipBytes));
        }
        dataInput.skipBytes((int)skipBytes);
    }

    public BarmanHeaderDataV1(@NonNull BarmanTypeAndVersion typeAndVersion, @NonNull ClockInfo clockInfo, @NonNull ConfigConstants configConstants, @NonNull List<@NonNull CustomChart> customCharts, @NonNull BarmanDataStoreParameters dataStoreParameters, @NonNull DataStoreType dataStoreType, long lastTimestamp, @NonNull MmapLayout @NonNull [] mmapLayout, @NonNull PmuSettings @NonNull [] perCorePmuSettings, @NonNull String targetName, @NonNull TaskInfo @NonNull [] taskInfo, int timerSampleRate) {
        this.typeAndVersion = typeAndVersion;
        this.clockInfo = clockInfo;
        this.configConstants = configConstants;
        this.customCharts = customCharts;
        this.dataStoreParameters = dataStoreParameters;
        this.dataStoreType = dataStoreType;
        this.lastTimestamp = lastTimestamp;
        this.mmapLayout = mmapLayout;
        this.perCorePmuSettings = perCorePmuSettings;
        this.targetName = targetName;
        this.taskInfo = taskInfo;
        this.timerSampleRate = timerSampleRate;
    }

    public BarmanHeaderDataV1(@NonNull ClockInfo clockInfo, @NonNull BarmanDataStoreParameters dataStoreParameters, @NonNull DataStoreType dataStoreType, long lastTimestamp, @NonNull MmapLayout @NonNull [] mmapLayout, @NonNull PmuSettings @NonNull [] perCorePmuSettings, @NonNull String targetName, @NonNull TaskInfo @NonNull [] taskInfo, int timerSampleRate, @NonNull BarmanTypeAndVersion typeAndVersion) {
        this.typeAndVersion = typeAndVersion;
        this.dataStoreType = dataStoreType;
        this.targetName = targetName;
        this.lastTimestamp = lastTimestamp;
        this.timerSampleRate = timerSampleRate;
        this.clockInfo = clockInfo;
        this.taskInfo = taskInfo;
        this.mmapLayout = mmapLayout;
        this.customCharts = Collections.emptyList();
        this.dataStoreParameters = dataStoreParameters;
        int maxPmuCounters = Stream.of(perCorePmuSettings).mapToInt(PmuSettings::getNumCounters).max().orElse(0);
        int maxCores = 1 + Stream.of(perCorePmuSettings).mapToInt(PmuSettings::getProcessorId).max().orElse(-1);
        @NonNull PmuSettings @NonNull [] newPerCorePmuSettings = new PmuSettings[maxCores];
        ClusterMap clusterMap = new ClusterMap();
        int i = 0;
        while (i < maxCores) {
            int id = i;
            @NonNull PmuSettings pmu = Stream.of(perCorePmuSettings).filter(p -> p.getProcessorId() == id).findAny().orElseGet(PmuSettings::new);
            newPerCorePmuSettings[i] = new PmuSettings(pmu, clusterMap, id);
            ++i;
        }
        this.perCorePmuSettings = newPerCorePmuSettings;
        int maxStringTableLength = 1 + this.getAllStrings().stream().mapToInt(s -> s.length() + 1).sum();
        this.configConstants = new ConfigConstants(maxCores, mmapLayout.length, maxPmuCounters, maxStringTableLength, taskInfo.length, 0);
    }

    public @NonNull ClockInfo getClockInfo() {
        return this.clockInfo;
    }

    public @NonNull ConfigConstants getConfigConstants() {
        return this.configConstants;
    }

    public long getCreatedUnixTimestampSeconds() {
        return this.clockInfo.getUnixBaseNs() / 1000000000L;
    }

    public @NonNull List<@NonNull CustomChart> getCustomCharts() {
        return this.customCharts;
    }

    public @NonNull BarmanDataStoreParameters getDataStoreParameters() {
        return this.dataStoreParameters;
    }

    public @NonNull DataStoreType getDataStoreType() {
        return this.dataStoreType;
    }

    public long getFirstTimestamp() {
        return this.clockInfo.getTimestampBase();
    }

    public long getLastTimestamp() {
        return this.lastTimestamp;
    }

    public @NonNull MmapLayout @NonNull [] getMmapLayout() {
        return this.mmapLayout;
    }

    public @NonNull PmuSettings @NonNull [] getPerCorePmuSettings() {
        return this.perCorePmuSettings;
    }

    public @NonNull String getTargetDescription() {
        return this.targetName;
    }

    public @NonNull TaskInfo @NonNull [] getTaskInfo() {
        return this.taskInfo;
    }

    public int getTimerSampleRateHz() {
        return this.timerSampleRate;
    }

    public @NonNull BarmanTypeAndVersion getTypeAndVersion() {
        return this.typeAndVersion;
    }

    public byte @NonNull [] serialize() {
        int maxMmapLayouts;
        GrowableTargetByteBuffer buffer = this.typeAndVersion.toTargetByteBuffer();
        int headerLengthPos = buffer.position();
        buffer.skip(4).put32(this.dataStoreType.getProtocolValue()).skip(4).put64(this.lastTimestamp).put32(this.timerSampleRate);
        this.configConstants.serialize(buffer);
        this.clockInfo.serialize(buffer);
        @NonNull ToIntFunction<@NonNull String> stringtableReverseLookup = BarmanHeaderDataV1.writeStringTable(buffer, this.configConstants.getMaxStringTableLength(), this.getAllStrings());
        assert (this.perCorePmuSettings.length == this.configConstants.getMaxCores());
        int maxPmuCounters = this.configConstants.getMaxPmuCounters();
        ArrayUtils.forEach((Object[])this.perCorePmuSettings, p -> p.serialize(buffer, maxPmuCounters));
        int maxTaskInfos = this.configConstants.getMaxTaskInfos();
        if (maxTaskInfos > 0) {
            buffer.put32(this.taskInfo.length);
            ArrayUtils.forN((Object[])this.taskInfo, (int)maxTaskInfos, TaskInfo::new, t -> t.serialize(buffer, stringtableReverseLookup));
        }
        if ((maxMmapLayouts = this.configConstants.getMaxMmapLayouts()) > 0) {
            buffer.put32(this.mmapLayout.length);
            ArrayUtils.forN((Object[])this.mmapLayout, (int)maxMmapLayouts, MmapLayout::new, m -> m.serialize(buffer, maxTaskInfos > 0, stringtableReverseLookup));
        }
        if (this.configConstants.getNumCustomCounters() != 0) {
            throw new IllegalArgumentException("Calling this with custom counters is not allowed");
        }
        this.dataStoreParameters.serialize(buffer);
        buffer.put32(headerLengthPos, buffer.position()).put32(headerLengthPos + 8, stringtableReverseLookup.applyAsInt(this.targetName));
        return buffer.getBytes();
    }

    private @NonNull Set<@NonNull String> getAllStrings() {
        return StreamUtils.concat((Stream[])new Stream[]{Stream.of(this.taskInfo).map(TaskInfo::getTaskName), Stream.of(this.mmapLayout).map(MmapLayout::getImageName), Stream.of(this.targetName)}).collect(Collectors.toSet());
    }

    public static class ClockInfo {
        private final long timestampBase;
        private final long timestampDivisor;
        private final long timestampMultiplier;
        private final long unixBaseNs;

        public ClockInfo(@NonNull BarmanDataInput<?> dataInput) throws IOException {
            this.timestampBase = dataInput.readLong();
            BigInteger tmpTimestampMultiplier = BigInteger.valueOf(dataInput.readLong());
            BigInteger tmpTimestampDivisor = BigInteger.valueOf(dataInput.readLong());
            this.unixBaseNs = dataInput.readLong();
            BigInteger gcd = tmpTimestampMultiplier.gcd(tmpTimestampDivisor);
            this.timestampMultiplier = tmpTimestampMultiplier.divide(gcd).longValue();
            this.timestampDivisor = tmpTimestampDivisor.divide(gcd).longValue();
        }

        public ClockInfo(long timestampBase, long timestampMultiplier, long timestampDivisor, long unixBaseNs) {
            this.timestampBase = timestampBase;
            this.timestampMultiplier = timestampMultiplier;
            this.timestampDivisor = timestampDivisor;
            this.unixBaseNs = unixBaseNs;
        }

        public long convertTimestampToNs(long timestamp) {
            return Math.max((timestamp - this.timestampBase) * this.timestampMultiplier / this.timestampDivisor, 0L);
        }

        public long convertTimestampToUnixNs(long timestamp) {
            return this.convertTimestampToNs(timestamp) + this.unixBaseNs;
        }

        public long getFrequencyHz() {
            return 1000000000L * this.timestampDivisor / this.timestampMultiplier;
        }

        public long getTimestampBase() {
            return this.timestampBase;
        }

        public long getTimestampDivisor() {
            return this.timestampDivisor;
        }

        public long getTimestampMultiplier() {
            return this.timestampMultiplier;
        }

        public long getUnixBaseNs() {
            return this.unixBaseNs;
        }

        public void serialize(GrowableTargetByteBuffer buffer) {
            buffer.put64(this.timestampBase).put64(this.timestampMultiplier).put64(this.timestampDivisor).put64(this.unixBaseNs);
        }
    }

    public static class ClusterMap {
        private final @NonNull TIntIntMap clusterIdMap = new TIntIntHashMap(10, 0.5f, -1, -1);
        private final @NonNull TIntIntMap clusterIndexMap = new TIntIntHashMap(10, 0.5f, 0, 0);

        public int mapClusterId(int clusterId) {
            int result = this.clusterIdMap.get(clusterId);
            if (result == this.clusterIdMap.getNoEntryValue()) {
                result = this.clusterIdMap.size();
                this.clusterIdMap.put(clusterId, result);
            }
            return result;
        }

        public int nextClusterIndex(int clusterId) {
            return this.clusterIndexMap.adjustOrPutValue(clusterId, 1, 0);
        }
    }

    public static class ConfigConstants {
        private final int maxCores;
        private final int maxMmapLayouts;
        private final int maxPmuCounters;
        private final int maxStringTableLength;
        private final int maxTaskInfos;
        private final int numCustomCounters;

        public ConfigConstants(@NonNull BarmanDataInput<?> dataInput) throws IOException {
            this.maxCores = dataInput.readInt();
            this.maxTaskInfos = dataInput.readInt();
            this.maxMmapLayouts = dataInput.readInt();
            this.maxPmuCounters = dataInput.readInt();
            this.maxStringTableLength = dataInput.readInt();
            this.numCustomCounters = dataInput.readInt();
        }

        public ConfigConstants(int maxCores, int maxMmapLayouts, int maxPmuCounters, int maxStringTableLength, int maxTaskInfos, int numCustomCounters) {
            this.maxCores = maxCores;
            this.maxMmapLayouts = maxMmapLayouts;
            this.maxPmuCounters = maxPmuCounters;
            this.maxStringTableLength = maxStringTableLength;
            this.maxTaskInfos = maxTaskInfos;
            this.numCustomCounters = numCustomCounters;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigConstants other = (ConfigConstants)obj;
            if (this.maxCores != other.maxCores) {
                return false;
            }
            if (this.maxMmapLayouts != other.maxMmapLayouts) {
                return false;
            }
            if (this.maxPmuCounters != other.maxPmuCounters) {
                return false;
            }
            if (this.maxStringTableLength != other.maxStringTableLength) {
                return false;
            }
            if (this.maxTaskInfos != other.maxTaskInfos) {
                return false;
            }
            return this.numCustomCounters == other.numCustomCounters;
        }

        public int getMaxCores() {
            return this.maxCores;
        }

        public int getMaxMmapLayouts() {
            return this.maxMmapLayouts;
        }

        public int getMaxPmuCounters() {
            return this.maxPmuCounters;
        }

        public int getMaxStringTableLength() {
            return this.maxStringTableLength;
        }

        public int getMaxTaskInfos() {
            return this.maxTaskInfos;
        }

        public int getNumCustomCounters() {
            return this.numCustomCounters;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.maxCores;
            result = 31 * result + this.maxMmapLayouts;
            result = 31 * result + this.maxPmuCounters;
            result = 31 * result + this.maxStringTableLength;
            result = 31 * result + this.maxTaskInfos;
            result = 31 * result + this.numCustomCounters;
            return result;
        }

        public void serialize(GrowableTargetByteBuffer buffer) {
            buffer.put32(this.maxCores).put32(this.maxTaskInfos).put32(this.maxMmapLayouts).put32(this.maxPmuCounters).put32(this.maxStringTableLength).put32(this.numCustomCounters);
        }
    }

    public static final class CustomChartDescriptor {
        private static final int BM_CHART_FLAG_AVERAGE_CORES = 2;
        private static final int BM_CHART_FLAG_AVERAGE_SELECTION = 1;
        private static final int BM_CHART_FLAG_PER_CPU = 8;
        private static final int BM_CHART_FLAG_PERCENTAGE = 4;
        private final int booleanFlags;
        private final @NonNull String name;
        private final int renderingType;
        private final @NonNull List<@NonNull CustomChartSeriesDescriptor> series;
        private final int seriesComposition;

        private static @Nullable GraphRenderingType mapRenderingType(int renderingType) throws BarmanDataError {
            switch (renderingType) {
                case 1: {
                    return GraphRenderingType.FILLED;
                }
                case 2: {
                    return GraphRenderingType.LINE;
                }
                case 3: {
                    return GraphRenderingType.BAR;
                }
            }
            throw new BarmanDataError();
        }

        private static @NonNull List<@NonNull CustomChartSeries> mapSeries(@NonNull List<@NonNull CustomChartSeriesDescriptor> serieses) throws BarmanDataError {
            ArrayList<@NonNull CustomChartSeries> result = new ArrayList<CustomChartSeries>();
            for (CustomChartSeriesDescriptor series : serieses) {
                result.add(series.toCustomChartSeries());
            }
            return result;
        }

        private static @Nullable SeriesComposition mapSeriesComposition(int seriesComposition) throws BarmanDataError {
            switch (seriesComposition) {
                case 1: {
                    return SeriesComposition.STACKED;
                }
                case 2: {
                    return SeriesComposition.OVERLAY;
                }
                case 3: {
                    return SeriesComposition.LOG10;
                }
            }
            throw new BarmanDataError();
        }

        public CustomChartDescriptor(@NonNull BarmanDataInput<?> dataInput, @NonNull StringTable stringTable) throws IOException {
            this.name = stringTable.getString(dataInput.readInt());
            this.seriesComposition = dataInput.readUnsignedByte();
            this.renderingType = dataInput.readUnsignedByte();
            this.booleanFlags = dataInput.readUnsignedByte();
            this.series = new ArrayList<CustomChartSeriesDescriptor>();
        }

        public void addSeries(@NonNull CustomChartSeriesDescriptor seriesDescriptor) {
            this.series.add(seriesDescriptor);
        }

        public @NonNull CustomChart toCustomChart() throws BarmanDataError {
            return new CustomChart(this.name, CustomChartDescriptor.mapSeriesComposition(this.seriesComposition), CustomChartDescriptor.mapRenderingType(this.renderingType), BarmanHeaderDataV1.mapBoolean(this.booleanFlags & 1), BarmanHeaderDataV1.mapBoolean(this.booleanFlags & 2), BarmanHeaderDataV1.mapBoolean(this.booleanFlags & 4), BarmanHeaderDataV1.mapBoolean(this.booleanFlags & 8), CustomChartDescriptor.mapSeries(this.series));
        }
    }

    public static final class CustomChartSeriesDescriptor {
        private static final int BM_CHART_SERIES_FLAG_SAMPLED = 1;
        private final int boolean_flags;
        private final int chartIndex;
        private final int clazz;
        private final int colour;
        private final @NonNull String description;
        private final int display;
        private final double multiplier;
        private final @NonNull String name;
        private final @NonNull String units;

        private static @Nullable Integer mapColour(int colour) {
            if (colour == -1) {
                return null;
            }
            return colour & 0xFFFFFF;
        }

        private static @Nullable CounterClass mapCounterClass(int clazz) throws BarmanDataError {
            switch (clazz) {
                case 1: {
                    return CounterClass.DELTA;
                }
                case 2: {
                    return CounterClass.INCIDENT;
                }
                case 3: {
                    return CounterClass.ABSOLUTE;
                }
            }
            throw new BarmanDataError();
        }

        private static @Nullable CounterDisplay mapDisplay(int display) throws BarmanDataError {
            switch (display) {
                case 1: {
                    return CounterDisplay.ACCUMULATE;
                }
                case 2: {
                    return CounterDisplay.AVERAGE;
                }
                case 3: {
                    return CounterDisplay.HERTZ;
                }
                case 4: {
                    return CounterDisplay.MAXIMUM;
                }
                case 5: {
                    return CounterDisplay.MINIMUM;
                }
            }
            throw new BarmanDataError();
        }

        public CustomChartSeriesDescriptor(@NonNull BarmanDataInput<?> dataInput, @NonNull StringTable stringTable) throws IOException {
            this.chartIndex = dataInput.readInt();
            this.name = stringTable.getString(dataInput.readInt());
            this.units = stringTable.getString(dataInput.readInt());
            this.description = stringTable.getString(dataInput.readInt());
            this.colour = dataInput.readInt();
            this.multiplier = dataInput.readDouble();
            this.clazz = dataInput.readUnsignedByte();
            this.display = dataInput.readUnsignedByte();
            this.boolean_flags = dataInput.readUnsignedByte();
        }

        public int getChartIndex() {
            return this.chartIndex;
        }

        public @NonNull CustomChartSeries toCustomChartSeries() throws BarmanDataError {
            return new CustomChartSeries(this.name, this.units, BarmanHeaderDataV1.mapBoolean(this.boolean_flags & 1), this.multiplier, CustomChartSeriesDescriptor.mapCounterClass(this.clazz), CustomChartSeriesDescriptor.mapDisplay(this.display), CustomChartSeriesDescriptor.mapColour(this.colour), this.description);
        }
    }

    public static enum DataStoreType {
        CIRCULAR(2),
        ITM(5),
        LINEAR(1),
        STM(3),
        STREAMING(4),
        USER_DEFINED(0);

        private final int intVal;

        public static @NonNull DataStoreType fromInt(int intVal) throws BarmanDataError {
            DataStoreType[] dataStoreTypeArray = DataStoreType.values();
            int n = dataStoreTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataStoreType type = dataStoreTypeArray[n2];
                if (type.intVal == intVal) {
                    return type;
                }
                ++n2;
            }
            throw new BarmanDataError();
        }

        private DataStoreType(int intVal) {
            this.intVal = intVal;
        }

        public int getProtocolValue() {
            return this.intVal;
        }
    }

    public static final class MmapLayout {
        private final long baseAddress;
        private final @NonNull String imageName;
        private final long imageOffset;
        private final long length;
        private final @Nullable Integer taskId;
        private final long timestamp;

        public MmapLayout() {
            this.timestamp = 0L;
            this.taskId = null;
            this.baseAddress = 0L;
            this.length = 0L;
            this.imageOffset = 0L;
            this.imageName = "";
        }

        public MmapLayout(long timestamp, int taskId, long baseAddress, long length, long imageOffset, @NonNull String imageName) {
            this.timestamp = timestamp;
            this.taskId = taskId;
            this.baseAddress = baseAddress;
            this.length = length;
            this.imageOffset = imageOffset;
            this.imageName = imageName;
        }

        public MmapLayout(long timestamp, long baseAddress, long length, long imageOffset, @NonNull String imageName) {
            this.taskId = null;
            this.timestamp = timestamp;
            this.baseAddress = baseAddress;
            this.length = length;
            this.imageOffset = imageOffset;
            this.imageName = imageName;
        }

        public MmapLayout(@NonNull StringTable stringTable, @NonNull BarmanDataInput<?> dataInput, @NonNull ConfigConstants configConstants, @NonNull ClockInfo clockInfo) throws IOException {
            boolean hasTaskInfos = configConstants.getMaxTaskInfos() > 0;
            this.timestamp = hasTaskInfos ? dataInput.readLong() : clockInfo.getTimestampBase();
            this.taskId = hasTaskInfos ? Integer.valueOf(dataInput.readInt()) : null;
            this.baseAddress = dataInput.readMachineWord();
            this.length = dataInput.readMachineWord();
            this.imageOffset = dataInput.readMachineWord();
            this.imageName = stringTable.getString(dataInput.readInt());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MmapLayout other = (MmapLayout)obj;
            if (this.baseAddress != other.baseAddress) {
                return false;
            }
            if (!this.imageName.equals(other.imageName)) {
                return false;
            }
            if (this.imageOffset != other.imageOffset) {
                return false;
            }
            if (this.length != other.length) {
                return false;
            }
            Integer taskId = this.taskId;
            if (taskId == null ? other.taskId != null : !taskId.equals(other.taskId)) {
                return false;
            }
            return this.timestamp == other.timestamp;
        }

        public long getBaseAddress() {
            return this.baseAddress;
        }

        public @NonNull String getImageName() {
            return this.imageName;
        }

        public long getImageOffset() {
            return this.imageOffset;
        }

        public long getLength() {
            return this.length;
        }

        public @Nullable Integer getTaskId() {
            return this.taskId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.baseAddress ^ this.baseAddress >>> 32);
            result = 31 * result + this.imageName.hashCode();
            result = 31 * result + (int)(this.imageOffset ^ this.imageOffset >>> 32);
            result = 31 * result + (int)(this.length ^ this.length >>> 32);
            Integer taskId = this.taskId;
            result = 31 * result + (taskId == null ? 0 : taskId.hashCode());
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            return result;
        }

        public boolean overlaps(@NonNull MmapLayout other) {
            return Long.compareUnsigned(this.baseAddress, other.baseAddress + other.length) < 0 && Long.compareUnsigned(this.baseAddress + this.length, other.baseAddress) > 0;
        }

        public void serialize(GrowableTargetByteBuffer buffer, boolean hasTaskInfos, @NonNull ToIntFunction<@NonNull String> stringtableReverseLookup) {
            if (hasTaskInfos) {
                @Nullable Integer tid = this.taskId;
                if (tid == null) {
                    throw new IllegalArgumentException("Can not serialize unknown task ID");
                }
                buffer.put64(this.timestamp).put32(tid.intValue());
            }
            buffer.putPointer(this.baseAddress).putPointer(this.length).putPointer(this.imageOffset).put32(stringtableReverseLookup.applyAsInt(this.imageName));
        }

        public @NonNull String toString() {
            return this.imageName + "@0x" + Long.toHexString(this.imageOffset);
        }
    }

    public static class PmuSettings
    implements IBarmanProcessorInformation {
        private final int clusterId;
        private final int clusterIndex;
        private final int midr;
        private final long mpidr;
        private final @NonNull TIntIntMap pmuEventsMap;
        private final int processorId;
        private final long timestamp;

        public PmuSettings() {
            this.clusterId = 0;
            this.clusterIndex = 0;
            this.midr = 0;
            this.mpidr = 0L;
            this.pmuEventsMap = new TIntIntHashMap(10, 0.5f, -1, -1);
            this.processorId = 0;
            this.timestamp = 0L;
        }

        public PmuSettings(@NonNull ClusterMap clusterMap, int processorId, @NonNull BarmanDataInput<?> dataInput, @NonNull ConfigConstants configConstants) throws IOException {
            this.processorId = processorId;
            this.pmuEventsMap = new TIntIntHashMap(10, 0.5f, -1, -1);
            this.timestamp = dataInput.readLong();
            this.midr = dataInput.readInt();
            this.mpidr = dataInput.readMachineWord();
            int rawClusterId = dataInput.readInt();
            int numCounters = dataInput.readInt();
            int i = 0;
            while (i < configConstants.getMaxPmuCounters()) {
                int counterType = dataInput.readInt();
                if (i < numCounters) {
                    this.pmuEventsMap.put(i, counterType);
                }
                ++i;
            }
            if (this.isValid()) {
                this.clusterId = clusterMap.mapClusterId(rawClusterId);
                this.clusterIndex = clusterMap.nextClusterIndex(this.clusterId);
            } else {
                this.clusterId = -1;
                this.clusterIndex = 0;
            }
        }

        public PmuSettings(int clusterId, int clusterIndex, int midr, long mpidr, int @NonNull [] pmuEvents, int processorId, long timestamp) {
            this.clusterId = clusterId;
            this.clusterIndex = clusterIndex;
            this.midr = midr;
            this.mpidr = mpidr;
            this.pmuEventsMap = new TIntIntHashMap(10, 0.5f, -1, -1);
            int i = 0;
            while (i < pmuEvents.length) {
                this.pmuEventsMap.put(i, pmuEvents[i]);
                ++i;
            }
            this.processorId = processorId;
            this.timestamp = timestamp;
        }

        public PmuSettings(@NonNull PmuSettings other, @NonNull ClusterMap clusterMap, int processorId) {
            this.midr = other.midr;
            this.mpidr = other.mpidr;
            this.pmuEventsMap = other.pmuEventsMap;
            this.processorId = processorId;
            this.timestamp = other.timestamp;
            if (other.isValid()) {
                this.clusterId = clusterMap.mapClusterId(other.clusterId);
                this.clusterIndex = clusterMap.nextClusterIndex(this.clusterId);
            } else {
                this.clusterId = -1;
                this.clusterIndex = 0;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PmuSettings other = (PmuSettings)obj;
            if (this.clusterId != other.clusterId) {
                return false;
            }
            if (this.midr != other.midr) {
                return false;
            }
            if (this.mpidr != other.mpidr) {
                return false;
            }
            if (!this.pmuEventsMap.equals(other.pmuEventsMap)) {
                return false;
            }
            if (this.processorId != other.processorId) {
                return false;
            }
            return this.timestamp == other.timestamp;
        }

        public int getClusterId() {
            return this.clusterId;
        }

        public int getClusterIndex() {
            return this.clusterIndex;
        }

        public int getMIDR() {
            return this.midr;
        }

        public long getMPIDR() {
            return this.mpidr;
        }

        public int getNumCounters() {
            return this.pmuEventsMap.size();
        }

        public @NonNull TIntIntMap getPmuEvents() {
            return TCollections.unmodifiableMap((TIntIntMap)this.pmuEventsMap);
        }

        public int getProcessorId() {
            return this.processorId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.clusterId;
            result = 31 * result + this.midr;
            result = 31 * result + (int)(this.mpidr ^ this.mpidr >>> 32);
            result = 31 * result + this.pmuEventsMap.hashCode();
            result = 31 * result + this.processorId;
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            return result;
        }

        public boolean isValid() {
            return this.midr != 0;
        }

        public void serialize(@NonNull GrowableTargetByteBuffer buffer, int maxPmuCounters) {
            buffer.put64(this.timestamp).put32(this.midr).putPointer(this.mpidr).put32(this.clusterId).put32(this.pmuEventsMap.size());
            int i = 0;
            while (i < maxPmuCounters) {
                buffer.put32(this.pmuEventsMap.get(i));
                ++i;
            }
        }
    }

    public static final class StringTable {
        public static final int NOT_FOUND_INDEX = 0;
        protected final byte @NonNull [] stringData;

        public StringTable(@NonNull BarmanDataInput<?> dataInput, @NonNull ConfigConstants configConstants) throws IOException, BarmanDataError {
            int length = dataInput.readInt();
            byte[] bytes = new byte[configConstants.getMaxStringTableLength()];
            if (length > configConstants.getMaxStringTableLength()) {
                throw new BarmanDataError();
            }
            dataInput.readFully(bytes);
            this.stringData = new byte[length];
            System.arraycopy(bytes, 0, this.stringData, 0, length);
        }

        public @NonNull String getString(int index) {
            if (index == 0 && this.stringData.length == 0) {
                return "";
            }
            if (index < 0 || index >= this.stringData.length) {
                throw new IllegalArgumentException();
            }
            StringBuilder result = new StringBuilder();
            while (index < this.stringData.length && this.stringData[index] != 0) {
                result.append((char)(this.stringData[index] & 0xFF));
                ++index;
            }
            return result.toString();
        }
    }

    public static final class TaskInfo {
        public static final int DEFAULT_TASK_ID = 0;
        private final int taskId;
        private final @NonNull String taskName;
        private final long timestamp;

        public TaskInfo() {
            this.timestamp = 0L;
            this.taskName = "";
            this.taskId = 0;
        }

        public TaskInfo(long timestamp, int taskId, @NonNull String taskName) {
            this.timestamp = timestamp;
            this.taskName = taskName;
            this.taskId = taskId;
        }

        public TaskInfo(@NonNull StringTable stringTable, @NonNull BarmanDataInput<?> dataInput, @NonNull ConfigConstants configConstants) throws IOException {
            this.timestamp = dataInput.readLong();
            this.taskId = dataInput.readInt();
            this.taskName = stringTable.getString(dataInput.readInt());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TaskInfo other = (TaskInfo)obj;
            if (this.taskId != other.taskId) {
                return false;
            }
            if (!this.taskName.equals(other.taskName)) {
                return false;
            }
            return this.timestamp == other.timestamp;
        }

        public int getTaskId() {
            return this.taskId;
        }

        public @NonNull String getTaskName() {
            return this.taskName;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.taskId;
            result = 31 * result + this.taskName.hashCode();
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            return result;
        }

        public void serialize(@NonNull GrowableTargetByteBuffer buffer, @NonNull ToIntFunction<@NonNull String> stringtableReverseLookup) {
            buffer.put64(this.timestamp).put32(this.taskId).put32(stringtableReverseLookup.applyAsInt(this.taskName));
        }
    }
}

