/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.stm;

import com.arm.debug.dtsl.decoders.stm.stpprotocol.NibbleData;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STPDecodeException;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STPPacket;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_C16;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_C8;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_D;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_FLAG;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_GERR;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_M16;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_M8;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_MERR;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_VERSION;
import com.arm.streamline.barman.stm.ISTPDecodingPipeline;
import com.arm.streamline.barman.stm.ISTPFrameHandler;
import com.arm.streamline.barman.stm.STPDecodingPipeline;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Container;
import gnu.trove.list.array.TByteArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class STPMerger {
    private int channel = -1;
    private final @NonNull Container<Integer> channels;
    private final @NonNull ISTPFrameHandler frameHandler;
    private int master = -1;
    private final @NonNull Container<Integer> masters;
    private long numNibblesAccepted = 0L;
    private final @NonNull ISTPDecodingPipeline pipeline;
    private final @NonNull Map<Integer, TByteArrayList> unfinishedFrames = new TreeMap<Integer, TByteArrayList>();
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable STP_VERSION.STPV2VERSION version = null;

    public static @NonNull STPMerger newWithDefaultPipeline(@NonNull Container<Integer> masters, @NonNull Container<Integer> channels, @NonNull ISTPFrameHandler frameHandler) {
        return new STPMerger(new STPDecodingPipeline(), masters, channels, frameHandler);
    }

    public static @NonNull STPMerger newWithDefaultPipeline(@NonNull Container<Integer> masters, @NonNull ISTPFrameHandler frameHandler) {
        return STPMerger.newWithDefaultPipeline(masters, (Container<Integer>)Container.newWithEverything(), frameHandler);
    }

    public STPMerger(@NonNull ISTPDecodingPipeline pipeline, @NonNull Container<Integer> masters, @NonNull Container<Integer> channels, @NonNull ISTPFrameHandler frameHandler) {
        this.masters = masters;
        this.channels = channels;
        this.pipeline = pipeline;
        this.frameHandler = frameHandler;
    }

    public void extractFrames(byte @NonNull [] data) {
        this.extractFrames(data, data.length);
    }

    public void extractFrames(byte @NonNull [] data, int length) {
        STPPacket packet;
        this.pipeline.appendData(data, 2 * length);
        this.numNibblesAccepted += (long)(2 * length);
        while ((packet = this.pipeline.getPacket()) != null) {
            TByteArrayList frame;
            if (packet instanceof STP_VERSION) {
                this.version = ((STP_VERSION)packet).getVersion();
                this.master = 0;
                this.channel = 0;
                continue;
            }
            if (this.version == null) {
                throw new STPDecodeException(STPDecodeException.Cause.TimestampPriorToVersion);
            }
            if (packet instanceof STP_C8) {
                this.channel = ((STP_C8)packet).updateChannelID(this.channel);
                continue;
            }
            if (packet instanceof STP_C16) {
                this.channel = ((STP_C16)packet).getChannelID();
                continue;
            }
            if (packet instanceof STP_MERR) {
                this.channel = 0;
                this.unfinishedFrames.clear();
                this.frameHandler.onDataLost();
                continue;
            }
            if (packet instanceof STP_M8) {
                this.channel = 0;
                this.master = ((STP_M8)packet).updateMasterID(this.master);
                continue;
            }
            if (packet instanceof STP_M16) {
                this.channel = 0;
                this.master = ((STP_M16)packet).getMasterID();
                continue;
            }
            if (packet instanceof STP_GERR) {
                this.channel = 0;
                this.master = 0;
                this.unfinishedFrames.clear();
                this.frameHandler.onDataLost();
                continue;
            }
            if (packet instanceof STP_D) {
                if (!this.masters.contains((Object)this.master) || !this.channels.contains((Object)this.channel) || (frame = this.unfinishedFrames.get(this.channel)) == null) continue;
                NibbleData nibbleData = ((STP_D)packet).getData();
                frame.add(nibbleData.getData(), 0, nibbleData.getNibbleCount() / 2);
                continue;
            }
            if (!(packet instanceof STP_FLAG) || !this.masters.contains((Object)this.master) || !this.channels.contains((Object)this.channel)) continue;
            frame = this.unfinishedFrames.get(this.channel);
            if (frame != null && !frame.isEmpty()) {
                this.frameHandler.onFrame((byte[])NullChecking.neverNull((Object)frame.toArray()));
            }
            this.unfinishedFrames.put(this.channel, new TByteArrayList());
        }
    }

    public long getNumNibblesProcessed() {
        return this.numNibblesAccepted - (long)this.pipeline.length();
    }

    public void restart() {
        this.pipeline.resync();
        this.unfinishedFrames.clear();
    }
}

