/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.recordstream;

import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.BarmanDataInput;
import com.arm.utils.io.GrowableTargetByteBuffer;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class BarmanDataStoreParameters {
    private final long basePointer;
    private final long bufferLength;
    private final long readOffset;
    private final long totalWritten;
    private final long writeOffset;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.basePointer ^ this.basePointer >>> 32);
        result = 31 * result + (int)(this.bufferLength ^ this.bufferLength >>> 32);
        result = 31 * result + (int)(this.readOffset ^ this.readOffset >>> 32);
        result = 31 * result + (int)(this.totalWritten ^ this.totalWritten >>> 32);
        result = 31 * result + (int)(this.writeOffset ^ this.writeOffset >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BarmanDataStoreParameters other = (BarmanDataStoreParameters)obj;
        if (this.basePointer != other.basePointer) {
            return false;
        }
        if (this.bufferLength != other.bufferLength) {
            return false;
        }
        if (this.readOffset != other.readOffset) {
            return false;
        }
        if (this.totalWritten != other.totalWritten) {
            return false;
        }
        return this.writeOffset == other.writeOffset;
    }

    public BarmanDataStoreParameters(long basePointer, long bufferLength, long readOffset, long totalWritten, long writeOffset) {
        this.basePointer = basePointer;
        this.bufferLength = bufferLength;
        this.readOffset = readOffset;
        this.totalWritten = totalWritten;
        this.writeOffset = writeOffset;
    }

    public BarmanDataStoreParameters(@NonNull BarmanDataInput<?> dataInput) throws IOException, BarmanDataError {
        dataInput.alignTo(8);
        this.bufferLength = dataInput.readLong();
        this.writeOffset = dataInput.readLong();
        this.readOffset = dataInput.readLong();
        this.totalWritten = dataInput.readLong();
        this.basePointer = dataInput.readMachineWord();
        if (this.bufferLength < 0L || this.readOffset < 0L || this.writeOffset < 0L || this.readOffset > this.writeOffset) {
            throw new BarmanDataError();
        }
    }

    public BarmanDataStoreParameters() {
        this.bufferLength = 0L;
        this.writeOffset = 0L;
        this.readOffset = 0L;
        this.totalWritten = 0L;
        this.basePointer = 0L;
    }

    public long getBasePointer() {
        return this.basePointer;
    }

    public long getBufferLength() {
        return this.bufferLength;
    }

    public long getCircularDataLength() {
        if (this.readOffset == this.writeOffset) {
            return this.totalWritten != 0L ? this.bufferLength : 0L;
        }
        if (this.readOffset < this.writeOffset) {
            return this.writeOffset - this.readOffset;
        }
        return this.bufferLength - this.readOffset + this.writeOffset;
    }

    public long getReadOffset() {
        return this.readOffset;
    }

    public long getTotalWritten() {
        return this.totalWritten;
    }

    public long getWriteOffset() {
        return this.writeOffset;
    }

    public void serialize(@NonNull GrowableTargetByteBuffer buffer) {
        buffer.alignTo(8).put64(this.bufferLength).put64(this.writeOffset).put64(this.readOffset).put64(this.totalWritten).putPointer(this.basePointer);
    }
}

