/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.itm.packets;

import com.arm.streamline.barman.itm.ITimestampedPacketReceiver;
import com.arm.streamline.barman.itm.packets.ISourcePacket;
import org.eclipse.jdt.annotation.NonNull;

public class PeriodicPcSamplePacket
implements ISourcePacket {
    private final int pcValue;
    private final NotSampledReason notSampledReason;

    public PeriodicPcSamplePacket(int pcValue) {
        this.pcValue = pcValue;
        this.notSampledReason = null;
    }

    public PeriodicPcSamplePacket(@NonNull NotSampledReason notSampledReason) {
        this.pcValue = 0;
        this.notSampledReason = notSampledReason;
    }

    @Override
    public void callReceiver(@NonNull ITimestampedPacketReceiver receiver, long timestamp) {
        if (this.notSampledReason == null) {
            receiver.onPeriodicPCSamplePacket(timestamp, Integer.toUnsignedLong(this.pcValue));
        } else {
            switch (this.notSampledReason) {
                case Sleeping: {
                    receiver.onPeriodicPCSamplePacketSleeping(timestamp);
                    break;
                }
                case Prohibited: {
                    receiver.onPeriodicPCSamplePacketProhibited(timestamp);
                    break;
                }
            }
        }
    }

    public static enum NotSampledReason {
        Sleeping,
        Prohibited;

    }
}

