/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.frames.objects;

import com.arm.streamline.barman.BarmanTypeAndVersion;
import com.arm.streamline.barman.frames.IBarmanSerializableFrame;
import com.arm.streamline.barman.v1.BarmanRecordType;
import com.arm.utils.NullChecking;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class PcWithoutTaskId
implements IBarmanSerializableFrame {
    private final long timestamp;
    private final int core;
    private final long pc;

    public PcWithoutTaskId(long timestamp, int core, long pc) {
        this.timestamp = timestamp;
        this.core = core;
        this.pc = pc;
    }

    @Override
    public byte @Nullable [] getRawFrameData() {
        return null;
    }

    @Override
    public @Nullable Long getTimestampOverride() {
        return null;
    }

    @Override
    public byte @NonNull [] serializeRecord(@NonNull BarmanTypeAndVersion typeAndVersion) {
        ByteOrder byteOrder = typeAndVersion.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        int length = 16 + (typeAndVersion.isBits64() ? 8 : 4);
        ByteBuffer buffer = ByteBuffer.allocate(length).order(byteOrder);
        buffer.putInt(BarmanRecordType.PC_WITHOUT_TASK_ID.getValue());
        buffer.putInt(this.core);
        buffer.putLong(this.timestamp);
        if (typeAndVersion.isBits64()) {
            buffer.putLong(this.pc);
        } else {
            buffer.putInt((int)this.pc);
        }
        return (byte[])NullChecking.neverNull((Object)buffer.array());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getCore() {
        return this.core;
    }

    public long getPc() {
        return this.pc;
    }
}

