/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.frames;

import com.arm.streamline.barman.BarmanTypeAndVersion;
import com.arm.streamline.barman.IBarmanHeader;
import com.arm.streamline.barman.frames.IBarmanFrameStreamWriter;
import com.arm.utils.io.ByteChannelUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BarmanFrameStreamWriter
implements IBarmanFrameStreamWriter {
    private static final int BUFFER_SIZE = 65536;
    private long frameCounter;
    private byte @Nullable [] lastHeaderFrame;
    private @Nullable IBarmanHeader lastHeaderObject;
    private final @NonNull FileChannel outputStream;
    private final byte[] buffer = new byte[65536];
    private int bufferOffset;

    public BarmanFrameStreamWriter(@NonNull FileChannel outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void consumeHeader(@NonNull IBarmanHeader headerObject, byte @NonNull [] headerFrame) throws IOException {
        @Nullable IBarmanHeader lastHeaderObject = this.lastHeaderObject;
        byte @Nullable [] lastHeaderFrame = this.lastHeaderFrame;
        assert (lastHeaderFrame == null || lastHeaderFrame.length == headerFrame.length);
        assert (lastHeaderObject == null || lastHeaderObject.getTypeAndVersion().equals(headerObject.getTypeAndVersion()));
        this.lastHeaderObject = headerObject;
        this.lastHeaderFrame = headerFrame;
        @NonNull ByteBuffer frameBuffer = ByteBuffer.wrap(headerFrame);
        long fSize = this.outputStream.position();
        long hoLength = headerObject.getHeaderLength();
        long hLength = headerFrame.length;
        long length = Math.max(Math.max(fSize, hoLength), hLength);
        this.outputStream.position(0L);
        ByteChannelUtils.writeBytes((ByteChannel)this.outputStream, (ByteBuffer)frameBuffer);
        this.outputStream.position(length);
    }

    @Override
    public void consumeRecord(byte @NonNull [] frame) throws IOException {
        assert (frame.length >= 16);
        @Nullable IBarmanHeader lastHeaderObject = this.lastHeaderObject;
        if (lastHeaderObject == null) {
            throw new AssertionError();
        }
        @NonNull BarmanTypeAndVersion typeAndVersion = lastHeaderObject.getTypeAndVersion();
        ByteBuffer lengthBuffer = ByteBuffer.allocate(typeAndVersion.isBits64() ? 8 : 4);
        lengthBuffer.order(typeAndVersion.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        if (typeAndVersion.isBits64()) {
            lengthBuffer.putLong(frame.length);
        } else {
            lengthBuffer.putInt(frame.length);
        }
        this.appendBuffer(lengthBuffer.array());
        this.appendBuffer(frame);
        ++this.frameCounter;
    }

    private void appendBuffer(byte[] data) throws IOException {
        if (this.bufferOffset > 0 && this.bufferOffset + data.length > this.buffer.length) {
            this.writeBytes(this.buffer, this.bufferOffset);
            this.bufferOffset = 0;
        }
        if (data.length >= this.buffer.length) {
            this.writeBytes(data, data.length);
        } else {
            System.arraycopy(data, 0, this.buffer, this.bufferOffset, data.length);
            this.bufferOffset += data.length;
        }
    }

    private void writeBytes(byte[] buffer, int dataLength) throws IOException {
        ByteChannelUtils.writeBytes((ByteChannel)this.outputStream, (int)0, (int)dataLength, (ByteBuffer)ByteBuffer.wrap(buffer));
    }

    @Override
    public byte @Nullable [] getHeader() {
        return this.lastHeaderFrame;
    }

    @Override
    public @Nullable IBarmanHeader getHeaderObject() {
        return this.lastHeaderObject;
    }

    @Override
    public long getNumberOfFramesWritten() {
        return this.frameCounter;
    }

    @Override
    public boolean hasHeader() {
        return this.lastHeaderFrame != null;
    }

    @Override
    public void close() throws IOException {
        if (this.bufferOffset > 0) {
            this.writeBytes(this.buffer, this.bufferOffset);
        }
        this.bufferOffset = 0;
    }
}

