/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman;

import com.arm.streamline.barman.BarmanClustersInfo;
import com.arm.streamline.barman.BarmanMessages;
import com.arm.streamline.barman.IBarmanProcessorInformation;
import com.arm.streamline.barmancfg.configuration.CustomChart;
import com.arm.streamline.barmancfg.configuration.CustomChartSeries;
import com.arm.streamline.common.model.counters.CounterMode;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.utility.MIDRUtilities;
import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.common.xml.counters.Category;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.pmus.EventsAndPmusXml;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.utils.NullChecking;
import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BarmanProcessorCounters {
    private static final @NonNull Category ACTIVITY_CATEGORY = new Category("Activity", true, false);
    private final @NonNull List<@NonNull CounterRecord> counterRecords;
    private final @NonNull TObjectIntMap<StockCounter> countersToKeysMap = new TObjectIntHashMap(10, 0.5f, -1);
    private final @NonNull TIntIntMap customCounterKeysMap;
    private final @NonNull Map<ProcessorPmu, TIntIntMap> customEventCounterKeysMap;
    private int keyCounter = 0;
    private final @NonNull TIntObjectMap<TIntIntMap> processorToEventIdToKeyMap = new TIntObjectHashMap(10, 0.5f, -1);
    private final @NonNull TIntObjectMap<TIntIntMap> processorToEventTypeToKeyMap = new TIntObjectHashMap(10, 0.5f, -1);

    private static @Nullable ProcessorPmu mapProcessorToPmu(@NonNull Map<Integer, ProcessorPmu> pmus, @NonNull IBarmanProcessorInformation processor) {
        return pmus.get(MIDRUtilities.makeGatorCpuid((int)processor.getMIDR()));
    }

    public BarmanProcessorCounters(@NonNull BarmanClustersInfo clustersInfo, @NonNull Map<Integer, ProcessorPmu> pmus, @NonNull Events events, @NonNull Collection<@NonNull IBarmanProcessorInformation> processors, @NonNull List<@NonNull CustomChart> customCharts) {
        this.counterRecords = new ArrayList<CounterRecord>();
        this.customEventCounterKeysMap = new HashMap<ProcessorPmu, TIntIntMap>();
        this.customCounterKeysMap = new TIntIntHashMap(10, 0.5f, -1, -1);
        Map<ProcessorPmu, CycleCounterAndEvents> pmuEventsMap = CycleCounterAndEvents.collectPmuToEventsMap((Collection)NullChecking.neverNull(pmus.values()), events);
        boolean multiCluster = clustersInfo.getNumberOfClusters() > 1;
        TIntObjectIterator iterator = clustersInfo.getClusterNames().iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int clusterId = iterator.key();
            String clusterName = clustersInfo.getClusterPmncName(clusterId);
            this.addUserActivityCounter(clusterName, multiCluster ? Integer.valueOf(clusterId) : null);
        }
        for (IBarmanProcessorInformation processor : processors) {
            ProcessorPmu pmu = BarmanProcessorCounters.mapProcessorToPmu(pmus, processor);
            CycleCounterAndEvents cycleCounterAndEvents = pmuEventsMap.get(pmu);
            if (cycleCounterAndEvents != null) {
                this.addPmuEvents((ProcessorPmu)NullChecking.neverNull((Object)pmu), cycleCounterAndEvents, processor);
                continue;
            }
            this.addCustomPmuEvents(clustersInfo, processor);
        }
        int seriesCounter = 0;
        for (CustomChart customChart : customCharts) {
            for (CustomChartSeries series : customChart.getSeries()) {
                this.addCustomChart(seriesCounter, customChart, series);
                ++seriesCounter;
            }
        }
    }

    public @NonNull List<@NonNull CounterRecord> getCounterRecords() {
        return Collections.unmodifiableList(this.counterRecords);
    }

    public int getCustomCounterKey(int id) {
        int key = this.customCounterKeysMap.get(id);
        if (key != this.customCounterKeysMap.getNoEntryValue()) {
            return key;
        }
        throw new AssertionError((Object)("Invalid custom counter id: " + id));
    }

    public int getProcessorEventKeyFromEventId(int processor, int eventId) {
        int result;
        TIntIntMap eventIdToKeyMap = (TIntIntMap)this.processorToEventIdToKeyMap.get(processor);
        if (eventIdToKeyMap != null && (result = eventIdToKeyMap.get(eventId)) != eventIdToKeyMap.getNoEntryValue()) {
            return result;
        }
        throw new AssertionError((Object)("Invalid processor event id: " + processor + ":" + eventId));
    }

    public int getProcessorEventKeyFromEventType(int processor, int eventType) {
        int result;
        TIntIntMap eventTypeToKeyMap = (TIntIntMap)this.processorToEventTypeToKeyMap.get(processor);
        if (eventTypeToKeyMap != null && (result = eventTypeToKeyMap.get(eventType)) != eventTypeToKeyMap.getNoEntryValue()) {
            return result;
        }
        throw new AssertionError((Object)("Invalid processor event id: " + processor + ":" + eventType));
    }

    private void addCounterRecord(@NonNull IBarmanProcessorInformation processor, @NonNull CounterRecord counterRecord) {
        counterRecord.setCluster(Integer.valueOf(processor.getClusterId()));
        this.counterRecords.add(counterRecord);
    }

    private void addCustomChart(int seriesCounter, @NonNull CustomChart chart, @NonNull CustomChartSeries series) {
        int key = this.keyCounter++;
        CounterRecord counter = new CounterRecord(Integer.toString(key), chart.getName(), series.getName(), series.getDescription(), series.getUnits(), series.getColour(), key, series.getClazz(), series.getDisplay(), chart.isAverageSelection(), chart.isPerCpu() ? CounterMode.PER_CORE : CounterMode.SYSTEM_WIDE, series.getMultiplier(), chart.getSeriesComposition(), chart.getRenderingType(), chart.isAverageCores(), chart.isPercentage(), new ArrayList(), new TIntArrayList(), 0, false, false, Ternary.FALSE, null);
        this.customCounterKeysMap.put(seriesCounter, key);
        this.counterRecords.add(counter);
    }

    private void addCustomEvent(@NonNull ProcessorPmu pmu, @NonNull IBarmanProcessorInformation processor, int eventId, int eventType) {
        int key;
        TIntIntMap typeToKeyMap = this.customEventCounterKeysMap.get(pmu);
        if (typeToKeyMap == null) {
            typeToKeyMap = new TIntIntHashMap(10, 0.5f, -1, -1);
            this.customEventCounterKeysMap.put(pmu, typeToKeyMap);
        }
        if ((key = typeToKeyMap.get(eventType)) == typeToKeyMap.getNoEntryValue()) {
            key = this.keyCounter++;
            typeToKeyMap.put(eventType, key);
            String counter = pmu.getId() + "_cnt" + key;
            String title = MessageFormat.format(BarmanMessages.UNKNOWN_COUNTER_TITLE, pmu.getCoreName());
            String name = MessageFormat.format(BarmanMessages.UNKNOWN_COUNTER_NAME, Integer.toHexString(eventType));
            String description = BarmanMessages.UNKNOWN_COUNTER_DESCRIPTION;
            this.addCounterRecord(processor, new CounterRecord(counter, title, name, description, null, key));
        } else {
            this.validateCounterCluster(processor, key);
        }
        this.addProcessorEventIdKeyMapping(processor, eventId, key);
    }

    private void addCustomPmuEvents(@NonNull BarmanClustersInfo clustersInfo, @NonNull IBarmanProcessorInformation processor) {
        ProcessorPmu fakePmu = BarmanClustersInfo.getFakeProcessorPmu((int)processor.getMIDR());
        TIntIntIterator it = processor.getPmuEvents().iterator();
        while (it.hasNext()) {
            it.advance();
            int eventId = it.key();
            int eventType = it.value();
            this.addCustomEvent(fakePmu, processor, eventId, eventType);
        }
    }

    private int addEvent(@NonNull IBarmanProcessorInformation processor, @NonNull StockCounter counter) {
        int key = this.countersToKeysMap.get((Object)counter);
        if (key == this.countersToKeysMap.getNoEntryValue()) {
            key = this.keyCounter++;
            this.countersToKeysMap.put((Object)counter, key);
            String id = counter.getCategory().getCounterSetAttribute() + key;
            String name = counter.getName();
            this.addCounterRecord(processor, new CounterRecord(counter, id, name, key));
        } else {
            this.validateCounterCluster(processor, key);
        }
        return key;
    }

    private void addPmuEvents(@NonNull ProcessorPmu pmu, @NonNull CycleCounterAndEvents cycleCounterAndEvents, @NonNull IBarmanProcessorInformation processor) {
        int key;
        StockCounter counter;
        int eventType;
        TIntIntIterator it = processor.getPmuEvents().iterator();
        while (it.hasNext()) {
            it.advance();
            int eventId = it.key();
            eventType = it.value();
            counter = cycleCounterAndEvents.getEvent(eventType);
            if (counter != null) {
                key = this.addEvent(processor, counter);
                this.addProcessorEventIdKeyMapping(processor, eventId, key);
                continue;
            }
            this.addCustomEvent(pmu, processor, eventId, eventType);
        }
        if (processor.getPmuEvents().isEmpty()) {
            TIntObjectIterator it2 = cycleCounterAndEvents.getEvents().iterator();
            while (it2.hasNext()) {
                it2.advance();
                eventType = it2.key();
                counter = (StockCounter)it2.value();
                key = this.addEvent(processor, (StockCounter)NullChecking.neverNull((Object)counter));
                this.addProcessorEventTypeKeyMapping(processor, eventType, key);
            }
        }
    }

    private void addProcessorEventIdKeyMapping(@NonNull IBarmanProcessorInformation processor, int eventId, int key) {
        TIntIntMap eventIdToKeyMap = (TIntIntMap)this.processorToEventIdToKeyMap.get(processor.getProcessorId());
        if (eventIdToKeyMap == null) {
            eventIdToKeyMap = new TIntIntHashMap(10, 0.5f, -1, -1);
            this.processorToEventIdToKeyMap.put(processor.getProcessorId(), (Object)eventIdToKeyMap);
        }
        eventIdToKeyMap.put(eventId, key);
    }

    private void addProcessorEventTypeKeyMapping(@NonNull IBarmanProcessorInformation processor, int eventType, int key) {
        TIntIntMap eventTypeToKeyMap = (TIntIntMap)this.processorToEventTypeToKeyMap.get(processor.getProcessorId());
        if (eventTypeToKeyMap == null) {
            eventTypeToKeyMap = new TIntIntHashMap(10, 0.5f, -1, -1);
            this.processorToEventTypeToKeyMap.put(processor.getProcessorId(), (Object)eventTypeToKeyMap);
        }
        eventTypeToKeyMap.put(eventType, key);
    }

    private void addUserActivityCounter(@NonNull String name, @Nullable Integer cluster) {
        StockCounter counter = new StockCounter(ACTIVITY_CATEGORY, name + "_user", "CPU Activity", "User", true, "Task CPU activity", "activity", "", "", true);
        counter.setDerived(true);
        counter.setRenderingType("bar");
        counter.setAverageSelection(true);
        counter.setPercentage(true);
        counter.setMultiplier(1.0E-4);
        counter.setColor(3858243);
        int key = this.keyCounter++;
        this.countersToKeysMap.put((Object)counter, key);
        String id = counter.getCategory().getCounterSetAttribute() + key;
        CounterRecord counterRecord = new CounterRecord(counter, id, counter.getName(), key);
        counterRecord.setCounter(name + "_user");
        counterRecord.setCluster(cluster);
        this.counterRecords.add(counterRecord);
    }

    private void validateCounterCluster(@NonNull IBarmanProcessorInformation processor, int key) {
        for (CounterRecord record : this.counterRecords) {
            if (record.getKey() != key) continue;
            Integer clusterId = record.getCluster();
            if (clusterId == null || clusterId.intValue() == processor.getClusterId()) break;
            record.setCluster(null);
            break;
        }
    }

    public static class CycleCounterAndEvents {
        private static final @NonNull Map<String, CycleCounterAndEvents> BUILT_IN_MAP = CycleCounterAndEvents.collectCategoryToEventsMapRaw(EventsAndPmusXml.BUILT_IN_EVENTS);
        private final TIntObjectMap<StockCounter> events = new TIntObjectHashMap(10, 0.5f, Integer.MAX_VALUE);

        public static @NonNull Map<ProcessorPmu, CycleCounterAndEvents> collectPmuToEventsMap(@NonNull Collection<ProcessorPmu> pmus, @NonNull Events events) {
            HashMap<ProcessorPmu, CycleCounterAndEvents> result = new HashMap<ProcessorPmu, CycleCounterAndEvents>();
            Map<String, CycleCounterAndEvents> eventsMap = CycleCounterAndEvents.collectCategoryToEventsMap(events);
            for (ProcessorPmu pmu : pmus) {
                CycleCounterAndEvents map = eventsMap.get(pmu.getCounterSet().toLowerCase());
                if (map == null) continue;
                result.put(pmu, map);
            }
            return result;
        }

        public static @NonNull Map<String, CycleCounterAndEvents> collectCategoryToEventsMap(@NonNull Events events) {
            if (events == EventsAndPmusXml.BUILT_IN_EVENTS) {
                return BUILT_IN_MAP;
            }
            return CycleCounterAndEvents.collectCategoryToEventsMapRaw(events);
        }

        private static @NonNull Map<String, CycleCounterAndEvents> collectCategoryToEventsMapRaw(@NonNull Events events) {
            HashMap<String, CycleCounterAndEvents> result = new HashMap<String, CycleCounterAndEvents>();
            for (StockCounter counter : events.getStockCounterMap().values()) {
                Category category = counter.getCategory();
                String counterSet = category.getCounterSetAttribute();
                if (counterSet == null || !counterSet.endsWith("_cnt") || counter.getOptionSet() != null) continue;
                String key = counterSet.replaceAll("_cnt$", "").toLowerCase();
                CycleCounterAndEvents mapping = (CycleCounterAndEvents)result.get(key);
                if (mapping == null) {
                    mapping = new CycleCounterAndEvents();
                    result.put(key, mapping);
                }
                String name = counter.getCounterName();
                Long event = counter.getEvent();
                if (name == null || name.isEmpty()) {
                    int eventIdInt;
                    assert (event != null);
                    long eventIdLong = event;
                    if (eventIdLong != (long)(eventIdInt = (int)eventIdLong)) continue;
                    mapping.put(eventIdInt, counter);
                    continue;
                }
                if (!name.endsWith("_ccnt")) continue;
                mapping.setCycleCounter(counter);
            }
            return result;
        }

        public @Nullable StockCounter getEvent(int eventType) {
            return (StockCounter)this.events.get(eventType);
        }

        public TIntObjectMap<StockCounter> getEvents() {
            return this.events;
        }

        private void setCycleCounter(@NonNull StockCounter cycleCounter) {
            this.put(-1, cycleCounter);
        }

        private void put(int type, @NonNull StockCounter counter) {
            StockCounter oldCounter = (StockCounter)this.events.put(type, (Object)counter);
            if (oldCounter != null && oldCounter != counter) {
                throw new AssertionError((Object)("Duplicate counters with same event id: " + String.valueOf(oldCounter) + " vs " + String.valueOf(counter)));
            }
        }
    }
}

