/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.authentication;

import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.authentication.TargetAuthenticationConfig;
import com.arm.streamline.authentication.TargetAuthenticationDialog;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.ui.part.lpv.SshTargetLauncher;
import com.arm.streamline.utility.target.CredentialsAddress;
import com.arm.utils.NullChecking;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

@SuppressFBWarnings(value={"HARD_CODE_KEY"})
public final class TargetAuthentication
implements Cloneable {
    private static final Map<@NonNull CredentialsAddress, @NonNull TargetAuthentication> CACHE = new HashMap<CredentialsAddress, TargetAuthentication>();
    private static final Map<@NonNull CredentialsAddress, @NonNull TargetAuthentication> SSH_CACHE = new HashMap<CredentialsAddress, TargetAuthentication>();
    private static final String TAG_CREDENTRIALS = "credentials";
    private static final String TAG_AUTHENTICATIONS = "authentications";
    private static final String TAG_AUTHENTICATION = "authentication";
    private static final String ATTR_ADDRESS = "address";
    private static final String ATTR_USERNAME = "user";
    private static final String ATTR_PASSWORD = "pass";
    private static final String ATTR_ROOT_PASSWORD = "root";
    private static final String TAG_SSH_AUTHENTICATIONS = "ssh_authentications";
    private static final String TAG_SSH_AUTHENTICATION = "ssh_authentication";
    private static final String ATTR_SSH_SESSION_NAME = "session_name";
    private static final String ATTR_SSH_ADDRESS = "address";
    private static final String ATTR_SSH_PORT = "port";
    private static final String ATTR_SSH_USERNAME = "user";
    private static final String ATTR_SSH_PASSWORD = "pass";
    private static final String ATTR_SSH_PASS_KEY = "key_file";
    private static final String ATTR_SSH_GATOR_PATH = "gator_path";
    private static final String ATTR_SSH_GATOR_PORT = "gator_port";
    private static final byte[] KEY = new byte[]{34, 115, 1, 52, 85, 8, 119, 35};
    private @NonNull CredentialsAddress mAddress = new CredentialsAddress(false, "");
    private String mUserName = "";
    private String mPassword = "";
    private String mRootPassword = "";
    private @NonNull CredentialsAddress mSSHAddress = new CredentialsAddress(false, "");
    private @NonNull String mSSHSessionName = "";
    private int mSSHPort;
    private @NonNull String mSSHUserName = "";
    private String mSSHPassKey = "";
    private String mSSHPassword = "";
    private @NonNull String mSSHGatorPath = "";
    private int mSSHGatorPort;

    public static @Nullable TargetAuthentication getFromCache(@NonNull CredentialsAddress address) {
        return CACHE.get(address);
    }

    public static @Nullable TargetAuthentication getFromSSHCache(@NonNull CredentialsAddress address) {
        return SSH_CACHE.get(address);
    }

    public static @Nullable TargetAuthentication getFromCacheOrCreate(@NonNull CredentialsAddress address, TargetAuthenticationConfig config, boolean allowTargetChange) {
        TargetAuthentication result = CACHE.get(address);
        return result == null ? TargetAuthentication.prompt(address, config, allowTargetChange) : result;
    }

    public static boolean isCached(@NonNull CredentialsAddress address) {
        return CACHE.containsKey(address);
    }

    public static boolean isSSHCached(@NonNull CredentialsAddress address) {
        return SSH_CACHE.containsKey(address);
    }

    public static void loadCache() {
        String cache = StreamlinePreferences.getAuthCache();
        if (!cache.isEmpty()) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (XMLParser xml = new XMLParser((InputStream)new ByteArrayInputStream(cache.getBytes(StandardCharsets.UTF_8)));){
                    String tag;
                    String marker = xml.getMarker();
                    while ((tag = xml.nextTag(marker)) != null) {
                        if (tag.equals(TAG_CREDENTRIALS)) {
                            tag = xml.nextTag(marker);
                            if (TAG_AUTHENTICATIONS.equals(tag)) {
                                TargetAuthentication.loadCachePerStorage(xml, CACHE, TAG_AUTHENTICATION);
                            }
                            if (TAG_SSH_AUTHENTICATIONS.equals(tag = xml.nextTag(marker))) {
                                TargetAuthentication.loadCachePerStorage(xml, SSH_CACHE, TAG_SSH_AUTHENTICATION);
                            }
                        }
                        xml.skip();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
    }

    public static @Nullable TargetAuthentication prompt(@NonNull CredentialsAddress address, TargetAuthenticationConfig config, boolean allowTargetChange) {
        TargetAuthentication authentication = new TargetAuthentication();
        authentication.setAddress(address);
        return TargetAuthentication.prompt(authentication, config, allowTargetChange);
    }

    public static @Nullable TargetAuthentication prompt(TargetAuthentication authentication, TargetAuthenticationConfig config, boolean allowTargetChange) {
        UIHelper helper = new UIHelper(authentication, config, allowTargetChange);
        Task.blockingCallOnUIThread((Runnable)helper);
        return helper.getAuthentication();
    }

    public static void saveCache() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (XMLGenerator xml = new XMLGenerator((OutputStream)baos);){
                xml.startDocument();
                xml.startTag(TAG_CREDENTRIALS);
                TargetAuthentication.saveCache(TAG_AUTHENTICATIONS, xml);
                TargetAuthentication.saveSSHCache(TAG_SSH_AUTHENTICATIONS, xml);
                xml.endTag();
                xml.endDocument();
                StreamlinePreferences.setAuthCache(baos.toString(StandardCharsets.UTF_8.name()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            CommonPlugin.error((Throwable)exception);
        }
    }

    private static String decrypt(String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        byte[] buffer = new byte[bytes.length / 2];
        int i = 0;
        while (i < buffer.length) {
            buffer[i] = (byte)((TargetAuthentication.getHexDigit(bytes[i * 2]) << 4) + TargetAuthentication.getHexDigit(bytes[i * 2 + 1]) & 0xFF);
            ++i;
        }
        byte[] result = new byte[buffer.length];
        int i2 = 0;
        while (i2 < buffer.length) {
            result[result.length - (i2 + 1)] = (byte)((buffer[i2] ^ KEY[(buffer.length - (i2 + 1)) % KEY.length]) & 0xFF);
            ++i2;
        }
        return new String(result, StandardCharsets.UTF_8);
    }

    private static String encrypt(String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        byte[] result = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            result[result.length - (i + 1)] = (byte)((bytes[i] ^ KEY[i % KEY.length]) & 0xFF);
            ++i;
        }
        StringBuilder buffer = new StringBuilder(result.length * 2);
        byte[] byArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            Object hex = Integer.toHexString(b & 0xFF);
            if (((String)hex).length() < 2) {
                hex = "0" + (String)hex;
            }
            buffer.append((String)hex);
            ++n2;
        }
        return buffer.toString();
    }

    private static final @NonNull String filter(String in, boolean trim) {
        return in != null ? (trim ? in.trim() : in) : "";
    }

    private static int getHexDigit(byte b) {
        return b <= 57 ? b - 48 : 10 + b - 97;
    }

    private static void loadCachePerStorage(XMLParser xml, Map<@NonNull CredentialsAddress, @NonNull TargetAuthentication> cache, String tags) throws IOException {
        String tag;
        cache.clear();
        String marker = xml.getMarker();
        boolean isSSH = tags.equals(TAG_SSH_AUTHENTICATION);
        while ((tag = xml.nextTag(marker)) != null) {
            if (tags.equals(tag)) {
                CredentialsAddress address;
                TargetAuthentication authentication = new TargetAuthentication();
                if (isSSH) {
                    authentication.loadSSH(xml);
                } else {
                    authentication.load(xml);
                }
                CredentialsAddress credentialsAddress = address = isSSH ? authentication.getSSHAddress() : authentication.getAddress();
                if (address.address.isEmpty()) continue;
                cache.put(address, authentication);
                continue;
            }
            xml.skip();
        }
    }

    private static void saveCache(String tag, XMLGenerator xml) throws IOException {
        ArrayList<@NonNull CredentialsAddress> keys = new ArrayList<CredentialsAddress>(CACHE.keySet());
        Collections.sort(keys);
        xml.startTag(tag);
        for (CredentialsAddress key : keys) {
            ((TargetAuthentication)NullChecking.neverNull((Object)CACHE.get(key))).save(TAG_AUTHENTICATION, xml);
        }
        xml.endTag();
    }

    public final TargetAuthentication clone() {
        try {
            return (TargetAuthentication)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            return null;
        }
    }

    public final @NonNull CredentialsAddress getAddress() {
        return this.mAddress;
    }

    public final String getPassword() {
        return this.mPassword;
    }

    public final String getRootPassword() {
        return this.mRootPassword;
    }

    public final String getUsername() {
        return this.mUserName;
    }

    public final void setAddress(@NonNull CredentialsAddress address) {
        this.mAddress = address;
    }

    public final void setPassword(String password) {
        this.mPassword = TargetAuthentication.filter(password, false);
    }

    public final void setRootPassword(String password) {
        this.mRootPassword = TargetAuthentication.filter(password, false);
    }

    public final void setUserName(String userName) {
        this.mUserName = TargetAuthentication.filter(userName, true);
    }

    private final void load(XMLParser xml) {
        this.mAddress = new CredentialsAddress(new TargetAddressString(TargetAuthentication.filter(xml.getAttribute("address"), true)));
        this.mUserName = TargetAuthentication.filter(xml.getAttribute("user"), true);
        this.mPassword = TargetAuthentication.filter(TargetAuthentication.decrypt(xml.getAttribute("pass", "")), false);
        this.mRootPassword = TargetAuthentication.filter(TargetAuthentication.decrypt(xml.getAttribute(ATTR_ROOT_PASSWORD, "")), false);
    }

    private final void save(String tag, XMLGenerator xml) throws IOException {
        xml.startEmptyTag(tag);
        xml.addAttributeNotEmpty("address", this.mAddress.toString());
        xml.addAttributeNotEmpty("user", this.mUserName);
        xml.addAttributeNotEmpty("pass", TargetAuthentication.encrypt(this.mPassword));
        xml.addAttributeNotEmpty(ATTR_ROOT_PASSWORD, TargetAuthentication.encrypt(this.mRootPassword));
    }

    public static void cache(@Nullable TargetAuthentication cache) {
        if (cache != null) {
            CACHE.put(cache.getAddress(), cache);
        }
    }

    private static void saveSSHCache(String tag, XMLGenerator xml) throws IOException {
        ArrayList<@NonNull CredentialsAddress> keys = new ArrayList<CredentialsAddress>(SSH_CACHE.keySet());
        Collections.sort(keys);
        xml.startTag(tag);
        for (CredentialsAddress key : keys) {
            ((TargetAuthentication)NullChecking.neverNull((Object)SSH_CACHE.get(key))).saveSSH(TAG_SSH_AUTHENTICATION, xml);
        }
        xml.endTag();
    }

    public final @NonNull CredentialsAddress getSSHAddress() {
        return this.mSSHAddress;
    }

    public @NonNull String getSSHSessionName() {
        return this.mSSHSessionName;
    }

    public final int getSSHPort() {
        return this.mSSHPort;
    }

    public @NonNull String getSSHUserName() {
        return this.mSSHUserName;
    }

    public final String getSSHPassword() {
        return this.mSSHPassword;
    }

    public String getSSHPassKey() {
        return this.mSSHPassKey;
    }

    public void setSSHPassKey(String mSSHPassKey) {
        this.mSSHPassKey = mSSHPassKey;
    }

    public final void setSSHAddress(@NonNull CredentialsAddress address) {
        this.mSSHAddress = address;
    }

    public final void setSSHPassword(String password) {
        this.mSSHPassword = TargetAuthentication.filter(password, false);
    }

    public @NonNull String getSSHGatorPath() {
        return this.mSSHGatorPath;
    }

    public void setSSHGatorPath(String mSSHGatorPath) {
        this.mSSHGatorPath = TargetAuthentication.filter(mSSHGatorPath, true);
    }

    public int getSSHGatorPort() {
        return this.mSSHGatorPort;
    }

    public void setSSHGatorPort(int mSSHGatorPort) {
        this.mSSHGatorPort = mSSHGatorPort;
    }

    public final void setSSHUserName(String userName) {
        this.mSSHUserName = TargetAuthentication.filter(userName, true);
    }

    public final void setSSHSessionName(String sessionName) {
        this.mSSHSessionName = TargetAuthentication.filter(sessionName, true);
    }

    public void setSSHPort(int mSSHPort) {
        this.mSSHPort = mSSHPort;
    }

    private final void loadSSH(XMLParser xml) {
        this.mSSHAddress = new CredentialsAddress(new TargetAddressString(TargetAuthentication.filter(xml.getAttribute("address"), true)));
        this.mSSHSessionName = TargetAuthentication.filter(xml.getAttribute(ATTR_SSH_SESSION_NAME), true);
        try {
            this.mSSHPort = Integer.parseInt(TargetAuthentication.filter(xml.getAttribute(ATTR_SSH_PORT, ""), true));
            this.mSSHGatorPort = Integer.parseInt(TargetAuthentication.filter(xml.getAttribute(ATTR_SSH_GATOR_PORT, ""), true));
        }
        catch (NumberFormatException e) {
            CommonPlugin.info((String)String.format("Failed to read port from session.xml. Expected number but got sshport=%s, gatorport=%s", xml.getAttribute(ATTR_SSH_PORT, ""), xml.getAttribute(ATTR_SSH_GATOR_PORT, "")));
        }
        this.mSSHUserName = TargetAuthentication.filter(xml.getAttribute("user", ""), true);
        this.mSSHPassword = TargetAuthentication.filter(TargetAuthentication.decrypt(xml.getAttribute("pass", "")), true);
        this.mSSHPassKey = TargetAuthentication.filter(xml.getAttribute(ATTR_SSH_PASS_KEY, ""), true);
        this.mSSHGatorPath = TargetAuthentication.filter(xml.getAttribute(ATTR_SSH_GATOR_PATH, ""), true);
    }

    private final void saveSSH(String tag, XMLGenerator xml) throws IOException {
        xml.startEmptyTag(tag);
        xml.addAttributeNotEmpty("address", this.mSSHAddress.toString());
        xml.addAttributeNotEmpty("user", this.mSSHUserName);
        xml.addAttributeNotEmpty("pass", TargetAuthentication.encrypt(this.mSSHPassword));
        xml.addAttributeNotEmpty(ATTR_SSH_PASS_KEY, this.mSSHPassKey);
        xml.addAttributeNotEmpty(ATTR_SSH_SESSION_NAME, this.mSSHSessionName);
        xml.addAttributeNotEmpty(ATTR_SSH_PORT, String.valueOf(this.mSSHPort));
        xml.addAttributeNotEmpty(ATTR_SSH_GATOR_PATH, this.mSSHGatorPath);
        xml.addAttributeNotEmpty(ATTR_SSH_GATOR_PORT, String.valueOf(this.mSSHGatorPort));
    }

    public static void cacheSSH(@Nullable TargetAuthentication cache) {
        if (cache != null) {
            SSH_CACHE.put(cache.getSSHAddress(), cache);
        }
    }

    public static void removeFromSSHCache(String address) {
        SSH_CACHE.remove(new CredentialsAddress(new TargetAddressString(address)));
    }

    public static @NonNull SshTargetLauncher[] getCachedTargets() {
        return SSH_CACHE.values().stream().map(targetAuth -> SshTargetLauncher.create(targetAuth.getSSHAddress().toString(), "", "", "", targetAuth.getSSHSessionName(), targetAuth.getSSHUserName(), targetAuth.getSSHPassword(), targetAuth.getSSHPassKey(), targetAuth.getSSHPort(), targetAuth.getSSHGatorPort(), targetAuth.getSSHGatorPath(), false)).collect(Collectors.toList()).toArray(new SshTargetLauncher[SSH_CACHE.values().size()]);
    }

    public static class Address {
        private final String mHostname;
        private final int mPort;

        public Address(String hostname, int port) {
            this.mHostname = hostname;
            this.mPort = port;
        }

        public String getHostname() {
            return this.mHostname;
        }

        public int getPort() {
            return this.mPort;
        }
    }

    private static class UIHelper
    implements Runnable {
        private TargetAuthentication mAuthentication;
        private TargetAuthenticationConfig mConfig;
        private boolean mAllowTargetChange;

        UIHelper(TargetAuthentication authentication, TargetAuthenticationConfig config, boolean allowTargetChange) {
            this.mAuthentication = authentication;
            this.mConfig = config;
            this.mAllowTargetChange = allowTargetChange;
        }

        @Override
        public void run() {
            TargetAuthenticationDialog dialog = new TargetAuthenticationDialog(this.mAuthentication, this.mConfig, this.mAllowTargetChange);
            this.mAuthentication = dialog.open() == 0 ? dialog.getResult() : null;
        }

        public @Nullable TargetAuthentication getAuthentication() {
            return this.mAuthentication;
        }
    }
}

