/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application.preferences.editors;

import com.arm.streamline.application.preferences.PreferencesMessages;
import com.arm.streamline.application.preferences.editors.TableEditor;
import com.arm.streamline.model.session.PathWithEnabledFlag;
import com.arm.utils.NullChecking;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class EditablePathWithEnabledFlagEditor
extends TableEditor<PathWithEnabledFlag> {
    private static final @NonNull TableEditor.ITableEditorColumn<PathWithEnabledFlag> @NonNull [] COLUMS = new TableEditor.ITableEditorColumn[]{new TableEditor.ITableEditorColumn<PathWithEnabledFlag>(){

        @Override
        public @NonNull String getColumnLabel() {
            return "Enabled";
        }

        @Override
        public @Nullable Image getItemImage(@NonNull PathWithEnabledFlag value) {
            return null;
        }

        @Override
        public @NonNull String getItemLabel(@NonNull PathWithEnabledFlag value) {
            return value.isUsed() ? "\u2713" : "\u2717";
        }

        @Override
        public int getSwtColumnStyle() {
            return 0x1000000;
        }
    }, new TableEditor.ITableEditorColumn<PathWithEnabledFlag>(){

        @Override
        public @NonNull String getColumnLabel() {
            return "Path";
        }

        @Override
        public @Nullable Image getItemImage(@NonNull PathWithEnabledFlag value) {
            return null;
        }

        @Override
        public @NonNull String getItemLabel(@NonNull PathWithEnabledFlag value) {
            return value.getPath();
        }

        @Override
        public int getSwtColumnStyle() {
            return 16384;
        }
    }};
    private @Nullable String dirChooserLabelText;
    private @Nullable String lastPath;
    private @Nullable Button toggleStateButton;

    public static @NonNull String createPrefValue(@NonNull Collection<@NonNull PathWithEnabledFlag> items) {
        StringBuilder result = new StringBuilder();
        for (PathWithEnabledFlag item : items) {
            if (!result.isEmpty()) {
                result.append(File.pathSeparator);
            }
            result.append(EditablePathWithEnabledFlagEditor.stringify(item));
        }
        return result.toString();
    }

    public static @NonNull PathWithEnabledFlag @NonNull [] parsePrefValueAsPaths(@Nullable String stringList) {
        if (stringList == null) {
            return new PathWithEnabledFlag[0];
        }
        StringTokenizer st = new StringTokenizer(stringList, File.pathSeparator + "\n\r");
        ArrayList<PathWithEnabledFlag> result = new ArrayList<PathWithEnabledFlag>();
        while (st.hasMoreElements()) {
            String entry = (String)NullChecking.neverNull((Object)((String)st.nextElement()));
            PathWithEnabledFlag item = EditablePathWithEnabledFlagEditor.splitItem(entry);
            if (item == null) {
                assert (false);
                continue;
            }
            result.add(item);
        }
        return (PathWithEnabledFlag[])result.toArray(PathWithEnabledFlag[]::new);
    }

    public static @Nullable PathWithEnabledFlag splitItem(@Nullable String entry) {
        if (entry == null || entry.isEmpty()) {
            return null;
        }
        char prefix = entry.charAt(0);
        String path = entry.substring(1);
        if (path.isBlank() || prefix != '+' && prefix != '-') {
            return null;
        }
        return new PathWithEnabledFlag(new File(path), prefix == '+');
    }

    private static @NonNull String stringify(@NonNull PathWithEnabledFlag item) {
        return String.format("%s%s", item.isUsed() ? "+" : "-", item.getPath());
    }

    public EditablePathWithEnabledFlagEditor(@NonNull String name, @NonNull String labelText, @Nullable String dirChooserLabelText, @NonNull Composite parent, boolean allowUpDown) {
        super(name, labelText, parent, allowUpDown, COLUMS);
        this.dirChooserLabelText = dirChooserLabelText;
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        Composite buttonBox = (Composite)NullChecking.neverNull((Object)this.getButtonBox());
        Button toggleStateButton = new Button(buttonBox, 8);
        toggleStateButton.setText(PreferencesMessages.TOGGLE_STATE_LABEL);
        toggleStateButton.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)toggleStateButton, 61);
        data.widthHint = Math.max(widthHint, toggleStateButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        toggleStateButton.setLayoutData((Object)data);
        this.toggleStateButton = toggleStateButton;
        Control[] bbChildren = buttonBox.getChildren();
        assert (bbChildren.length > 1);
        assert (bbChildren[1] instanceof Button);
        toggleStateButton.moveBelow(bbChildren[1]);
        buttonBox.addDisposeListener(e -> {
            Button button = this.toggleStateButton = null;
        });
        toggleStateButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EditablePathWithEnabledFlagEditor.this.toggleListSelection();
            }
        });
        this.onSelectionChanged();
    }

    @Override
    protected @Nullable PathWithEnabledFlag getNewRowValue() {
        String dir;
        String dirChooserLabelText = this.dirChooserLabelText;
        String lastPath = this.lastPath;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0x10000000);
        if (dirChooserLabelText != null) {
            dialog.setMessage(dirChooserLabelText);
        }
        if (lastPath != null && new File(lastPath).isDirectory()) {
            dialog.setFilterPath(lastPath);
        }
        if ((dir = dialog.open()) == null) {
            return null;
        }
        this.lastPath = dir;
        return new PathWithEnabledFlag(new File(dir), true);
    }

    protected @NonNull PathWithEnabledFlag @NonNull [] newValuesArray(int length) {
        return new PathWithEnabledFlag[length];
    }

    @Override
    protected void onSelectionChanged() {
        super.onSelectionChanged();
        Button toggleStateButton = this.toggleStateButton;
        if (toggleStateButton == null) {
            return;
        }
        Table table = this.getTable();
        if (table == null) {
            return;
        }
        toggleStateButton.setEnabled(table.getSelectionCount() > 0);
    }

    protected @NonNull PathWithEnabledFlag @NonNull [] valuesFromString(@NonNull String prefValue) {
        return EditablePathWithEnabledFlagEditor.parsePrefValueAsPaths(prefValue);
    }

    protected @NonNull String valuesToString(@NonNull PathWithEnabledFlag @NonNull [] values) {
        return EditablePathWithEnabledFlagEditor.createPrefValue(Arrays.asList(values));
    }

    private void toggleListSelection() {
        Table table = this.getTable();
        if (table == null) {
            return;
        }
        int[] is = table.getSelectionIndices();
        int n = 0;
        while (n < is.length) {
            int index = is[n];
            TableItem tableItem = table.getItem(index);
            PathWithEnabledFlag oldValue = (PathWithEnabledFlag)NullChecking.neverNull((Object)((PathWithEnabledFlag)tableItem.getData()));
            PathWithEnabledFlag newValue = new PathWithEnabledFlag(oldValue.getFile(), !oldValue.isUsed());
            this.populateItemFromValue(tableItem, newValue);
            ++n;
        }
    }
}

