/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.splash.EclipseSplashHandler;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class StreamlineSplashHandler
extends EclipseSplashHandler {
    private Image image;
    private final @NonNull String splashPath;

    protected StreamlineSplashHandler(@NonNull String splashPath) {
        this.splashPath = splashPath;
    }

    public void dispose() {
        super.dispose();
        if (this.image != null) {
            this.image.dispose();
        }
    }

    public void init(Shell splash) {
        super.init(splash);
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.arm.streamline", (String)this.splashPath);
        final Image image = descriptor != null ? descriptor.createImage() : null;
        this.image = image;
        if (image != null) {
            final int xposition = (splash.getSize().x - image.getImageData().width) / 2;
            final int yposition = (splash.getSize().y - image.getImageData().height) / 2;
            this.getContent().addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.drawImage(image, xposition, yposition);
                }
            });
        }
    }

    public static final class Ds
    extends StreamlineSplashHandler {
        private static final @NonNull String SPLASH_PATH_DS = "images/branding/streamline-splash-ds-455x297.png";

        public Ds() {
            super(SPLASH_PATH_DS);
        }
    }
}

