/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.timeline;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.database.api.IAnalysisReaderFactoryV2;
import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.processor.timeline.ThreadActivity;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.analysis.session.SessionSettings;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.utils.collections.ArrayOf;
import java.io.IOException;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.eclipse.jdt.annotation.NonNull;

public class ThreadsActivity
extends AnalysisBase {
    private ArrayOf<ThreadActivity> mTraces;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public ThreadsActivity(SessionSettings settings, @NonNull SessionProcessor sp, int clusterCount, @NonNull ToIntFunction<@NonNull ProcessingElementReference> peReferenceToClusterNumber, @NonNull ICaptureDetails captureDetails, @NonNull IAnalysisReaderFactoryV2 analysisReaderFactory) throws IOException {
        super(sp);
        @NonNull @NonNull Set activityStreams = analysisReaderFactory.enumerateActivityStreams();
        this.mTraces = new ArrayOf(activityStreams.size());
        int i = 0;
        for (IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream activityStream : activityStreams) {
            this.mTraces.set(i++, (Object)new ThreadActivity(settings, sp, clusterCount, peReferenceToClusterNumber, captureDetails, activityStream));
        }
    }

    @Override
    public void close() {
        if (this.mTraces != null) {
            int i = 0;
            while (i < this.mTraces.length()) {
                ThreadActivity value = (ThreadActivity)this.mTraces.swap(i, null);
                if (value != null) {
                    value.close();
                }
                ++i;
            }
            this.mTraces = null;
        }
    }

    @Override
    public void interrupt() {
        super.interrupt();
        if (this.mTraces != null) {
            for (ThreadActivity trace : this.mTraces) {
                if (trace == null) continue;
                trace.interrupt();
            }
        }
    }

    @Override
    public void join() {
        super.join();
        if (this.mTraces != null) {
            for (ThreadActivity trace : this.mTraces) {
                if (trace == null) continue;
                trace.join();
            }
        }
    }

    @Override
    protected void process() {
    }
}

