/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.timeline;

import com.arm.streamline.common.utility.io.Compression;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.streamline.report.shared.io.IndexDataFile;
import com.arm.utils.ArrayUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TLongSet;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ThreadActivityEntry
implements Closeable {
    private final int activityCount;
    private int channelCount;
    private final @NonNull IntUnaryOperator channelToClusterMapper;
    private final @NonNull ChartClusterState @NonNull [] counterStateByCluster;
    private final boolean cpuActivity;
    private final @Nullable Integer @NonNull [] currentlyActiveUtidByChannel;
    private final boolean generateHeatMapData;
    private final @NonNull IndexDataFile @NonNull [] heatmapIndexDataFileByActivity;
    private int indexCounter;
    private final int nonProcHeatmapUtid;
    private final boolean procCounter;
    private final boolean supportsMultipleClusters;
    private final @NonNull TIntObjectMap<ThreadState> threadStateByUtid = new TIntObjectHashMap(10, 0.5f, -1);
    private final @NonNull ThreadState threadStateForSystemWide;
    private final @NonNull Set<@NonNull UniqueThread> threadsToRemove = new HashSet<UniqueThread>();
    private int tickCounter;
    private final int tickLimit;
    private final @NonNull IUniqueIds uniqueIds;
    private boolean writeFlag1;
    private boolean writeFlag2;

    private static void accumulateTotalTimeForChannel(long @NonNull [] channelTotals, @NonNull ThreadState threadState) {
        long[][] lArray = threadState.percentageInfoByActivityByChannel;
        int n = threadState.percentageInfoByActivityByChannel.length;
        int n2 = 0;
        while (n2 < n) {
            long[] activity = lArray[n2];
            int channelNumber = 0;
            while (channelNumber < activity.length) {
                int n3 = channelNumber;
                channelTotals[n3] = channelTotals[n3] + activity[channelNumber];
                ++channelNumber;
            }
            ++n2;
        }
    }

    private static void calculatePercentageFor(long @NonNull [] channelTotals, int @NonNull [] percentageTotals, long @NonNull [] @NonNull [] max, @NonNull ThreadState threadState) {
        long[][] lArray = threadState.percentageInfoByActivityByChannel;
        int n = threadState.percentageInfoByActivityByChannel.length;
        int n2 = 0;
        while (n2 < n) {
            long[] activity = lArray[n2];
            int channelNumber = 0;
            while (channelNumber < activity.length) {
                float time = 0.0f;
                if (channelTotals[channelNumber] > 0L) {
                    time = activity[channelNumber];
                    time = 10000.0f * time / (float)channelTotals[channelNumber];
                }
                int calc = (int)time;
                if (time > 0.0f && calc == 0) {
                    calc = 1;
                } else if (time < 0.0f) {
                    calc = 0;
                }
                activity[channelNumber] = calc;
                int n3 = channelNumber;
                percentageTotals[n3] = percentageTotals[n3] + calc;
                if (activity[channelNumber] > max[channelNumber][channelNumber]) {
                    max[channelNumber] = activity;
                }
                ++channelNumber;
            }
            ++n2;
        }
    }

    private static void clearPercentageInfo(@NonNull ThreadState threadState) {
        long[][] lArray = threadState.percentageInfoByActivityByChannel;
        int n = threadState.percentageInfoByActivityByChannel.length;
        int n2 = 0;
        while (n2 < n) {
            long[] activity = lArray[n2];
            Arrays.fill(activity, 0L);
            ++n2;
        }
    }

    private static byte @NonNull [] makeHeatmapBytes(int uid, int coreNo, int stateIndexOrPercent) {
        assert (uid >= -1);
        assert (coreNo >= -1);
        assert (stateIndexOrPercent >= -1);
        assert (coreNo < 0 || stateIndexOrPercent > 0);
        return new byte[]{(byte)uid, (byte)(uid >>> 8), (byte)(uid >>> 16), (byte)(uid >>> 24), (byte)coreNo, (byte)(coreNo >>> 8), (byte)(coreNo >>> 16), (byte)(coreNo >>> 24), (byte)stateIndexOrPercent, (byte)(stateIndexOrPercent >>> 8), (byte)(stateIndexOrPercent >>> 16), (byte)(stateIndexOrPercent >>> 24)};
    }

    public ThreadActivityEntry(boolean cpuActivity, boolean supportsMultipleClusters, boolean procCounter, @NonNull IUniqueIds uniqueIds, int channelNumbers, @NonNull File @NonNull [] heatmapPathByActivity, int tickLimit, @NonNull File @NonNull [] @NonNull [] counterPathByClusterByActivity, @NonNull IntUnaryOperator channelToClusterMapper, boolean mGenerateHeatMaps) throws IOException {
        this.cpuActivity = cpuActivity;
        this.supportsMultipleClusters = supportsMultipleClusters;
        this.procCounter = procCounter;
        this.generateHeatMapData = mGenerateHeatMaps;
        this.uniqueIds = uniqueIds;
        this.channelCount = channelNumbers;
        this.tickCounter = this.tickLimit = tickLimit;
        this.nonProcHeatmapUtid = uniqueIds.getAnyThreadUtid();
        this.channelToClusterMapper = channelToClusterMapper;
        this.counterStateByCluster = (ChartClusterState[])ArrayUtils.createNonNull(ChartClusterState[]::new, (int)counterPathByClusterByActivity.length, i -> new ChartClusterState(counterPathByClusterByActivity[i]));
        if (this.counterStateByCluster.length > 1 && !supportsMultipleClusters || this.counterStateByCluster.length == 0) {
            throw new IllegalArgumentException("Invalid cluster list");
        }
        int activityCount = -1;
        ChartClusterState[] chartClusterStateArray = this.counterStateByCluster;
        int n = this.counterStateByCluster.length;
        int n2 = 0;
        while (n2 < n) {
            ChartClusterState c = chartClusterStateArray[n2];
            if (activityCount < 0) {
                activityCount = c.activities.length;
            } else if (activityCount != c.activities.length) {
                throw new IllegalArgumentException("Invalid activity map");
            }
            ++n2;
        }
        this.activityCount = activityCount;
        if (activityCount == 0 || cpuActivity && activityCount != 2) {
            throw new IllegalArgumentException("Invalid activity map for scheduler");
        }
        this.threadStateForSystemWide = new ThreadState(null, activityCount, this.channelCount);
        this.currentlyActiveUtidByChannel = new Integer[channelNumbers];
        if (mGenerateHeatMaps && (cpuActivity ? heatmapPathByActivity.length != 1 : heatmapPathByActivity.length != activityCount)) {
            throw new IllegalArgumentException("Invalid index paths list");
        }
        this.heatmapIndexDataFileByActivity = mGenerateHeatMaps ? (IndexDataFile[])ArrayUtils.createNonNull(IndexDataFile[]::new, (int)heatmapPathByActivity.length, i -> new IndexDataFile(heatmapPathByActivity[i])) : new IndexDataFile[0];
    }

    public void addLimitIndices(@NonNull TLongSet set, int clusterIndex, int activity) {
        ChartActivityState state = this.counterStateByCluster[clusterIndex].activities[activity];
        set.add((long)state.limitMinIndex);
        set.add((long)state.limitMaxIndex);
    }

    public void addTime(long time) {
        int channelNumber = 0;
        while (channelNumber < this.channelCount) {
            Integer utid = this.currentlyActiveUtidByChannel[channelNumber];
            ThreadState threadState = this.getOrCreateThreadState(utid);
            long[] percentInfo = threadState.percentageInfoByActivityByChannel[threadState.currentActivity];
            this.writeFlag2 = true;
            this.writeFlag1 = true;
            int n = channelNumber++;
            percentInfo[n] = percentInfo[n] + time;
        }
    }

    @Override
    public void close() throws IOException {
        Throwing.closeAll((Iterable[])new Iterable[]{Arrays.asList(this.heatmapIndexDataFileByActivity), Arrays.asList(this.counterStateByCluster)});
    }

    public void normalize() {
        if (!this.writeFlag2) {
            return;
        }
        long[] channelTotal = new long[this.channelCount];
        ThreadActivityEntry.accumulateTotalTimeForChannel(channelTotal, this.threadStateForSystemWide);
        for (ThreadState entry : this.threadStateByUtid.valueCollection()) {
            ThreadActivityEntry.accumulateTotalTimeForChannel(channelTotal, entry);
        }
        int[] percentageTotal = new int[this.channelCount];
        long[][] max = new long[this.channelCount][this.channelCount];
        ThreadActivityEntry.calculatePercentageFor(channelTotal, percentageTotal, max, this.threadStateForSystemWide);
        for (ThreadState entry : this.threadStateByUtid.valueCollection()) {
            ThreadActivityEntry.calculatePercentageFor(channelTotal, percentageTotal, max, entry);
        }
        int channelNumber = 0;
        while (channelNumber < this.channelCount) {
            int target = 10000;
            int diff = target - percentageTotal[channelNumber];
            if (diff != 0) {
                long[] lArray = max[channelNumber];
                int n = channelNumber;
                lArray[n] = lArray[n] + (long)diff;
                if (max[channelNumber][channelNumber] < 0L) {
                    max[channelNumber][channelNumber] = 0L;
                }
            }
            ++channelNumber;
        }
    }

    public void output() throws IOException {
        if (this.writeFlag2) {
            this.writeFlag2 = this.writeFlag1;
            this.writeFlag1 = false;
            boolean[] heatmapModified = new boolean[this.heatmapIndexDataFileByActivity.length];
            boolean[][] counterWrittenByClusterByActivity = new boolean[this.counterStateByCluster.length][this.activityCount];
            ThreadActivityEntry.clearPercentageInfo(this.threadStateForSystemWide);
            if (this.procCounter) {
                for (ThreadState threadState : this.threadStateByUtid.valueCollection()) {
                    UniqueThread thread = (UniqueThread)NullChecking.neverNull((Object)threadState.thread);
                    this.outputFor(heatmapModified, counterWrittenByClusterByActivity, !thread.isIdle(), threadState, thread.getUid(), thread.getUid());
                }
            } else {
                ThreadState threadState;
                assert (this.threadStateByUtid.size() <= 1);
                threadState = (ThreadState)this.threadStateByUtid.get(-1);
                if (threadState != null) {
                    this.outputFor(heatmapModified, counterWrittenByClusterByActivity, true, threadState, -1, this.nonProcHeatmapUtid);
                }
            }
            int i = 0;
            while (i < this.heatmapIndexDataFileByActivity.length) {
                if (!heatmapModified[i]) {
                    byte[] out = ThreadActivityEntry.makeHeatmapBytes(-1, -1, -1);
                    this.heatmapIndexDataFileByActivity[i].write(out);
                }
                ++i;
            }
            int clusterIndex = 0;
            while (clusterIndex < this.counterStateByCluster.length) {
                ChartClusterState clusterData = this.counterStateByCluster[clusterIndex];
                int activityIndex = 0;
                while (activityIndex < clusterData.activities.length) {
                    if (!counterWrittenByClusterByActivity[clusterIndex][activityIndex]) {
                        ChartActivityState activityData = clusterData.activities[activityIndex];
                        Compression.packInt((long)-1L, (OutputStream)activityData.counterDataFile);
                        Compression.packInt((long)0L, (OutputStream)activityData.counterDataFile);
                        Compression.packInt((long)0L, (OutputStream)activityData.counterDataFile);
                    }
                    ++activityIndex;
                }
                ++clusterIndex;
            }
            for (UniqueThread thread : this.threadsToRemove) {
                this.threadStateByUtid.remove(thread.getUID());
            }
            this.threadsToRemove.clear();
        } else {
            ThreadActivityEntry.clearPercentageInfo(this.threadStateForSystemWide);
            for (ThreadState entry : this.threadStateByUtid.valueCollection()) {
                ThreadActivityEntry.clearPercentageInfo(entry);
            }
        }
        Object object = this.heatmapIndexDataFileByActivity;
        int n = this.heatmapIndexDataFileByActivity.length;
        int n2 = 0;
        while (n2 < n) {
            IndexDataFile file = object[n2];
            file.writeIndex();
            ++n2;
        }
        object = this.counterStateByCluster;
        n = this.counterStateByCluster.length;
        n2 = 0;
        while (n2 < n) {
            Object cluster = object[n2];
            ChartActivityState[] chartActivityStateArray = ((ChartClusterState)cluster).activities;
            int n3 = ((ChartClusterState)cluster).activities.length;
            int n4 = 0;
            while (n4 < n3) {
                ChartActivityState activity = chartActivityStateArray[n4];
                activity.counterDataFile.writeIndex();
                ++n4;
            }
            ++n2;
        }
        ++this.indexCounter;
    }

    public boolean process() {
        if (--this.tickCounter > 0) {
            return false;
        }
        this.tickCounter = this.tickLimit;
        return true;
    }

    public void threadFree(long time, int utid) {
        if (this.procCounter) {
            @NonNull Optional thread = this.uniqueIds.findThread(utid);
            thread.ifPresent(t -> {
                if (t.getNonUid().getEndTime() == time) {
                    this.threadFree((UniqueThread)t);
                }
            });
        }
    }

    public void threadStop(int channelNumber, int reason) {
        this.writeFlag2 = true;
        this.writeFlag1 = true;
        Integer utid = this.currentlyActiveUtidByChannel[channelNumber];
        ThreadState threadState = this.getOrCreateThreadState(utid);
        threadState.lastSwitchReasonByActivity[threadState.currentActivity] = reason;
        this.currentlyActiveUtidByChannel[channelNumber] = null;
    }

    public void threadSwitch(long time, int channelNumber, int activity, int reason, @NonNull OptionalInt utid) {
        Integer incomingUtid;
        this.writeFlag2 = true;
        this.writeFlag1 = true;
        Object object = this.procCounter ? (utid.isEmpty() ? null : Integer.valueOf(utid.getAsInt())) : (incomingUtid = Integer.valueOf(-1));
        assert (incomingUtid == null || incomingUtid != -1 || !this.procCounter);
        ThreadState incomingThreadState = this.getOrCreateThreadState(incomingUtid);
        Integer currentUtid = this.currentlyActiveUtidByChannel[channelNumber];
        ThreadState currentThreadState = this.getOrCreateThreadState(currentUtid);
        UniqueThread currentThread = currentThreadState.thread;
        currentThreadState.lastSwitchReasonByActivity[currentThreadState.currentActivity] = reason;
        if (currentThread != null && currentThread.getNonUid().getEndTime() <= time) {
            this.threadFree(currentThread);
        }
        this.currentlyActiveUtidByChannel[channelNumber] = incomingUtid;
        incomingThreadState.currentActivity = this.mapActivity(activity, incomingThreadState.thread);
    }

    private @NonNull ThreadState getOrCreateThreadState(@Nullable Integer utid) {
        if (utid == null) {
            return this.threadStateForSystemWide;
        }
        ThreadState result = (ThreadState)this.threadStateByUtid.get(utid.intValue());
        if (result == null) {
            UniqueThread thread = this.uniqueIds.findThread(utid.intValue()).orElse(null);
            assert (thread != null || utid == -1);
            result = new ThreadState(thread, this.activityCount, this.channelCount);
            this.threadStateByUtid.put(utid.intValue(), (Object)result);
        }
        return result;
    }

    private int mapActivity(int activity, @Nullable UniqueThread incomingThread) {
        if (!this.cpuActivity) {
            return Math.max(0, Math.min(this.activityCount - 1, activity));
        }
        return incomingThread == null || incomingThread.isKernel() ? 1 : 0;
    }

    private void outputFor(boolean @NonNull [] heatmapModified, boolean @NonNull [] @NonNull [] counterWrittenByClusterByActivity, boolean writeCounterValue, @NonNull ThreadState threadState, int uid, int uidForHeatmap) throws IOException {
        int activityNumber = 0;
        while (activityNumber < threadState.percentageInfoByActivityByChannel.length) {
            byte reason;
            long[] activity = threadState.percentageInfoByActivityByChannel[activityNumber];
            int heatmapFileIndex = this.cpuActivity ? 0 : activityNumber;
            boolean active = false;
            int channelNumber = 0;
            while (channelNumber < activity.length) {
                int value = (int)activity[channelNumber];
                activity[channelNumber] = 0L;
                if (value > 0) {
                    active = true;
                    if (this.generateHeatMapData) {
                        byte[] out = ThreadActivityEntry.makeHeatmapBytes(uidForHeatmap, channelNumber, value);
                        this.heatmapIndexDataFileByActivity[heatmapFileIndex].write(out);
                        heatmapModified[heatmapFileIndex] = true;
                    }
                    if (writeCounterValue) {
                        int clusterIndex = this.supportsMultipleClusters ? this.channelToClusterMapper.applyAsInt(channelNumber) : 0;
                        ChartClusterState clusterState = this.counterStateByCluster[clusterIndex];
                        ChartActivityState activityState = clusterState.activities[activityNumber];
                        counterWrittenByClusterByActivity[clusterIndex][activityNumber] = true;
                        Compression.packInt((long)uid, (OutputStream)activityState.counterDataFile);
                        Compression.packInt((long)channelNumber, (OutputStream)activityState.counterDataFile);
                        Compression.packInt((long)value, (OutputStream)activityState.counterDataFile);
                        if (value > activityState.limitMaxValue) {
                            activityState.limitMaxValue = value;
                            activityState.limitMaxIndex = this.indexCounter;
                        }
                        if (value < activityState.limitMinValue) {
                            activityState.limitMinValue = value;
                            activityState.limitMinIndex = this.indexCounter;
                        }
                    }
                }
                ++channelNumber;
            }
            if (!active && this.generateHeatMapData && (reason = (byte)threadState.lastSwitchReasonByActivity[activityNumber]) != 0) {
                byte[] out = ThreadActivityEntry.makeHeatmapBytes(uidForHeatmap, -1, reason);
                this.heatmapIndexDataFileByActivity[heatmapFileIndex].write(out);
                heatmapModified[heatmapFileIndex] = true;
            }
            ++activityNumber;
        }
    }

    private void threadFree(@NonNull UniqueThread thread) {
        Integer utid = thread.getUID();
        this.writeFlag2 = true;
        this.writeFlag1 = true;
        this.threadsToRemove.add(thread);
        int i = 0;
        while (i < this.currentlyActiveUtidByChannel.length) {
            if (NullChecking.equalsNullable((Object)this.currentlyActiveUtidByChannel[i], (Object)utid)) {
                this.currentlyActiveUtidByChannel[i] = null;
            }
            ++i;
        }
    }

    private static final class ChartActivityState
    implements Closeable {
        public final @NonNull IndexDataFile counterDataFile;
        public int limitMaxIndex;
        public int limitMaxValue;
        public int limitMinIndex;
        public int limitMinValue;

        public ChartActivityState(@NonNull File dataFile) throws IOException {
            this.counterDataFile = new IndexDataFile(dataFile);
        }

        @Override
        public void close() throws IOException {
            this.counterDataFile.close();
        }
    }

    private static final class ChartClusterState
    implements Closeable {
        public final @NonNull ChartActivityState @NonNull [] activities;

        public ChartClusterState(@NonNull File @NonNull [] dataFiles) throws IOException {
            this.activities = (ChartActivityState[])ArrayUtils.create(ChartActivityState[]::new, (int)dataFiles.length, i -> new ChartActivityState(dataFiles[i]));
        }

        @Override
        public void close() throws IOException {
            Throwing.closeAll((Closeable[])this.activities);
        }
    }

    private static final class ThreadState {
        public int currentActivity = 0;
        public int @NonNull [] lastSwitchReasonByActivity;
        public final long @NonNull [] @NonNull [] percentageInfoByActivityByChannel;
        public final @Nullable UniqueThread thread;

        public ThreadState(@Nullable UniqueThread thread, int activityCount, int channelCount) {
            this.thread = thread;
            this.lastSwitchReasonByActivity = new int[activityCount];
            this.percentageInfoByActivityByChannel = new long[activityCount][channelCount];
        }
    }
}

