/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator;

import com.arm.streamline.analysis.gator.BacktraceProcessing;
import com.arm.streamline.analysis.gator.GatorCapturedRawXML;
import com.arm.streamline.analysis.gator.GatorProtocolVerifier;
import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.gator.ILiveAgentCapabilities;
import com.arm.streamline.analysis.gator.ProtocolInfo;
import com.arm.streamline.analysis.session.SessionMessages;
import com.arm.streamline.common.model.CaptureSubType;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.SpeCaptureRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.model.EventBasedSampleInfo;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GatorCapturedXML
implements ICaptureDetails,
ILiveAgentCapabilities {
    public static final String CAPTURED_FILENAME = "captured.xml";
    private final @NonNull CaptureSubType captureSubType;
    private final @Nullable String gatordBuildId;
    private final @Nullable String gatordMd5Sum;
    private final @Nullable Integer gpuCoresCount;
    private final @NonNull String mAPCPath;
    private @NonNull BacktraceProcessing mBacktraceProcessing;
    private int mCoreCount;
    private final @NonNull List<@NonNull CounterRecord> mCounterList = new ArrayList<CounterRecord>();
    private @Nullable EventBasedSampleInfo mEBSInfo;
    private @NonNull Map<String, String> mInvalidCounters;
    private boolean mLocalCapture;
    private @NonNull String mName;
    private @NonNull String mGpuPublicName;
    private @NonNull ProtocolInfo mProtocolInfo;
    private boolean mIsPerfImport;
    private int mSampleRate;
    private final @NonNull Set<@NonNull SpeCaptureRecord> mSpes = new HashSet<SpeCaptureRecord>();
    private boolean mSupportsLive;
    private final boolean mHasArmNNCounters;
    private final boolean offCpuProfiling;
    private final boolean mIsAtraceEnabled;

    public <T extends Throwable> GatorCapturedXML(@NonNull String input, @NonNull CaptureSubType captureSubType, @NonNull GatorProtocolVerifier.IGatorProtocolVerificationExceptionFactory<T> exceptionFactory, @NonNull Map<String, StockCounter> stockCounterMap, @NonNull Collection<@NonNull SpeTargetDescription> speTargetDescriptions, boolean hasArmNNCounters) throws IOException, T {
        this.mAPCPath = input;
        this.mInvalidCounters = new HashMap<String, String>();
        GatorCapturedRawXML capturedXML = GatorCapturedRawXML.readFromDir(new File(input));
        this.captureSubType = captureSubType;
        this.mName = (String)NullChecking.neverNullOr((Object)capturedXML.getName(), (Object)"");
        this.mGpuPublicName = (String)NullChecking.neverNullOr((Object)capturedXML.getGPUPublicName(), (Object)"");
        this.mProtocolInfo = capturedXML.getProtocolInfo();
        this.mCoreCount = capturedXML.getCoreCount();
        this.mIsPerfImport = capturedXML.isPerfImport();
        this.gpuCoresCount = capturedXML.getGpuCoresCount();
        this.addCounters(stockCounterMap, speTargetDescriptions, capturedXML);
        this.mBacktraceProcessing = capturedXML.getBacktraceProcessing();
        this.mSupportsLive = capturedXML.supportsLive();
        this.mLocalCapture = capturedXML.isLocalCapture();
        this.mSampleRate = capturedXML.getSampleRate();
        this.mEBSInfo = EventBasedSampleInfo.create(this.mCounterList);
        this.gatordMd5Sum = capturedXML.getGatordMd5Sum();
        this.gatordBuildId = capturedXML.getGatordBuildId();
        this.offCpuProfiling = capturedXML.isOffCpuProfilingEnabled();
        this.mHasArmNNCounters = hasArmNNCounters;
        this.mIsAtraceEnabled = capturedXML.isATraceEnabled();
        GatorProtocolVerifier.verifyCaptureProtocol(this.getProtocolInfo(), exceptionFactory);
    }

    public <T extends Throwable> GatorCapturedXML(@NonNull XMLParser in, @NonNull String input, @NonNull CaptureSubType captureSubType, @NonNull GatorProtocolVerifier.IGatorProtocolVerificationExceptionFactory<T> exceptionFactory, @NonNull Map<String, StockCounter> stockCounterMap, @NonNull Collection<@NonNull SpeTargetDescription> speTargetDescriptions, boolean hasArmNNCounters) throws IOException, T {
        this.mAPCPath = input;
        this.mInvalidCounters = new HashMap<String, String>();
        GatorCapturedRawXML capturedXML = GatorCapturedRawXML.read(in);
        this.captureSubType = captureSubType;
        this.mName = (String)NullChecking.neverNullOr((Object)capturedXML.getName(), (Object)"");
        this.mGpuPublicName = (String)NullChecking.neverNullOr((Object)capturedXML.getGPUPublicName(), (Object)"");
        this.mProtocolInfo = capturedXML.getProtocolInfo();
        this.mIsPerfImport = capturedXML.isPerfImport();
        this.mCoreCount = capturedXML.getCoreCount();
        this.addCounters(stockCounterMap, speTargetDescriptions, capturedXML);
        this.mBacktraceProcessing = capturedXML.getBacktraceProcessing();
        this.mSupportsLive = capturedXML.supportsLive();
        this.mLocalCapture = capturedXML.isLocalCapture();
        this.mSampleRate = capturedXML.getSampleRate();
        this.mEBSInfo = EventBasedSampleInfo.create(this.mCounterList);
        this.gpuCoresCount = capturedXML.getGpuCoresCount();
        this.gatordMd5Sum = capturedXML.getGatordMd5Sum();
        this.gatordBuildId = capturedXML.getGatordBuildId();
        this.offCpuProfiling = capturedXML.isOffCpuProfilingEnabled();
        this.mHasArmNNCounters = hasArmNNCounters;
        this.mIsAtraceEnabled = capturedXML.isATraceEnabled();
        GatorProtocolVerifier.verifyCaptureProtocol(this.getProtocolInfo(), exceptionFactory);
    }

    public boolean isOffCpuProfilingEnabled() {
        return this.offCpuProfiling;
    }

    @Override
    public @NonNull BacktraceProcessing getBacktraceProcessing() {
        return this.mBacktraceProcessing;
    }

    @Override
    public @NonNull CaptureSubType getCaptureSubType() {
        return this.captureSubType;
    }

    @Override
    public @Nullable CounterRecord getCounter(int key) {
        for (CounterRecord counter : this.mCounterList) {
            if (counter.getKey() != key) continue;
            return counter;
        }
        return null;
    }

    @Override
    public @NonNull List<@NonNull CounterRecord> getCounterList() {
        return this.mCounterList;
    }

    @Override
    public @Nullable CounterRecord getDerivedCounter(String type) {
        for (CounterRecord counter : this.mCounterList) {
            if (!counter.getCounter().contentEquals(type)) continue;
            return counter;
        }
        return null;
    }

    @Override
    public @Nullable EventBasedSampleInfo getEBSInfo() {
        return this.mEBSInfo;
    }

    @Override
    public @NonNull ProtocolInfo getProtocolInfo() {
        return this.mProtocolInfo;
    }

    public boolean isPerfImport() {
        return this.mIsPerfImport;
    }

    @Override
    public @Nullable String getGatordBuildId() {
        return this.gatordBuildId;
    }

    @Override
    public @Nullable String getGatordMd5Sum() {
        return this.gatordMd5Sum;
    }

    @Override
    public @Nullable Integer getGpuCoresCount() {
        return this.gpuCoresCount;
    }

    @Override
    public String[] getInvalidCounters() {
        Object[] keys = this.mInvalidCounters.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        ArrayList<CallSite> invalid = new ArrayList<CallSite>();
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            invalid.add((CallSite)((Object)((String)key + " (" + this.mInvalidCounters.get(key) + ")")));
            ++n2;
        }
        return invalid.toArray(new String[0]);
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getGPUPublicName() {
        return this.mGpuPublicName;
    }

    @Override
    public int getNumberOfCores() {
        return this.mCoreCount;
    }

    @Override
    public String getPath() {
        return this.mAPCPath;
    }

    @Override
    public long getSampleIntervalNanoSeconds() {
        return this.mSampleRate;
    }

    @Override
    public @NonNull Set<@NonNull SpeCaptureRecord> getSpes() {
        return Collections.unmodifiableSet(this.mSpes);
    }

    @Override
    public @NonNull TimeUnit getTimeUnit() {
        return TimeUnit.NANO_SECONDS;
    }

    @Override
    public boolean hasBeenRecordedOnTarget() {
        return this.mLocalCapture;
    }

    @Override
    public boolean hasDerivedCounterOfType(String type) {
        for (CounterRecord counter : this.mCounterList) {
            if (counter.getCounter() == null || !counter.getCounter().contentEquals(type) || !counter.isDerived()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasArmNNCounters() {
        return this.mHasArmNNCounters;
    }

    @Override
    public boolean hasMaliCounters() {
        for (CounterRecord counter : this.mCounterList) {
            if (counter.getCounter().toLowerCase().startsWith("arm_mali")) {
                return true;
            }
            @Nullable DeviceType deviceType = counter.getDeviceType();
            if (deviceType == null || !deviceType.isGPU()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCallStackUnwindingSupported() {
        switch (this.mBacktraceProcessing) {
            case GATOR: 
            case PERF: {
                return true;
            }
            case NONE: {
                return false;
            }
        }
        throw new AssertionError((Object)this.mBacktraceProcessing);
    }

    public void setSampleRate(int sampleRate) {
        this.mSampleRate = sampleRate;
    }

    @Override
    public boolean supportsCaptureCommand() {
        return true;
    }

    @Override
    public boolean supportsEfficientFtrace() {
        return true;
    }

    @Override
    public boolean supportsLive() {
        return this.mSupportsLive;
    }

    @Override
    public boolean isAtraceEnabled() {
        return this.mIsAtraceEnabled;
    }

    @Override
    public boolean supportsRetrieveImage(@NonNull TargetAddressString targetAddress) {
        return this.getCaptureSubType() != CaptureSubType.ANDROID || !targetAddress.isDefinitelyLoopback();
    }

    @Override
    public boolean supportsSelectableCPUActivity() {
        return true;
    }

    @Override
    public boolean supportsSelectableCPUActivityPerCluster() {
        return true;
    }

    private void addCounters(@NonNull Map<String, StockCounter> stockCounterMap, @NonNull Collection<@NonNull SpeTargetDescription> speTargetDescriptions, @NonNull GatorCapturedRawXML capturedXML) throws IOException {
        GatorCapturedRawXML.createCountersFromCapturedAndEventsXml(true, this.mCounterList, this.mSpes, this.mCoreCount, stockCounterMap, speTargetDescriptions, capturedXML);
    }

    public static void checkCounterAliasesDuplicates(List<@NonNull CounterRecord> counters) throws IOException {
        @NonNull HashSet<@NonNull String> aliases = new HashSet<String>();
        @NonNull HashSet<@NonNull String> duplicateAliases = new HashSet<String>();
        for (CounterRecord counter : counters) {
            @NonNull String alias = counter.getAlias();
            if (aliases.add(alias)) continue;
            duplicateAliases.add(alias);
        }
        if (!duplicateAliases.isEmpty()) {
            @NonNull String errorMessage = MessageFormat.format(SessionMessages.DUPLICATE_COUNTER_ALIAS, ((Object)duplicateAliases).toString());
            throw new IOException(errorMessage);
        }
    }
}

