/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator;

import com.arm.streamline.common.model.CommonModelMessages;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public enum BacktraceProcessing {
    GATOR("gator", new String[0]){

        public String toString() {
            return "Gator";
        }
    }
    ,
    NONE("none", new String[0]){

        public String toString() {
            return CommonModelMessages.NONE_TITLE;
        }
    }
    ,
    PERF("perf", new String[0]){

        public String toString() {
            return CommonModelMessages.PERF_TITLE;
        }
    };

    private static final @NonNull BacktraceProcessing DEFAULT;
    private final @NonNull String xmlValue;
    private final @NonNull String[] alternatives;

    static {
        DEFAULT = GATOR;
    }

    public static @NonNull BacktraceProcessing get(@Nullable String text) {
        if (text != null) {
            BacktraceProcessing[] backtraceProcessingArray = BacktraceProcessing.values();
            int n = backtraceProcessingArray.length;
            int n2 = 0;
            while (n2 < n) {
                BacktraceProcessing one = backtraceProcessingArray[n2];
                if (one.parseXml(text)) {
                    return one;
                }
                ++n2;
            }
        }
        return DEFAULT;
    }

    private BacktraceProcessing(String xmlValue, String ... alternatives) {
        this.xmlValue = xmlValue;
        this.alternatives = alternatives;
    }

    public boolean parseXml(@NonNull String xmlValue) {
        if (!this.xmlValue.equalsIgnoreCase(xmlValue)) {
            if (!Stream.of(this.alternatives).anyMatch(xmlValue::equalsIgnoreCase)) {
                return false;
            }
        }
        return true;
    }

    public @NonNull String toXmlString() {
        return this.xmlValue;
    }
}

