//
// ARMv8-A AArch64 - Basic Mutex Example
//
// Copyright (C) 2012-2025 by Arm Limited (or its affiliates). All rights reserved.
// Use, modification and redistribution of this file is subject to your possession of a
// valid End User License Agreement for the Arm Product of which these examples are part of 
// and your compliance with all applicable terms and conditions of such license agreement.
//
// Redistribution permitted only in object code form and only as
// part of Software Applications developed by you or your permitted users. If you
// choose to redistribute the whole or any part of Example Code, you agree: (a)
// to ensure that they are licensed for use only as part of Software Applications
// and only for execution on microprocessors manufactured or simulated under
// licence from Arm; (b) not to use Arm's or any of its licensors names, logos or
// trademarks to market Software Applications; (c) to include valid copyright
// notices on Software Applications, and preserve any copyright notices which are
// included with, or in, the Example Code; and (d) to ensure that any further
// redistribution is limited to redistribution by either or both your customers
// and your authorised distributors as part of Software Applications and that
// your customers and your authorised distributors comply with these terms.
//


    .text


    .global _mutex_initialize
    .global _mutex_acquire
    .global _mutex_release

//
// These routines implement the mutex management functions required for running
// the ARM C library in a multi-threaded environment.
//
// They use a value of 0 to represent an unlocked mutex, and 1 for a locked mutex
//
// **********************************************************************
//

    .type _mutex_initialize, "function"
_mutex_initialize:

    //
    // mark the mutex as unlocked
    //
    mov     w1, #0
    str     w1, [x0]

    //
    // we are running multi-threaded, so set a non-zero return
    // value (function prototype says use 1)
    //
    mov     w0, #1
    ret


    .type _mutex_acquire, "function"
_mutex_acquire:

    //
    // send ourselves an event, so we don't stick on the wfe at the
    // top of the loop
    //
    sevl

    //
    // wait until the mutex is available
    //
loop:
    wfe
    ldaxr   w1, [x0]
    cbnz    w1, loop

    //
    // mutex is (at least, it was) available - try to claim it
    //
    mov     w1, #1
    stxr    w2, w1, [x0]
    cbnz    w2, loop

    //
    // OK, we have the mutex, our work is done here
    //
    ret


    .type _mutex_release, "function"
_mutex_release:

    mov     w1, #0
    stlr    w1, [x0]
    ret
