/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.ssh.jsch;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IChannelExec {
    public static @Nullable IChannelExec wrap(final @Nullable ChannelExec channel) {
        if (channel == null) {
            return null;
        }
        return new IChannelExec(){

            @Override
            public void connect() throws JSchException {
                channel.connect(60000);
                channel.setPty(false);
            }

            @Override
            public @Nullable InputStream getErrStream() throws IOException {
                return channel.getErrStream();
            }

            @Override
            public int getExitStatus() {
                return channel.getExitStatus();
            }

            @Override
            public @Nullable InputStream getInputStream() throws IOException {
                return channel.getInputStream();
            }

            @Override
            public @Nullable OutputStream getOutputStream() throws IOException {
                return channel.getOutputStream();
            }

            @Override
            public boolean isConnected() {
                return channel.isConnected() && !channel.isClosed();
            }

            @Override
            public boolean isEOF() {
                return channel.isEOF();
            }

            @Override
            public void sendSignal(@NonNull String signal) throws Exception {
                channel.sendSignal(signal);
            }

            @Override
            public void setCommand(@NonNull String string) {
                channel.setCommand("exec " + string);
            }
        };
    }

    public void connect() throws JSchException;

    public @Nullable InputStream getErrStream() throws IOException;

    public int getExitStatus();

    public @Nullable InputStream getInputStream() throws IOException;

    public @Nullable OutputStream getOutputStream() throws IOException;

    public boolean isConnected();

    public boolean isEOF();

    default public void sendSigInt() throws Exception {
        this.sendSignal("INT");
    }

    default public void sendSigKill() throws Exception {
        this.sendSignal("KILL");
    }

    public void sendSignal(@NonNull String var1) throws Exception;

    default public void sendSigTerm() throws Exception {
        this.sendSignal("TERM");
    }

    public void setCommand(@NonNull String var1);
}

