/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.adb.utils;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.adb.utils.AdbCommandIOException;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AdbRedirects {
    private static @NonNull Pattern PATTERN = Pattern.compile("(.+) ([^:]+):(.+) ([^:]+):(.+)");

    public static final @NonNull Set<@NonNull AdbRedirect> enumerateForwards(@NonNull IAdbProcessRunner adbRunner) throws IOException {
        IBasicInteractiveShell.InteractiveCommandResult commandResult = adbRunner.runCommandAndGetOutput("forward", "--list");
        if (!commandResult.status.isSuccessful()) {
            throw new AdbCommandIOException("adb forward --list", commandResult);
        }
        @NonNull HashSet<@NonNull AdbRedirect> redirects = new HashSet<AdbRedirect>();
        for (String line : commandResult.output) {
            if (line.isBlank()) continue;
            AdbRedirect redirect = AdbRedirects.parseOne(line);
            redirects.add(redirect);
        }
        return redirects;
    }

    public static @NonNull AdbRedirect forward(@NonNull IAdbProcessRunner adbRunner, @NonNull String serialNo, @NonNull AdbRedirectType localType, @NonNull AdbRedirectTargetValue localTarget, @NonNull AdbRedirectType remoteType, @NonNull AdbRedirectTargetValue remoteTarget) throws IOException {
        IBasicInteractiveShell.InteractiveCommandResult commandResult = adbRunner.runCommandAndGetOutput("-s", serialNo, "forward", localType.format(localTarget), remoteType.format(remoteTarget));
        if (!commandResult.status.isSuccessful()) {
            throw new AdbCommandIOException("adb forward --list", commandResult);
        }
        if (localType == AdbRedirectType.TCP && localTarget.asInt() == 0) {
            if (commandResult.output.isEmpty()) {
                throw new AssertionError((Object)("Expected generated port number, but got: " + String.valueOf(commandResult)));
            }
            String selectedPortStr = commandResult.output.get(0);
            int selectedPort = Integer.parseInt(selectedPortStr);
            return new AdbRedirect(serialNo, AdbRedirectType.TCP, new AdbRedirectTargetValue(selectedPort), remoteType, remoteTarget);
        }
        return new AdbRedirect(serialNo, localType, localTarget, remoteType, remoteTarget);
    }

    public static @NonNull AdbRedirect forward(@NonNull IAdbProcessRunner commandRunner, @NonNull String serialNo, int localPort, int remotePort) throws IOException {
        return AdbRedirects.forward(commandRunner, serialNo, AdbRedirectType.TCP, new AdbRedirectTargetValue(localPort), AdbRedirectType.TCP, new AdbRedirectTargetValue(remotePort));
    }

    public static @NonNull AdbRedirect forward(@NonNull IAdbProcessRunner commandRunner, @NonNull String serialNo, int localPort, @NonNull String remoteLocalAbstract) throws IOException {
        return AdbRedirects.forward(commandRunner, serialNo, AdbRedirectType.TCP, new AdbRedirectTargetValue(localPort), AdbRedirectType.LOCALABSTRACT, new AdbRedirectTargetValue(remoteLocalAbstract));
    }

    public static void remove(@NonNull IAdbProcessRunner adbRunner, @NonNull AdbRedirect forward) throws IOException {
        AdbRedirects.remove(adbRunner, forward.getSerialNumber(), forward.getLocalType(), forward.getLocalValue());
    }

    public static void remove(@NonNull IAdbProcessRunner adbRunner, @NonNull String serialNo, @NonNull AdbRedirectType type, @NonNull AdbRedirectTargetValue target) throws IOException {
        String targetStr = type.format(target);
        IBasicInteractiveShell.InteractiveCommandResult commandResult = adbRunner.runCommandAndGetOutput("-s", serialNo, "forward", "--remove", targetStr);
        if (!commandResult.status.isSuccessful()) {
            if (commandResult.errorsAndOutputJoined().contains(String.format("error: listener '%s' not found", targetStr))) {
                return;
            }
            throw new AdbCommandIOException("adb forward --list", commandResult);
        }
    }

    public static void removeAllForDevice(@NonNull IAdbProcessRunner adbRunner, @NonNull String serialNo) throws IOException {
        Set<AdbRedirect> forwards = AdbRedirects.enumerateForwards(adbRunner);
        for (AdbRedirect forward : forwards) {
            if (!forward.serialNumber.contentEquals(serialNo)) continue;
            AdbRedirects.remove(adbRunner, forward);
        }
    }

    private static @NonNull AdbRedirect parseOne(@NonNull String line) {
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.matches()) {
            throw new AssertionError((Object)("Unexpected output from 'adb forward --list': '" + line + "'"));
        }
        String serialNumber = (String)NullChecking.neverNull((Object)matcher.group(1));
        AdbRedirectType localType = AdbRedirectType.parse((String)NullChecking.neverNull((Object)matcher.group(2)));
        String localTarget = (String)NullChecking.neverNull((Object)matcher.group(3));
        AdbRedirectType remoteType = AdbRedirectType.parse((String)NullChecking.neverNull((Object)matcher.group(4)));
        String remoteTarget = (String)NullChecking.neverNull((Object)matcher.group(5));
        if (localType == null || remoteType == null) {
            throw new AssertionError((Object)("Unexpected output from 'adb forward --list': '" + line + "'"));
        }
        AdbRedirectTargetValue localValue = localType.map(localTarget);
        AdbRedirectTargetValue remoteValue = remoteType.map(remoteTarget);
        if (localValue == null || remoteValue == null) {
            throw new AssertionError((Object)("Unexpected output from 'adb forward --list': '" + line + "'"));
        }
        return new AdbRedirect(serialNumber, localType, localValue, remoteType, remoteValue);
    }

    public static final class AdbRedirect {
        private final @NonNull AdbRedirectType localType;
        private final @NonNull AdbRedirectTargetValue localValue;
        private final @NonNull AdbRedirectType remoteType;
        private final @NonNull AdbRedirectTargetValue remoteValue;
        private final @NonNull String serialNumber;

        public AdbRedirect(@NonNull String serialNumber, @NonNull AdbRedirectType localType, @NonNull AdbRedirectTargetValue localValue, @NonNull AdbRedirectType remoteType, @NonNull AdbRedirectTargetValue remoteValue) {
            this.serialNumber = serialNumber;
            this.localType = localType;
            this.localValue = localValue;
            this.remoteType = remoteType;
            this.remoteValue = remoteValue;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AdbRedirect) {
                AdbRedirect that = (AdbRedirect)obj;
                return this.serialNumber.contentEquals(that.serialNumber) && this.localType.equals((Object)that.localType) && this.localValue.equals(that.localValue) && this.remoteType.equals((Object)that.remoteType) && this.remoteValue.equals(that.remoteValue);
            }
            return false;
        }

        public @NonNull AdbRedirectType getLocalType() {
            return this.localType;
        }

        public @NonNull AdbRedirectTargetValue getLocalValue() {
            return this.localValue;
        }

        public @NonNull AdbRedirectType getRemoteType() {
            return this.remoteType;
        }

        public @NonNull AdbRedirectTargetValue getRemoteValue() {
            return this.remoteValue;
        }

        public @NonNull String getSerialNumber() {
            return this.serialNumber;
        }

        public int hashCode() {
            return (this.serialNumber.hashCode() * 31 + this.localValue.hashCode()) * 31 + this.localType.hashCode();
        }

        public String toString() {
            return String.format("AdbPortRedirect [serialNumber=%s, localType=%s, localValue=%s, remoteType=%s, remoteValue=%s]", new Object[]{this.serialNumber, this.localType, this.localValue, this.remoteType, this.remoteValue});
        }
    }

    public static final class AdbRedirectTargetValue {
        private final @NonNull Object value;

        public AdbRedirectTargetValue(int value) {
            this.value = value;
        }

        public AdbRedirectTargetValue(@NonNull Object value) {
            if (!(value instanceof String) && !(value instanceof Integer)) {
                throw new IllegalArgumentException();
            }
            this.value = value;
        }

        public int asInt() {
            return (Integer)this.value;
        }

        public @NonNull String asString() {
            return (String)this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AdbRedirectTargetValue) {
                AdbRedirectTargetValue that = (AdbRedirectTargetValue)obj;
                return this.value.equals(that.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static enum AdbRedirectType {
        DEV(false, "dev"),
        JDWP(true, "jdwp"),
        LOCALABSTRACT(false, "localabstract"),
        LOCALFILESYSTEM(false, "localfilesystem"),
        LOCALRESERVED(false, "localreserved"),
        TCP(true, "tcp");

        public final @NonNull String code;
        public final boolean targetIsInt;

        public static @Nullable AdbRedirectType parse(@NonNull String typeStr) {
            AdbRedirectType[] adbRedirectTypeArray = AdbRedirectType.values();
            int n = adbRedirectTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AdbRedirectType value = adbRedirectTypeArray[n2];
                if (value.code.contentEquals(typeStr)) {
                    return value;
                }
                ++n2;
            }
            return null;
        }

        private AdbRedirectType(boolean targetIsInt, String code) {
            this.targetIsInt = targetIsInt;
            this.code = code;
        }

        public @NonNull String format(@NonNull AdbRedirectTargetValue target) {
            if (this.targetIsInt) {
                return String.format("%s:%d", this.code, target.asInt());
            }
            return String.format("%s:%s", this.code, target.asString());
        }

        public @Nullable AdbRedirectTargetValue map(@NonNull String valueStr) {
            if (!this.targetIsInt) {
                return new AdbRedirectTargetValue(valueStr);
            }
            try {
                return new AdbRedirectTargetValue(Integer.valueOf(valueStr, 10));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }
}

