/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.adb;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.Log;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.deviceconn.adb.IAdbPackageCommandRunner;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.lib.AsyncCommandFuture;
import com.arm.streamline.deviceconn.lib.IProcessInteractiveCommand;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingSupplier;
import gnu.trove.map.TIntIntMap;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IAdbCommandRunner
extends IBasicInteractiveShell {
    public static final boolean ALLOW_USER_DEBUG = "true".contentEquals((CharSequence)NullChecking.neverNullOr((Object)System.getenv("STREAMLINE_ALLOW_USER_DEBUG"), (Object)"false"));
    public static final /* synthetic */ int[] $SWITCH_TABLE$com$arm$streamline$deviceconn$adb$AdbDeviceRootMode;

    static {
        $SWITCH_TABLE$com$arm$streamline$deviceconn$adb$AdbDeviceRootMode = IAdbCommandRunner.$SWITCH_TABLE$com$arm$streamline$deviceconn$adb$AdbDeviceRootMode();
    }

    public static @NonNull AdbDeviceRootMode detectRootMode(@NonNull IAdbCommandRunner commandRunner) throws IOException {
        IBasicInteractiveShell.InteractiveCommandResult result = commandRunner.runCommandAndGetOutput(WrapMode.DEFAULT, "getprop", "ro.build.type");
        if (result.status.isSuccessful() && result.output.size() > 0 && result.output.get(0).contentEquals("user")) {
            Log.warn(String.format("ADB: %s: User-debug builds of android are not supported.", commandRunner.getDeviceSerial()));
            if (!ALLOW_USER_DEBUG) {
                return AdbDeviceRootMode.NONE;
            }
        }
        result = commandRunner.runCommandAndGetOutput(WrapMode.DEFAULT, "su", "--help");
        if (result.status.isSuccessful()) {
            boolean isMagisk = result.errorsAndOutputJoined().toLowerCase().contains("magisk");
            Log.info(String.format("ADB: %s: Magisk=%s", commandRunner.getDeviceSerial(), isMagisk));
            boolean timedOutSu0 = IAdbCommandRunner.detectCommandHangs(commandRunner, "su", "0", "ls", "/");
            boolean timedOutSuC = IAdbCommandRunner.detectCommandHangs(commandRunner, "su", "-c", "ls", "/");
            if (!timedOutSuC) {
                result = commandRunner.runCommandAndGetOutput(WrapMode.SU_C, "id", new String[0]);
                if (result.status.isSuccessful() && result.output.size() > 0 && IAdbCommandRunner.idIsRoot(result.output.get(0))) {
                    Log.info(String.format("ADB: %s: su -c works", commandRunner.getDeviceSerial()));
                    return AdbDeviceRootMode.USE_SU_C;
                }
                result = commandRunner.runCommandAndGetOutput(WrapMode.SU_C, "sh", "-c", "echo $USER");
                if (result.status.isSuccessful() && result.output.size() > 0 && result.output.get(0).contentEquals("root")) {
                    Log.info(String.format("ADB: %s: su -c works", commandRunner.getDeviceSerial()));
                    return AdbDeviceRootMode.USE_SU_C;
                }
            }
            if (!timedOutSu0) {
                result = commandRunner.runCommandAndGetOutput(WrapMode.SU_0, "id", new String[0]);
                if (result.status.isSuccessful() && result.output.size() > 0 && IAdbCommandRunner.idIsRoot(result.output.get(0))) {
                    Log.info(String.format("ADB: %s: su 0 works", commandRunner.getDeviceSerial()));
                    return AdbDeviceRootMode.USE_SU_0;
                }
                result = commandRunner.runCommandAndGetOutput(WrapMode.SU_0, "sh", "-c", "echo $USER");
                if (result.status.isSuccessful() && result.output.size() > 0 && result.output.get(0).contentEquals("root")) {
                    Log.info(String.format("ADB: %s: su 0 works", commandRunner.getDeviceSerial()));
                    return AdbDeviceRootMode.USE_SU_0;
                }
            }
            if (timedOutSu0 && timedOutSuC) {
                if (isMagisk) {
                    Log.warn(String.format("Using su on %s hangs. Root will not be available. Magisk users may be able to change settings to allow automatic grant of root privileges.", commandRunner.getDeviceSerial()));
                } else {
                    Log.warn(String.format("Using su on %s hangs unexpectedly. Root will not be available. Are you using Magisk or a similar root tool?", commandRunner.getDeviceSerial()));
                }
            }
        }
        result = commandRunner.runCommandAndGetOutput(WrapMode.DEFAULT, "id", new String[0]);
        if (result.status.isSuccessful() && result.output.size() > 0 && IAdbCommandRunner.idIsRoot(result.output.get(0))) {
            Log.info(String.format("ADB: %s: defaults to root", commandRunner.getDeviceSerial()));
            return AdbDeviceRootMode.DEFAULTS_TO_ROOT;
        }
        result = commandRunner.runCommandAndGetOutput(WrapMode.DEFAULT, "sh", "-c", "echo $USER");
        if (result.status.isSuccessful() && result.output.size() > 0 && result.output.get(0).contentEquals("root")) {
            Log.info(String.format("ADB: %s: defaults to root", commandRunner.getDeviceSerial()));
            return AdbDeviceRootMode.DEFAULTS_TO_ROOT;
        }
        Log.info(String.format("ADB: %s: No root support", commandRunner.getDeviceSerial()));
        return AdbDeviceRootMode.NONE;
    }

    public static @Nullable WrapMode rootWrapMode(@NonNull AdbDeviceRootMode rootMode) {
        switch (rootMode) {
            case DEFAULTS_TO_ROOT: {
                return WrapMode.DEFAULT;
            }
            case USE_SU_0: {
                return WrapMode.SU_0;
            }
            case USE_SU_C: {
                return WrapMode.SU_C;
            }
            case NONE: {
                return null;
            }
        }
        throw new AssertionError((Object)rootMode);
    }

    public static @NonNull WrapMode rootWrapModeOrDefault(@NonNull AdbDeviceRootMode rootMode) {
        switch (rootMode) {
            case DEFAULTS_TO_ROOT: {
                return WrapMode.DEFAULT;
            }
            case USE_SU_0: {
                return WrapMode.SU_0;
            }
            case USE_SU_C: {
                return WrapMode.SU_C;
            }
            case NONE: {
                return WrapMode.DEFAULT;
            }
        }
        throw new AssertionError((Object)rootMode);
    }

    private static boolean detectCommandHangs(@NonNull IAdbCommandRunner commandRunner, @NonNull String cmd, String ... args) throws IOException {
        long TIMEOUT_NS = 5000000000L;
        AsyncCommandFuture command = commandRunner.runCommandAsync(WrapMode.DEFAULT, cmd, args);
        long startTimestamp = System.nanoTime();
        while (!command.isDone() && System.nanoTime() - startTimestamp < 5000000000L) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (command.isDone()) {
            return false;
        }
        command.cancel(true);
        return true;
    }

    private static boolean idIsRoot(@NonNull String string) {
        String[] parts;
        String[] stringArray = parts = string.split("[ \\t\\n\\r]+");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.contentEquals("uid=0") || part.contentEquals("uid=root") || part.startsWith("uid=0(")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public @NonNull File adbPull(boolean var1, @NonNull File var2, @NonNull String var3) throws IOException;

    public @NonNull String adbPush(@NonNull File var1, @NonNull String var2) throws IOException;

    public @NonNull AdbDeviceRootMode detectRootMode() throws IOException;

    public @NonNull IAdbProcessRunner getAdbProcessRunner();

    public @NonNull String getDeviceSerial();

    public boolean isRootAs(@NonNull WrapMode var1) throws IOException;

    public @Nullable String pushAsTempFile(@NonNull File var1) throws IOException;

    public @NonNull IAdbPackageCommandRunner runAs(@NonNull String var1) throws IOException;

    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutput(@NonNull WrapMode var1, @NonNull String var2, String ... var3) throws IOException;

    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutputAsStream(@NonNull IThrowingSupplier< @NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> var1, @NonNull String var2, String ... var3) throws IOException;

    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutputAsStream(@NonNull WrapMode var1, @NonNull IThrowingSupplier< @NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> var2, @NonNull String var3, String ... var4) throws IOException;

    public @NonNull AsyncCommandFuture runCommandAsync(@NonNull WrapMode var1, @NonNull String var2, String ... var3) throws IOException;

    public @NonNull IProcessInteractiveCommand runInteractiveCommand(@NonNull WrapMode var1, @NonNull String var2, String ... var3) throws IOException;

    public void setPortForwards(@NonNull TIntIntMap var1) throws IOException;

    public static enum WrapMode {
        DEFAULT,
        PLAIN,
        SU_0,
        SU_C;

    }
}

