/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.topology;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.ClusterNameUtils;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.utils.NullChecking;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class GatorClusters {
    public static final String CLUSTERS_FILE = "clusters.xml";
    public static final String TAG_CLUSTERS = "clusters";
    public static final String TAG_CLUSTER = "cluster";
    public static final String TAG_CPU = "cpu";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CLUSTER = "cluster";
    private static final String ATTR_NAME = "name";
    private final @NonNull TIntObjectMap<String> mClusterNames;
    private final @NonNull TIntIntMap mCpuClusterIds;

    public static void writeXml(@NonNull File path, @NonNull TIntObjectMap<String> clusterNames, @NonNull TIntIntMap cpuClusterIds) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (XMLGenerator xml = XMLGenerator.create((File)new File(path, CLUSTERS_FILE));){
                xml.startDocument();
                xml.startTag(TAG_CLUSTERS);
                int[] nArray = clusterNames.keys();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int clusterIndex = nArray[n2];
                    xml.startEmptyTag("cluster");
                    xml.addAttribute(ATTR_ID, clusterIndex);
                    String clusterName = (String)NullChecking.neverNull((Object)((String)clusterNames.get(clusterIndex)));
                    String prettyName = (String)NullChecking.neverNullOr((Object)ClusterNameUtils.getPrettyName((String)clusterName), (Object)clusterName);
                    xml.addAttribute(ATTR_NAME, prettyName);
                    ++n2;
                }
                nArray = cpuClusterIds.keys();
                n = nArray.length;
                n2 = 0;
                while (n2 < n) {
                    int cpuIndex = nArray[n2];
                    xml.startEmptyTag(TAG_CPU);
                    xml.addAttribute(ATTR_ID, cpuIndex);
                    xml.addAttribute("cluster", cpuClusterIds.get(cpuIndex));
                    ++n2;
                }
                xml.endTag();
                xml.endDocument();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            CommonPlugin.error((Throwable)exception);
        }
    }

    public GatorClusters() {
        this.mClusterNames = new TIntObjectHashMap();
        this.mCpuClusterIds = new TIntIntHashMap();
    }

    public GatorClusters(File path) throws IOException {
        XMLParser in = null;
        this.mClusterNames = new TIntObjectHashMap();
        this.mCpuClusterIds = new TIntIntHashMap();
        File fullPath = new File(path, CLUSTERS_FILE);
        File clustersFile = CommonFileUtils.getFile((File)fullPath);
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileInputStream is = new FileInputStream(clustersFile);){
            try {
                String tag;
                in = XMLParser.create((File)clustersFile);
                while ((tag = in.nextTag()) != null) {
                    block25: {
                        if (!TAG_CLUSTERS.equals(tag)) break block25;
                        String marker = in.getMarker();
                        while ((tag = in.nextTag(marker)) != null) {
                            switch (tag) {
                                case "cluster": {
                                    this.tagCluster(in);
                                    break;
                                }
                                case "cpu": {
                                    this.tagCpu(in);
                                    break;
                                }
                                default: {
                                    in.skip();
                                }
                            }
                        }
                        continue;
                    }
                    in.skip();
                }
            }
            finally {
                CommonFileUtils.ignoredClose((Closeable)in);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public GatorClusters(@NonNull TIntObjectMap<String> clusterNames, @NonNull TIntIntMap cpuClusterIds) {
        this.mClusterNames = clusterNames;
        this.mCpuClusterIds = cpuClusterIds;
    }

    public @NonNull TIntObjectMap<String> getClusterNames() {
        return this.mClusterNames;
    }

    public @NonNull TIntIntMap getCpuClusterIds() {
        return this.mCpuClusterIds;
    }

    public void tagCluster(XMLParser in) {
        int id = in.getIntegerAttribute(ATTR_ID, -1);
        String name = in.getAttribute(ATTR_NAME);
        if (id >= 0 && name != null) {
            this.mClusterNames.put(id, (Object)name);
        }
    }

    public void tagCpu(XMLParser in) {
        int id = in.getIntegerAttribute(ATTR_ID, -1);
        int cluster = in.getIntegerAttribute("cluster", -1);
        if (id >= 0 && cluster >= 0) {
            this.mCpuClusterIds.put(id, cluster);
        }
    }

    public void write(@NonNull File path) {
        GatorClusters.writeXml(path, this.mClusterNames, this.mCpuClusterIds);
    }
}

